//
// $Header: d:\\32bits\\ext2-os2\\minifsd\\rcs\\devhelp.c,v 1.1 1997/03/15 22:31:04 Willm Exp $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996, 1997  Matthieu WILLM (willm@ibm.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>           // From the "Developer Connection Device Driver Kit" version 2.0
#include <dhcalls.h>       // From the "Developer Connection Device Driver Kit" version 2.0

#include <os2/types.h>
#include <os2/os2misc.h>
#include <os2/os2proto.h>


/*
 * This routine is used in place of FSH_PROBEBUF to verify and lock user buffers passed to the IFS.
 * Contrarily to FSH_PROBEBUF, this one is valid across yields. It uses a verify-lock. (VMLock)
 */

int LockUserBuffer(void *buf, unsigned long size, void *lock, int write, unsigned long *plock_lin) {
    unsigned long buf_lin;
    unsigned long PgCount;
    unsigned long flags;
    int           rc;

    flags = VMDHL_NOBLOCK | VMDHL_LONG | VMDHL_VERIFY;
    if (write) {
        flags |= VMDHL_WRITE;
    }

    /*
     * FLAT address of user buffer
     */
    if ((rc = VirtToLin(buf, &buf_lin)) == NO_ERROR) {
        /*
         * FLAT address of lock handle
         */
        if ((rc = VirtToLin(lock, plock_lin)) == NO_ERROR) {
            /*
             * Requests a Verify-Lock on the user buffer.
             */
            rc = VMLock(flags, buf_lin, size, 0xFFFFFFFF, *plock_lin, &PgCount);
            if ((rc == NO_ERROR) || 
                (rc == ERROR_NOBLOCK)) {   /* VMLock seems to return this error when the buffer is paged out.  */
                /*
                 * Nothing to do ...
                 */
            } else {
                kernel_printf("VMLock returned %d", rc);
            }
        } else {
            kernel_printf("LockUserBuffer : VirtToLin() returned %d", rc);
        }
    } else {
        kernel_printf("LockUserBuffer : VirtToLin() returned %d", rc);
    }

    return rc;
}

/*
 * Locks a buffer in PHYSICAL MEMORY
 */ 
int LockBuffer(void *buf, unsigned long size, void *lock, int write, unsigned long *plock_lin) {
    unsigned long buf_lin;
    unsigned long PgCount;
    unsigned long flags;
    int           rc;

    flags = VMDHL_LONG;
    if (write) {
        flags |= VMDHL_WRITE;
    }

    /*
     * FLAT address of user buffer
     */
    if ((rc = VirtToLin(buf, &buf_lin)) == NO_ERROR) {
        /*
         * FLAT address of lock handle
         */
        if ((rc = VirtToLin(lock, plock_lin)) == NO_ERROR) {
            /*
             * Requests a Verify-Lock on the user buffer.
             */
            if ((rc = VMLock(flags, buf_lin, size, 0xFFFFFFFF, *plock_lin, &PgCount)) == NO_ERROR) {
                /*
                 * Nothing to do ...
                 */
            } else {
                kernel_printf("VMLock returned %d", rc);
            }
        } else {
            kernel_printf("LockBuffer : VirtToLin() returned %d", rc);
        }
    } else {
        kernel_printf("LockBuffer : VirtToLin() returned %d", rc);
    }

    return rc;
}
