//
// $Header: d:\\32bits\\ext2-os2\\include\\linux\\rcs\\ext2_fs_i.h,v 1.2 1997/03/15 18:00:22 Willm Exp $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996, 1997  Matthieu WILLM (willm@ibm.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.



//
// This file is a OS/2 "port" of /usr/src/linux-1.2.1/include/linux/ext2_fs_i.h
// It contains the ext2 specific inode structure definition
//


#ifndef __EXT2_FS_I_H
#define __EXT2_FS_I_H

//
// From /usr/src/linux-1.2.1/include/linux/ext2_fs_i.h
//
#pragma pack(4)
struct ext2_inode_info {
	__u32	i_data[15];
	__u32	i_flags;
	__u32	i_faddr;
	__u8	i_frag_no;
	__u8	i_frag_size;
	__u16	i_osync;
	__u32	i_file_acl;
	__u32	i_dir_acl;
	__u32	i_dtime;
	__u32	i_version;
	__u32	i_block_group;
	__u32	i_next_alloc_block;
	__u32	i_next_alloc_goal;
	__u32	i_prealloc_block;
	__u32	i_prealloc_count;
};
#pragma pack()
// end from

#endif /* __EXT2_FS_I_H */
