#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <string.h>
#include "resource.h"

int __stdcall PrivateEmulatorSetup(int type);

BOOL CALLBACK SetupWnd(HWND hwndDlg,UINT uMsg,WPARAM wParam,LPARAM lParam)
{	int EmMode;
  switch (uMsg) {
		case WM_INITDIALOG:
      CheckRadioButton(hwndDlg,IDC_DIS,IDC_REF,IDC_DIS+PrivateEmulatorSetup(-1));
			break;
		case WM_COMMAND:
      switch (wParam) {
        case IDC_APPLY:
        case IDOK:
          EmMode=0;
          if (IsDlgButtonChecked(hwndDlg,IDC_RGB)) EmMode=1;
          if (IsDlgButtonChecked(hwndDlg,IDC_REF)) EmMode=2;
          PrivateEmulatorSetup(EmMode);
          if (wParam == IDOK) {
            char buf[8];
            wsprintf(buf,"%ld",EmMode);
            WriteProfileString("Direct3D","Emulation",buf);
          }
          EndDialog(hwndDlg,0);
          break;
        case IDCANCEL:
          EndDialog(hwndDlg,1);
          break;
      }
			break;
		case WM_CLOSE:
			EndDialog(hwndDlg,1);
			break;
	}
	return 0;
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine, int nCmdShow)
{	
	return DialogBoxParam(hInstance,MAKEINTRESOURCE(IDD_DIALOG1),0,SetupWnd,(LPARAM)lpCmdLine);
}
