; DDRAW.DLL replacement to use software emulation but make programs
;  think we have hardware support.
; The real DDRAW.DLL must be renamed to ORGDDRAW.DLL
;
; Works by intercepting DLL functions and patching vtables with
;  pointers to our methods.
;
; Created by Paul Chitescu - 15 August 1999

		.386p

; How we handle IDirect3D23::FindDevice : patch GUID or ignore it ?
FIND_GUID_REPL	equ	1	; change to 0 to ignore GUID instead


; Various standard identifiers for which I don't have the include
;  files (and also don't like to use them even if I had them)
DLL_PROC_ATTACH	equ	1

MB_OK		equ	0
MB_ICONHAND	equ	10h
MB_ICONQUESTION	equ	20h
MB_ICONEXCLAMATION	equ	30h
MB_ICONASTERISK	equ	40h

DDCREATE_HARDWAREONLY	equ	1
DDCREATE_EMULATIONONLY	equ	2

DDCAPS_3D	equ	1

D3DFDS_GUID	equ	2
D3DFDS_HARDWARE	equ	4

LENGTH_GUID1	equ	16
LENGTH_GUID2	equ	8
LENGTH_GUID4	equ	4

LENGTH_D3DDEVICEDESC	equ	100h		; 0fch for version 6

.idata		segment dword public use32 'DATA'

; Pointers to the real methods (taken from the vtable)
ICLSF_CI	dd	0
IDDraw_QI	dd	0
IDDraw_GC	dd	0
ID3D23_QI	dd	0
ID3D23_ED	dd	0
ID3D23_FD	dd	0
ID3D23_CD	dd	0
ID3D3_EZ	dd	0
ID3DD23_GC	dd	0

; Pointer to the GUID of the 3D device to be used
pTrueDevice	dd	-1
; Number of the 3D device to be used (0=none 1=RGB 2=REF)
iEmulType	dd	-1

; Device description of the HEL of the 3D device to be used
D3D_HEL_DevDesc	db	LENGTH_D3DDEVICEDESC dup (0)

.idata		ends

DGROUP		group	.idata


DEFINE_GUID	macro	lbl,l,w1,w2,b1,b2,b3,b4,b5,b6,b7,b8
lbl:
		dd	l
		dw	w1,w2
		db	b1,b2,b3,b4,b5,b6,b7,b8
		endm


MKFWD		macro	n
		public	My&n
		extrn	_&n:NEAR
My&n:		jmp	_&n
		endm


MKENT		macro	n
		public	My&n
		extrn	_&n:NEAR
My&n:
		endm


.text		segment byte public use32 'CODE'
		assume	cs:.text,ds:DGROUP,es:DGROUP

DEFINE_GUID	IID_IClassFactory,000000001h,00000h,00000h,0C0h,000h,000h,000h,000h,000h,000h,046h
DEFINE_GUID	CLSID_DirectDraw, 0D7B70EE0h,04340h,011CFh,0B0h,063h,000h,020h,0AFh,0C2h,0CDh,035h
DEFINE_GUID	IID_IDirectDraw,  06C14DB80h,0A733h,011CEh,0A5h,021h,000h,020h,0AFh,00Bh,0E5h,060h
DEFINE_GUID	IID_IDirectDraw2, 0B3A6F3E0h,02B43h,011CFh,0A2h,0DEh,000h,0AAh,000h,0B9h,033h,056h
DEFINE_GUID	IID_IDirectDraw4, 09c59509ah,039bdh,011d1h,08ch,04ah,000h,0c0h,04fh,0d9h,030h,0c5h
DEFINE_GUID	IID_IDirect3D,    03BBA0080h,02421h,011CFh,0A3h,01Ah,000h,0AAh,000h,0B9h,033h,056h
DEFINE_GUID	IID_IDirect3D2,   06aae1ec1h,0662ah,011d0h,088h,09dh,000h,0aah,000h,0bbh,0b7h,06ah
DEFINE_GUID	IID_IDirect3D3,   0bb223240h,0e72bh,011d0h,0a9h,0b4h,000h,0aah,000h,0c0h,099h,03eh
DEFINE_GUID	IID_IDirect3DRampDevice, 0F2086B20h,0259Fh,011CFh,0A3h,01Ah,000h,0AAh,000h,0B9h,033h,056h
DEFINE_GUID	IID_IDirect3DRGBDevice,  0A4665C60h,02673h,011CFh,0A3h,01Ah,000h,0AAh,000h,0B9h,033h,056h
DEFINE_GUID	IID_IDirect3DHALDevice,  084E63dE0h,046AAh,011CFh,081h,06Fh,000h,000h,0C0h,020h,015h,06Eh
DEFINE_GUID	IID_IDirect3DMMXDevice,  0881949a1h,0d6f3h,011d0h,089h,0abh,000h,0a0h,0c9h,005h,041h,029h
DEFINE_GUID	IID_IDirect3DRefDevice,  050936643h,013e9h,011d1h,089h,0aah,000h,0a0h,0c9h,005h,041h,029h
DEFINE_GUID	IID_IDirect3DNullDevice, 08767df22h,0bacch,011d1h,089h,069h,000h,0a0h,0c9h,006h,029h,0a8h
DEFINE_GUID	IID_IDirect3DDevice,     064108800h,0957dh,011d0h,089h,0abh,000h,0a0h,0c9h,005h,041h,029h
DEFINE_GUID	IID_IDirect3DDevice2,    093281501h,08cf8h,011d0h,089h,0abh,000h,0a0h,0c9h,005h,041h,029h
DEFINE_GUID	IID_IDirect3DDevice3,    0b0ab3b60h,033d7h,011d1h,0a9h,081h,000h,0c0h,04fh,0d7h,0b1h,074h

HAL_Dev_Name	db	'Pseudo Hardware',0
HAL_Dev_Desc	db	'Software Emulation',0
INI_Section	db	'Direct3D',0
INI_Key		db	'Emulation',0

;		extrn	_MessageBeep@4:NEAR
		extrn	_GetProfileIntA@12:NEAR


		public	_PrivateEmulatorSetup@4
_PrivateEmulatorSetup@4	PROC	NEAR
		mov	ecx,[esp+4]
		mov	eax,iEmulType
		cmp	ecx,-1
		je	pes_ret
		mov	eax,ecx
		mov	ecx,OFFSET IID_IDirect3DRGBDevice
		cmp	eax,1
		je	pes_set
		mov	ecx,OFFSET IID_IDirect3DRefDevice
		cmp	eax,2
		je	pes_set
		xor	eax,eax
		xor	ecx,ecx
pes_set:
		mov	iEmulType,eax
		mov	pTrueDevice,ecx
		mov	dword ptr D3D_HEL_DevDesc,0
pes_ret:
		ret	4
_PrivateEmulatorSetup@4	ENDP


		public	_DllEntry@12
_DllEntry@12	PROC	NEAR
		push	ebp
		mov	ebp,esp
		mov	eax,[ebp+12]		; fdwReason
		cmp	eax,DLL_PROC_ATTACH
		jne	@@ent_ret

		cmp	pTrueDevice,-1
		jne	@@ent_ret		; Already init
		push	0
		push	OFFSET INI_Key
		push	OFFSET INI_Section
		call	_GetProfileIntA@12
		push	eax
		call	_PrivateEmulatorSetup@4

@@ent_ret:	xor	eax,eax
		inc	eax
		leave
		ret	12
_DllEntry@12	ENDP


MayPatchClassF	PROC	NEAR
		; ebx = vtable of ICLSF
		; destroy ecx,flags
		mov	ecx,[ebx+3*4]		; CreateInstance
		cmp	ecx,OFFSET CLSF_CI
		je	clsf_no_ci		; already patched
		mov	ICLSF_CI,ecx
		mov	dword ptr [ebx+3*4],OFFSET CLSF_CI ; patch
clsf_no_ci:
		ret
MayPatchClassF	ENDP


MayPatchDDraw	PROC	NEAR
		; ebx = vtable of IDD, IDD2 or IDD4
		; destroy ecx,flags
		mov	ecx,[ebx+0]		; QueryInterface
		cmp	ecx,OFFSET DDraw_QI
		je	mpdd_no_qi		; already patched
		mov	IDDraw_QI,ecx
		mov	dword ptr [ebx+0],OFFSET DDraw_QI ; patch
mpdd_no_qi:
		mov	ecx,[ebx+11*4]		; GetCaps
		cmp	ecx,OFFSET DDraw_GC
		je	mpdd_no_gc		; already patched
		mov	IDDraw_GC,ecx
		mov	dword ptr [ebx+11*4],OFFSET DDraw_GC ; patch
mpdd_no_gc:
		ret
MayPatchDDraw	ENDP


MayPatchD3D23	PROC	NEAR
		; ebx = vtable of ID3D2 or ID3D3
		; destroy ecx,flags
		mov	ecx,[ebx+0]		; QueryInterface
		cmp	ecx,OFFSET D3D23_QI
		je	mpd3d23_no_qi		; already patched
		mov	ID3D23_QI,ecx
		mov	dword ptr [ebx+0],OFFSET D3D23_QI ; patch
mpd3d23_no_qi:
		mov	ecx,[ebx+3*4]		; EnumDevices
		cmp	ecx,OFFSET D3D23_ED
		je	mpd3d23_no_ed		; already patched
		mov	ID3D23_ED,ecx
		mov	dword ptr [ebx+3*4],OFFSET D3D23_ED ; patch
mpd3d23_no_ed:
		mov	ecx,[ebx+7*4]		; FindDevice
		cmp	ecx,OFFSET D3D23_FD
		je	mpd3d23_no_fd		; already patched
		mov	ID3D23_FD,ecx
		mov	dword ptr [ebx+7*4],OFFSET D3D23_FD ; patch
mpd3d23_no_fd:
		mov	ecx,[ebx+8*4]		; CreateDevice
		cmp	ecx,OFFSET D3D23_CD
		je	mpd3d23_no_cd		; already patched
		mov	ID3D23_CD,ecx
		mov	dword ptr [ebx+8*4],OFFSET D3D23_CD ; patch
mpd3d23_no_cd:
		ret
MayPatchD3D23	ENDP


MayPatchD3D3	PROC	NEAR
		; ebx = vtable of ID3D3
		; destroy ecx,flags
		mov	ecx,[ebx+10*4]		; EnumZBufferFormats
		cmp	ecx,OFFSET D3D3_EZ
		je	mpd3d3_no_ez		; already patched
		mov	ID3D3_EZ,ecx
		mov	dword ptr [ebx+10*4],OFFSET D3D3_EZ ; patch
mpd3d3_no_ez:
		ret
MayPatchD3D3	ENDP


MayPatchD3DD23	PROC	NEAR
		; ebx = vtable of ID3DD23
		; destroy ecx,flags
		mov	ecx,[ebx+3*4]		; GetCaps
		cmp	ecx,OFFSET D3DD23_GC
		je	mpd3dd23_no_gc		; already patched
		mov	ID3DD23_GC,ecx
		mov	dword ptr [ebx+3*4],OFFSET D3DD23_GC ; patch
mpd3dd23_no_gc:
		ret
MayPatchD3DD23	ENDP


; Callback for the original EnumDevices to fill D3D_HEL_DevDesc
D3DEnumDevCB	PROC	NEAR
		push	ebp
		mov	ebp,esp
		push	esi
		push	edi

		mov	eax,1			; continue enumeration
		mov	esi,[ebp+08]		; lpGuid
		test	esi,esi
		jz	d3d_enum_ret
		mov	edi,pTrueDevice		; what we look for
		test	edi,edi
		jz	d3d_enum_stop
		mov	ecx,LENGTH_GUID4
		cld
		repe	cmpsd
		jne	d3d_enum_ret

		mov	esi,[ebp+24]		; lpD3DHELDeviceDesc
		test	esi,esi
		jz	d3d_enum_stop
		mov	edi,OFFSET D3D_HEL_DevDesc
		mov	ecx,LENGTH_D3DDEVICEDESC
		cmp	ecx,[esi]
		jbe	d3d_enum_cpy
		mov	ecx,[esi]		; limit the size
d3d_enum_cpy:
		jecxz	d3d_enum_stop
		mov	eax,ecx
		cld
		rep	movsb
		mov	dword ptr D3D_HEL_DevDesc,eax
d3d_enum_stop:
		xor	eax,eax			; stop enumeration
d3d_enum_ret:
		pop	edi
		pop	esi
		pop	ebp
		ret	6*4
D3DEnumDevCB	ENDP


		MKFWD	AcquireDDThreadLock
		MKFWD	D3DParseUnknownCommand
		MKFWD	DDHAL32_VidMemAlloc
		MKFWD	DDHAL32_VidMemFree
		MKFWD	DDInternalLock
		MKFWD	DDInternalUnlock
		MKFWD	DSoundHelp
; trapped	MKFWD	DirectDrawCreate
		MKFWD	DirectDrawCreateClipper
		MKFWD	DirectDrawEnumerateA
		MKFWD	DirectDrawEnumerateExA
		MKFWD	DirectDrawEnumerateExW
		MKFWD	DirectDrawEnumerateW
		MKFWD	DllCanUnloadNow
; trapped	MKFWD	DllGetClassObject
		MKFWD	GetAliasedVidMem
		MKFWD	GetNextMipMap
		MKFWD	GetOLEThunkData
		MKFWD	GetSurfaceFromDC
		MKFWD	HeapVidMemAllocAligned
		MKFWD	InternalLock
		MKFWD	InternalUnlock
		MKFWD	LateAllocateSurfaceMem
		MKFWD	RegisterSpecialCase
		MKFWD	ReleaseDDThreadLock
		MKFWD	VidMemAlloc
		MKFWD	VidMemAmountFree
		MKFWD	VidMemFini
		MKFWD	VidMemFree
		MKFWD	VidMemInit
		MKFWD	VidMemLargestFree
		MKFWD	thk1632_ThunkData32
		MKFWD	thk3216_ThunkData32

; *** DirectDrawCreate ***
		MKENT	DirectDrawCreate
		push	ebp
		mov	ebp,esp
		push	ebx
		push	dword ptr [ebp+16]	; pUnkOuter
		push	dword ptr [ebp+12]	; lplpDD
		push	dword ptr [ebp+08]	; lpGUID
		call	_DirectDrawCreate
		test	eax,80000000h
		jnz	ddc_ret			; error
		mov	ebx,[ebp+12]		; lplpDD
		test	ebx,ebx
		jz	ddc_ret
		mov	ebx,[ebx]		; lpDD
		test	ebx,ebx
		jz	ddc_ret
		mov	ebx,[ebx]		; vtable
		test	ebx,ebx
		jz	ddc_ret
		call	MayPatchDDraw
ddc_ret:
		pop	ebx
		pop	ebp
		ret	3*4


; *** DllGetClassObject ***
		MKENT	DllGetClassObject
		push	ebp
		mov	ebp,esp
		push	ebx
		push	esi
		push	edi

		push	dword ptr [ebp+16]	; ppvObject
		push	dword ptr [ebp+12]	; rIID
		push	dword ptr [ebp+08]	; rCLSID
		call	_DllGetClassObject
		test	eax,eax
		jnz	gco_ret			; error

		mov	ebx,[ebp+16]		; ppvObject
		test	ebx,ebx
		jz	gco_ret
		mov	ebx,[ebx]		; pvObject
		test	ebx,ebx
		jz	gco_ret
		mov	ebx,[ebx]		; vtable
		test	ebx,ebx
		jz	gco_ret

		cld
		mov	esi,[ebp+12]		; rIID
		mov	edi,OFFSET IID_IClassFactory
		mov	ecx,LENGTH_GUID4
		repe	cmpsd
		jne	gco_test_dd
		call	MayPatchClassF
		jmp	gco_ret

gco_test_dd:
		mov	esi,[ebp+08]		; rCLSID
		mov	edi,OFFSET CLSID_DirectDraw
		mov	ecx,LENGTH_GUID4
		repe	cmpsd
		jne	gco_ret
		mov	esi,[ebp+12]		; rIID
		mov	edi,OFFSET IID_IDirectDraw
		mov	ecx,LENGTH_GUID4
		repe	cmpsd
		je	gco_dd_patch
		mov	esi,[ebp+12]		; rIID
		mov	edi,OFFSET IID_IDirectDraw2
		mov	ecx,LENGTH_GUID4
		repe	cmpsd
		je	gco_dd_patch
		mov	esi,[ebp+12]		; rIID
		mov	edi,OFFSET IID_IDirectDraw4
		mov	ecx,LENGTH_GUID4
		repe	cmpsd
		jne	gco_ret
gco_dd_patch:
		call	MayPatchDDraw
gco_ret:
		pop	edi
		pop	esi
		pop	ebx
		pop	ebp
		ret	3*4

; *** IClassFactory::CreateInstance ***
CLSF_CI:
		push	ebp
		mov	ebp,esp
		push	ebx
		push	esi
		push	edi

		push	dword ptr [ebp+20]	; ppvObject
		push	dword ptr [ebp+16]	; rIID
		push	dword ptr [ebp+12]	; pUnkOuter
		push	dword ptr [ebp+08]	; this
		call	ICLSF_CI
		test	eax,80000000h
		jnz	cf_ci_ret		; error

		mov	ebx,[ebp+20]		; ppvObject
		test	ebx,ebx
		jz	cf_ci_ret
		mov	ebx,[ebx]		; pvObject
		test	ebx,ebx
		jz	cf_ci_ret
		mov	ebx,[ebx]		; vtable
		test	ebx,ebx
		jz	cf_ci_ret

		cld
		mov	esi,[ebp+16]		; rIID
		mov	edi,OFFSET IID_IDirectDraw
		mov	ecx,LENGTH_GUID4
		repe	cmpsd
		je	cf_ci_dd_patch
		mov	esi,[ebp+16]		; rIID
		mov	edi,OFFSET IID_IDirectDraw2
		mov	ecx,LENGTH_GUID4
		repe	cmpsd
		je	cf_ci_dd_patch
		mov	esi,[ebp+16]		; rIID
		mov	edi,OFFSET IID_IDirectDraw4
		mov	ecx,LENGTH_GUID4
		repe	cmpsd
		jne	cf_ci_nodd
cf_ci_dd_patch:
		call	MayPatchDDraw
		jmp	cf_ci_ret
cf_ci_nodd:
		mov	esi,[ebp+16]		; rIID
		mov	edi,OFFSET IID_IDirect3D2
		mov	ecx,LENGTH_GUID4
		repe	cmpsd
		je	cf_ci_d3d_patch
		mov	esi,[ebp+16]		; rIID
		mov	edi,OFFSET IID_IDirect3D3
		mov	ecx,LENGTH_GUID4
		repe	cmpsd
		jne	cf_ci_nod3d
		call	MayPatchD3D3
cf_ci_d3d_patch:
		call	MayPatchD3D23
		jmp	cf_ci_ret
cf_ci_nod3d:

cf_ci_ret:
		pop	edi
		pop	esi
		pop	ebx
		pop	ebp
		ret	4*4


; *** IDirect3D::QueryInterface ***
D3D23_QI:
		push	ebp
		mov	ebp,esp
		push	ebx
		push	esi
		push	edi

		push	dword ptr [ebp+16]	; ppvObject
		push	dword ptr [ebp+12]	; rIID
		push	dword ptr [ebp+08]	; this
		call	ID3D23_QI
		jmp	qi_common


; *** IDirectDraw::QueryInterface ***
DDraw_QI:
		push	ebp
		mov	ebp,esp
		push	ebx
		push	esi
		push	edi

		push	dword ptr [ebp+16]	; ppvObject
		push	dword ptr [ebp+12]	; rIID
		push	dword ptr [ebp+08]	; this
		call	IDDraw_QI
qi_common:
		test	eax,80000000h
		jnz	dd_qi_ret		; error

		mov	ebx,[ebp+16]		; ppvObject
		test	ebx,ebx
		jz	dd_qi_ret
		mov	ebx,[ebx]		; pvObject
		test	ebx,ebx
		jz	dd_qi_ret
		mov	ebx,[ebx]		; vtable
		test	ebx,ebx
		jz	dd_qi_ret

		cld
		mov	esi,[ebp+12]		; rIID
		mov	edi,OFFSET IID_IDirectDraw
		mov	ecx,LENGTH_GUID4
		repe	cmpsd
		je	dd_qi_dd_patch
		mov	esi,[ebp+12]		; rIID
		mov	edi,OFFSET IID_IDirectDraw2
		mov	ecx,LENGTH_GUID4
		repe	cmpsd
		je	dd_qi_dd_patch
		mov	esi,[ebp+12]		; rIID
		mov	edi,OFFSET IID_IDirectDraw4
		mov	ecx,LENGTH_GUID4
		repe	cmpsd
		jne	dd_qi_nodd
dd_qi_dd_patch:
		call	MayPatchDDraw
		jmp	dd_qi_ret
dd_qi_nodd:
		mov	esi,[ebp+12]		; rIID
		mov	edi,OFFSET IID_IDirect3D2
		mov	ecx,LENGTH_GUID4
		repe	cmpsd
		je	dd_qi_d3d_patch
		mov	esi,[ebp+12]		; rIID
		mov	edi,OFFSET IID_IDirect3D3
		mov	ecx,LENGTH_GUID4
		repe	cmpsd
		jne	dd_qi_nod3d
		call	MayPatchD3D3
dd_qi_d3d_patch:
		call	MayPatchD3D23
		jmp	dd_qi_ret
dd_qi_nod3d:

dd_qi_ret:
		pop	edi
		pop	esi
		pop	ebx
		pop	ebp
		ret	3*4


; *** IDirectDraw::GetCaps ***
DDraw_GC:
		push	ebp
		mov	ebp,esp
		push	ebx

		push	dword ptr [ebp+16]	; lpDDHELCaps
		push	dword ptr [ebp+12]	; lpDDDriverCaps
		push	dword ptr [ebp+08]	; this
		call	IDDraw_GC
		test	eax,80000000h
		jnz	dd_gc_ret		; error

		mov	ebx,[ebp+12]		; lpDDDriverCaps
		test	ebx,ebx
		jz	dd_gc_ret
		or	dword ptr [ebx+4],DDCAPS_3D
dd_gc_ret:
		pop	ebx
		pop	ebp
		ret	3*4


; *** IDirect3D23::CreateDevice ***
D3D23_CD:
		push	ebp
		mov	ebp,esp
		push	ebx
		push	esi
		push	edi

		cld
		mov	esi,[ebp+12]		; rCLSID
		test	esi,esi
		jz	d3d23_cd_go
		mov	edi,OFFSET IID_IDirect3DHALDevice
		mov	ecx,LENGTH_GUID4
		repe	cmpsd
		jne	d3d23_cd_go
		mov	ecx,pTrueDevice
		jecxz	d3d23_cd_go
		mov	dword ptr [ebp+12],ecx
d3d23_cd_go:
		pop	edi
		pop	esi
		pop	ebx
		pop	ebp
		jmp	ID3D23_CD


; *** IDirect3D23::EnumDevices ***
D3D23_ED:
		push	ebp
		mov	ebp,esp
		push	ebx

		mov	ebx,[ebp+12]		; lpEnumDevicesCallback
		test	ebx,ebx
		jz	d3d23_ed_go

; Check the length field of D3D_HEL_DevDesc to see if it was filled
		test	dword ptr D3D_HEL_DevDesc,0ffffffffh
		jnz	d3d23_ed_filled
; Call the original EnumDevices to fill D3D_HEL_DevDesc
		push	ebx			; just to be sure ..
		push	0
		push	OFFSET D3DEnumDevCB
		push	dword ptr [ebp+08]	; this
		call	ID3D23_ED
		pop	ebx
		test	eax,80000000h
		jnz	d3d23_ed_go		; error
		test	dword ptr D3D_HEL_DevDesc,0ffffffffh
		jz	d3d23_ed_go		; no match ???
d3d23_ed_filled:
		push	dword ptr [ebp+16]	; lpUserArg
		push	OFFSET D3D_HEL_DevDesc
		push	OFFSET D3D_HEL_DevDesc
		push	OFFSET HAL_Dev_Name
		push	OFFSET HAL_Dev_Desc
		push	OFFSET IID_IDirect3DHALDevice
		call	ebx
		test	eax,eax
		jnz	d3d23_ed_go		; continue
		pop	ebx
		pop	ebp
		ret	3*4

d3d23_ed_go:
		pop	ebx
		pop	ebp
		jmp	ID3D23_ED


; *** IDirect3D23::FindDevice ***
D3D23_FD:
		push	ebp
		mov	ebp,esp
		push	ebx
		push	esi
		push	edi

		mov	ebx,[ebp+12]		; lpD3DFDS
		test	ebx,ebx
		jz	d3d23_fd_nuls
		and	dword ptr [ebx+4],NOT D3DFDS_HARDWARE
		test	dword ptr [ebx+4],D3DFDS_GUID
		jz	d3d23_fd_nuls
		cld
		lea	esi,[ebx+16]		; guid
		mov	edi,OFFSET IID_IDirect3DHALDevice
		mov	ecx,LENGTH_GUID4
		repe	cmpsd
		jne	d3d23_fd_nuls
	IF	FIND_GUID_REPL
		mov	esi,pTrueDevice
		test	esi,esi
		jz	d3d23_fd_nuls
		lea	edi,[ebx+16]		; guid
		mov	ecx,LENGTH_GUID4
		rep	movsd
	ELSE
		and	dword ptr [ebx+4],NOT D3DFDS_GUID
	ENDIF
d3d23_fd_nuls:
		push	dword ptr [ebp+16]	; lpD3DFDR
		push	dword ptr [ebp+12]	; lpD3DFDS
		push	dword ptr [ebp+08]	; this
		call	ID3D23_FD
		test	eax,80000000h
		jnz	d3d23_fd_ret		; error

		mov	ebx,[ebp+16]		; lpD3DFDR
		test	ebx,ebx
		jz	d3d23_fd_ret
;;

d3d23_fd_ret:
		pop	edi
		pop	esi
		pop	ebx
		pop	ebp
		ret	3*4


; *** IDirect3D3::EnumZBufferFormats ***
D3D3_EZ:
		push	ebp
		mov	ebp,esp
		push	ebx
		push	esi
		push	edi

		cld
		mov	esi,[ebp+12]		; riidDevice
		test	esi,esi
		jz	d3d3_ez_go
		mov	edi,OFFSET IID_IDirect3DHALDevice
		mov	ecx,LENGTH_GUID4
		repe	cmpsd
		jne	d3d3_ez_go
		mov	ecx,pTrueDevice
		jecxz	d3d3_ez_go
		mov	dword ptr [ebp+12],ecx
d3d3_ez_go:
		pop	edi
		pop	esi
		pop	ebx
		pop	ebp
		jmp	ID3D3_EZ


; *** IDirect3DDevice23::GetCaps ***
D3DD23_GC:
		push	ebp
		mov	ebp,esp
		push	ebx

		push	dword ptr [ebp+16]	; lpD3DHELDevDesc
		push	dword ptr [ebp+12]	; lpD3DHWDevDesc
		push	dword ptr [ebp+08]	; this
		call	ID3DD23_GC
		test	eax,80000000h
		jnz	d3dd23_gc_ret		; error

d3dd23_gc_ret:
		pop	ebx
		pop	ebp
		ret	3*4


; To do :
; IDirect3DDevice::Initialize
; IDirect3DDevice::CreateExecuteBuffer
; IDirect3DExecuteBuffer::Lock

.text		ends

		end
