/* SLAMacs.Cmd: Copy updated mac drivers to install directory

    Copyright (c) 2000, 2001 Steven Levine and Associates, Inc.
    All rights reserved.

    $TLIB$: $ &(#) %n - Ver %v, %f $
    TLIB: $ $

    Revisions	03 Oct 00 SHL - Release
    		05 Oct 01 SHL - Use args

*/

signal on ERROR
signal on FAILURE name Error
signal on HALT
signal on NOTREADY name Error
signal on NOVALUE name Error
signal on SYNTAX name Error

call Initialize

Main:

  parse arg bootdrv rest

  err = 0

  'echo on'
  signal off error
  'mkdir' bootdrv || '\ibmcom'
  'mkdir' bootdrv || '\ibmcom\macs'
  signal on error
  'copy x:\macs\*' bootdrv || '\ibmcom\macs'

  exit err

/* end main */

/*====================================================== */
/*=== Common Code - Delete unused, but do not modify === */
/*====================================================== */

/*=== CatchError: Catch condition for user ===*/

CatchError:

  szCondition = condition('C')
  return

/* end CatchError */

/*=== Error: Trap ERROR, FAILURE etc. conditions ===*/

Error:

  /*=== Returns szCondition or Exits ===*/

  say
  parse source . . szThisCmd
  say condition('C') 'signaled at' SIGL 'of' szThisCmd
  drop szThisCmd
  say 'Source =' sourceline(SIGL)
  if condition('I') = 'CALL' then do
    szCondition = condition('C')
    say 'Returning'
    return
  end
  else do
    say 'Exiting'
    exit x2d(1604)
  end

/* end Error */

/*=== Halt: Trap HALT condition ===*/

Halt:

  /*=== Returns szCondition or Exits ===*/

  say
  parse source . . szThisCmd
  say condition('C') 'signaled at' SIGL 'of' szThisCmd
  drop szThisCmd
  say 'Source = ' sourceline(SIGL)
  if condition('I') = 'CALL' then do
    szCondition = condition('C')
    say 'Returning'
    return
  end
  else do
   say 'Exiting'
   exit x2d(1604)
  end

/* end Halt */

/*=== Initialize: Intialize globals ===*/

Initialize:

if 0 then call LoadFuncs

parse source . . szThisCmd

return

/* end Initialize */

/*=== LoadFuncs: Load fuctions ===*/

LoadFuncs:

/* Add all Rexx functions */
if RxFuncQuery('SysLoadFuncs') then do
  call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
  if RESULT then do
    say 'Cannot load SysLoadFuncs'
    exit x2d(1604)
  end
  call SysLoadFuncs
end /* end do */

return

/* end LoadFuncs */

/* The end */
