/* MyDesk.Cmd: Make standard desktop objects

    Copyright (c) 1997, 2001 Steven Levine and Associates, Inc.
    All rights reserved.

    $TLIB$: $ &(#) %n - Ver %v, %f $
    TLIB: $ $

    Revisions	27 Feb 01 SHL - Release
    		05 Oct 01 SHL - Correct typos

*/

signal on ERROR
signal on FAILURE name Error
signal on HALT
signal on NOTREADY name Error
signal on NOVALUE name Error
signal on SYNTAX name Error

call Initialize

Main:

  parse arg szRest

  szRest = strip(szRest)

  do while szRest \= ''
    parse var szRest szArg szRest
    szRest = strip(szRest)
    szArgU = translate(szArg)

    select
    when left(szArgU, 3) == '/B:' then do
      Gbl.szBootDrv = substr(szArg, 4)
      if right(Gbl.szBootDrv, 1) \= ':' then
        Gbl.szBootDrv = Gbl.szBootDrv':'
      if length(Gbl.szBootDrv) \= 2 then
        call Fatal Gbl.szBootDrv 'unexpected'
    end
    when left(szArgU, 3) == '/L:' then do
      Gbl.szLogFile = substr(szArg, 4)
    end
    otherwise
      call UsageErr szArg 'unexpecected'
    end
  end /* while */

  if symbol('Gbl.szLogFile') = 'LIT' then
    call UsageErr '/L:  missing'

  if symbol('Gbl.szBootDrv') = 'LIT' then
    call UsageErr '/B: missing'

  say 'OK'
  exit 0

  /* Create ZtBold program object */
  szSetup = 'EXENAME=c:\ztbold\ztb.exe;' ||,
            'PARAMETERS='Gbl.szBootDrv'\;' ||,
            'STARTUPDIR=c:\ztbold;' ||,
            'PROGTYPE=VIO' ||,
            'OBJECTID=<ZtBold>;'

  call CreatePgmObject 'ZtBold', '<WP_DESKTOP>', szSetup

  exit 0

/* end main */

/*=== CreatePgmObject(Name, Location, Setup) ===*/

CreatePgmObject: procedure expose Gbl.

  szName = arg(1)
  szLocation = arg(2)
  szSetup = arg(3)

  /* Create program object */
  say 'Creating' szName 'object...'
  rc = SysCreateObject('WPProgram',,
                       szName,,
                       szLocation,,
                       szSetup,,
                       'REPLACE')
  if rc \= 1 then
    call FatalErr 'Can not create' szName 'object'

  return

/* end CreatePgmObject */

/*=== CreateShadow(Name, Location) ===*/

CreateShadow: procedure expose Gbl. Gbl.

  szName = arg(1)
  szLocation = arg(2)

  /* Create program object */
  say 'Creating' szName 'object...'
  rc = SysCreateShadow(szName,,
                       szLocation)

  if rc \= 1 then
    call FatalErr 'Can not create' szName 'shadow'

  return

/* end CreateShadow */

/*=== FatalErr: Report fatal error and exit ===*/

FatalErr: expose Gbl.

  parse arg szMsg

  if symbol('Gbl.szLogFile') == 'LIT' then
    say szMsg
  else
    call WriteLog szMsg

  exit x2d(1604)

/* end FatalErr */

/*=== Initialize: Intialize globals ===*/

Initialize:

  call LoadFuncs

  /* Set:
      Gbl.szCmdName
  */

  parse source . . Gbl.szCmdName
  Gbl.szCmdName = filespec('N', Gbl.szCmdName)
  c = pos('.', Gbl.szCmdName)
  if c > 1 then
    Gbl.szCmdName = substr(Gbl.szCmdName, 1, c - 1)

  return

/* end Initialize */

/*=== LogClose(void): Close log file ===*/

LogClose:

  call stream Gbl.!szLogFile, 'C', 'CLOSE'

  if RESULT = '' then
    exit x2d(1604)

  return

/* end LogClose */

/*=== LogOpen(void): Open log file ===*/

LogOpen: procedure expose Gbl. Gbl.

  call stream Gbl.!szLogFile, 'C', 'OPEN WRITE'

  if RESULT = '' then
    exit x2d(1604)

  return

/* end LogOpen */

/*=== LogWrite(szLine): Write line to log ===*/

LogWrite: procedure expose Gbl. Gbl.

  parse arg sz

  call lineout Gbl.!szLogFile, date() time() Gbl.CmdName':' sz

  if RESULT \= 1 then
    exit x2d(1604)

  return

/* end LogWrite */

/*=== UsageErr(szMsg): ... ===*/

UsageErr:

  parse arg szMsg

  say szMsg

  /* Drop thru to UsageHelp */

/* end UsageErr */

/*=== UsageHelp: Display help ===*/

  exit x2d(1604)

/* end UsageHelp */

/*====================================================== */
/*=== Common Code - Delete unused, but do not modify === */
/*====================================================== */

/*=== CatchError: Catch condition for user ===*/

CatchError:

  szCondition = condition('C')
  return

/* end CatchError */

/*=== Error: Trap ERROR, FAILURE etc. conditions ===*/

Error:

  /*=== Returns szCondition or Exits ===*/

  say
  parse source . . szThisCmd
  say condition('C') 'signaled at' SIGL 'of' szThisCmd
  drop szThisCmd
  say 'Source =' sourceline(SIGL)
  if condition('I') = 'CALL' then do
    szCondition = condition('C')
    say 'Returning'
    return
  end
  else do
    say 'Exiting'
    exit x2d(1604)
  end

/* end Error */

/*=== Halt: Trap HALT condition ===*/

Halt:

  /*=== Returns szCondition or Exits ===*/

  say
  parse source . . szThisCmd
  say condition('C') 'signaled at' SIGL 'of' szThisCmd
  drop szThisCmd
  say 'Source = ' sourceline(SIGL)
  if condition('I') = 'CALL' then do
    szCondition = condition('C')
    say 'Returning'
    return
  end
  else do
   say 'Exiting'
   exit x2d(1604)
  end

/* end Halt */

/*=== LoadFuncs: Load fuctions ===*/

LoadFuncs:

/* Add all Rexx functions */
if RxFuncQuery('SysLoadFuncs') then do
  call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
  if RESULT then do
    say 'Cannot load SysLoadFuncs'
    exit
  end
  call SysLoadFuncs
end /* end do */

return

/* end LoadFuncs */

/* The end */
