/* CHKLANLK.CMD - check config.sys for the ibmlanlk driver
		  Fail if found
		  Arg is boot drive (C:) logfile

*/

signal on HALT
signal on NOVALUE name Error
signal on SYNTAX name Error

Gbl.szCmdName = 'ChkLANLk'

call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
call RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'

parse arg szBootDrv Gbl.szLogFile .

if szBootDrv = '' then
  drop szBootDrv                /* Force error */

if Gbl.szLogFile = '' then
  drop Gbl.szLogFile

szConfigSys = szBootDrv || '\CONFIG.SYS'

/* retry in case config.sys locked by someone else */

do sleepcnt = 0 to 12
  rc = stream(szConfigSys, 'C', 'OPEN READ')
  if rc = 'READY:' then do
    call stream szConfigSys, 'C', 'CLOSE'
    leave
  end
  say ''
  call SysSleep 5
end

if rc \= 'READY:' then
  call Fatal 'Can not open' szConfigSys

fGotLock = 0

do until lines(szConfigSys) = 0 | fGotLock > 0
  szLine = linein(szConfigSys)
  parse upper var szLine szCmd szFile
  fGotLock = pos('IBMLANLK', szCmd)
  If fGotLock > 0 then do
    fGotLock = 1
    szLockFile = szFile
    parse upper var szCmd 'DEVICE='szDriverPath '\IBMLANLK'.
  end
end

call stream szConfigSys, 'C', 'CLOSE'

if fGotLock then
  call Fatal 'Locked files pending'

return 0

/*====================================================== */
/*=== Common Code - Delete unused, but do not modify === */
/*====================================================== */

/*=== Error() - report ERROR, FAILURE etc. conditions ===*/

Error:
  parse source . . szThisCmd
  say condition('C') 'signaled at' SIGL 'of' szThisCmd
  say 'Source = ' sourceline(SIGL)
  say 'Exiting'
  exit x2d(1604)

/* end Error */

/*=== Fatal(message) Report fatal error and exit ===*/

Fatal:
  parse arg szMsg
  say szMsg
  call LogWrite szMsg
  exit x2d(1604)		/* Unexpected condition */

/* end Fatal */

/*=== Halt() - report HALT condition ===*/

Halt:
  parse source . . szThisCmd
  say condition('C') 'signaled at' SIGL 'of' szThisCmd
  say 'Source = ' sourceline(SIGL)
  say 'Exiting'
  exit x2d(1604)

/* end Halt */

/*=== LogWrite(szLine): Write line to log ===*/

LogWrite: procedure expose Gbl.

  parse arg sz

  sz = date() time() Gbl.szCmdName':' sz
  if symbol('Gbl.szLogFile') == 'LIT' then
    say sz
  else do
    call lineout Gbl.szLogFile, date() time()':' sz
    if RESULT \= 0 then do
      say sz
      say 'Can not write to' Gbl.szLogFile
      exit x2d(1604)
    end
  end

  return

/* end LogWrite */

/* ChkLockedFiles */
