/* JSLBX1C.CMD - Warp 4.5 (MCP) CID install
   09 Oct 01 SHL

   Destination:  JSLBX1 Drive C
   NIC: DAVICOM DM9 PCI Series Fast Ethernet Adapter (DM9PCI.NIF)

   Assumes: Warp4.5 MCP CD in drive I

   Installs:
     Warp4.5 from CD
     MPTS 6.x from CD
     Peer 1.0 from Server
     TCP/IP 4.3 from CD
     Base SLA tools
*/

/*     Warp Server Sample LCU Command File           */
/*---------------------------------------------------*/
/*         DO NOT MODIFY THE NEXT EIGHT LINES        */
/*---------------------------------------------------*/

parse ARG client logfile additional

QUEUE_REBOOT = 0
CALL_AGAIN = 0

Call AddDLLFunctions

x.0.instprog = ''
x.0.rspdir   = ''
x.0.statevar = 'CAS_STATE'
x.0.default  = ''

/*---------------------------------------------------*/
/*             MODIFICATIONS START HERE              */
/*---------------------------------------------------*/


/*****************************************************/
/*                 SRVATTCH SECTION                  */
/*****************************************************/


server1 = '\\slasrv\'                   /* SRVIFS CID Server                       */

/* 'srvattch x: 'server1'cid' */        /* Additional SRVATTCHs can be placed here */
/* 'srvattch y: 'server1'log' */        /* Additional SRVATTCHs can be placed here */
/* 'srvattch z: 'server1'cdrom' */      /* Additional SRVATTCHs can be placed here */

/*****************************************************/
/*                 VARIABLES SECTION                 */
/*****************************************************/

/*---------------------------------------------------*/
/*         DO NOT REMOVE THE REFERENCED LINES        */
/*              (They may be modified)               */
/*---------------------------------------------------*/

bootdrive  = 'C:'                       /* Boot Drive                           */

cddrive    = 'Z:'                       /* CD-ROM Redirected Drive              */
writedrive = 'Y:'                       /* CID Server Redirected Writable Drive */
ciddrive   = 'X:'                       /* CID Server Redirected Drive          */

configsys = bootdrive'\CONFIG.SYS'      /* Fully qualified path to CONFIG.SYS   */
maintdir  = bootdrive'\SERVICE'         /* Maintenance directory                */

/* Product image locations */

ibminstdir = cddrive'\IBMINST'                  /* Install tools on CD-ROM                     */
cidimgdir  = ciddrive'\IMG'                     /* Image directory on server                   */
cidcsddir  = ciddrive'\CSD'                     /* CSD image directory on server               */
cdimgdir   = cddrive'\CID\SERVER'               /* Product image directory on CD-ROM           */

os2imgdir  = cddrive'\OS2IMAGE'                 /* Warp4.5 source directory                    */
mptsimgdir = cddrive'\CID\SERVER\MPTS'          /* MPTS 6.? image directory                    */
tcpipimgdir = cdimgdir'\TCPAPPS'                /* TCP/IP 4.3 applications directory on CD     */
peerimgdir = cdimgdir'\IBMLS'                   /* Peer ?.? source directory                   */
xr_m0xxdir = ciddrive'\CSD\Warp45\XR_M0XX'      /* Warp 4.5 service pak directory on server    */
xr_d0xxdir = ciddrive'\CSD\Warp45\XR_D0XX'      /* Warp 4.5 service pak directory on server    */
ddprepdir  = ciddrive'\CSD\WARP45\XR_D0XX\FIX\FIXTOOL.EXT'
lcudir     = cidimgdir'\LCU.45'                 /* V4.5 LCU directory on server                */
dllpath    = ciddrive'\DLL\V450;'lcudir';'ibminstdir';' /* DLL directories on server and CD-ROM */
exepath    = ciddrive'\EXE\V450'                /* Path to executable directory on server      */
lcucmddir  = ciddrive'\CLIENT'                  /* Location of .cmd files (passed to casagent) */
logsdir    = writedrive                         /* Log file directory                          */
respdir    = ciddrive'\RSP'                     /* Response file directory                     */
slatooldir = ciddrive'\SLATOOL'                 /* SL&A tools directory                        */

configsys = bootdrive'\CONFIG.SYS'      /* Fully qualified path to CONFIG.SYS   */

/* MPTS VARIABLES */
mptsdrive = "C:"                        /* MPTS target directory                */
nifname   = 'DM9PCI.NIF'                /* DawiCom                              */

/* NETWARE REQUESTER VARIABLES */
nwtgtpath   = "C"                       /* NetWare Requester target directory   */
nwprefsrv   = ""                        /* NetWare Requester Perfered Server    */
nwtokenring = "FALSE"                   /* Token-Ring or Ethernet network       */
nwcontext   = '""'
nwversion   = "4"                       /* NetWare Requester Version 4.0        */

/* MOBILE FILE SYNCH VARIABLES */
MFS_Drive = "C:"                        /* Mobile File Synch target directory   */

netscape_instupdt = "i"                 /* Netscape install option              */

lcfagent_instupdt = "i"                 /* TME 10 install option                */

booksdrive = "C:"                       /* Books target directory               */

MyCasSetup:

/*****************************************************/
/*               PRODUCT DATA SECTION                */
/*****************************************************/

/* Note , at EOF same as ' ' */

i = 0

i            = i + 1
x.seinst     = i                                       /* structure index                      */
x.i.name     = 'OS/2 Warp 4.5'                         /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = exepath'\seinst',                       /* fully qualified install program name */
		 '/b:'bootdrive,                       /* bootdrive                            */
		 '/s:'os2imgdir,                       /* source directory                     */
		 '/t:'maintdir,                        /* service directory                    */
		 '/l1:'logsdir'\warp45\'client'.log',  /* log file                             */
		 '/r:'                                 /* response file flag (auto selection)  */
x.i.rspdir   = respdir'\warp45\'                       /* response file directory              */
x.i.default  = 'DefaultC.rsp'                          /* default response file name           */

i            = i + 1
x.MptsMaint  = i                                       /* structure index                      */
x.i.name     = 'MPTS from Maintenance'                 /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = mptsimgdir'\mpts',                      /* fully qualified install program name */
		 '/e:maint',                           /* maintenance installation             */
		 '/s:'mptsimgdir,                      /* source directory                     */
		 '/t:'mptsdrive'\',                    /* target directory                     */
		 '/tu:'bootdrive,                      /* location of config.sys               */
		 '/l1:'logsdir'\mpts\'client'.log',    /* log file                             */
		 '/r:'                                 /* response file flag (auto selection)  */
x.i.rspdir   = respdir'\mpts\'                         /* response file directory              */
x.i.default  = 'dm9pci_c.rsp'                          /* default response file name           */

i            = i + 1
x.peer       = i                                       /* structure index                      */
x.i.name     = 'OS/2 Peer 1.0'                         /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = peerimgdir'\laninstr',                  /* fully qualified install program name */
		 '/l1:'logsdir'\peer10\'client'.log',  /* error log file                       */
		 '/req',                               /* install type                         */
		 '/r:'                                 /* response file flag (auto selection)  */
x.i.rspdir   = respdir'\peer10\'                       /* response file directory              */
x.i.default  = 'DefaultC.rsp'                          /* default response file name           */

i            = i + 1
x.nsc = i                                              /* structure index                      */
x.i.name     = 'NSC'                                   /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = cdimgdir'\nsc\install.exe',             /* fully qualified install program name */
		 '/a:i',                               /* action flag - i = install            */
		 '/x',                                 /* interactive flag x = unattended      */
		 '/l1:'logsdir'\nsc\'client'.err',     /* error log file                       */
		 '/l2:'logsdir'\nsc\'client'.log',     /* install history log file             */
		 '/s:'cdimgdir'\nsc',                  /* source directory                     */
		 '/r:'                                 /* response file flag (auto selection)  */
x.i.rspdir   = respdir'\nsc\'                          /* response file directory              */
x.i.default  = 'DefaultC.rsp'                          /* default response file name           */

i            = i + 1
x.tcpip      = i                                       /* structure index                      */
x.i.name     = 'TCP/IP 4.3 Applications'               /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = tcpipimgdir'\install',                  /* fully qualified install program name */
		 '/a-',                                /* unattended                           */
		 '/l1:'logsdir'\tcpip43\'client'.err', /* error log file                       */
		 '/l2:'logsdir'\tcpip43\'client'.log', /* install history log file             */
		 '/r:'                                 /* response file flag (auto selection)  */
x.i.rspdir   = respdir'\tcpip43\'                      /* response file directory              */
x.i.default  = 'dm9pci_c.rsp'                          /* default response file name           */

i            = i + 1
x.nwinst     = i                                       /* structure index                      */
x.i.name     = 'NetWare Requester'                     /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = ibminstdir'\npnwinst',                  /* fully qualified install program name */
		 '/l1:'logsdir'\nwreq\'client'.err',   /* error log file                       */
		 '/l2:'logsdir'\nwreq\'client'.log',   /* install history log file             */
		 '/nc:'nwcontext,                      /*                                      */
		 '/p:'nwprefsrv,                       /* NetWare Preferred Server             */
		 '/t:'nwtgtpath,                       /* target directory                     */
		 '/v:'nwversion,                       /* NetWare Requester Version            */
		 '/tr:'nwtokenring,                    /* Type of Network                      */
		 '/s:'left(cdimgdir,1)                 /* source directory                     */
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

i            = i + 1
x.netscape = i                                               /* structure index                      */
x.i.name     = 'Netscape Communicator'                       /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                            /* state variable name                  */
x.i.instprog = cdimgdir'\netscape\install',                  /* fully qualified install program name */
		     '/x',                                   /* interactive flag                     */
		     '/a:' || netscape_instupdt,             /* action flag                          */
		     '/nmsg',                                /* no ending message                    */
		     '/o:drive',                             /* originating system                   */
		     '/l2:'logsdir'\netscape\'client'.log',  /* install history log file             */
		     '/r:'                                   /* response file flag (auto selection)  */
x.i.rspdir   = respdir'\netscape\'                           /* response file directory              */
x.i.default  = 'DefaultC.rsp'                                /* default response file name           */

i            = i + 1
x.svagent    = i                                       /* structure index                      */
x.i.name     = 'SystemView Agent'                      /* product name                         */
x.i.statevar = 'CAS_'|| x.i.name                       /* state variable name                  */
x.i.instprog = cdimgdir'\svagent\install.cmd',         /* fully qualified install program name */
		 '/l1:'logsdir'\svagent\'client'.log', /* error log file                       */
		 '/s:'cdimgdir'\svagent',              /* source directory                     */
		 '/a:i',                               /* action flag - i = install            */
		 '/x',                                 /* interactive flag x = unattended      */
		 '/o:DRIVE',                           /* originating system                   */
		 '/r:'                                 /* response file flag (auto selection)  */
x.i.rspdir   = respdir'\svagent\'                      /* response file directory              */
x.i.default  = 'DefaultC.rsp'                          /* default response file name           */

i            = i + 1
x.lcfagent   = i                                         /* structure index                      */
x.i.name     = 'Tivoli TME 10 Endpoint'                  /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                        /* state variable name                  */
x.i.instprog = cdimgdir'\lcfagent\install',              /* fully qualified install program name */
		 '/x',                                   /* interactive flag                     */
		 '/a:'|| lcfagent_instupdt,              /* action flag                          */
		 '/s:'cdimgdir'\lcfagent',               /* source directory                     */
		 '/l1:'logsdir'\lcfagent\'client'.log',  /* error log file                       */
		 '/r:'                                   /* response file flag (auto selection)  */
x.i.rspdir  = respdir'\lcfagent\'                        /* response file path                   */
x.i.default = 'DefaultC.rsp'                             /* default response file name           */

/* fixme to be gone */
i            = i + 1
x.mfs        = i                                       /* structure index                      */
x.i.name     = 'Mobile File Sync'                      /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = cdimgdir'\MFS\INSTALL.EXE',             /* fully qualified install program name */
		  '/l1:'logsdir'\mfs\'client'.err',    /* error log file                       */
		  '/l2:'logsdir'\mfs\'client'.log',    /* install history log file             */
		  '/a:i',                              /* action flag - i = install            */
		  '/x',                                /* interactive flag x = unattended      */
		  '/o:DRIVE',                          /* originating system                   */
		  '/p:"MFS Cache Manager"',            /* program name                         */
		  '/s:'cdimgdir'\MFS',                 /* source directory                     */
		  '/t:'MFS_Drive,                      /* target directory                     */
		  '/r:'                                /* response file flag (auto selection)  */
x.i.rspdir   = respdir'\mfs\'                          /* response file directory              */
x.i.default  = 'DefaultC.RSP'                          /* default response file name           */

/* fixme to be gone */
i            = i + 1
x.ldap       = i                                       /* structure index                      */
x.i.name     = 'Lightweight Directory Access Protocol' /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = 'clifi',                                /* fully qualified install program name */
		  '/a:c',                              /* ?                                    */
		  '/l1:'logsdir'\ldap\'client'.err',   /* error log file                       */
		  '/l2:'logsdir'\ldap\'client'.log',   /* install history log file             */
		  '/s:'cdimgdir'\ldap',                /* source directory                     */
		  '/b:'bootdrive,                      /* boot drive                           */
		  '/r2:'                               /* user default response file name      */
x.i.rspdir   = respdir'\ldap\'                         /* response file directory              */
x.i.default  = 'DefaultC.rsp'                          /* default response file name           */

i            = i + 1
x.thinifsX   = i                                       /* structure index                      */
x.i.name     = 'SRVIFS Requester - drive X'            /* product name                         */
x.i.statevar = ''                                      /* no state variable                    */
x.i.instprog = cidimgdir'\srvifs\thinifs',             /* fully qualified install program name */
		 '/s:'cidimgdir'\srvifs',              /* source directory                     */
		 '/t:'bootdrive'\srvifsrq',            /* target directory                     */
		 '/tu:'bootdrive'\',                   /* config.sys location                  */
		 '/l1:'logsdir'\srvifs\'client'.log',  /* log file                             */
		 '/req:'client,                        /* requester name                       */
		 '/srv:'server1'CID',                  /* SRVIFS server name                   */
		 '/w',                                 /* 30 second timeout                    */
		 '/d:x'                                /* remote drive identifier              */
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

i            = i + 1
x.thinifsY   = i                                       /* structure index                      */
x.i.name     = 'SRVIFS Requester - drive Y'            /* product name                         */
x.i.statevar = ''                                      /* no state variable                    */
x.i.instprog = cidimgdir'\srvifs\thinifs',             /* fully qualified install program name */
		 '/s:'cidimgdir'\srvifs',              /* source directory                     */
		 '/t:'bootdrive'\srvifsrq',            /* target directory                     */
		 '/tu:'bootdrive'\',                   /* config.sys location                  */
		 '/l1:'logsdir'\srvifs\'client'.log',  /* log file                             */
		 '/req:'client,                        /* requester name                       */
		 '/srv:'server1'LOG',                  /* SRVIFS server name                   */
		 '/w',                                 /* 30 second timeout                    */
		 '/d:y'                                /* remote drive identifier              */
x.i.respdir  = ''
x.i.default  = ''				       /* no auto selection                    */

i            = i + 1
x.casinstl   = i                                       /* structure index                      */
x.i.name     = 'LAN CID Utility'                       /* product name                         */
x.i.statevar = ''                                      /* no state variable                    */
x.i.instprog = lcudir'\casinstl',                      /* fully qualified install program name */
		  '/cmd:'lcucmddir,                    /* location of .cmd files (passed to casagent) */
		  '/tu:'bootdrive,                     /* config.sys location (boot drive)     */
		  '/pl:'dllpath,                       /* string to add to libpath             */
		  '/pa:'lcudir,                        /* workstation's path to LCU code on server */
		  '/l1:'logsdir'\lcu\'client'.log',    /* CASINSTL/DELETE log file             */
		  '/l2:'logsdir'\lcu\SRVIFS_REQ.log',  /* CASAGENT log file                    */
		  '/d',                                /* will use LCU default.cmd file        */
		  '/req:'client                        /* LCU client name                      */
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

i            = i + 1
x.casdelet   = i                                        /* structure index                      */
x.i.name     = 'LAN CID Utility Delete'                 /* product name                         */
x.i.statevar = ''                                       /* no state variable                    */
x.i.instprog = lcudir'\casdelet',                       /* fully qualified install program name */
		  '/pl:'dllpath,                        /* string to delete from libpath        */
		  '/tu:'bootdrive,                      /* config.sys location (boot drive)     */
		  '/l1:'logsdir'\casdelet\'client'.log' /* CASINSTL/DELETE log file            */
x.i.rspdir   = ''
x.i.default  = ''					/* no auto selection                    */

i            = i + 1
x.ifsdel     = i                                       /* structure index                      */
x.i.name     = 'SRVIFS Requester Delete'               /* product name                         */
x.i.statevar = ''                                      /* no state variable                    */
x.i.instprog = cidimgdir'\srvifs\ifsdel',              /* fully qualified install program name */
		  '/t:'bootdrive'\srvifsrq',           /* target directory                     */
		  '/tu:'bootdrive                      /* config.sys location                  */
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

i            = i + 1
x.nwmpts     = i                                       /* structure index                      */
x.i.name     = 'MPTS for NetWare'                      /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = mptscimgdir'\mpts',                     /* fully qualified install program name */
		  '/e:prod',                           /* product installation                 */
		  '/s:'mptsimgdir,                     /* source directory                     */
		  '/t:'mptsdrive'\',                   /* target directory                     */
		  '/tu:'bootdrive'\',                  /* location of config.sys               */
		  '/l1:'logsdir'\mpts\'client'.log',   /* log file                             */
		  '/r:'                                /* response file flag (auto selection)  */
x.i.rspdir   = respdir'\mpts\'                         /* response file directory              */
x.i.default  = 'DefaultC.rsp'                          /* default response file name           */

/* fixme to be gone */
i            = i + 1
x.ldrmpts    = i                                          /* structure index                      */
x.i.name     = 'MPTS for LAN Distance'                 /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = mptsimgdir'\mpts',                      /* fully qualified install program name */
		  '/e:prod',                           /* product installation                 */
		  '/s:'mptsimgdir,                     /* source directory                     */
		  '/t:'mptsdrive'\',                   /* target directory                     */
		  '/tu:'bootdrive'\',                  /* location of config.sys               */
		  '/l1:'logsdir'\mpts\'client'.log',   /* log file                             */
		  '/r:'                                /* response file flag (auto selection)  */
x.i.rspdir   = respdir'\mpts\'                         /* response file directory              */
x.i.default  = 'DefaultC.rsp'                          /* default response file name           */

i            = i + 1
x.semaint    = i                                       /* structure index                      */
x.i.name     = 'OS/2 4.5 Maintenance Boot (no FP)'     /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = exepath'\semaint',                      /* fully qualified install program name */
		 '/s:'os2imgdir,                       /* source directory                     */
		 '/t:'maintdir,                        /* target directory                     */
		 '/b:'bootdrive,                       /* target boot drive (not necessarily current) */
		 '/l1:'logsdir'\semaint\'client'.log'  /* log file                             */
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

i            = i + 1
x.W45DDPrep  = i                                       /* structure index                      */
x.i.name     = 'OS/2 Warp 4.5 DD FixPak Prep'          /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = ddprepdir'\fixtprep',                   /* fully qualified install program name */
		 bootdrive                             /* drive to prepare                     */
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

i            = i + 1
x.thinifsZ   = i                                       /* structure index                      */
x.i.name     = 'SRVIFS Requester - drive Z'            /* product name                         */
x.i.statevar = ''                                      /* no state variable                    */
x.i.instprog = cidimgdir'\srvifs\thinifs',             /* fully qualified install program name */
		 '/s:'cidimgdir'\srvifs',              /* source directory                     */
		 '/t:'bootdrive'\srvifsrq',            /* target directory                     */
		 '/tu:'bootdrive'\',                   /* config.sys location                  */
		 '/l1:'logsdir'\srvifs\'client'.log',  /* log file                             */
		 '/req:'client,                        /* random requester name                */
		 '/srv:'server1'CDROM',                /* SRVIFS server name                   */
		 '/w',                                 /* 30 second timeout                    */
		 '/d:z'                                /* remote drive identifier              */
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

i            = i + 1
x.xr_m0xx    = i                                        /* structure index                      */
x.i.name     = 'OS/2 Warp 4.5 FixPak 15'                /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                       /* state variable name                  */
x.i.instprog = cidimgdir'\csf\fservice',                /* fully qualified install program name */
		  '/b:'bootdrive,                       /* post install boot drive              */
		  '/s:'xr_m0xxdir,                      /* service pak directory                */
		  '/t:'bootdrive'\service',             /* service directory                    */
		  '/l1:'logsdir'\xr_m0xx\'client'.log', /* log file                             */
		  '/r:'respdir'\xr_m0xx\fp15a_f.rsp'    /* response file                        */
x.i.rspdir   = ''
x.i.default  = ''					/* no auto selection                    */

i            = i + 1
x.LCUInstl   = i                                       /* structure index                      */
x.i.name     = 'LCU Client'                            /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = slatooldir'\MyUnzip',                   /* fully qualified install program name */
		 '/s:'mptsimgdir'\utility\lcu\lcu.zip', /* zip file                            */
		 '/t:'bootdrive'\cid\lcu',             /* target directory (base)              */
		 '/l:'logsdir'\LCUInstl\'client'.log', /* log file                             */
		 '/z:'mptsimgdir'\pkunzip2'            /* unzip utility                        */
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

i            = i + 1
x.SrvIFS   = i                                         /* structure index                      */
x.i.name     = 'SRVIFS Client'                         /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = slatooldir'\MyUnzip',                   /* fully qualified install program name */
		 '/s:'mptsimgdir'\utility\srvifs\srvifs.zip', /* zip file                      */
		 '/t:'bootdrive'\cid\srvifs',          /* target directory (base)              */
		 '/l:'logsdir'\SrvIFSIn\'client'.log',  /* log file                             */
		 '/z:'mptsimgdir'\pkunzip2'            /* unzip utility                        */
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

i            = i + 1
x.clifi      = i                                           /* structure index                      */
x.i.name     = 'CLI FI'                                    /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                          /* state variable name                  */
x.i.instprog = bootdrive'\os2\install\clifi',              /* fully qualified install program name */
		 '/a:c',                                   /* action flag                          */
		 '/s:'os2imgdir'\FI',                      /* source directory                     */
		 '/b:'bootdrive,                           /* service directory                    */
		 '/r:'bootdrive'\os2\install\fibase.rsp',  /* Feature Installer response file      */
		 '/f:'bootdrive'\os2\install',             /* ?                                    */
		 '/l1:'logsdir'\clifi\'client'.err',       /* Installation error log file          */
		 '/l2:'logsdir'\clifi\'client'.log',       /* Installation history log file        */
		 '/r2:'					   /* user response file                   */
x.i.rspdir   = bootdrive'\os2\install\'			   /* response file directory              */
x.i.default  = 'DefaultC.rsp'				   /* default response file name           */

i            = i + 1
x.MPTSProd   = i                                       /* structure index                      */
x.i.name     = 'MPTS from Production'                  /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = mptsimgdir'\mpts',                      /* fully qualified install program name */
		 '/e:prod',                            /* installing on production installation*/
		 '/s:'mptsimgdir,                      /* source directory                     */
		 '/t:'mptsdrive'\',                    /* target drive                         */
		 '/tu:'bootdrive,                      /* location of config.sys               */
		 '/l1:'logsdir'\mpts\'client'.log',    /* log file                             */
		 '/r:'                                 /* response file flag (auto selection)  */
x.i.rspdir   = respdir'\mpts\'                         /* response file directory              */
x.i.default  = 'dm9pci_c.rsp'                          /* default response file name           */

i            = i + 1
x.ZTBInstl   = i                                       /* structure index                      */
x.i.name     = 'ZTBold Install'                        /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = slatooldir'\ZTBInstl',                  /* fully qualified install program name */
		 '/b:'bootdrive,                      /* post install boot drive              */
		 '/s:'cidimgdir'\ZTBold',              /* source directory                     */
		 '/t:'bootdrive'\ZTBold',              /* target directory                     */
		 '/l:'logsdir'\SLATool\'client'.log'   /* log file                             */
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

i            = i + 1
x.SLADesk    = i                                       /* structure index                      */
x.i.name     = 'SL&A Desktop Objects'                  /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = slatooldir'\sladesk',                   /* fully qualified install program name */
		 '/b:'bootdrive,                       /* location of config.sys               */
		 '/l:'logsdir'\SLATool\'client'.log'   /* log file                             */
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

i            = i + 1
x.ClnDesk    = i                                       /* structure index                      */
x.i.name     = 'Clean TCP Desktop'                     /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = cddrive'\ibminst\clndesk',              /* fully qualified install program name */
		 cddrive'\ibminst\deskobj.rem',        /* ?                                    */
		 respdir'\warp45\npconf_c.cfg'         /* response file                        */
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

i            = i + 1
x.xr_d0xx    = i                                       /* structure index                      */
x.i.name     = 'OS/2 Warp 4.5 DD FixPak 02'            /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = imgdir'\csf\fservice',                  /* fully qualified install program name */
		  '/b:'bootdrive,                      /* post install boot drive              */
		  '/s:'xr_d0xxdir,                     /* service pak directory                */
		  '/l1:'logsdir'\w4dd02\'client'.log', /* log file                             */
		  '/r:'respdir'\w4dd02\dd02a_f.rsp'    /* response file                        */
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

i            = i + 1
x.SLAMacs    = i                                       /* structure index                      */
x.i.name     = 'SL&A Additional MAC Drivers'           /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = slatooldir'\slamacs',                   /* fully qualified install program name */
		bootdrive                              /* post install boot drive              */
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

i            = i + 1
x.LAPSIns    = i                                       /* structure index                      */
x.i.name     = 'Thin LAPS'                             /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = mptsimgdir'\thinlaps',                  /* fully qualified install program name */
		 mptsimgdir,                           /* MPTS image source                    */
		 bootdrive'\',                         /* boot drive                           */
		 nifname,                              /* NIF name                             */
		 '/add:'ciddrive'\macs'                /* locaion for MACS and .NIF's          */
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

i             = i + 1
x.semaintwfp  = i                                       /* structure index                      */
x.i.name      = 'OS/2 Maintanance Boot (with FP)'       /* product name                         */
x.i.statevar  = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog  = exepath'\semaint',                      /* fully qualified install program name */
		  '/s:'os2imgdir,                       /* source directory                     */
		  '/s2:'xr_m0xxdir,                     /* service pak directory                */
		  '/t:'maintdir,                        /* target directory                     */
		  '/b:'bootdrive,                       /* target boot drive (not necessarily current) */
		  '/l1:'logsdir'\semaint\'client'.log'  /* log file                             */
x.i.rspdir    = ''
x.i.default   = ''					/* no auto selection                    */

i            = i + 1
x.un_0980    = i                                       /* structure index                      */
x.i.name     = 'TCPIP FixPak un_0980'                  /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = cidimgdir'\csf\fservice.exe',           /* fully qualified install program name */
		'/s:'cidcsddir'\tcpip\un_0980',        /* source directory                     */
		'/l1:'logsdir'\un_0980\'client'.log',  /* log file                             */
		'/r:'respdir'\un_0980\un_0980_f.rsp'   /* response file                        */
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

i            = i + 1
x.ip08414    = i                                       /* structure index                      */
x.i.name     = 'Peer FixPak ip08414'                   /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = cidimgdir'\csf\fservice.exe',           /* fully qualified install program name */
		'/s:'cidcsddir'\peer\ip08414',         /* source directory                     */
		'/l1:'logsdir'\ip08414\'client'.log',  /* log file                             */
		'/r:'respdir'\ip08414\ip08414f.rsp'    /* response file                        */
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

i            = i + 1
x.wr08621    = i                                       /* structure index                      */
x.i.name     = 'MPTS FixPak wr08621'                   /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = cidimgdir'\csf\fservice.exe',           /* fully qualified install program name */
		'/s:'cidcsddir'\mpts\wr08621',         /* source directory                     */
		'/l1:'logsdir'\wr08621\'client'.log',  /* log file                             */
		'/r:'respdir'\wr08621\wr08621f.rsp'    /* response file                        */
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

i            = i + 1
x.ffst       = i                                       /* structure index                      */
x.i.name     = 'FFST'                                  /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = cdimgdir'\ffst\ffstinst.exe',           /* fully qualified install program name */
		 '/s:'cdimgdir'\ffst',                 /* source directory                     */
		 '/l1:'logsdir'\ffst\'client'.log',    /* error log file                       */
		 '/rout:1'                             /* rout parameter                       */
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

i            = i + 1
x.books      = i                                       /* structure index                      */
x.i.name     = 'Warp Server Books'                     /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = ibminstdir'\instbook',                  /* fully qualified install program name */
		 '/r:'respdir'\books\books.rsp',       /* response file name - non-standard arg order */
		 '/l1:'logsdir'\books\'client'.log',   /* error log file                       */
		 '/s:'cdimgdir'\books',                /* source directory                     */
		 '/t:'booksdrive                       /* target directory                     */
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

i            = i + 1
x.jdk13      = i                                       /* structure index                      */
x.i.name     = 'JDK 1.3 '                              /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = 'clifi',                                /* fully qualified install program name */
		  '/a:c',                              /* ?                                    */
		  '/l1:'logsdir'\jdk13\'client'.err',  /* error log file                       */
		  '/l2:'logsdir'\jdk13\'client'.log',  /* history log file                     */
		  '/s:'cdimgdir'\java13\en',           /* source directory                     */
		  '/b:'bootdrive,                      /* boot drive                           */
		  '/r:'cdimgdir'\java13\en\java130.rsp', /* Feature Installer response file      */
		  '/r2:'                               /* user response file flag (auto selection) */
x.i.rspdir   = respdir'\jdk13\'                        /* response file directory              */
x.i.default  = 'DefaultC.rsp'                          /* default response file name           */

i            = i + 1
x.sddvideo = i                                         /* structure index                      */
x.i.name     = 'SciTech Display Doctor GRADD Video'    /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = cidimgdir'\sdd704\setup.cmd',           /* fully qualified install program name */
		 'sdd',                                /* select SDD GRADD                     */
		 cidimgdir'\sdd704',                   /* source directory                     */
		 bootdrive,
		' /u'
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

i            = i + 1
x.minstall = i                                         /* structure index                      */
x.i.name     = 'CM8738 Audio'                          /* product name                         */
x.i.name     = 'ESS 1869 Audio'                        /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = bootdrive'\mmtemp\minstall',            /* fully qualified install program name */
	       '/m',                                   /* run from mmtemp */
	       '/l:'logsdir'\minstall\'client'.log',   /* history log file                     */
	       '/r:'                                   /* response file name                   */
x.i.rspdir   = respdir'\minstall'                      /* response file directory              */
x.i.default  = 'es1869_c.rsp'                          /* default response file name           */
x.i.default  = 'cm8738_c.rsp'                          /* default response file name           */

i            = i + 1
x.savlanlk   = i                                       /* structure index                      */
x.i.name     = 'Save Locked Files'                     /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = slatooldir'\savlanlk',                  /* fully qualified install program name */
		 bootdrive,                            /* location of config.sys               */
		 logsdir'\SLATool\'client'.log'        /* log file                             */
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

i            = i + 1
x.rstlanlk   = i                                       /* structure index                      */
x.i.name     = 'Restore Locked Files'                  /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = slatooldir'\rstlanlk',                  /* fully qualified install program name */
		 bootdrive,                            /* location of config.sys               */
		 logsdir'\SLATool\'client'.log'        /* log file                             */
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

i            = i + 1
x.chklanlk   = i                                       /* structure index                      */
x.i.name     = 'Check Locked Files'                    /* product name                         */
x.i.statevar = 'CAS_' || x.i.name                      /* state variable name                  */
x.i.instprog = slatooldir'\chklanlk',                  /* fully qualified install program name */
		 bootdrive,                            /* location of config.sys               */
		 logsdir'\SLATool\'client'.log'        /* log file                             */
x.i.rspdir   = ''
x.i.default  = ''				       /* no auto selection                    */

/*---------------------------------------------------*/
/*         NUMBER OF PROGRAMS SET UP IN THE          */
/*               PRODUCT DATA SECTION                */
/*---------------------------------------------------*/

NUM_INSTALL_PROGS = i

/*---------------------------------------------------*/
/*       DO NOT MODIFY OR REMOVE THE NEXT LINE       */
/*---------------------------------------------------*/

OVERALL_STATE = GetEnvironmentVars()


/*****************************************************/
/*                  INSTALL SECTION                  */
/*****************************************************/

MyInstall:

Do Forever
  say 'OVERALL_STATE =' OVERALL_STATE
  Select
    when OVERALL_STATE = 0 then do
      if BootDriveIsDiskette()   == 'YES' then iterate  /* Check booted from diskette   */
      if RunInstall(x.semaint)   == BAD_RC then exit    /* Install maintenance system   */
      if RunInstall(x.MPTSProd)  == BAD_RC then exit    /* Install MPTS from production boot */
      if RunInstall(x.thinifsX)  == BAD_RC then exit    /* Install SRVIFS requester     */
      if RunInstall(x.thinifsY)  == BAD_RC then exit    /* Install SRVIFS requester     */
      if RunInstall(x.thinifsZ)  == BAD_RC then exit    /* Install SRVIFS requester     */
      if RunInstall(x.casinstl)  == BAD_RC then exit    /* Install LCU                  */
      Call CheckBoot                                    /* Reboot if it was requested   */
    end
    when OVERALL_STATE = 1 then do
      /* If case FixPak already installed - ignore errors */
      if 0 then
      'attrib -r' bootdrive || '\os2\install\syslevel.os2'
      if 0 then
      'del' bootdrive || '\os2\install\syslevel.os2'
      call SetState OVERALL_STATE + 1
      iterate
    end
    when OVERALL_STATE = 2 then do
      if RunInstall(x.seinst)    == BAD_RC then exit    /* Install operating system     */
      if RunInstall(x.SLAMacs)   == BAD_RC then exit    /* Install extra MAC drivers    */
      if RunInstall(x.MptsMaint) == BAD_RC then exit    /* Install MPTS from Maint boot */
      if RunInstall(x.LCUInstl)  == BAD_RC then exit    /* Install LCU client           */
      if RunInstall(x.SrvIFS)    == BAD_RC then exit    /* Install SRVIFS client        */
      if RunInstall(x.thinifsX)  == BAD_RC then exit    /* Install SRVIFS requester     */
      if RunInstall(x.thinifsY)  == BAD_RC then exit    /* Install SRVIFS requester     */
      if RunInstall(x.thinifsZ)  == BAD_RC then exit    /* Install SRVIFS requester     */
      if RunInstall(x.casinstl)  == BAD_RC then exit    /* Install LCU                  */
      Call CheckBoot                                    /* Reboot if it was requested   */
    end
    when OVERALL_STATE = 3 then do
      if RunInstall(x.peer)     == BAD_RC then exit     /* Install Warp Peer            */
      if RunInstall(x.savlanlk) == BAD_RC then exit     /* Save locked files            */

      if RunInstall(x.clifi)    == BAD_RC then exit     /* Install Feature Installer Products */
      if RunInstall(x.savlanlk) == BAD_RC then exit     /* Save locked files            */
      if RunInstall(x.ffst)     == BAD_RC then exit     /* Install FFST                 */
      if RunInstall(x.savlanlk) == BAD_RC then exit     /* Save locked files            */

      /* never enable here - does not install correctly */
      if 0 then
      if RunInstall(x.minstall) == BAD_RC then exit     /* Install Multimedia Audio     */
      if RunInstall(x.savlanlk) == BAD_RC then exit     /* Save locked files            */

      if RunInstall(x.tcpip)    == BAD_RC then exit     /* Install TCP/IP Apps Kit      */
      if RunInstall(x.savlanlk) == BAD_RC then exit     /* Save locked files            */
      if RunInstall(x.netscape) == BAD_RC then exit     /* Install Netscape             */
      if RunInstall(x.savlanlk) == BAD_RC then exit     /* Save locked files            */
      if RunInstall(x.jdk13)    == BAD_RC then exit     /* Install JDK 1.3              */
      if RunInstall(x.savlanlk) == BAD_RC then exit     /* Save locked files            */
      if RunInstall(x.ZTBInstl) == BAD_RC then exit     /* Install ZTBold */
      if RunInstall(x.sddvideo) == BAD_RC then exit     /* Install SDD Video            */
      if RunInstall(x.savlanlk) == BAD_RC then exit     /* Save locked files            */

      if RunInstall(x.rstlanlk) == BAD_RC then exit     /* Restore locked files         */

      if RunInstall(x.SLADesk)  == BAD_RC then exit     /* Install SL&A desktop objects */
      if 0 then
      if RunInstall(x.ClnDesk)  == BAD_RC then exit     /* Clean TCP desktop objects    */
      if RunInstall(x.ifsdel)   == BAD_RC then exit     /* Delete SRVIFS requester      */
      if RunInstall(x.casdelet) == BAD_RC then exit     /* Delete LCU                   */
      Call Reboot                                       /* Reboot                       */
    end
  end
end
exit

/* MyShowState() - fixme to be gone */

MyShowState:
  say 'QUEUE_REBOOT:' QUEUE_REBOOT 'CALL_AGAIN:' CALL_AGAIN 'RC:' RC
  if QUEUE_REBOOT <> 0 | CALL_AGAIN <> 0 then
      'pause'

  return

/* end MyInstall */

/*************************************************************/
/*         DO NOT MODIFY ANY CODE BELOW THIS LINE !!!        */
/*************************************************************/

RunInstall: procedure expose x. queue_reboot call_again configsys logfile client OVERALL_STATE
  parse arg index, new_state, other
  install = SetEnvironmentVar(x.index.statevar)
  if install == YES then do
    state = value('REMOTE_INSTALL_STATE',,'OS2ENVIRONMENT')     /* check   REMOTE_INSTALL_STATE */
    if state <> 0 then
      rc2 = LogMessage(75, x.index.name, state, logfile)        /* log an install starting msg  */
    else
      rc2 = LogMessage(72, x.index.name, '', logfile)           /* log an install starting msg  */

    install_prog = 'CMD /C ' || strip(x.index.instprog)         /* build the command string     */

						/* If automatic responst file selection was     */
						/* indicated, then get the response file name   */
						/* and append it to the command string.         */
    if x.index.default <> '' then do
      response_file = DetermineResponseFile(x.index.rspdir, client,
					    , x.index.default, x.index.name,
					    , logfile)
      if response_file == '' then exit
      install_prog = install_prog || response_file
    end

    install_prog                                                /* Execute the install program  */

    state = value(x.index.statevar,,'OS2ENVIRONMENT')           /* Get the current install state*/
								/* for this install program from*/
								/* the environment.             */

						/* Check the return code and set the global     */
						/* variables accordingly.                       */

    parse value ProcessReturnCode(rc, state, QUEUE_REBOOT, CALL_AGAIN, logfile),
	   with rc ',' state ',' QUEUE_REBOOT ',' CALL_AGAIN

    rc2 = value(x.index.statevar, state, 'OS2ENVIRONMENT')      /* Set the new install state for*/
								/* this install program.        */

						/* Put the install state into the CONFIG.SYS,   */
						/* if this action was unsuccessful, then exit.  */

    if PutStateVar(x.index.statevar, state, configsys, logfile) <> 0 then exit

    if rc == GOOD_RC then do
      if pos('\SEMAINT', translate(install_prog)) <> 0 then     /* If the install program was   */
	Call PreserveStartupCmd(install_prog)                   /* SEMAINT, then make sure      */
								/* STARTUP.CMD won't be copied  */
								/* over when SEINST runs.       */

      rc2 = LogMessage(70, x.index.name, '', logfile)           /* log an install successful msg*/
      return GOOD_RC                                            /* return a good return code    */
    end

    else do
      rc2 = LogMessage(71, x.index.name, '', logfile)           /* log an install failed msg    */
      if (new_state <> '') then                                 /* If a new state was requested,*/
								/* then set OVERALL_STATE to the*/
	rc2 = SetState(new_state, 'RunInstall', 2)              /* new state.                   */

      return BAD_RC                                             /* return a bad return code     */
    end
  end
  return GOOD_RC


/*************************************************************/
PreserveStartupCmd: procedure

  parse upper arg string, other

  if pos('/T:', string) <> 0 then                               /* Determine if there is a      */
    findvalue = '/T:'                                           /* target parameter.  If there  */
  else                                                          /* is none, return.             */
    if pos('-T:',string) <> 0 then
      findvalue = '-T:'
    else
      return 0

  remain = substr(string, pos(findvalue, string) + 3)           /* Get the value of the target  */
								/* parameter.                   */
  blank = pos(' ', remain)

  if (blank <> 0) then
    param = substr(remain, 1, blank-1)
  else
    param = remain
						/* Erase startup.lcu in the target directory,  */
						/* then rename startup.s13 to startup.lcu      */

  'if exist ' param || '\startup.lcu erase  ' param || '\startup.lcu'
  'if exist ' param || '\startup.s13 rename ' param || '\startup.s13 *.lcu'

  return 0

/*************************************************************/
GetEnvironmentVars: procedure expose X. NUM_INSTALL_PROGS


  OVERALL_STATE = value(x.0.statevar,,'OS2ENVIRONMENT')         /* Get the overall install state */
								/* from the environment.         */

  if OVERALL_STATE == '' then do                                /* If the overall install state  */
    OVERALL_STATE = 0                                           /* has not been set yet, reset   */
    do I=0 to NUM_INSTALL_PROGS by 1                            /* all the state vars to 0.      */
      if x.I.statevar <> '' then
	rc = value(x.I.statevar,'0','OS2ENVIRONMENT')
    end
  end

  return OVERALL_STATE


/*************************************************************/
SetEnvironmentVar: procedure
  parse arg env_string, other
  if env_string == '' then do                                   /* If the install program has   */
								/* no state variable, then ...  */

    rc = value('REMOTE_INSTALL_STATE','0','OS2ENVIRONMENT')     /* Set the REMOTE_INSTALL_STATE */
								/* to 0 so that the program     */
								/* being run can know that is   */
								/* being run in an unattended   */
								/* environment.                 */

    return YES                                                  /* return install=yes           */

  end

  state = value(env_string,,'OS2ENVIRONMENT')                   /* Otherwise, get the value of  */
								/* the state variable from the  */
								/* environment.                 */

  if state <> '' then do                                        /* If the state variable exists */

    rc = value('REMOTE_INSTALL_STATE',state,'OS2ENVIRONMENT')   /* Set the REMOTE_INSTALL_STATE */
								/* environment variable to the  */
								/* value of the state variable. */

    return YES                                                  /* return install=yes           */
  end
  else                                                          /* Otherwise,                   */
    return NO                                                   /* return install=no            */


/*************************************************************/
BootDriveIsDiskette:

  if IsBootDriveRemovable() == 1 then do                        /* If the drive booted from is  */
								/* a diskette drive, then set   */
    rc2 = SetState(OVERALL_STATE+1)                             /* the OVERALL_STATE to the     */
								/* requested value.             */
    return 'YES'

  end

  else                                                          /* else the machine was booted  */
								/* from the hardfile.           */
    return 'NO'

/*************************************************************/
BootDriveIsFixedDisk:

  if IsBootDriveRemovable() == 0 then do                        /* If the drive booted from is  */
								/* a fixed disk, then set       */
    rc2 = SetState(OVERALL_STATE+1)                             /* the OVERALL_STATE to the     */
								/* requested value.             */
    return 'YES'

  end

  else                                                          /* else the machine was booted  */
								/* from a diskette.             */
    return 'NO'

/*************************************************************/
SetState:
  parse arg new_state, proc_name, param_num, other

    if datatype(new_state, number) <> 1 then do                 /* If the new state requested is*/
								/* not numeric, then log an     */
      if proc_name <> '' then                                   /* error.                       */
	LogMessage(63, proc_name, param_num, logfile)
      else
	LogMessage(63, 'SetState', 1, logfile)

      exit
    end

    OVERALL_STATE = new_state                                   /* Set the OVERALL_STATE to the */
								/* new state requested.         */

    rc = value(x.0.statevar, new_state, 'OS2ENVIRONMENT')       /* Save the OVERALL_STATE in the*/
								/* environment.                 */
    return 'NO_ERROR'


/*************************************************************/
SaveStates:

  do I=0 to NUM_INSTALL_PROGS by 1            /* Put the install states into the CONFIG.SYS,  */
    if x.I.statevar <> '' then                /* if this action was unsuccessful, then exit.  */

      if PutStateVar(x.I.statevar, value(x.I.statevar,,'OS2ENVIRONMENT'),
		     , configsys, logfile) <> 0 then exit
  end

  return

/*************************************************************/
RebootAndGotoState:
  parse arg new_state, other

  rc2 = SetState(new_state, 'RebootAndGotoState', 1)           /* Set the state to go to in    */
							       /* OVERALL_STATE.               */

  Call SaveStates                                              /* Save the environment vars    */

  Call Reboot                                                  /* Reboot the machine           */

  return


/*************************************************************/
CheckBoot:
  if QUEUE_REBOOT <> 0 then do                                  /* If a reboot has been queued  */
								/* by an install program ...    */

    if CALL_AGAIN == 0 then                                     /* If no install programs want  */
								/* to be recalled ...           */

      rc = SetState(OVERALL_STATE+1)                            /* Increment the overall state  */
								/* variable.                    */

    Call SaveStates                                             /* Save the environment vars    */

    Call Reboot                                                 /* Reboot the machine           */

  end

  else                                                          /* Otherwise, increment the     */
    rc = SetState(OVERALL_STATE+1)                              /* state variable and go on.    */

  return


/*************************************************************/
Reboot:
  bootdrive

  rc = value('OS2_SHELL', bootdrive || '\OS2\CMD.EXE', 'OS2ENVIRONMENT')
  rc = value('COMSPEC',   bootdrive || '\OS2\CMD.EXE', 'OS2ENVIRONMENT')

  'cls'
  rc = AskRemoveDiskIfFloppy()

  pathlen = length(exepath)                                     /* Get length of exepath        */
  posslash = lastpos("\",strip(exepath))                        /* Determine the last occurcnce */
								/*   of '\' in exepath          */

  if posslash = pathlen then                                    /* If '\' is the last character */

    cmdline = exepath || 'SETBOOT /IBD:' || bootdrive           /* Then append 'SETBOOT'        */

  else

    cmdline = exepath || '\SETBOOT /IBD:' || bootdrive          /* Else append '\SETBOOT'       */

  LogMessage(74, '', '', logfile)                               /* Log a message indicating     */
								/* reboot.                      */
  cmdline

  LogMessage(73, 'SETBOOT', '', logfile)                        /* If the code gets to here, the*/
								/* reboot failed.  Log a message*/
  exit                                                          /* and exit.                    */

  return


/*************************************************************/
AddDLLFunctions:
  Call RxFuncAdd 'ProcessReturnCode',     'CASAGENT', 'PROCESSRETURNCODE'
  Call RxFuncAdd 'DetermineResponseFile', 'CASAGENT', 'DETERMINERESPONSEFILE'
  Call RxFuncAdd 'PutStateVar',           'CASAGENT', 'PUTSTATEVAR'
  Call RxFuncAdd 'LogMessage',            'CASAGENT', 'GETANDLOGMESSAGE'
  Call RxFuncAdd 'AskRemoveDiskIfFloppy', 'CASAGENT', 'ASKREMOVEDISKIFFLOPPY'
  Call RxFuncAdd 'IsBootDriveRemovable',  'CASAGENT', 'ISBOOTDRIVEREMOVABLE'
  Call RxFuncAdd 'GetOS2Version',         'CASAGENT', 'GETOS2VERSION'
  Call RxFuncAdd 'SetCIDType',            'CASAGENT', 'SETCIDTYPE'

  return
