/* Rexx */
/* Sortiert die Datei CONFIG.SYS
   Copyright (c) 1997 by Stefan Milcke
                         Fresenbergstrae 75
		   28779 Bremen

   Dieses Rexx-Script ist Freeware
   Datum der Erstellung: 03.07.1997
   Letzte Aenderung am:  23.08.1998
*/

/* Vorgeplnkel */

CfgFile="\CONFIG.SYS"
TempCfg="\CONFIG.NEW"

Call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
Call RxFuncAdd 'SysFileDelete','RexxUtil','SysFileDelete'
Call RxFuncAdd 'SysTempFileName','RexxUtil','SysTempFileName'

/* CONFIG.SYS einlesen */
i=1
IFile=Stream(CfgFile,"C","OPEN READ")
Do Forever
 If Lines(CfgFile)=0 Then Leave
 CfgLine.i=Linein(CfgFile)
 If (Left(CfgLine.i,20)="REM ****************") | (Left(CfgLine.i,6)="REM : ") Then
  Nop
 Else
  i=i+1
 CfgLine.0=i
End
IFile=Stream(CfgFile,"C","CLOSE")

/* ggf. Temporre Datei lschen */
FileThere=Stream(TempCfg,"C","QUERY EXISTS")
If Length(FileThere)>0 Then
 Call SysFileDelete TempCfg

/* Temporre Datei ffnen */
OFile=Stream(TempCfg,"C","OPEN WRITE")

/* IFS einsortieren */
/* Zuerst einen Remark einfgen */
Call AddRemark "Installable File Systems (IFS)"
Call GetUnsorted "IFS"
Call WriteFoundArray
rc=LineOut(TempCfg,"")

/* Base Devices einsortieren */
Call AddRemark "Base Devices"
Call GetUnsorted "BASEDEV"
Call WriteFoundArray
rc=LineOut(TempCfg,"")

/* SET statements einsortieren */
Call AddRemark "Environment variables"
Call GetUnsorted "SET "
Call SortFoundArray
Call WriteFoundArray
rc=LineOut(TempCfg,"")

/* Devices einsortieren */
Call AddRemark "Devices"
Call GetUnsorted "DEVICE"
Call WriteFoundArray
rc=LineOut(TempCfg,"")

/* Alle bekannten OS/2 statements einsortieren */
Call AddRemark "OS2 Statements"
Call GetUnsorted "AUTOFAIL"
Call WriteFoundArray
Call GetUnsorted "PROTSHELL"
Call WriteFoundArray
Call GetUnsorted "LIBPATH"
Call WriteFoundArray
Call GetUnsorted "PRIORITY_DISK_IO"
Call WriteFoundArray
Call GetUnsorted "IOPL"
Call WriteFoundArray
Call GetUnsorted "DISKCACHE"
Call WriteFoundArray
Call GetUnsorted "MAXWAIT"
Call WriteFoundArray
Call GetUnsorted "MEMMAN"
Call WriteFoundArray
Call GetUnsorted "SWAPPATH"
Call WriteFoundArray
Call GetUnsorted "THREADS"
Call WriteFoundArray
Call GetUnsorted "PRINTMONBUFSIZE"
Call WriteFoundArray
Call GetUnsorted "PROTECTONLY"
Call WriteFoundArray
Call GetUnsorted "DEVINFO"
Call WriteFoundArray
rc=LineOut(TempCfg,"")

/* RUN und CALL anweisungen einsortieren */
Call AddRemark "Run And Call"
Call GetUnsortedRunAndCall
Call WriteFoundArray
rc=LineOut(TempCfg,"")

/* Rest unter unbekannt einsortieren */
Call AddRemark "Unknown"
Call WriteUnmatched

/* Datei schlieen */
OFile=Stream(TempCfg,"C","CLOSE")
Exit

SortFoundArray:
 Do i=1 To Found.0
  L1=Found.i
  If Left(L1,4)="REM " Then
  Do
   L1=Right(L1,Length(L1)-4)
  End
  Do j=i To Found.0
   L2=Found.j
   If Left(L2,4)="REM " Then
   Do
    L2=Right(L2,Length(L2)-4)
   End
   If L1>L2 Then
   Do
    T=Found.i
    Found.i=Found.j
    Found.j=T
    L1=Found.i
    If Left(L1,4)="REM " Then
    Do
     L1=Right(L1,Length(L1)-4)
    End
   End
  End
 End
Return

WriteFoundArray:
 Do i=1 To Found.0
  rc=LineOut(TempCfg,Found.i)
 End
Return
 
GetUnsorted:
 Sea1=Arg(1)
 Sea2="REM "Arg(1)
 Found.0=0
 j=0
 Do i=1 To CfgLine.0
  Line=CfgLine.i
  If (Translate(Left(Line,Length(Sea1)))=Translate(Sea1)) | (Translate(Left(Line,Length(Sea2)))=Translate(Sea2)) Then
  Do
   j=j+1
   Found.j=Line
   CfgLine.i=""
  End
 End
 Found.0=j
Return

GetUnsortedRunAndCall:
 Sea1="RUN"
 Sea2="REM RUN"
 Sea3="CALL"
 Sea4="REM CALL"
 Found.0=0
 j=0
 Do i=1 To CfgLine.0
  Line=CfgLine.i
  If (Left(Line,Length(Sea1))=Sea1) | (Left(Line,Length(Sea2))=Sea2) | (Left(Line,Length(Sea3))=Sea3) | (Left(Line,Length(Sea4))=Sea4) Then
  Do
   j=j+1
   Found.j=Line
   CfgLine.i=""
  End
 End
 Found.0=j
Return

WriteUnmatched:
 Do i=1 To CfgLine.0-1
  If CfgLine.i="" Then
   Nop
  Else
   rc=LineOut(TempCfg,CfgLine.i)
 End
Return


AddRemark:
Call AddRemarkLine
rc=LineOut(TempCfg,"REM : "Arg(1)":")
Call AddRemarkLine
Return

AddRemarkLine:
rc=LineOut(TempCfg,"REM ***************************************************************************")
Return
