; Netmgr.Asm written 1998 by Tobias Ernst.
;
; This file installs interrupt service handlers that are needed by the
; patched NetMgr executable and then spawns the patched Netmgr executable,
; and afterwards deinstalls the interrupt service handlers. The patched
; Netmgr executable is expected to have the name "netmgr.ovl" and reside
; in the same directory as the netmgr.com file that is assembled from
; netmgr.asm.
;
; This file is written for Borland TASM, but should also work with
; microsoft MASM and compatible assemblers, though I didn't test it.
; Assemble as follows:
;
; tasm netmgr.asm
; tlink netmgr /t
;
; If you use another linker, assure that a .COM file is generated, or
; convert the EXE file with EXE2BIN. It is important that the file is
; a .COM file!

DGROUP group  _TEXT, _DATA

_TEXT		SEGMENT BYTE PUBLIC 'CODE'
		ASSUME CS: DGROUP, DS:DGROUP, SS:DGROUP

org             0100h
start:          jmp main


; Symbolic contants for the interrupt vectors to use


vector1         equ 047h

;  Interrupt Service Routine #1
service1:       push   ax
                mov    ax,cx
                mov    cl,64h
                div    cl
                mov    cl,ah
                xor    ch,ch
                pop    ax
                shl    ax,1
                shl    ax,1
                iret


; The main program. These routines install the correct interrupt handlers,
; execute timed.ovl, and restore the original interrupt handlers. This code
; is fairly uninteresting.

main:
                mov ax, cs         ; set up the segment registers and stack
                mov ds, ax
                mov ss, ax
                mov es, ax
                mov ax, offset DGROUP:stack_high
                mov sp, ax

                                   ; free unneeded memory
                mov bx, offset DGROUP:highwater
                shr bx, 4
                inc bx
                mov ah, 4Ah
                int 21h

                                   ; store the old interrupt vectors
                mov ah, 35h
                mov al, vector1
                int 21h
                mov [oldofs1],bx
                mov [oldseg1],es

                                  ; set the new interrupt vectors
                mov ah,25h
                mov al, vector1
                mov dx, offset DGROUP:service1
                int 21h

                                   ; prepare the call to stringops
                push ds
                mov ax, offset DGROUP:paramoff
                push ax
                push ds
                mov ax, offset DGROUP:paramseg
                push ax
                push ds
                mov ax, offset DGROUP:prognameoff
                push ax
                push ds
                mov ax, offset DGROUP:prognameseg
                push ax

                mov ah,062h        ; get PSP
                int 21h
                push bx
                xor  ax,ax
                push ax

                call _stringops    ; fill in the various structures
                add sp, 014h


                mov ax, [paramseg] ; call the DOS EXEC function
                mov es, ax
                mov bx, [paramoff]
                mov dx, [prognameoff]
                mov ax, [prognameseg]
                mov ds, ax
                mov ax, 04B00h
                int 21h

                mov ax, cs         ; restore the registers
                mov ds, ax
                mov ss, ax
                mov ax, offset DGROUP:stack_high
                mov sp, ax


                mov bx, ds         ; restore the interrupt vectors
                mov ah, 25h

                mov al, vector1
                mov dx, [oldofs1]
                mov cx, [oldseg1]
                mov ds, cx
                int 21h
                mov ds, bx

                mov ax, 04c00h     ; terminate program
                int 21h


; _stringops
; This function fills in the huge bunch of tables that is required for the
; DOS exec function. It looks a bit weired, because it has originally been
; created by a C compiler.

_stringops	proc	near
	push	bp
	mov	bp,sp
	sub	sp,12
	push	si
	push	di


   ;	    /* pass the command line on as is */
	les	bx,dword ptr [bp+4]
	mov	al,byte ptr es:[bx+128]
	mov	byte ptr DGROUP:_cmdlin,al
	cmp	byte ptr DGROUP:_cmdlin,126
	jle	short @1@534
	mov	byte ptr DGROUP:_cmdlin,126
@1@534:
	xor	si,si
	jmp	short @1@618
@1@562:
	les	bx,dword ptr [bp+4]
	add	bx,si
	mov	al,byte ptr es:[bx+129]
	mov	byte ptr DGROUP:_cmdlin[si+1],al
	inc	si
@1@618:
	mov	al,byte ptr DGROUP:_cmdlin
	cbw
	cmp	ax,si
	jg	short @1@562
	mov	byte ptr DGROUP:_cmdlin[si+1],13

   ;	    /* adjust the name of the file to be spawned in the env_block */
	les	bx,dword ptr [bp+4]
	mov	ax,word ptr es:[bx+44]
	mov	word ptr [bp-2],ax
	mov	word ptr [bp-4],0
	mov	ax,word ptr [bp-2]
	mov	dx,word ptr [bp-4]
	mov	word ptr [bp-6],ax
	mov	word ptr [bp-8],dx
	jmp	short @1@702
@1@674:
	inc	word ptr [bp-8]
@1@702:
	les	bx,dword ptr [bp-8]
	cmp	byte ptr es:[bx],1
	jne	short @1@674
	les	bx,dword ptr [bp-8]
	cmp	byte ptr es:[bx+1],0
	jne	short @1@674

	mov	ax,word ptr [bp-6]
	mov	dx,word ptr [bp-8]
	add	dx,2
	mov	word ptr [bp-10],ax
	mov	word ptr [bp-12],dx
	mov	word ptr [bp-6],ax
	mov	word ptr [bp-8],dx
	jmp	short @1@814
@1@786:
	inc	word ptr [bp-8]
@1@814:
	les	bx,dword ptr [bp-8]
	cmp	byte ptr es:[bx],0
	jne	short @1@786
	les	bx,dword ptr [bp-8]
	mov	byte ptr es:[bx-3],79
	les	bx,dword ptr [bp-8]
	mov	byte ptr es:[bx-2],86
	les	bx,dword ptr [bp-8]
	mov	byte ptr es:[bx-1],76
   ;	    /* fill in the parameter block */
	mov	ax,word ptr [bp-2]
	mov	word ptr DGROUP:_paramblock,ax
	mov	word ptr DGROUP:_paramblock+2,offset DGROUP:_cmdlin
	mov	word ptr DGROUP:_paramblock+4,ds
	mov	word ptr DGROUP:_paramblock+6,offset DGROUP:_fcb2
	mov	word ptr DGROUP:_paramblock+8,ds
	mov	word ptr DGROUP:_paramblock+10,offset DGROUP:_fcb2
     	mov	word ptr DGROUP:_paramblock+12,ds
	les	bx,dword ptr [bp+16]
	mov	word ptr es:[bx],ds
	les	bx,dword ptr [bp+20]
	mov	word ptr es:[bx],offset DGROUP:_paramblock
	les	bx,dword ptr [bp+8]
	mov	ax,word ptr [bp-10]
	mov	word ptr es:[bx],ax
	les	bx,dword ptr [bp+12]
	mov	ax,word ptr [bp-12]
	mov	word ptr es:[bx],ax
	pop	di
	pop	si
	mov	sp,bp
	pop	bp
	ret
_stringops	endp


_TEXT ENDS

_DATA    	SEGMENT WORD PUBLIC 'DATA'


; These variables store the old interrupt vectors
oldseg1      dw ?
oldofs1      dw ?


; These variables are used to exchange data between the main program
; and the _stringops subroutine
paramoff    dw 1
paramseg    dw 2
prognameoff dw 3
prognameseg dw 4

; We do need a little bit of stack for our own ...
stack_low       dw 128 dup (10)
stack_high      dw 0


; These structures are filled in and passed to the DOS EXEC function
_cmdlin	label	byte
	db	128 dup (0)
_paramblock	label	word
	db	16 dup (0)
_fcb2	label	word
	db	35 dup (0)
_fcb1	label	word
	db	35 dup (0)

; This variable marks the last address in the file, so that the rest
; of the memory can be freed.
highwater db 0

_DATA ENDS

END start

