/****************** IBM Internal Use Only *************************/
/* TRAPTRAP: Process a OS/2 System error box window               */
/*           ---- Sample program demonstrating APMT -----         */
/* Author: Dev Banerjee (IBM Corporation)                         */
/*                                                                */
/* (C) Copyright IBM Corporation 1994. All rights reserved.       */
/*  All rights reserved                                           */
/*                                                                */
/* Function:                                                      */
/* This program loops and every 10 seconds looks at the top most  */
/* window on the desktop. If the top window is a system trap      */
/* window, it brings up  the trap information window, captures    */
/* the information in a bitmap file and dismisses the trap window.*/
/* The bitmap file can later be viewed by a bitmap viewing program*/
/*                                                                */
/* Prereqs:                                                       */
/*                                                                */
/*   APMT rexx function package (OS2EWS)                          */
/******************************************************************/
Trace off
call APMT_INIT
/******************************************************************/
trap_dir = ""; /* other example: trapdir = "d:\trap\"             */
say 'Waiting for a trap to occur...'
do while 1=1
   rc = WAIT(10000)
   rc = SELECT_WINDOW("*")
   rc = QUERY_TITLE("title")
   rc = PUSHBUTTON_QUERY_ALL("pbs")
   rc = RADIOBUTTON_QUERY_ALL("rbs")
   /* A tell-tale sign that we are looking at the system trap window */
   if title = '' & pbs.0 = 2 & pbs.1 = "" & pbs.2 = "" & rbs.0 = 2
      then do
        /* first, display the trap data */
        rc = RADIOBUTTON_CLICK("",2)
        rc = PUSHBUTTON_CLICK("")
        rc = WAIT(2000)
        rc = SELECT_WINDOW("*")
        /* Now get the bitmap image */
        trap_time = time()
        trap_file = translate(trap_time,'_',':')||.bmp
        trap_file = trap_dir||trap_file
        rc = SAVE_IMAGE(trap_file)
        /* dismiss the trap window  */
        rc = RADIOBUTTON_CLICK("",1)
        rc = PUSHBUTTON_CLICK("")
        say 'Trap window dismissed at ' date() trap_time
        say 'Waiting for a trap to occur...'
        end
   end
/******************************************************************/
APMT_CLOSE:
rc = END_SESSION();
exit

APMT_INIT:
call rxfuncadd  'APMTLoadFuncs',  'apmtext', 'APMTLoadFuncs'  /* entry points from the DLL    */
call APMTLoadFuncs;
rc = INIT_SESSION();
if rc \= 0
   then do
     say apmtmsg
     signal errorexit
     end
signal on halt name APMT_CLOSE
return
