/* APMT program sample provided by Jon Hosking (HOSKING@YKTVMV)        */
/*                     modified by Dev Banerjee               )        */
/* Print Screen of VM session, via APMT */
/*-----------------------------------------------------------------------
I run a VM mainframe session from an OS/2 window, connected from home
via PCTERM.  I often want to print the screen of the VM session, but
Shift+PrintScreen doesn't work in OS/2 windows and PrintScreen prints
in graphics mode (slow and unpleasant-looking).  The following procedure
works (I have slightly adapted it from an append in OS2HELP FORUM,
93/12/03, by Jane Griscti).

I can then make a program object from this file and put its icon on the
desktop, giving me a convenient replacement for Shift+PrintScreen.
-----------------------------------------------------------------------*/

Call RxFuncAdd 'APMTLoadFuncs','APMTEXT','APMTLoadFuncs'
Call APMTLoadFuncs

rc=INIT_SESSION();                      If rc\=0 Then Signal stop
signal on halt name close
rc=SELECT_WINDOW('VM Session');         If rc\=0 Then Signal stop
rc=SYSMENU_SELECT('Copy All');          If rc\=0 Then Signal stop

filename = 'emulprnt.jnk'
title    = '*emulprnt.jnk*'

/* start EPM only if needed */
rc=SELECT_WINDOW(title);
if rc \= 0 then do;
  rc=START_PROGRAM('EPM.EXE',filename); If rc\=0 Then Signal stop
  rc=SELECT_WINDOW(title,300);          If rc\=0 Then Signal stop
  rc=SYSMENU_SELECT('Minimize');        If rc\=0 Then Signal stop
  end
rc=KEYBOARD('INSERT','SHIFT');          If rc\=0 Then Signal stop
rc=MENU_SELECT('File','Print file...'); If rc\=0 Then Signal stop
rc=SELECT_WINDOW('Print document',50);  If rc\=0 Then Signal stop
rc=RADIOBUTTON_CLICK('Raw Ascii text'); If rc\=0 Then Signal stop
rc=PUSHBUTTON_CLICK('Print');           If rc\=0 Then Signal stop
rc=SELECT_WINDOW(title,50);             If rc\=0 Then Signal stop
/* Instead of ending EPM, just restore file to a blank line */
/* This will eliminate restarting EPM the next time       */
rc = KEYBOARD("HOME","C");              If rc\=0 Then Signal stop
rc = KEYBOARD("l","A");    /* mark top*/If rc\=0 Then Signal stop
rc = KEYBOARD("END","C");               If rc\=0 Then Signal stop
rc = KEYBOARD("l","A");    /* mark bot*/If rc\=0 Then Signal stop
rc = KEYBOARD("d","A");    /* delete  */If rc\=0 Then Signal stop
rc = KEYBOARD("ENTER");    /* add blank*/If rc\=0 Then Signal stop
close:
rc=END_SESSION()
Exit 0

stop:
code=Strip(rc)
Parse Value Sourceline(sigl) With 'rc=' function ';'
Say 'Return code' code 'from' function 'in line number' sigl
rc=END_SESSION()
exit code
