/******************************************************************/
/* Written by Dev Banerjee   5/5/95                               */
/* This cmd file will take one argument - The title of an already */
/* open PM application window. It will verify that its menu items */
/* have mnemonics defined and flag the duplicate ones. Output is  */
/* logfile based on the argument string.                          */
/* Input argument can can contain wildcard characters * and ?     */
/******************************************************************/
parse arg MainTitle
call LoadFUNC
rc = INIT_SESSION()
if rc \= 0 then signal errorexit
signal on halt name  CLOSE_RIGHT

/******************************************************************/
name = strip(MainTitle,'b')
parse var name w1 w2 w3 w4
logfile = w1||w2||w3||w4
logfile = translate(logfile,'_','*')
logfile = strip(substr(logfile,1,8))||'.log'
del logfile
signal on error name  errorexit
call LOGIT 'Checking mnemnics in ' MainTitle

rc = SELECT_WINDOW(MainTitle)
if rc > 0 then do
   call LOGIT 'Main window not found on the desktop'
   call CLOSE_RIGHT
   end

rc = SYSMENU_SELECT("Minimize")
call checkmenu
call logit 'Finished testing all menu items'
/******************************************************************/

CLOSE_RIGHT:
rc = END_SESSION(); call LOG
exit
/******************************************************************/
errorexit:
call DropFUNC
exit
LoadFUNC:
 call rxfuncadd  'APMTLoadFuncs',  'apmtext', 'APMTLoadFuncs'  /* entry points from the DLL    */
 call APMTLoadFuncs;
return

DropFUNC:
 call APMTDropFuncs;
 call rxfuncdrop(APMTDropFuncs)
return

LOGIT:
parse arg line
call lineout logfile, line
return

LOG:
code = rc
out = "Line" sigl ": " Sourceline(sigl) "rc = "rc
if code >0 then do
   call logit out
   call logit apmtmsg
   end
return

/*------------------------------------------------------------------*/
checkmenu: procedure expose rc apmtmsg desktop_window. logfile
rc = QUERY_WINDOW_HANDLE("sav_handle")   ;CALL log

rc = MENU_QUERY_ALL("menu")
j=0;k=0;l=0
if rc = 0 then,
   do i = 1 to menu.0
      level = 1
      if menu.i \= "" then
         call test_mnem menu.i
      rc = MENU_QUERY_ALL(menu.i,"menu1")
      do j = 1 to menu1.0
         level = 2
         if menu1.j \= "" then
         call test_mnem menu1.j
         rc = MENU_QUERY_ALL(menu.i,menu1.j,"menu2")
         if rc = 0 then,
            do k = 1 to menu2.0
               level = 3
               if menu2.k \= "" then
               call test_mnem menu2.k
               rc = MENU_QUERY_ALL(menu.i,menu1.j,menu2.k,"menu3")
               if rc = 0 then,
                  do l = 1 to menu3.0
                     level = 4
                     if menu3.l \= "" then
                     call test_mnem menu3.l
                     end
               end

         end
      end
rc = SELECT_WINDOW_BY_HANDLE(sav_handle)   ;CALL log
return




test_mnem: /*procedure expose logfile level i j k l level2 seen*/
parse arg item


item = strip(item,'b')
n = pos('~',item)
if n = 0
    then do
      mnemonic = ' *** No Mnemonic ***'
      call beeper BA
      end
    else do
      parse value item with item1 '~' item2
      mnemonic = substr(item,n+1,1)
      mnemonicU = translate(mnemonic)

      level2 = d2a(0)||d2a(i)||d2a(j)||d2a(k)||d2a(l)
      level2 = substr(level2,1,level)

     if seen.level2.mnemonicU  = 'TRUE' then do
        mnemonic = '*** mnemonic 'mnemonic 'already defined ***'
        call beeper ab
        end
        else  seen.level2.mnemonicU = 'TRUE'

      item = item1||item2
      end
out = copies('   ',level-1)||' '||left(item,30)
if length(out) > 50 then out = substr(out,1,30)
   else out = out ||copies(' ',50-length(out))
out = out ||mnemonic

call lineout logfile, out
return



d2a:
arg num
   t.0 = 'a'
   t.1 = 'b'
   t.2 = 'c'
   t.3 = 'd'
   t.4 = 'e'
   t.5 = 'f'
   t.6 = 'g'
   t.7 = 'h'
   t.8 = 'i'
   t.9 = 'j'
   t.10 = 'k'
   t.11 = 'l'
   t.12 = 'm'
   t.13 = 'n'
   t.14 = 'o'
   t.15 = 'p'
   t.16 = 'q'
   t.17 = 'r'
   t.18 = 's'
   t.19 = 't'
   t.20 = 'u'
   t.21 = 'v'
   t.22 = 'w'
   t.23 = 'x'
   t.24 = 'y'
   t.25 = 'z'

return t.num


/* Beeper: Beep according to passed string */
arg STR .
Note.A = 440
Note.B = 494
Note.C = 524
Note.D = 294
Note.E = 330
Note.F = 349
Note.G = 392
do i = 1 to length(STR)
   next = substr(STR,i,1)
   if Datatype(Note.next,'Number') = 1 then BEEP(Note.next,300)
      else BEEP(50,200)
   end
