/******************************************************************/
/* This program loops and every 10 seconds looks at the top most  */
/* window at the desktop. If the top window is a system trap      */
/* window, it dismisses the window by clicking on the first       */
/* pushbutton.                                                    */
/* Note that this window does not return any text to APMT queries.*/
/* The title and the labels are all blanks, even though the user  */
/* sees differently. Also it is not possible to get the trap      */
/* information using APMT (that would be nice!)                   */
/******************************************************************/
signal on error name  errorexit
call LoadFUNC
rc = INIT_SESSION()
if rc \= 0 then signal errorexit
signal on HALT name Break
do while 1=1
   rc = WAIT(10000)
   rc = SELECT_WINDOW("*")
   rc = QUERY_TITLE("title")
   rc = PUSHBUTTON_QUERY_ALL("pbs")
   /* A tell-tale sign that we are looking at the system trap window */
   if title = '' & pbs.0 = 2 & pbs.1 = "" & pbs.2 = ""
      then rc = PUSHBUTTON_CLICK("")
   end
/******************************************************************/
Break:
rc = END_SESSION();
exit
/******************************************************************/
errorexit:
call DropFUNC
exit
LoadFUNC:
 call rxfuncadd  'APMTLoadFuncs',  'apmtext', 'APMTLoadFuncs'  /* entry points from the DLL    */
 call APMTLoadFuncs;
return

DropFUNC:
 call APMTDropFuncs;
 call rxfuncdrop(APMTDropFuncs)
return

