/******************************************************************/
/* Sample APMT client program                                     */
/******************************************************************/
/* This program works on the PMSEEK (Seek and Scan Files) utility */
/* provided with OS/2 2.x. To run this PMSEEK.EXE should be in    */
/* the PATH.                                                      */
/* Note as a side effect of running this sample, a file may  be   */
/* printed and a file APMTJUNK may  be created in the current     */
/* directory.                                                     */
/******************************************************************/

/******************************************************************/
/* Part 1: sample common prefix for APMT programs                 */
/******************************************************************/
Trace off
call APMT_INIT
/******************************************************************/
/* Part 2: unique for each APMT program                           */
/******************************************************************/
/* start the PMSEEK program if not already started */
say "APMT Session started successfully"
say "Selecting PMSEEK window           "
rc = SELECT_WINDOW("PMSEEK*","10")
if rc > 0 then do
   say "PMSEEK not found.. starting PMSEEK.EXE "
   rc = START_PROGRAM("PMSEEK.EXE")
   if rc > 0 then do
      say "Program could not be started"
      signal errorexit
      end
      else Program_started = 1;
   rc = SELECT_WINDOW("PMSEEK*","50")
   end
say "PMSEEK window selected"
say "Setting search criteria on PMSEEK"
/* Set filename search criterion */
rc = ENTRYFIELD_SET_TEXT("1","CONFIG.*")
/* Set search text criterion */
rc = ENTRYFIELD_SET_TEXT("2","SWAPPATH")
/* set 'editor' to "E3" */
rc = ENTRYFIELD_SET_TEXT("3","E3.EXE")

/* Ensure sub-directory search */
rc = MENU_QUERY_STATE("Options", "Search subdirectories", "st")
if st.1 \= "CHECKED" then do
   say ' Setting subdirectory search option'
   rc = MENU_SELECT("Options", "Search subdirectories")
   end

/* search only the C drive */
 /* First uncheck all checkboxes                  */
 rc = CHECKBOX_QUERY_ALL("cbox")
 do i = 1 to cbox.0
    rc = CHECKBOX_QUERY_STATE(cbox.i,"state")
    if (state.1 = "CHECKED") then
       rc = CHECKBOX_CLICK(cbox.i)
    end
 /* Now check C            */
 rc = CHECKBOX_CLICK("C")

say "Clearing the previous list       "
/* Clear the list first, by using mnemonic keys */
rc = KEYBOARD("e","A")
rc = KEYBOARD("l")

/* press the search button */
say "Beginning Search.                "
rc = PUSHBUTTON_CLICK("Search")

/* wait for search to complete */
rc = WAIT(500)       /* enough time to clear status from any prior search*/
rc = TEXT_QUERY_TEXT("5", "status")    /* we know status is the 5th field*/
parse var status . w2 .
do while w2 \= "Complete..."
   rc = TEXT_QUERY_TEXT("5", "status")
   parse var status . w2 .
   end

say "Search completed. Print First File"
/* print the first file in the list                                      */
rc = LISTBOX_QUERY_COUNT("1","items")
if items > 0 then do
  rc = LISTBOX_SELECTITEM("1","0")
  rc = KEYBOARD("s","A")
  rc = KEYBOARD("c")
  rc = SELECT_DIALOGWINDOW("File Command","50")
  rc = ENTRYFIELD_SET_TEXT("1","print /")
  rc = KEYBOARD("ENTER")
  end

say "Saving the file list"
/* Save the file list                                                    */
/* Allow time for modal dialog box to clear */
rc = SELECT_DIALOGWINDOW("File Command")
do while rc = 0
   rc = WAIT(200)
   rc = SELECT_DIALOGWINDOW("File Command")
   end

rc = SELECT_WINDOW("PMSEEK*")
rc = MENU_SELECT("~File","Save ~as...")
rc = SELECT_DIALOGWINDOW("Save As","50")
rc = ENTRYFIELD_SET_TEXT("1","APMTJUNK")
rc = PUSHBUTTON_CLICK("Save")
rc = SELECT_DIALOGWINDOW("*",20)
rc = KEYBOARD("ENTER")  /* This cancels the message box from save  */

say "Quitting ..."
/* All done; If the program was started by this exec, terminate it */
if Program_started = 1 then do;
   rc = SELECT_WINDOW("PMSEEK*")
   rc = SYSMENU_SELECT("Close")
   end

/******************************************************************/
/* Part 3: common suffix for all APMT programs                    */
/******************************************************************/
APMT_CLOSE:
rc = END_SESSION();
/******************************************************************/
errorexit:
exit

DropFUNC:
 call APMTDropFuncs;
 call rxfuncdrop(APMTDropFuncs)
return

APMT_INIT:
call rxfuncadd  'APMTLoadFuncs',  'apmtext', 'APMTLoadFuncs'  /* entry points from the DLL    */
call APMTLoadFuncs;
rc = INIT_SESSION();
if rc \= 0
   then do
     say apmtmsg
     exit
     end
signal on error name  APMT_CLOSE
if apmtver.client \= apmtver.server then
   say 'WARNING: Version mismatch. Client ='apmtver.client 'Server ='apmtver.server
   else say 'Running APMT version 'apmtver.client
signal on halt name APMT_CLOSE
return

