% ------------
% PROTOCOL.CTL
% ------------
%
% This file is used to define external protocols usable with Max 2.0.
% Both Opus-compatible and non-standard protocols can be used
% directly by Maximus.
%
% If you're using a locked baud rate, THESE PROTOCOL ENTRIES MAY NEED
% TO BE MODIFIED.  You should replace all "%W"'s in this file with your
% locked baud rate (such as 19200 or 38400).
%
% Also, if you're running 4DOS (or any other alternate shell), you
% should replace all occurences of "command.com" with the name of
% your shell (such as command.com).  Failure to do this may cause erratic
% results when calling external protocols.

% The BiModem protocol from Erik Labs.  To use, simply uncomment this
% protocol entry and place BIMODEM.COM and associated configuration
% files in the \MAX directory.

Protocol BiModem
        Type            Batch
;       Type            Errorlevel
        Type            Bi
;       Type            Opus
%
        LogFile         Bimodem.Log
        ControlFile     Bimodem.Ctl
        DownloadCmd     bimodem /B %W /L 1 /T %t /R %V /U @Bimodem.Ctl
        UploadCmd       bimodem /B %W /L 1 /T %t /R %V
        DownloadString  %s
        UploadString
        DownloadKeyword " S "
        UploadKeyword   " R "
        FilenameWord    5
        DescriptWord    0
End Protocol

Protocol GYmodem
        Type            Batch
;       Type            Errorlevel
;       Type            Bi
;       Type            Opus
%
        LogFile         DSZY%K.Log
        ControlFile     DSZY%K.Ctl
        DownloadCmd     4os2 /c rdsz DSZY%K.Log 1 %W sb -g @%x:DSZY%K.Ctl
        UploadCmd       4os2 /c rdsz DSZY%K.Log 1 %W restrict rb -g %v
        DownloadString  %s
        UploadString
        DownloadKeyword S
        UploadKeyword   R
        FilenameWord    10
        DescriptWord    0
End Protocol


Protocol HS/Link
          Type            Batch
;         Type            Errorlevel
          Type            Bi
;         Type            Opus

          LogFile         HSL%K.Log
          ControlFile     HSL%K.Ctl
          DownloadCmd     4os2 /c rhsl HSL%K.Log 1 %V @%x:HSL%K.Ctl
          UploadCmd       4os2 /c rhsl HSL%K.Log 1 %V
          DownloadString  %s
          UploadString
          DownloadKeyword h
          UploadKeyword   H
          FilenameWord    10
          DescriptWord    0
 End Protocol


Protocol Kermit
         Type            Batch

         LogFile         KERM%K.Log
         ControlFile     KERM%K.Ctl
         DownloadCmd     OS2FTP.Exe -kermit -tmp\KERM%K -s#KERM%K.Ctl
         UploadCmd       OS2FTP.Exe -kermit -tmp\KERM%K -r#KERM%K.Ctl
         DownloadString  Send %s
         UploadString    Get %s
         DownloadKeyword Sent
         UploadKeyword   Got
         FilenameWord    1
         DescriptWord    0
End Protocol

;
%
% MPt protocol.  This is the protocol designed by MPt Systems.  To use,
% simply uncomment this protocol and place MPT.EXE in your \MAX directory.
%

Protocol MPt
        Type            Batch
;       Type            Errorlevel
;       Type            Bi
;       Type            Opus
%
        LogFile         Mpt.Log
        ControlFile     Mpt.Ctl
        DownloadCmd     mpt A+ B- D+ F+ N+ P1 S0 M- W- HF Lmpt.log s @mpt.ctl
        UploadCmd       mpt A+ B- D+ F+ N+ P1 S0 M- W- HF Lmpt.log r %v
        DownloadString  %s
        UploadString
        DownloadKeyword S
        UploadKeyword   R
        FilenameWord    10
        DescriptWord    0
End Protocol

Protocol Ymodem
        Type            Batch
;       Type            Errorlevel
;       Type            Bi
;       Type            Opus
%
        LogFile         DSZY%K.Log
        ControlFile     DSZY%K.Ctl
        DownloadCmd     4os2 /c rdsz DSZY%K.Log 1 %W sb -k @%x:DSZY%K.Ctl
        UploadCmd       4os2 /c rdsz DSZY%K.Log 1 %W rb %v
        DownloadString  %s
        UploadString
        DownloadKeyword S
        UploadKeyword   R
        FilenameWord    10
        DescriptWord    0
End Protocol

Protocol Zmodem-90
        Type            Batch
;       Type            Errorlevel
;       Type            Bi
;       Type            Opus
%
        LogFile         DSZ%K.Log
        ControlFile     DSZ%K.Ctl
        DownloadCmd     4os2 /c rdsz DSZ%K.Log 1 %W sz -m -Z @%x:DSZ%K.Ctl
        UploadCmd       4os2 /c rdsz DSZ%K.Log 1 %W rz %v
        DownloadString  %s
        UploadString
        DownloadKeyword z
        UploadKeyword   Z
        FilenameWord    10
        DescriptWord    0
End Protocol
