; Program to adjust the RTC date from 1994 to 2000 during OS/2 bootstrap.

; Copyright (C) 2000, David W. Noon

; You may use this code freely. You may also distribute it provided no
; charge is levied beyond the price of its distribution medium.

           .386
           .MODEL  FLAT

; Our entry points into the OS/2 kernel
           INCLUDELIB OS2386.LIB
           EXTRN   DosGetDateTime: NEAR
           EXTRN   DosSetDateTime: NEAR

; OS/2 date and time structure (11 bytes)
DATETIME   STRUCT
hours      DB      ?
minutes    DB      ?
seconds    DB      ?
hundredths DB      ?
day        DB      ?
month      DB      ?
year       DW      ?
timezone   DW      ?
weekday    DB      ?
DATETIME   ENDS

           ASSUME  CS:FLAT, DS:FLAT, SS:FLAT

           .STACK

           .CODE
mainentry: PUSH    EBP
           MOV     EBP, ESP
           SUB     ESP, 12

           PUSH    ESP
           CALL    DosGetDateTime        ; Obtain current date and time
           ADD     ESP, 4

           CMP     WORD PTR 6[ESP], 1994 ; Is current year 1994?
           JNE     SHORT NoAdjust        ; No, leave it as is
           MOV     WORD PTR 6[ESP], 2000 ; Yes, set it to 2000

           PUSH    ESP
           CALL    DosSetDateTime        ; Update current date and time

NoAdjust:  MOV     ESP,EBP
           XOR     EAX,EAX
           POP     EBP
           RET
           END     mainentry
