#!/bin/sh
#
# @(#) smbprint.sysv version 1.0 Ross Wakelin <r.wakelin@march.co.uk>
#
#      Version 1.0 13 January 1995
#		modified from the original smbprint (bsd) script
#
# this script is a System 5 printer interface script. It 
# uses the smbclient program to print the file to the specified smb-based 
# server and service. 
# 
# To add this to your lp system, copy this file into your samba directory 
# (the example here is /opt/samba), modify the server and service variables 
# and then execute the following command (as root) 
#
# lpadmin -punixprintername -v/dev/null -i/opt/samba/smbprint 
# 
# where	unixprintername is the name that the printer will be known as 
# on your unix box. 
# 
# the script smbprint will be copied into your printer administration 
# directory (/usr/lib/lp or /etc/lp) as a new interface 
# (interface/unixprintername)
# Then you have to enable unixprintername and accept unixprintername
#
# This script will then be called by the lp service to print the files
# This script will have 6 or more parameters passed to it by the lp service.
# The first five will contain details of the print job, who queued it etc,
# while parameters 6 onwards are a list of files to print.  We just
# cat these at the samba client.
#
# Set these to the server and service you wish to print to 
# In this example I have a WfWg PC called "lapland" that has a printer 
# exported called "printer" with no password.
#
# clear out the unwanted parameters
shift;shift;shift;shift;shift
# now the argument list is just the files to print

server=admin
service=hplj2
password=""

(
# NOTE You may wish to add the line `echo translate' if you want automatic
# CR/LF translation when printing.
       echo translate
	echo "print -"
	cat $*
) | /opt/samba/smbclient "\\\\$server\\$service" $password -N -P  > /dev/null
exit $?

