[OLIROU16]
Type = NDIS
Title = "Olicom Token-Ring ISA and MCA 16/4 ROUTER Adapters"
Version = 7.10
DriverName = OLITOK$
Xports = NETBEUI LANDD

[FILE]
Name = OLITOK16.OS2
Path = IBMCOM\MACS

[IoBase]
display = "I/O Base Address"
type = hexadecimal
set = 0a00,0a20,0a40,0a60,0a80,0aa0,0ac0,0ae0,0b00,0b20,0b40,0b60,0b80,0ba0,0bc0,0be0
; default = 0a20
optional=yes
help = "This parameter specifies the I/O-port base address for the NIC to use. 
The driver will search for the NIC if no parameter is specified (default).
If more than one NIC is installed in the PC you must specify an I/O Base Address"


[EnableBridge]
display = "Enable the IBM Bridge function"
type = string
strlength = 3
set = "Yes","No"
default = "Yes"
help = "This parameter specifies whether the IBM Source Routing Bridge 
 function shall be enabled. It must be set to 'Yes', if the LAN Distance 
 package shall be supported. If this parameter is set to 'Yes', the default 
 Bridge Transmit Buffer Size is 32K. This can be changed with the BridgeRam 
 parameter. 'Yes' is the default value.
 Note, that the IBM Source Routing Bridge function requires an Olicom
 Token-Ring Router Adapter."


[BridgeRAM]
display = "Bridge Transmit Buffer Size"
type = decimal
range = 2-60
optional=yes
editable=yes
help = "This parameter specifies the size (in kilobytes) of PC-memory you 
 allocate for Bridge Transmit Buffers. The adapter needs Bridge Transmit
 Buffers, if the EnableBridge parameter is set to 'Yes'. The default value
 is 32. If a Bridge Transmit Buffer Size is defined, the adapter cannot 
 forward transmit frames that are larger than the Bridge Transmit Buffer Size
 across the bridge."

[EarlyRelease]
display = "Early release"
type = string
strlength = 3
set = "Yes","No"
default = "Yes"
help = "This parameter specifies the early token release option for
 Olicom Token-Ring 16/4 network adapter cards.  The early token release
 option reduces the average time that another network adapter card
 must wait to gain access to the network.  Network adapter cards
 that do not support the early token release option ignore this
 parameter."


[NetAddress]
display = "Network adapter address"
type = hexstring
strlength = 12
range = 400000000000-4FFFFFFFFFFF
optional=yes
editable=yes
help = "This parameter overrides the network address of the network
 adapter card.  The value of this parameter is a hexadecimal string of
 12 digits, as in 400001020304.  The address must be unique among all
 other network adapter addresses on the network. Specify the network
 adapter address in IBM Token-Ring Network format."


[MaxRequests]
display = "Max. number of queued general requests"
type = decimal
default = 6
range = 1-10
help = "Sets the maximum number of outstanding GeneralRequests and configures
 the size of GeneralRquest Queue."


[MaxTransmits]
display = "Maximum number of queued transmits"
type = decimal
default = 40
range = 2-100
help = "This parameter specifies the maximum number of transmit queue
 entries for the network adapter driver.  For a server workstation or
 gateway workstation, set this parameter to the result of multiplying
 the Maximum Transmits Outstanding parameter against the Maximum Sessions
 parameter located in the NETBIOS protocol."


[RecBufCount]
display = "Number of receive buffers"
type = decimal
default = 10
range = 4-30
help = "This parameter specifies the number of Receive buffers in the Receive
 Buffer Pool. The maximum size of the frames which may be received by this
 adapter is determined by:
	min(MaxFs, ReceiveArea-256 , 1016 x ((ReceiveArea-1) div 1016)), 
	where MaxFs is 4472 at 4 Mbps and 17954 at 16Mbps and 
	ReceiveArea =  RecBufSize x RecBufCount."


[RecBufSize]
display = "Receive buffer size"
type = decimal
default = "4500"
range = 256-5080
help = "This parameter specifies the size (in bytes) of buffers in the Receive
 Buffer Pool. The maximum size of the frames which may be received by this
 adapter is determined by:
	min(MaxFs, ReceiveArea-256 , 1016 x ((ReceiveArea-1) div 1016)), 
	where MaxFs is 4472 at 4 Mbps and 17954 at 16Mbps and
	ReceiveArea =  RecBufSize x RecBufCount."


[MaxFrameSize]
display = "MaxFrameSize"
type = decimal
range = 512-17954
default = 4500
help = "This parameter specifies the maximum frame length the driver supports.
 Some protocols (like the IBM NETBIOS driver for DOS) requires that the 
 maximum frame size is below a certain value. If this parameter is omitted
 the maximum frame size is set to 17954 bytes on 16Mbit Token-Ring and 4472
 bytes on 4Mbit Token-Ring. The frame size is also limited by the RecBufSize
 and RecBufCount parameters. The MaxFrameSize parameter do not allocate any
 resources in the driver."


[ReOpen]
display = "Re-open on lobe-error"
type = string
strlength = 3
set = "Yes","No"
default = "No"
help = "This parameter specifies to the network driver whether it is should
 try to reopen the adapter if it closes due to lobe-errors, or not.
 The default is 'No.'"


[FrameStatus]
display = "FrameStatus"
type = string
strlength = 3
set = "Yes","No"
default = "No"
help = "This parameter specifies the value of the framestatus of a 
 transmitted frame. Some protocols depend on the actual frame status and 
 others requires a SUCCESS value on all transmitted frames.  
 If you cannot make a connection to a machine on an other ring you should
 try to set this parameter to 'Yes'. 
 'No' is the default value, it gives better performance."


[TxBufferSize]
display = "TransmitBufferSize"
type = decimal
range = 2-60
optional=yes
editable=yes
help = "This parameter specifies the size (in kilobytes) of PC-memory you 
 allocate for TransmitBuffers. The adapter needs TransmitBuffers if there
 are more than 16 megabytes of memory in the PC, AND you are not using
 an 'EISA 16/4 Adapter'.
 If a TransmitBufferSize is defined; the adapter cannot transmit frames that
 are larger than the TransmitBufferSize.
 If the parameter 'Accept virtual addresses (GDT)' is set to 'Yes' you can 
 use this parameter to change the TransmitBufferSize.
 By default no TransmitBufferSize is defined, this normally gives the best
 performance."


[SupportGDT]
display = "Accept virtual addresses (GDT)"
type = string
strlength = 3
set = "Yes","No"
default = "No"
help = "This parameter specifies whether a protocol can transmit frames
 using virtual addresses (GDT's), or if it MUST use physical addresses.
 Some protocols can only use virtual addresses, if you use such a protocol
 you must set this parameter to 'Yes', otherwise you should set it to 'No'.
 If this parameter is to 'Yes', the default size for TransmitBufferSize is 20K,
 this can be changed with the TransmitBufferSize parameter. 
 'No' is the default value, it gives better performance."


[DMABurstSize]
display = "DMABurstSize"
type = string
strlength = 6
set = "Short","Normal","Long"
; default = Normal
optional=yes
editable=yes
help = "This parameter specifies whether to change the DMA burstsize
 on the Olicom Token-Ring 16/4 ISA network adapter card. EISA and MC adapter
 cards will ignore this parameter. Heavy network activity can interfere 
 with the floppy drive and other DMA devices, Select 'Short' to decrease
 interference. Select 'Long' for best performance. 'Normal' is the default value."


[RecBufHigh]
display = "Buffer Pool in high memory"
type = decimal
range = 0-1
optional=yes
editable=yes
help = "Configures the Buffer Pool in high (above 1M bytes) or low
 memory. A value of 0 (zero) causes the driver to try to allocate the Pool
 in high memory and only if this fails to allocate from low memory. A value of
 1 causes the driver to do the opposite, that is, try to allocate the Pool in
 low memory and if this fails then try from high memory."


[NDIS201]
display = "Disable NDIS 2.02 support"
type = none
set = "Yes","No"
default = "No"
help = "This parameter specifies to the network driver that it may only
 support NDIS201 and not the IBM extension to the standard (NDIS 2.02).
 If you want to use LSM, LNM or 802.2 the driver you should leave the 
 support for NDIS 2.02 on. If you want to do NDIS 2.01 conformance test
 use the parameter. The default is that the parameter is not used."



