#!/bin/sh

RPM_BA="rpm -ba -ta misc/guenter.spec"
RPM_BB="rpm -bb -ta misc/guenter.spec"

echo "Creating tarball..."
rm -f config.cache && ./cvscompile.sh && make dist
cp xine-lib-0.9.8.tar.gz  /usr/src/redhat/SOURCES
rm -rf rpms
mkdir rpms

echo "*****************************************************"
echo
echo "building rpm for xine-lib 0.9.8"
echo 
echo "current architecture:pentiumpro"
echo "rpms will be copied to ./rpms directory"
echo
echo "*****************************************************"

export XINE_BUILD=i686-pc-linux-gnu

eval $RPM_BA

cp '/usr/src/redhat/SRPMS/xine-lib-0.9.8-0.src.rpm' ./rpms/
mv '/usr/src/redhat/RPMS/i386/xine-lib-0.9.8-0.i386.rpm' './rpms/xine-lib-0.9.8-0.i686.rpm'

echo "*****************************************************"
echo
echo "building rpm for xine-lib 0.9.8"
echo 
echo "current architecture:k6"
echo "rpms will be copied to ./rpms directory"
echo
echo "*****************************************************"

export XINE_BUILD=k6-pc-linux-gnu

eval $RPM_BB

mv '/usr/src/redhat/RPMS/i386/xine-lib-0.9.8-0.i386.rpm' './rpms/xine-lib-0.9.8-0.k6.rpm'

echo "*****************************************************"
echo
echo "building rpm for xine-lib 0.9.8"
echo 
echo "current architecture:pentium"
echo "rpms will be copied to ./rpms directory"
echo
echo "*****************************************************"

export XINE_BUILD=i586-pc-linux-gnu

eval $RPM_BB

mv '/usr/src/redhat/RPMS/i386/xine-lib-0.9.8-0.i386.rpm' './rpms/xine-lib-0.9.8-0.i586.rpm'

echo "*****************************************************"
echo
echo "building rpm for xine-lib 0.9.8"
echo 
echo "current architecture:k7"
echo "rpms will be copied to ./rpms directory"
echo
echo "*****************************************************"

export XINE_BUILD=athlon-pc-linux-gnu

eval $RPM_BB

mv '/usr/src/redhat/RPMS/i386/xine-lib-0.9.8-0.i386.rpm' './rpms/xine-lib-0.9.8-0.k7.rpm'

echo "Done."
