#include <stdio.h>
#include <xine.h>

vo_driver_t* vo;
ao_driver_t* ao;
config_values_t * conf;
xine_t* xine;

int width;
int height;

int          depth = 0;

void cds(void *user_data, int video_width, int video_height,
         int *dest_width, int *dest_height){

  *dest_width = width;
  *dest_height = height;
}

void rds(void *user_data,
         int video_width, int video_height,
         int *dest_x, int *dest_y,
         int *dest_width, int *dest_height){

  *dest_x = 0;
  *dest_y = 0;
  *dest_width = width;
  *dest_height = height;
}

int main(int argc, char ** argv) {
  int windowed;
  char confFile[256];
  char **driver_ids;
  int i;
  windowed = 1;

  sprintf(confFile, "%s%s", xine_get_homedir(), "/.dvdplayer/xinerc");
  conf = config_file_init (confFile);

  ao = xine_load_audio_output_plugin(conf, "dart");

  vo = xine_load_video_output_plugin(conf, "aa", VISUAL_TYPE_AA, NULL);
  if(!vo) {
    printf("Loading videoplugin failed! Bailing..\n");
    exit(2);
  }

  xine = xine_init(vo, ao, conf);

  if(!xine) {
    printf("xine init failed! Bailing..\n");
    exit(3);
  }



  if(!xine_play(xine, "/download/mpegtest.mpg", 0, 0)) {
    printf("Can't play! Bailing");
  }
  sleep(30);

  xine_exit(xine);

  printf("All done!\n");
}
