/* !! DO NO EDIT THIS FILE, it is automatically generated */
/**
 * \file xine.h
 * \author Guenter Bartsch <guenter@users.sourceforge.net>
 * \author Siegfried Langauf <siggi@users.sourceforge.net>
 * \author Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
 * \date 16/09/2001
 *
 * API of XINE library.
 \verbatim
   Copyright (C) 2000-2001 the xine project
 
   This file is part of xine, a unix video player.
 
   xine is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   xine is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 
 \endverbatim
 */
/*
 * $Id: xine.h.tmpl.in,v 1.75 2002/01/10 15:48:55 jcdutton Exp $
 *
 */

#ifndef HAVE_XINE_H
#define HAVE_XINE_H

#ifdef __cplusplus
extern "C" {
#endif

#include <inttypes.h>
#include <unistd.h>
#include <sys/types.h>

#include <xine/events.h>

/**
 * \def XINE_SKINDIR
 * Skin file location
 */
#define XINE_SKINDIR    "/usr/local/share/xine/skins"

     /**
      * \defgroup build_info Build informations
      * @{
      */

/**
 * \def XINE_BUILD_CC
 * Compiler used to build xine-lib
 */
#define XINE_BUILD_CC      "gcc version 3.0.3"
/** \def XINE_BUILD_OS
 * OS used to build xine-lib
 */
#define XINE_BUILD_OS      "OS/2 1 i386"
/** \def XINE_BUILD_DATE
 * Build time
 */
#define XINE_BUILD_DATE    "Sat 11 May 2002 19:12:39"

     /** @} end of build_info */

     /**
      * \defgroup xine_api API functions
      * @{
      */

          /**
	   * \defgroup status_group Player status constants
	   * @{
	   */

/** 
 * \def XINE_STOP
 * Stop status.
 * \sa xine_get_status()
 */
#define XINE_STOP      0
/**
 * \def XINE_PLAY
 * Play status.
 * \sa xine_get_status()
 */
#define XINE_PLAY      1
/** 
 * \def XINE_QUIT
 * Quit status.
 * \sa xine_get_status()
 */
#define XINE_QUIT      2

          /** @} end of status_group */

          /** 
	   * \defgroup version_group Version constants 
	   * @{
	   */

/**
 * \def XINE_MAJOR_VERSION
 * Major version constant.
 */
#define XINE_MAJOR_VERSION 0
/**
 * \def XINE_MINOR_VERSION
 * Minor version constant.
 */
#define XINE_MINOR_VERSION 9
/**
 * \def XINE_SUB_VERSION
 * Sub version constant.
 */
#define XINE_SUB_VERSION   8

          /** @} end of version_group */

          /**
	   * \defgroup xine_version Version functions
	   * @{
	   */

/**
 * \fn char *xine_get_str_version(void);
 * \brief return string version, like "0.5.0"
 * \param None.
 * \return string version
 *
 */
char *xine_get_str_version(void);

/**
 * \fn int xine_get_major_version(void);
 * \brief return version information
 * \param None.
 * \return major version.
 *
 */
int xine_get_major_version(void);

/**
 * \fn int xine_get_minor_version(void);
 * \brief return version information
 * \param None.
 * \return minor version.
 *
 */
int xine_get_minor_version(void);

/**
 * \fn int xine_get_sub_version(void);
 * \brief return version information
 * \param None.
 * \return sub version.
 *
 */
int xine_get_sub_version(void);

/**
 * \fn int xine_check_version(int major, int minor, int sub);
 * \brief check minimal version.
 * \param major major version wanted.
 * \param minorr minor version wanted.
 * \param sub sub version wanted.
 * \return 1 if installed version is >= to desired, otherwise 0
 *
 * Compare version numbers with xine installed version.
 */
int xine_check_version(int major, int minor, int sub);

          /** @} end of xine_version */

          /** 
	   * \defgroup video_group Video.
	   * @{
	   */

                /**
		 * 
		 * \defgroup video_cap video driver capabilities
		 * @{
		 */
/** 
 * \def VO_CAP_HUE
 * Driver can set HUE value.
 */
#define VO_CAP_HUE          0x00000010
/** 
 * \def VO_CAP_SATURATION
 * Driver can set SATURATION value.
 */
#define VO_CAP_SATURATION   0x00000020
/**
 * \def VO_CAP_BRIGHTNESS
 * Driver can set BRIGHTNESS value.
 */
#define VO_CAP_BRIGHTNESS   0x00000040
/**
 * \def VO_CAP_CONTRAST
 * Driver can set CONTRAST value.
 */
#define VO_CAP_CONTRAST     0x00000080
/**
 * \def VO_CAP_COLORKEY
 * Driver can set COLORKEY value.
 */
#define VO_CAP_COLORKEY     0x00000100
/**
 * \def VO_CAP_AUTOPAINT_COLORKEY
 * Driver can set AUTOPAINT_COLORKEY value.
 */
#define VO_CAP_AUTOPAINT_COLORKEY     0x00000400

               /** @} end of video_cap */

               /**
		* 
		* \defgroup video_prop Constants for the get/set properties functions.
		* @{
		*/
/**
 * \def VO_PROP_INTERLACED
 * Interleave property.
 * \sa vo_driver_t
 */
#define VO_PROP_INTERLACED           0
/**
 * \def VO_PROP_ASPECT_RATIO
 * Aspect ratio property.
 * \sa vo_driver_t, video_ratio
 */
#define VO_PROP_ASPECT_RATIO         1
/**
 * \def VO_PROP_HUE
 * Hue property.
 * \sa vo_driver_t
 */
#define VO_PROP_HUE                  2
/**
 * \def VO_PROP_SATURATION
 * Saturation property.
 * \sa vo_driver_t
 */
#define VO_PROP_SATURATION           3
/**
 * \def VO_PROP_CONTRAST
 * Contrast property.
 * \sa vo_driver_t
 */
#define VO_PROP_CONTRAST             4
/**
 * \def VO_PROP_BRIGHTNESS
 * Brightness property.
 * \sa vo_driver_t
 */
#define VO_PROP_BRIGHTNESS           5
/**
 * \def VO_PROP_COLORKEY
 * Colorkey property.
 * \sa vo_driver_t
 */
#define VO_PROP_COLORKEY             6
/**
 * \def VO_PROP_AUTOPAINT_COLORKEY
 * Autopaint colorkey property.
 * \sa vo_driver_t
 */
#define VO_PROP_AUTOPAINT_COLORKEY   7
/**
 * \def VO_PROP_ZOOM_X
 * Horizontal zoom  property.
 * \sa vo_driver_t
 */
#define VO_PROP_ZOOM_X               8
/**
 * \def VO_PROP_ZOOM_Y
 * Vertical zoom property.
 * \sa vo_driver_t
 */
#define VO_PROP_ZOOM_Y               9
/**
 * \def VO_PROP_OFFSET_X
 * Horizontal offset property.
 * \sa vo_driver_t
 */
#define VO_PROP_OFFSET_X             10
/**
 * \def VO_PROP_OFFSET_Y
 * Vertical offset property.
 * \sa vo_driver_t
 */
#define VO_PROP_OFFSET_Y             11
/**
 * \def VO_PROP_TVMODE
 * Change TVmode property.
 * \sa vo_driver_t
 */
#define VO_PROP_TVMODE               12
/**
 * \def VO_NUM_PROPERTIES
 * Number of available properties property.
 * \sa vo_driver_t
 */
#define VO_NUM_PROPERTIES            13

               /** @} end of video_prop */

                /**
		* \defgroup video_zoom Zoom related constants
		* \sa VO_PROP_ASPECT_RATIO, vo_driver_t
		* @{
		*/
/**
 * \def ZOOM_STEP
 * Step for the zoom feature
 * \sa VO_PROP_ZOOM_X
 */
#define ZOOM_STEP        100
/**
 * \def ZOOM_MAX
 * Max value for zoom properties
 * \sa VO_PROP_ZOOM_X
 */
#define ZOOM_MAX         400
/**
 * \def ZOOM_MIN
 * Min value for zoom properties
 * \sa VO_PROP_ZOOM_X
 */
#define ZOOM_MIN         -85
    
               /** @} end of video_zoom */
	       
                /**
		* \defgroup video_ratio Possible ratios for the VO_PROP_ASPECT_RATIO call
		* \sa VO_PROP_ASPECT_RATIO, vo_driver_t
		* @{
		*/

/**
 * \def ASPECT_AUTO
 * Let video driver guessing aspect ratio.
 * \sa VO_PROP_ASPECT_RATIO
 */
#define ASPECT_AUTO        0
/**
 * \def ASPECT_ANAMORPHIC
 * Set aspect ration to 16:9.
 * \sa VO_PROP_ASPECT_RATIO
 */
#define ASPECT_ANAMORPHIC  1
/**
 * \def ASPECT_FULL
 * Set aspect ration to 4:3.
 * \sa VO_PROP_ASPECT_RATIO
 */
#define ASPECT_FULL        2
/**
 * \def ASPECT_DVB
 * Set aspect ration to 1:2.
 * \sa VO_PROP_ASPECT_RATIO
 */
#define ASPECT_DVB         3
/**
 * \def ASPECT_SQUARE
 * Set aspect ration to square pels.
 * \sa VO_PROP_ASPECT_RATIO
 */
#define ASPECT_SQUARE      4
/**
 * \def NUM_ASPECT_RATIOS
 * Number of aspect ratios supported for VO_PROP_ASPECT_RATIO property.
 * \sa VO_PROP_ASPECT_RATIO
 */
#define NUM_ASPECT_RATIOS  5

               /** @} end of video_ratio */

/**
 * \def OVL_PALETTE_SIZE
 * The number of colors in the overlay palette.
 */
#define OVL_PALETTE_SIZE 256

/**
 * \struct vo_frame_t
 * Opaque data type.
 * \sa vo_driver_t
 */
typedef void vo_frame_t;
/**
 * \struct vo_overlay_t
 * Opaque data type.
 * \sa vo_driver_t
 */
typedef void vo_overlay_t;

typedef struct vo_info_s vo_info_t;

struct vo_info_s {
   
  int    interface_version; /* plugin interface version                  */
  char  *id;                /* id of this plugin                         */
  char  *description;       /* human-readable description of this plugin */
  int    visual_type;       /* visual type supported by this plugin      */
  int    priority;          /* priority of this plugin for auto-probing  */

};

/**
 * \struct vo_driver_t
 * \brief Data type of structure vo_driver_s.
 * \sa structure vo_driver_s.
 */
typedef struct vo_driver_s vo_driver_t;

/**
 * \struct vo_driver_s
 * Video driver fonctions.
 */
struct vo_driver_s {
  /**
   * Get capabilities of video driver.
   * \sa video_cap
   */
  uint32_t (*get_capabilities) (vo_driver_t *self);
  /**
   * Allocate an vo_frame_t struct,
   * the driver must supply the copy, field and dispose functions
   */
  vo_frame_t* (*alloc_frame) (vo_driver_t *self);
  /**
   * Check if the given image fullfills the format specified
   * (re-)allocate memory if necessary
   */
  void (*update_frame_format) (vo_driver_t *self, vo_frame_t *img,
			       uint32_t width, uint32_t height, 
			       int ratio_code, int format);
  /**
   * Display a given frame
   */
  void (*display_frame) (vo_driver_t *self, vo_frame_t *vo_img);
  /**
   * Overlay functions
   */
  void (*overlay_blend) (vo_driver_t *self, vo_frame_t *vo_img, vo_overlay_t *overlay);
  /**
   * These can be used by the gui directly:
   */
  /**
   * Get value if property.
   * \sa video_prop
   */
  int (*get_property) (vo_driver_t *self, int property);
  /**
   * Set value of property.
   * \sa video_prop
   */
  int (*set_property) (vo_driver_t *self, 
		       int property, int value);
  /**
   * Get min/max values of property.
   * \sa video_prop
   */
  void (*get_property_min_max) (vo_driver_t *self,
				int property, int *min, int *max);
  /** 
   * General purpose communication channel between gui and driver
   *
   * this should be used to propagate events, display data, window sizes
   * etc. to the driver
   */
  int (*gui_data_exchange) (vo_driver_t *self, int data_type,
			    void *data);
  /**
   * Leaving video driver.
   */
  void (*exit) (vo_driver_t *self);

  /**
   * Get driver name etc.
   */
  vo_info_t* (*get_info) ();

};
          /** @} end of video_group */

          /** 
	   * \defgroup xine_init Init functions
	   * @{
	   */

               /** 
		* \defgroup config_group Configuration structure type.
		* @{
		*/

/**
 * \struct xine_t
 * Opaque data type.
 * \sa xine_load_audio_output_plugin
 */
typedef void xine_t;
/**
 * \struct ao_driver_t 
 * Opaque data type.
 */
typedef void ao_driver_t;

typedef struct cfg_entry_s cfg_entry_t;
typedef struct config_values_s config_values_t;
typedef void (*config_cb_t) (void *, cfg_entry_t *);

struct cfg_entry_s {
  cfg_entry_t     *next;
  config_values_t *config;
  
  char            *key;
  int              type;

  /* type unknown */
  char            *unknown_value;

  /* type string */
  char            *str_value;
  char            *str_default;
  char            *str_sticky;

  /* common to range, enum, num, bool: */

  int              num_value;
  int              num_default;

  /* type range specific: */
  int              range_min;
  int              range_max;

  /* type enum specific: */
  char           **enum_values;

  /* help info for the user */
  char            *description;
  char            *help;

  /* callback function and data for live changeable values */
  config_cb_t      callback;
  void            *callback_data;
};

/*
 * config entry data types
 */

#define CONFIG_TYPE_UNKNOWN 0
#define CONFIG_TYPE_RANGE   1
#define CONFIG_TYPE_STRING  2
#define CONFIG_TYPE_ENUM    3
#define CONFIG_TYPE_NUM     4
#define CONFIG_TYPE_BOOL    5

struct config_values_s {

  /*
   * register config values
   *
   * these functions return the current value of the
   * registered item, i.e. the default value if it was
   * not found in the config file or the current value
   * from the config file otherwise
   */

  char* (*register_string) (config_values_t *self,
			    char *key, 
			    char *def_value,
			    char *description, 
			    char *help,
			    config_cb_t changed_cb,
			    void *cb_data);

  int (*register_range) (config_values_t *self,
			 char *key,
			 int def_value,
			 int min, int max,
			 char *description, 
			 char *help,
			 config_cb_t changed_cb,
			 void *cb_data);

  int (*register_enum) (config_values_t *self,
			char *key,
			int def_value,
			char **values,
			char *description, 
			char *help,
			config_cb_t changed_cb,
			void *cb_data);

  int (*register_num) (config_values_t *self,
		       char *key, 
		       int def_value,
		       char *description, 
		       char *help,
		       config_cb_t changed_cb,
		       void *cb_data);

  int (*register_bool) (config_values_t *self,
			char *key, 
			int def_value,
			char *description, 
			char *help,
			config_cb_t changed_cb,
			void *cb_data);

  /* convenience function to update range, enum, num and bool values */
  void (*update_num) (config_values_t *self,
		      char *key, int value);

  /* convenience function to update string values */
  void (*update_string) (config_values_t *self,
			 char *key, char *value);

  /* small utility function for enum handling */
  int (*parse_enum) (char *str, char **values);

  /*
   * lookup config entries
   * 
   * remember to call the changed_cb if it exists
   * and you changed the value of this item
   */

  cfg_entry_t* (*lookup_entry) (config_values_t *self,
				char *key);

  /*
   * write config file to disk
   */
  void (*save) (config_values_t *self);

  /*
   * read config file from disk, overriding values in memory
   */
  void (*read) (config_values_t *self, char *filename);

  /* 
   * config values are stored here:
   */
  cfg_entry_t         *first, *last;
};

               /** @} end of config_group */
  

/**
 * \fn config_values_t *config_file_init (char *filename)
 * \brief Configuration file initialisation.
 * \param filename Pathname of configuration file.
 * \return Current config
 * \sa config_values_t
 * \warning This function should be called at least one time before xine_init() call.
 *
 * Read config file and init a config object of config_values_t type (if it exists)
 */
config_values_t *config_file_init (char *filename);

               /** 
		* \defgroup ui_callbacks UI communication callbacks.
		* @{
		*
		*/

               /** @} end of ui_callbacks */

               /**
		* \defgroup demux_strategy Possible demuxer guessing strategy.
		* "demux_strategy" should be set to one of these value in configuration file ( #see @ref config_group) before xine_init() call.
		* \sa config_values_t
		* @{
		*/

/**
 * \def DEMUX_DEFAULT_STRATEGY
 * Recognize by content then by extension.
 * \sa config_values_t
 */
#define DEMUX_DEFAULT_STRATEGY    0
/**
 * \def DEMUX_REVERT_STRATEGY
 * Recognize by extension then by content.
 * \sa config_values_t
 */
#define DEMUX_REVERT_STRATEGY     1
/**
 * \def DEMUX_CONTENT_STRATEGY
 * Recognize by content only.
 * \sa config_values_t
 */
#define DEMUX_CONTENT_STRATEGY    2
/**
 * \def DEMUX_EXTENSION_STRATEGY
 * Recognize by extension only.
 * \sa config_values_t
 */
#define DEMUX_EXTENSION_STRATEGY  3

               /** @} end of demux_strategy */

/**
 * \fn xine_t *xine_init (vo_driver_t *vo, ao_driver_t *ao, config_values_t *config, void *user_data);
 * \brief Initialisation of xine.
 * \param vo video driver ( #see @ref xine_load_video_output_plugin() )
 * \param ao audio driver ( #see @ref xine_load_audio_output_plugin() )
 * \param config current configuration ( #see config_file_init() )
 * \return Current xine engine configuration
 * \sa vo_driver_t, ao_driver_t, config_values_t, gui_stream_end_cb_t, gui_get_next_mrl_cb_t, gui_branched_cb_t
 * \warning This function should be called before any other xine_*() function.
 *
 * Init of xine. It should called once at startup.
 * all callbacks may be NULL if ui is not interested in them for whatever reason
 * ao may be NULL for no audio playback
 *
 */
xine_t *xine_init (vo_driver_t *vo, 
		   ao_driver_t *ao,
		   config_values_t *config);

/**
 * \fn void xine_exit (xine_t *self)
 * \brief De-initialisation of xine
 * \param self Current xine engine configuration.
 * \return Nothing
 * \sa xine_init()
 *
 * De-init xine engine.
 */
void xine_exit (xine_t *self);

          /** @} end of xine_init */

          /**
	   * \defgroup xine_management Engine management
	   * @{
	   */
/**
 * \fn void xine_play (xine_t *self, char *MRL, int start_pos, int start_time)
 * \brief Start to play a stream
 * \param self Current xine engine configuration ( #see xine_init() )
 * \param MRL Media Resource Location to open
 * \param start_pos position in input source (0..65535)
 * \param start_time position measured in seconds from stream start
 * \return 1 => OK, 0=>err (use xine_get_error for details)
 *
 * Open a stream and play it.  If both start position parameters 
 * are !=0 start_pos will be used
 * for non-seekable streams both values will be ignored
 *
 */
int xine_play (xine_t *self, char *MRL, int start_pos, int start_time);

/**
 * \fn void xine_set_speed (xine_t *self, int speed)
 * \brief Set playback speed.
 * \param self Current xine engine configuration ( #see xine_init() )
 * \param speed Desired playback speed ( #see SPEED_PAUSE, SPEED_SLOW_4, SPEED_SLOW_2, SPEED_NORMAL, SPEED_FAST_2, SPEED_FAST_4 )
 * \return Nothing
 *
 * Set the playback speed to desired speed, according of SPEED_x constant.
 *
 */
void xine_set_speed (xine_t *self, int speed);

/**
 * \fn xine_get_speed (xine_t *self)
 * \brief Get the playback speed.
 * \param self Current xine engine configuration ( #see xine_init() )
 * \return speed value ( #see SPEED_PAUSE, SPEED_SLOW_4, SPEED_SLOW_2, SPEED_NORMAL, SPEED_FAST_2, SPEED_FAST_4 )
 *
 * Get the current speed playback. Possible values are SPEED_PAUSE, SPEED_SLOW_4, SPEED_SLOW_2, SPEED_NORMAL, SPEED_FAST_2, SPEED_FAST_4.
 */
int xine_get_speed (xine_t *self);

/**
 * \def SPEED_PAUSE
 * Playback pause.
 * \sa xine_set_speed(), xine_get_speed()
 */
#define SPEED_PAUSE   0
/**
 * \def SPEED_SLOW_4
 * Playback at 25% speed.
 *\sa xine_set_speed(), xine_get_speed()
 */
#define SPEED_SLOW_4  1
/**
 * \def SPEED_SLOW_2
 * Playback at 50% speed.
 * \sa xine_set_speed(), xine_get_speed()
 */
#define SPEED_SLOW_2  2
/**
 * \def SPEED_NORMAL
 * Playback at 100% speed.
 * \sa xine_set_speed(), xine_get_speed()
 */ 
#define SPEED_NORMAL  4
/**
 * \def SPEED_FAST_2
 * Playback at 200% speed.
 * \sa xine_set_speed(), xine_get_speed()
 */
#define SPEED_FAST_2  8
/**
 * \def SPEED_FAST_4
 * Playback at 400% speed.
 * \sa xine_set_speed(), xine_get_speed()
 */
#define SPEED_FAST_4 16

/**
 * \fn void xine_set_av_offset (xine_t *self, int offset_pts)
 * \brief Set audio/video sync.
 * \param self Current xine engine configuration ( #see xine_init() )
 * \param offset_pts New pts.
 * \return Nothing
 *
 * Set audio/video sync offset, according to offset_pts value ( #see xine_get_av_offset() ).
 */
void xine_set_av_offset (xine_t *self, int offset_pts);

/**
 * \fn int xine_get_av_offset (xine_t *self)
 * \brief Get audio/video sync.
 * \param self Current xine engine configuration ( #see xine_init() )
 * \return Current audio/video offset.
 *
 * Return the current audio/video sync offset ( #see xine_set_av_offset() ).
 */
int xine_get_av_offset (xine_t *self);

/**
 * \fn void xine_stop (xine_t *self)
 * \brief Stop playing
 * \param self Current xine engine configuration ( #see xine_init() )
 * \return Nothing
 *
 * Stop the playback.
 */
void xine_stop (xine_t *self);

/**
 * \fn int xine_eject(xine_t *self)
 * \brief Eject media
 * \param self Current xine engine configuration ( #see xine_init() )
 * \return 1 on success, 0 on failure.
 *
 * Tell current input plugin to eject media.
 */
int xine_eject(xine_t *self);

/**
 * \fn int xine_get_status (xine_t *self)
 * \brief Get current xine status
 * \param self Current xine engine configuration ( #see xine_init() )
 * \return Current status ( #see @ref status_group )
 *
 * Return the current state of xine engine.
 */
int xine_get_status (xine_t *self);

/**
 * \fn int xine_get_current_position (xine_t *self)
 * \brief Get current position
 * \param self Current xine engine configuration ( #see xine_init() )
 * \return Current position ( 0..65535 )
 *
 * Get current position in stream.
 */
int xine_get_current_position (xine_t *self);

/**
 * \fn int xine_get_current_time (xine_t *self)
 * \brief get current pos in seconds
 * \param self Current xine engine configuration ( #see xine_init() )
 * \return current position measured in seconds from the beginning of the stream
 *
 * get current position measured in seconds from the beginning of the stream
 */
int xine_get_current_time (xine_t *self);

/**
 * \fn int xine_get_stream_length (xine_t *self);
 * \brief estimate length of input stream in seconds
 * \param self Current xine engine configuration ( #see xine_init() )
 * \return length of input stream in seconds or 0 if stream is not seekable
 *
 * estimate length of input stream in seconds
 */
int xine_get_stream_length (xine_t *self);

/**
 * \fn void xine_select_audio_channel (xine_t *self, int channel)
 * \brief Set logical audio channel (-1 => auto)
 * \param self Current xine engine configuration ( #see xine_init() )
 * \return Nothing
 *
 * Set desired audio channel.
 */
void xine_select_audio_channel (xine_t *self, int channel);

/**
 * \fn int xine_get_audio_selection (xine_t *self)
 * \brief Get current logical audio channel
 * \param self Current xine engine configuration ( #see xine_init() )
 * \return Current audio channel
 *
 * Get current audio channel.
 */
int xine_get_audio_selection (xine_t *self);

/**
 * \fn void xine_get_audio_lang (xine_t *self, char *str)
 * \brief  try to find out current audio language
 * \param self current xine engine configuration ( #see xine_init() )
 * \param str current audio language or number
 *
 * try to find out current audio language
 */
void xine_get_audio_lang (xine_t *self, char *str);

/**
 * \fn int xine_get_spu_channel (xine_t *self)
 * \brief get current sub-title channel.
 * \param self current xine engine configuration ( #see xine_init() )
 * \return current sub-title channel
 *
 * Get current sub-title channel.
 */
int xine_get_spu_channel (xine_t *self);

/**
 * \fn void xine_get_spu_lang (xine_t *self, char *str)
 * \brief  try to find out current spu language
 * \param self current xine engine configuration ( #see xine_init() )
 * \param str current spu language or number
 *
 * try to find out current spu language
 */
void xine_get_spu_lang (xine_t *self, char *str);

/**
 * \fn int xine_is_stream_seekable (xine_t *self)
 * \brief check if the stream is seekable (at the moment) 
 * \param self current xine engine configuration ( #see xine_init() )
 *
 * check if the stream is seekable (at the moment).
 * this state may change during playback
 */
int xine_is_stream_seekable (xine_t *self);

/**
 * \fn void xine_select_spu_channel (xine_t *self, int channel)
 * \brief Set sub-title channel
 * \param self Current xine engine configuration ( #see xine_init() )
 * \return Nothing
 *
 * Set desired sub-title channel.
 */
void xine_select_spu_channel (xine_t *self, int channel);

         /** @} end of xine_management */

         /** 
	  * \defgroup audio_group Audio.
	  * @{
	  */

                /**
		 * 
		 * \defgroup audio_cap audio driver capabilities
		 * @{
		 */
/**
 * \def AO_CAP_NOCAP
 * Driver has no capabilities.
 * \sa xine_get_audio_capabilities()
 */
#define AO_CAP_NOCAP            0x00000000
/**
 * \def AO_CAP_MODE_A52
 * Driver supports A/52 output.
 * \sa xine_get_audio_capabilities()
 */
#define AO_CAP_MODE_A52         0x00000001
/**
 * \def AO_CAP_MODE_AC5
 * Driver supports AC5 output.
 * \sa xine_get_audio_capabilities()
 */
#define AO_CAP_MODE_AC5         0x00000002
/**
 * \def AO_CAP_MODE_MONO
 * Driver supports mono output.
 * 1 sample ==  2 bytes (C)
 * \sa xine_get_audio_capabilities()
 */
#define AO_CAP_MODE_MONO        0x00000004
/**
 * \def AO_CAP_MODE_STEREO
 * Driver supports stereo output.
 * 1 sample ==  4 bytes (L,R)
 * \sa xine_get_audio_capabilities()
 */
#define AO_CAP_MODE_STEREO      0x00000008
/**
 * \def AO_CAP_MODE_4CHANNEL
 * Driver supports 4 channels.
 * 1 sample ==  8 bytes (L,R,LR,RR)
 * \sa xine_get_audio_capabilities()
 */
#define AO_CAP_MODE_4CHANNEL    0x00000010
/**
 * \def AO_CAP_MODE_5CHANNEL
 * Driver supports 5 channels.
 * 1 sample == 10 bytes (L,R,LR,RR,C)
 * \sa xine_get_audio_capabilities()
 */
#define AO_CAP_MODE_5CHANNEL    0x00000020
/**
 * \def AO_CAP_MODE_5_1CHANNEL
 * Driver supports 5.1 channels.
 * 1 sample == 12 bytes (L,R,LR,RR,C,LFE)
 * \sa xine_get_audio_capabilities()
 */
#define AO_CAP_MODE_5_1CHANNEL  0x00000040
/**
 * \def AO_CAP_MIXER_VOL
 * Driver supports mixer control.
 * \sa xine_get_audio_capabilities()
 */
#define AO_CAP_MIXER_VOL        0x00000080
/**
 * \def AO_CAP_PCM_VOL
 * Driver supports pcm control.
 * \sa xine_get_audio_capabilities()
 */
#define AO_CAP_PCM_VOL          0x00000100
/**
 * \def AO_CAP_MUTE_VOL
 * Driver can mute volume.
 * \sa xine_get_audio_capabilities()
 */
#define AO_CAP_MUTE_VOL         0x00000200

/**
 * \fn int xine_get_audio_capabilities(xine_t *self)
 * \brief Get audio driver capabilities.
 * \param self Current xine engine configuration ( #see xine_init() )
 * \return Audio capabilities.
 *
 * Get audio driver capabilities, returned value can be AND/ORed with AO_CAP_* constant
 * to get relevant informations.
 */
int xine_get_audio_capabilities(xine_t *self);

               /** @} end of audio_cap */

               /**
		* 
		* \defgroup audio_prop Constants for the get/set properties functions.
		* @{
		*/
/**
 * \def AO_PROP_MIXER_VOL
 * Mixer volume property.
 * \sa xine_get_audio_property(), xine_set_audio_property()
 */
#define AO_PROP_MIXER_VOL       0
/**
 * \def AO_PROP_PCM_VOL
 * Pcm volume property.
 * \sa xine_get_audio_property(), xine_set_audio_property()
 */
#define AO_PROP_PCM_VOL         1
/**
 * \def AO_PROP_MUTE_VOL
 * Pcm volume property.
 * \sa xine_get_audio_property(), xine_set_audio_property()
 */
#define AO_PROP_MUTE_VOL        2

/**
 * \fn int xine_get_audio_property(xine_t *self, int property)
 * \brief Get audio driver property.
 * \param self Current xine engine configuration ( #see xine_init() )
 * \param property ( see AO_PROP_* )
 * \return value of property.
 *
 * Get audio property ( AO_PROP_* ) value .
 */
int xine_get_audio_property(xine_t *self, int property);
/**
 * \fn int xine_set_audio_property(xine_t *self, int property, int value)
 * \brief Set audio driver property value.
 * \param self Current xine engine configuration ( #see xine_init() )
 * \param property ( see AO_PROP_* )
 * \param value of property
 * \return value on success, otherwise ~value.
 *
 * Set audio property value ( AO_PROP_* ). It will return value if
 * operation is successfuly completed, and ~value on failure.
 */
int xine_set_audio_property(xine_t *self, int property, int value);

               /** @} end of audio_prop */

          /** @} end of audio_group */

         /**
	  * \defgroup browse_group Browsing support
	  * @{
	  */

/**
 * \fn char **xine_get_browsable_input_plugin_ids (xine_t *self)
 * \brief Request list of browsable featured plugins
 * \param self Current xine engine configuration ( #see xine_init() )
 * \return List of plugins
 *
 * Some input plugins are browseable, 
 * get the list of ids of these plugins.
 */
char **xine_get_browsable_input_plugin_ids (xine_t *self) ;

               /**
		* \defgroup mrl_types Types of available mrls
		* These types are bit field, can be used ORed/ANDed.
		* \sa mrl_t
		* @{
		*/

/**
 * \def mrl_unknown
 * Unknow mrl type.
 * \sa mrl_t
 */
#define mrl_unknown        (0 << 0)
/**
 * \def mrl_dvd
 * DVD mrl type.
 * \sa mrl_t
 */
#define mrl_dvd            (1 << 0)
/**
 * \def mrl_vcd
 * VCD mrl type.
 * \sa mrl_t
 */
#define mrl_vcd            (1 << 1)
/**
 * \def mrl_net
 * Network mrl type.
 * \sa mrl_t
 */
#define mrl_net            (1 << 2)
/**
 * \def mrl_rtp
 * Multicast mrl type.
 * \sa mrl_t
 */
#define mrl_rtp            (1 << 3)
/**
 * \def mrl_stdin
 * Standart input mrl type.
 * \sa mrl_t
 */
#define mrl_stdin          (1 << 4)
/**
 * \def mrl_cda
 * CD Audio mrl type.
 * \sa mrl_t
 */
#define mrl_cda            (1 << 5)
/**
 * \def mrl_file
 * File mrl type.
 * \sa mrl_t
 */
#define mrl_file           (1 << 6)
/**
 * \def mrl_file_fifo
 * Fifo file mrl type.
 * \sa mrl_t
 */
#define mrl_file_fifo      (1 << 7)
/**
 * \def mrl_file_chardev
 * Char device file mrl type.
 * \sa mrl_t
 */
#define mrl_file_chardev   (1 << 8)
/**
 * \def mrl_file_directory
 * Directory file mrl type.
 * \sa mrl_t
 */
#define mrl_file_directory (1 << 9)
/**
 * \def mrl_file_blockdev
 * Block device file mrl type.
 * \sa mrl_t
 */
#define mrl_file_blockdev  (1 << 10)
/**
 * \def mrl_file_normal
 * Normal file mrl type.
 * \sa mrl_t
 */
#define mrl_file_normal    (1 << 11)
/**
 * \def mrl_file_symlink
 * Soft link file mrl type.
 * \sa mrl_t
 */
#define mrl_file_symlink   (1 << 12)
/**
 * \def mrl_file_sock
 * Socket file mrl type.
 * \sa mrl_t
 */
#define mrl_file_sock      (1 << 13)
/**
 * \def mrl_file_exec
 * Executable file mrl type.
 * \sa mrl_t
 */
#define mrl_file_exec      (1 << 14)
/**
 * \def mrl_file_backup
 * Backup file mrl type.
 * \sa mrl_t
 */
#define mrl_file_backup    (1 << 15)
/**
 * \def mrl_file_hidden
 * Hidden file mrl type.
 * \sa mrl_t
 */
#define mrl_file_hidden    (1 << 16)

               /** @} end of mrl_types */

/**
 * \def MRL_ZERO(m)
 * Freeing/zeroing all of entries of given mrl.
 * \sa mrl_t, xine_get_browse_mrls()
 */
#define MRL_ZERO(m) {                                                         \
  if((m)) {                                                                   \
    if((m)->origin)                                                           \
      free((m)->origin);                                                      \
    if((m)->mrl)                                                              \
      free((m)->mrl);                                                         \
    if((m)->link)                                                             \
      free((m)->link);                                                        \
    (m)->origin = NULL;                                                       \
    (m)->mrl    = NULL;                                                       \
    (m)->link   = NULL;                                                       \
    (m)->type   = 0;                                                          \
    (m)->size   = (off_t) 0;                                                  \
  }                                                                           \
}

/**
 * \def MRL_DUPLICATE(s, d)
 * Duplicate two mrls entries (s = source, d = destination).
 * \sa mrl_t, xine_get_browse_mrls()
 */
#define MRL_DUPLICATE(s, d) {                                                 \
  assert((s) != NULL);                                                        \
  assert((d) != NULL);                                                        \
                                                                              \
  if((s)->origin) {                                                           \
    if((d)->origin) {                                                         \
      (d)->origin = (char *) realloc((d)->origin, strlen((s)->origin) + 1);   \
      sprintf((d)->origin, "%s", (s)->origin);                                \
    }                                                                         \
    else                                                                      \
      (d)->origin = strdup((s)->origin);                                      \
  }                                                                           \
  else                                                                        \
    (d)->origin = NULL;                                                       \
                                                                              \
  if((s)->mrl) {                                                              \
    if((d)->mrl) {                                                            \
      (d)->mrl = (char *) realloc((d)->mrl, strlen((s)->mrl) + 1);            \
      sprintf((d)->mrl, "%s", (s)->mrl);                                      \
    }                                                                         \
    else                                                                      \
      (d)->mrl = strdup((s)->mrl);                                            \
  }                                                                           \
  else                                                                        \
    (d)->mrl = NULL;                                                          \
                                                                              \
  if((s)->link) {                                                             \
    if((d)->link) {                                                           \
      (d)->link = (char *) realloc((d)->link, strlen((s)->link) + 1);         \
      sprintf((d)->link, "%s", (s)->link);                                    \
    }                                                                         \
    else                                                                      \
      (d)->link = strdup((s)->link);                                          \
  }                                                                           \
  else                                                                        \
    (d)->link = NULL;                                                         \
                                                                              \
  (d)->type = (s)->type;                                                      \
  (d)->size = (s)->size;                                                      \
}

/**
 * \def MRLS_DUPLICATE(s, d)
 * Duplicate two arrays of mrls (s = source, d = destination).
 * \sa mrl_t, xine_get_browse_mrls()
 */
#define MRLS_DUPLICATE(s, d) {                                                \
  int i = 0;                                                                  \
                                                                              \
  assert((s) != NULL);                                                        \
  assert((d) != NULL);                                                        \
                                                                              \
  while((s) != NULL) {                                                        \
    d[i] = (mrl_t *) malloc(sizeof(mrl_t));                                   \
    MRL_DUPLICATE(s[i], d[i]);                                                \
    i++;                                                                      \
  }                                                                           \
}

/**
 * \struct mrl_t
 * mrl type.
 * \sa xine_get_browse_mrls(), MRL_ZERO, MRL_DUPLICATE, MRLS_DUPLICATE, mrl_types
 */
typedef struct {
  /** Origin of grabbed mrls (eg: path for file plugin */
  char         *origin;
  /** <type>://<location> */
  char         *mrl;
  /** name of link, if exist, otherwise NULL */
  char         *link;
  /** match to mrl_type enum */
  uint32_t      type;
  /** size of this source, may be 0 */
  off_t         size;
} mrl_t;

/**
 * \fn mrl_t **xine_get_browse_mrls (xine_t *self, char *plugin_id, char *start_mrl, int *num_mrls)
 *  \brief Request available MRLs from plugins
 * \param self Current xine engine configuration ( #see xine_init() )
 * \param plugin_id Plugin name ( #see xine_get_browsable_input_plugin_ids() )
 * \param start_mrl MRL
 * \param num_mrl how many mrls was found
 * \return start_mrl on success, NULL on failure.
 *
 * Asks input plugin named <plugin_id> to return
 * a list of available MRLs in domain/directory <start_mrl>.
 * 
 * <start_mrl> may be NULL indicating the toplevel domain/dir
 * returns <start_mrl> if <start_mrl> is a valid MRL, not a directory
 * returns NULL if <start_mrl> is an invalid MRL, not even a directory.
 */
mrl_t **xine_get_browse_mrls (xine_t *self, char *plugin_id, char *start_mrl, int *num_mrls);

          /** @} end of browse_group */

          /**
	   * \defgroup autoplay_group Autoplay support
	   * @{
	   */
/**
 * \fn char **xine_get_autoplay_input_plugin_ids (xine_t *self)
 * \brief Request playlist from plugin
 * \param self Current xine engine configuration ( #see xine_init() )
 * \return Playlist.
 *
 * Some input plugins can generate autoplay lists
 * returns a list of ids of these plugins.
 */
char **xine_get_autoplay_input_plugin_ids (xine_t *self);

/**
 * \fn char *xine_get_input_plugin_description(xine_t *self, char *plugin_id)
 * \brief Request input plugin description
 * \param self Current xine engine configuration ( #see xine_init() )
 * \param plugin_id Plugin identifier.
 * \return Description string.
 *
 */
char *xine_get_input_plugin_description(xine_t *self, char *plugin_id);

/**
 * \fn char **xine_get_autoplay_mrls (xine_t *self, char *plugin_id, int *num_mrls)
 * \brief Request MRL list from plugin
 * \param self Current xine engine configuration ( #see xine_init() )
 * \param plugin_id Plugin name ( #see xine_get_autoplay_input_plugin_ids() )
 * \param num_mrls Entries in return array.
 * \return MRL list.
 *
 * Get autoplay MRL list for input plugin named <plugin_id>.
   */
char **xine_get_autoplay_mrls (xine_t *self, char *plugin_id, int *num_mrls);

          /** @} end of autoplay_group */

          /**
	   * \defgroup loadplugins_group Loading plugins
	   * output plugin load support functions
	   * @{
	   */

/**
 * \def XINE_PLUGINDIR
 * Plugin files location.
 * \ingroup loadplugins_group
 */
#define XINE_PLUGINDIR  "/usr/local/lib/xine/plugins"

                /**
		 * \defgroup visual_types Valid visual types
		 * @{
		 */

/**
 * \def VISUAL_TYPE_X11
 * X11 visual type.
 * \sa xine_list_video_output_plugins, xine_load_video_output_plugin
*/
#define VISUAL_TYPE_X11   1
/**
 * \def VISUAL_TYPE_AA
 * Asci Art visual type.
 * \sa xine_list_video_output_plugins, xine_load_video_output_plugin
 */
#define VISUAL_TYPE_AA    2
/**
 * \def VISUAL_TYPE_FB
 * Framebuffer visual type
 * \sa xine_list_video_output_plugins, xine_load_video_output_plugin
 */
#define VISUAL_TYPE_FB    3
/**
 * \def VISUAL_TYPE_GTK
 * GTK visual type
 * \sa xine_list_video_output_plugins, xine_load_video_output_plugin
 */
#define VISUAL_TYPE_GTK   4

               /** @} end of visual_types */

/**
 * \fn void xine_list_demux_plugins (config_values_t *config, char **identifiers, char **mimetypes)
 * \brief list available demux plugins
 * \param config current configuration ( #see config_file_init() )
 * \param identifiers pointer to a (char *) that will be allocated and filled with all demux identifiers 
 * \param mimetypes pointer to a (char *) that will be allocated and filled with all demux mimetypes 
 * \return none (strings are returned on *identifiers and *mimetypes). It is up to called to free these after use.
 */
void xine_list_demux_plugins (config_values_t *config,
                              char **identifiers, char **mimetypes);

/**
 * \fn char **xine_list_video_output_plugins (int visual_type)
 * \brief list available video output plugins
 * \param visual_type #see @ref visual_types
 * \return a list of available video output plugins for the specified visual type - the list is sorted by plugin priority
 * \sa visual_types
 */
char **xine_list_video_output_plugins (int visual_type);

/**
 * \fn vo_driver_t *xine_load_video_output_plugin(config_values_t *config, char *id, int visual_type, void *visual)
 * \param config current configuration ( #see config_file_init() )
 * \param id driver name.
 * \param visual_type #see @ref visual_types
 * \param visual visual type dependant data pointer.
 * \brief load a specific video output plugin
 * \sa vo_driver_t, visual_types
 */
vo_driver_t *xine_load_video_output_plugin(config_values_t *config,
					   char *id, int visual_type, void *visual);

/**
 * \fn char **xine_list_audio_output_plugins (void)
 * \brief generate a list of all available audio output plugins
 * \return a list of available audio output plugins  the list returned is sorted by plugin priority
 */
char **xine_list_audio_output_plugins (void);

/**
 * \fn ao_driver_t *xine_load_audio_output_plugin(config_values_t *config, char *id)
 * \param config current configuration ( #see config_file_init() )
 * \param id driver name.
 * \brief load a specific audio output plugin.
 * \sa ao_driver_t
 */
ao_driver_t *xine_load_audio_output_plugin(config_values_t *config, char *id);

          /** @} end of loadplugins_group */

          /**
	   * \defgroup event_group Sending events
	   * Event dispatcher mechanism
	   * @{
	   */


/**
 * Event listener callback.
 * \sa xine_register_event_listener, xine_remove_event_listener
 */
typedef void (*event_listener_t) (void *user_data, xine_event_t *event);

/**
 * \fn int xine_register_event_listener(xine_t *self, event_listener_t listener)
 * \param self Current xine engine configuration ( #see xine_init() )
 * \param listener callback function.
 * \param user_data - will be used as first parameter to callback
 * \brief registers an event listener callback.
 * \return 0 if the listener was registerd, non-zero if it could not.
 * \sa event_listener_t
 */
int xine_register_event_listener(xine_t *self, event_listener_t listener, void *user_data);

/**
 * \fn int xine_remove_event_listener(xine_t *self, event_listener_t listener)
 * \param self Current xine engine configuration ( #see xine_init() )
 * \param listener callback function.
 * \brief Attempts to remove a registered event listener.
 * \return 0 if the listener was removes, non-zero if it wasn't (e.g. not found).
 * \sa event_listener_t
 */
int xine_remove_event_listener(xine_t *self, event_listener_t listener);

/**
 * \fn void xine_send_event(xine_t *self, event_t *event)
 * \param self Current xine engine configuration ( #see xine_init() )
 * \param event event to send
 * \brief sends an event to all listeners.
 * \sa event_t
 */
void xine_send_event(xine_t *self, xine_event_t *event);

          /** @} end of event_group */

/**
 * \fn int xine_get_current_frame (xine_t *self, int *width, int *height, int *ratio_code, int *format, uint8_t **y, uint8_t **u, uint8_t **v)
 *
 * \param self Current xine engine configuration ( #see xine_init() )
 * \param width Width of image (be aware that u,v may be subsampled)
 * \param height Height of image (be aware that u,v may be subsampled)
 * \param ratio_code Aspect ratio of the frame
 * \param format Subsampling format YUV 4:2:0 or 4:2:2
 * \param y Lumiance information
 * \param u Subsample color information
 * \param v Subsample color information
 * \brief Snapshot function.
 * \return 1 on success, 0 failure.
 *
 *
 */
int xine_get_current_frame (xine_t *self, int *width, int *height,
			    int *ratio_code, int *format,
			    uint8_t **y, uint8_t **u,
			    uint8_t **v);



/**
 * \def XINE_IMGFMT_YV12
 * image format.
 * \sa xine_get_current_frame
*/
#define XINE_IMGFMT_YV12 0x32315659
/**
 * \def XINE_IMGFMT_YUY2
 * image format.
 * \sa xine_get_current_frame
*/
#define XINE_IMGFMT_YUY2 (('2'<<24)|('Y'<<16)|('U'<<8)|'Y')

/**
 * \def XINE_ASPECT_RATIO_SQUARE
 * aspect ratio.
 * \sa xine_get_current_frame
*/
#define XINE_ASPECT_RATIO_SQUARE      1
/**
 * \def XINE_ASPECT_RATIO_4_3
 * aspect ratio.
 * \sa xine_get_current_frame
*/
#define XINE_ASPECT_RATIO_4_3         2
/**
 * \def XINE_ASPECT_RATIO_ANAMORPHIC
 * aspect ratio.
 * \sa xine_get_current_frame
*/
#define XINE_ASPECT_RATIO_ANAMORPHIC  3
/**
 * \def XINE_ASPECT_RATIO_211_1
 * aspect ratio.
 * \sa xine_get_current_frame
*/
#define XINE_ASPECT_RATIO_211_1       4
/**
 * \def XINE_ASPECT_RATIO_DONT_TOUCH
 * aspect ratio.
 * \sa xine_get_current_frame
*/
#define XINE_ASPECT_RATIO_DONT_TOUCH 42


          /**
	   * \defgroup osd_group OSD section
	   * @{
	   */

               /**
	        * \defgroup osd_textgroup OSD text attributes
                * @{
                */

/**
 * \def TEXT_PALETTE_SIZE
 * The size of an OSD text palette 
 */
#define TEXT_PALETTE_SIZE 11

/** Preassigned color index for text palettes and rendering text */
#define OSD_TEXT1 (0 * TEXT_PALETTE_SIZE)

/** Preassigned color index for text palettes and rendering text */
#define OSD_TEXT2 (1 * TEXT_PALETTE_SIZE)

/** Preassigned color index for text palettes and rendering text */
#define OSD_TEXT3 (2 * TEXT_PALETTE_SIZE)

/** Preassigned color index for text palettes and rendering text */
#define OSD_TEXT4 (3 * TEXT_PALETTE_SIZE)

/** Preassigned color index for text palettes and rendering text */
#define OSD_TEXT5 (4 * TEXT_PALETTE_SIZE)

/** Preassigned color index for text palettes and rendering text */
#define OSD_TEXT6 (5 * TEXT_PALETTE_SIZE)

/** Preassigned color index for text palettes and rendering text */
#define OSD_TEXT7 (6 * TEXT_PALETTE_SIZE)

/** Preassigned color index for text palettes and rendering text */
#define OSD_TEXT8 (7 * TEXT_PALETTE_SIZE)

/** Preassigned color index for text palettes and rendering text */
#define OSD_TEXT9 (8 * TEXT_PALETTE_SIZE)

/** Preassigned color index for text palettes and rendering text */
#define OSD_TEXT10 (9 * TEXT_PALETTE_SIZE)

/**
 * \def TEXTPALETTE_WHITE_BLACK_TRANSPARENT 
 * White text, black border, transparent background
 */
#define TEXTPALETTE_WHITE_BLACK_TRANSPARENT    0

/**
 * \def TEXTPALETTE_WHITE_NONE_TRANSPARENT 
 * White text, noborder, transparent background
 */
#define TEXTPALETTE_WHITE_NONE_TRANSPARENT     1

/**
 * \def TEXTPALETTE_WHITE_NONE_TRANSLUCID 
 * White text, no border, translucid background
 */
#define TEXTPALETTE_WHITE_NONE_TRANSLUCID      2

/**
 * \def TEXTPALETTE_YELLOW_BLACK_TRANSPARENT 
 * Yellow text, black border, transparent background
 */
#define TEXTPALETTE_YELLOW_BLACK_TRANSPARENT   3

               /** @} end of osd_textgroup */


typedef struct osd_object_s osd_object_t;
typedef struct osd_renderer_s osd_renderer_t;
typedef struct osd_font_s osd_font_t;

struct osd_renderer_s {

  /*
   * open a new osd object. this will allocated an empty (all zero) drawing
   * area where graphic primitives may be used.
   * It is ok to specify big width and height values. The render will keep
   * track of the smallest changed area to not generate too big overlays.
   * A default palette is initialized (i sugest keeping color 0 as transparent
   * for the sake of simplicity)
   */
  osd_object_t* (*new_object) (osd_renderer_t *self, int width, int height);

  /*
   * free osd object
   */
  void (*free_object) (osd_object_t *osd_to_close);


  /*
   * send the osd to be displayed at given pts (0=now)
   * the object is not changed. there may be subsequent drawing  on it.
   */
  int (*show) (osd_object_t *osd, uint32_t vpts );

  /*
   * send event to hide osd at given pts (0=now)
   * the object is not changed. there may be subsequent drawing  on it.
   */
  int (*hide) (osd_object_t *osd, uint32_t vpts );

  /*
   * Bresenham line implementation on osd object
   */
  void (*line) (osd_object_t *osd,
		int x1, int y1, int x2, int y2, int color );
  
  /*
   * filled retangle
   */
  void (*filled_rect) (osd_object_t *osd,
		       int x1, int y1, int x2, int y2, int color );

  /*
   * set palette (color and transparency)
   */
  void (*set_palette) (osd_object_t *osd, uint32_t *color, uint8_t *trans );

  /*
   * set on existing text palette
   * (-1 to set used specified palette)
   *
   * color_base specifies the first color index to use for this text
   * palette. The OSD palette is then modified starting at this
   * color index, up to the size of the text palette.
   *
   * Use OSD_TEXT1, OSD_TEXT2, ... for some preasssigned color indices.
   */
  void (*set_text_palette) (osd_object_t *osd, int palette_number,
			    int color_base );

  /*
   * get palette (color and transparency)
   */
  void (*get_palette) (osd_object_t *osd, uint32_t *color, 
		       uint8_t *trans);

  /*
   * set position were overlay will be blended
   */
  void (*set_position) (osd_object_t *osd, int x, int y);

  /*
   * set the font of osd object
   */

  int (*set_font) (osd_object_t *osd, char *fontname, int size);


  /*
   * render text on x,y position (8 bits version)
   * no \n yet
   *
   * The text is assigned the colors starting at the index specified by
   * color_base up to the size of the text palette. 
   *
   * Use OSD_TEXT1, OSD_TEXT2, ... for some preasssigned color indices
   */
  int (*render_text) (osd_object_t *osd, int x1, int y1, 
		      char *text, int color_base);

  /*
   * get width and height of how text will be renderized
   */
  int (*get_text_size) (osd_object_t *osd, char *text, 
			int *width, int *height);

  /* 
   * close osd rendering engine
   * loaded fonts are unloaded
   * osd objects are closed
   */
  void (*close) (osd_renderer_t *self);
  
  /*
   * clear an osd object
   */
  void (*clear) (osd_object_t *osd );
  
};

osd_renderer_t *xine_get_osd_renderer (xine_t *self);

          /** @} end of osd_group */


          /**
	   * \defgroup log_group Logging section
	   * @{
	   */
             /**
	      * \defgroup log_def log defines.
	      * @{
	      */
/**
 * \def XINE_LOG_MSG
 * \sa xine_log()
*/
#define XINE_LOG_MSG       0
/**
 * \def XINE_LOG_INPUT
 * \sa xine_log()
*/
#define XINE_LOG_INPUT     1
/**
 * \def XINE_LOG_DEMUX
 * \sa xine_log()
*/
#define XINE_LOG_DEMUX     2
/**
 * \def XINE_LOG_CODEC
 * \sa xine_log()
*/
#define XINE_LOG_CODEC     3
/**
 * \def XINE_LOG_VIDEO
 * \sa xine_log()
*/
#define XINE_LOG_VIDEO     4
/**
 * \def XINE_LOG_METRONOM
 * \sa xine_log()
*/
#define XINE_LOG_METRONOM  5
/**
 * \def XINE_LOG_PLUGIN
 * \sa xine_log()
*/
#define XINE_LOG_PLUGIN    6
/**
 * \def XINE_LOG_NUM
 * number of log buffers defined *
 * \sa xine_log()
*/
#define XINE_LOG_NUM       7

            /** @} end of log_def */
/**
 * \fn unsigned int xine_get_log_section_count(void)
 * \brief return number of available buffers.
 * \sa xine_get_log_names(), xine_log(), xine_get_log()
 */
unsigned int xine_get_log_section_count(void);
/**
 * \fn const char **xine_get_log_names(void)
 * \brief return a NULL terminated array of log sections names.
 * \sa xine_get_log_section_count(), xine_log(), xine_get_log()
 */
const char **xine_get_log_names(void);
/**
 * \fn void xine_log (xine_t *self, int buf, const char *format, ...)
 * \param self xine object.
 * \param buf buffer section (#see @ref log_def)
 * \brief write message to buffer 'buf'.
 *
 */
void xine_log (xine_t *self, int buf, const char *format, ...);
/**
 * \fn char **xine_get_log (xine_t *self, int buf)
 * \param self xine object.
 * \param buf buffer section (#see @ref log_def)
 * \return an array of char, NULL terminated.
 * \brief return a message array from buffer 'buf' (#see @ref log_def)
 *
 */
char **xine_get_log (xine_t *self, int buf);

          /** @} end of log_group */


          /**
	   * \defgroup error_group Error reporting.
	   * @{
	   */
             /**
	      * \defgroup error_def error defines.
	      * @{
	      */
/**
 * \def XINE_ERROR_NONE
 * No error reported.
 * \sa xine_get_error()
*/
#define XINE_ERROR_NONE              0
/**
 * \def XINE_ERROR_NO_INPUT_PLUGIN
 * No input plugin found to handle a stream type.
 * \sa xine_get_error()
*/
#define XINE_ERROR_NO_INPUT_PLUGIN   1
/**
 * \def XINE_ERROR_NO_DEMUXER_PLUGIN
 * No demuxer plugin found to handle a stream type.
 * \sa xine_get_error()
*/
#define XINE_ERROR_NO_DEMUXER_PLUGIN 2

             /** @} end of error_def */

/**
 * \fn int xine_get_error (xine_t *self)
 * \param self xine object.
 * \return return last error (#see @ref error_def)
 * \brief return the last error.
 *
 */
int xine_get_error (xine_t *self);

          /** @} end of error_group */


          /**
	   * \defgroup locale_group localisation.
	   * @{
	   */
/**
 * \fn char *xine_set_locale(void)
 * \return current locale.
 * \brief prepare and setup localization for xine-lib usage.
 * This function should be called BEFORE xine_init() ( #see xine_init() )
 *
 */
char *xine_set_locale(void);

          /** @} end of locale_group */

     /** @} end of xine_api */

#ifdef __cplusplus
}
#endif

#endif
