#define INCL_DOS
#define INCL_DOSPROFILE
#define INCL_GPI
#define INCL_WIN
#define INCL_OS2MM

#include <os2.h>
#include <os2me.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <time.h>
#include <math.h>
#include <limits.h>

#include <mmioos2.h>
#include <dive.h>
#include <fourcc.h>

#include "def.h"

#include "avifmt.h"

#include "codec-cfg.h"

#include "video_out.h"
#include "audio_out.h"

#include "avcodec.h"

ReSampleContext *aud_resample;
int aud_resample_flg;
extern int MP3_channels;

#include "libavcodec\inttypes.h"
#include <rgb2rgb.h>

#ifdef __cplusplus
extern "C" {
#endif

int verbose=0;
int quiet=0;

HMTX demux_mtx = NULLHANDLE;
HMTX pause_mtx = NULLHANDLE;
HMTX rewind_mtx = NULLHANDLE;

#ifdef __cplusplus
}
#endif

#define INITED_VO 1
#define INITED_AO 2

// dive

#include "libDIVE.h"
#include "libDIVEpm.h"
#include "wvision.h"

static volatile bool Shutdown = false;
bool FullScreen = false;
bool Pause = false;
int  RewindFlg = 0;

int MCIFormat;

// Command line options
int AudioResampleFlag = 0;

diveWindow *dW;

FOURCC fccColorFormat;
int ScreenBpp;
CHAR pszTitleText[128];
CHAR szTitle[128];

#include "devaudio.h"

static void MouseHandlerStub (void *Self, int Button, bool Down,
  int x, int y, int ShiftFlags)
{
//  Printf ("誠 -- (%d) H(%d) x(%d) y(%d) ShiftFlags(%04X)\n",
//    Button, Down, x, y, ShiftFlags);
}

void FocusHandlerStub (void *Self, bool Enable)
{
//  Printf (" -- %d\n", Enable);
}

void TerminateHandlerStub (void *Self)
{
//  Printf (" p \n");
  Shutdown = true;
}

//**************************************************************************//
//**************************************************************************//
//             Input media streaming & demultiplexer:
//**************************************************************************//

static int max_framesize=0;

#include "stream.h"
#include "demuxer.h"

#include "stheader.h"

char* encode_name=NULL;
char* encode_index_name=NULL;
int encode_bitrate=0;

//**************************************************************************//
//**************************************************************************//
static vo_functions_t *video_out=NULL;
static ao_functions_t *audio_out=NULL;

static float c_total=0;

#ifdef __cplusplus
extern "C" {
#endif

double video_time_usage=0;
double vout_time_usage=0;

#ifdef __cplusplus
}
#endif

static double audio_time_usage=0;
static int total_time_usage_start=0;
static int benchmark=0;

static int play_in_bg=0;

extern void avi_fixate();

// options:

int divx_quality=0;
static int auto_quality=0;
static int output_quality=0;

int use_gui=0;

int osd_level=2;
char *seek_to_sec=NULL;
off_t seek_to_byte=0;
int has_audio=1;

char *audio_codec=NULL; // override audio codec
char *video_codec=NULL; // override video codec
int audio_family=-1;     // override audio codec family 
int video_family=-1;     // override video codec family 

// streaming:
static int audio_id=-1;
static int video_id=-1;
static int dvdsub_id=-1;
static int vcd_track=0;
static char *stream_dump_name=NULL;
static int stream_dump_type=0;

extern int dvd_title;

static float default_max_pts_correction=-1;//0.01f;
static float max_pts_correction=0;//default_max_pts_correction;

#ifdef __cplusplus
extern "C" {
#endif

int index_mode=-1;  // -1=untouched  0=don't use index  1=use (geneate) index
int force_ni=0;

#ifdef AVI_SYNC_BPS
int pts_from_bps=1;
#else
int pts_from_bps=0;
#endif

#ifdef __cplusplus
}
#endif

float force_fps=0;
int force_srate=0;
float audio_delay=0;
int frame_dropping=0; // option  0=no drop  1= drop vo  2= drop decode
int play_n_frames=-1;

// screen info:
char* video_driver=NULL; //"mga"; // default
char* audio_driver=NULL;
static int fullscreen=0;
static int vidmode=0;
static int softzoom=0;
static int flip=-1;
static int screen_size_x=0;//SCREEN_SIZE_X;
static int screen_size_y=0;//SCREEN_SIZE_Y;
static int screen_size_xy=0;
static float movie_aspect=0.0;

// sub:
char *font_name=NULL;
float font_factor=0.75;
char *sub_name=NULL;
float sub_delay=0;
float sub_fps=0;
int   sub_auto = 1;
/*DSP!!char *dsp=NULL;*/

//float initial_pts_delay=0;

int drop_frame=0;
int drop_frame_cnt=0;
float AV_delay=0; // average of A-V timestamp differences

float rel_seek_secs=0;
int abs_seek_pos=0;

float mci_pts=0;

extern char *vo_subdevice;
extern char *ao_subdevice;

static char* current_module=NULL; // for debugging

static unsigned int inited_flags=0;

extern "C" stream_t* open_stream(char* filename,int vcd_track,int* file_format);

extern "C" void write_avi_header_1(FILE *f,int fcc,float fps,int width,int height);

// dec_audio.c:
extern "C" int init_audio(sh_audio_t *sh_audio);
extern "C" int decode_audio(sh_audio_t *sh_audio,unsigned char *buf,int minlen,int maxlen);
extern "C" void resync_audio_stream(sh_audio_t *sh_audio);
extern "C" void skip_audio_frame(sh_audio_t *sh_audio);

// dec_video.c:
extern "C" int video_read_properties(sh_video_t *sh_video);
extern "C" int init_video(sh_video_t *sh_video);
extern "C" int decode_video(unsigned char *,sh_video_t *sh_video,unsigned char *start,int in_size,int drop_frame);

    static demuxer_t *demuxer=NULL;

    static demux_stream_t *d_audio=NULL;
    static demux_stream_t *d_video=NULL;
    static demux_stream_t *d_dvdsub=NULL;

    static sh_audio_t *sh_audio=NULL;
    static sh_video_t *sh_video=NULL;

    // for multifile support:
    char **filenames=NULL;
    int num_filenames=0;
    int curr_filename=0;

    char* filename=NULL;
    stream_t* stream=NULL;
    int file_format=DEMUXER_TYPE_UNKNOWN;

    //
    int delay_corrected=1;

    // movie info:
    int out_fmt=0;

    int v_bright=50;
    int v_cont=50;
    int v_hue=50;
    int v_saturation=50;

    int i;
    int use_stdin=0;


void KeyboardHandlerStub (void *Self, unsigned char ScanCode,
  unsigned char CharCode, bool Down, unsigned char RepeatCount, int ShiftFlags)
{
//  printf (" -- (%d) (%c) H(%d) -(%d) ShiftFlags(%04X)\n",
//    ScanCode, CharCode, Down, RepeatCount, ShiftFlags);

  if (ScanCode == 1) // Esc
    Shutdown = true;

  if (ScanCode == 99 && Down == 1) // Left
    RewindFlg = REWIND_BACKWARD_15S;

  if (ScanCode == 100 && Down == 1) // Right
    RewindFlg = REWIND_FORWARD_15S;

  if (ScanCode == 97 && Down == 1) // Up
    RewindFlg = REWIND_FORWARD_60S;

  if (ScanCode == 102 && Down == 1) // Down
    RewindFlg = REWIND_BACKWARD_60S;

  if (ScanCode == 98 && Down == 1) // PageUp
    RewindFlg = REWIND_FORWARD_600S;

  if (ScanCode == 103 && Down == 1) // PageDown
    RewindFlg = REWIND_BACKWARD_600S;

  if (ScanCode == 33 && Down == 1)
  {
    if (FullScreen == true)
    {
        FullScreen = false;
        dW->MouseVisible(TRUE);
    }
    else
    {
        FullScreen = true;
        dW->MouseVisible(FALSE);
    }

    dW->Command(cmdFullScreen);
  }

  if (ScanCode == 25 && Down == 1)
  {
    if (Pause == true)
    {
      Pause = false;
      dW->Command(cmdPause);
      DosReleaseMutexSem(pause_mtx);
    }
    else
    {
      Pause = true;
      dW->Command(cmdPause);
      DosRequestMutexSem(pause_mtx, (ULONG)SEM_INDEFINITE_WAIT);
    }
  }

}

void TimestampCorrection(int DartBufferSize)
{
  if(sh_audio){
    float a_pts=0;
    float v_pts=0;

    // unplayed bytes in our and soundcard/dma buffer:
    int delay_bytes=DartBufferSize + sh_audio->a_buffer_len;
    float delay=(float)delay_bytes/(float)sh_audio->o_bps;

      if(sh_audio->audio.dwSampleSize)
        a_pts=(ds_tell(d_audio)-sh_audio->a_in_buffer_len)/(float)sh_audio->wf->nAvgBytesPerSec;
      else  // VBR:
        a_pts=d_audio->pack_no*(float)sh_audio->audio.dwScale/(float)sh_audio->audio.dwRate;

      delay_corrected=1;
/*
    } else {
      // PTS = (last timestamp) + (bytes after last timestamp)/(bytes per sec)
      a_pts=d_audio->pts;
      if(!delay_corrected) if(a_pts) delay_corrected=1;
      a_pts+=(ds_tell_pts(d_audio)-sh_audio->a_in_buffer_len)/(float)sh_audio->i_bps;
    }
*/
    v_pts=d_video->pts;

      if(delay_corrected){
        float x;
        AV_delay=(a_pts-delay-audio_delay)-v_pts;
        x=AV_delay*0.1f;
        if(x<-max_pts_correction) x=-max_pts_correction; else
        if(x> max_pts_correction) x= max_pts_correction;
        if(default_max_pts_correction>=0)
          max_pts_correction=default_max_pts_correction;
        else
          max_pts_correction=sh_video->frametime*0.10; // +-10% of time

        sh_audio->timer+=x;

        c_total = AV_delay/sh_video->fps;

        if(!quiet) fprintf(stdout, "A:%6.1f V:%6.1f A-V:%7.3f (%7.3f)        \r",
	  a_pts-audio_delay-delay,
          v_pts,
          AV_delay,
          c_total);
/*
        sprintf(szTitle, "A-V: %7.3f", AV_delay);
        dW->SetTitle(szTitle);
*/
        fflush(stdout);
      }
    
  } else {
    // No audio:
    
      fprintf(stdout, "V:%6.1f  %3d  %2d%%  %2d%%  %3.1f%% \r",d_video->pts,
        (int)sh_video->num_frames,
        (sh_video->timer>0.5)?(int)(100.0*video_time_usage/(double)sh_video->timer):0,
        (sh_video->timer>0.5)?(int)(100.0*vout_time_usage/(double)sh_video->timer):0,
        (sh_video->timer>0.5)?(100.0*audio_time_usage/(double)sh_video->timer):0
        );
      fflush(stdout);
  }

    return;
}

size_t dartCallback (void *Buffer, size_t BufferSize)
{
    int rc, hr, bsize, usize, len;
    int isamp, osamp;
    DWORD srcsize = 0;
    unsigned char *tmp_buffer;

    DosRequestMutexSem(rewind_mtx, (ULONG)SEM_INDEFINITE_WAIT);

    TimestampCorrection(BufferSize);

    bsize = BufferSize;
    usize = 0;

    tmp_buffer = (unsigned char *)malloc(BufferSize);

    if (sh_audio->a_buffer_len > 0)
    {
        memmove((BYTE *)Buffer+usize, sh_audio->a_buffer, sh_audio->a_buffer_len);
        bsize -= sh_audio->a_buffer_len;
        usize += sh_audio->a_buffer_len;
        sh_audio->a_buffer_len = 0;
    }

    while(bsize > 0)
    {
      if(srcsize>sh_audio->a_in_buffer_size) srcsize=sh_audio->a_in_buffer_size; // !!!!!!

      len = decode_audio(sh_audio, (unsigned char *)sh_audio->a_buffer, 128, 128);

      if (len < 0)
      {
          Shutdown = 1;
          goto Exit;
      }

      if (aud_resample_flg == TRUE)
      {
          isamp = len/(MP3_channels*2);
          osamp = audio_resample(aud_resample, (short *)tmp_buffer, (short *)sh_audio->a_buffer, isamp);
          osamp *= (MP3_channels*2);
      }
      else
      {
          memcpy(tmp_buffer, sh_audio->a_buffer, len);
          osamp = len;
      }

      if(osamp == 0)
      {
          free(tmp_buffer);
          return 0;
      }

      if (osamp <= bsize)
      {
          memcpy((BYTE *)Buffer+usize, tmp_buffer, osamp);
          bsize -= osamp;
          usize += osamp;
          sh_audio->a_buffer_len = 0;
      } else {
          memcpy((BYTE *)Buffer+usize, tmp_buffer, bsize);
          sh_audio->a_buffer_len = osamp - bsize;
          memmove(sh_audio->a_buffer, tmp_buffer+bsize, sh_audio->a_buffer_len);
          bsize = 0;
      }

    }

Exit:

    free(tmp_buffer);

    DosReleaseMutexSem(rewind_mtx);

    if (Shutdown) BufferSize = 0;

/*
    {
      static FILE *out = NULL;

      if (out == NULL)
        out = fopen("pcm_out.wav", "wb");

      fwrite(Buffer, 1, BufferSize, out);
    }
*/

    return BufferSize;
}

#define Q2LL(a) ((ULONG)a.ulHi<<32)|((ULONG)a.ulLo)

VOID APIENTRY PlayVideo(ULONG parm1)
{
    ULONG Timer1, TmrFrq;
    QWORD Qres;
    unsigned long long StartDec, EndDec, StartShow, EndShow, W;
    unsigned long long TotalFrames;
    float TotalTime;
    ULONG numcadr, numwait;
    int ret;

    unsigned char *Memory;
    ULONG bpl;
    int in_size;
    unsigned char *start=NULL;

    int got_picture=0;

    int end_video=0;

    TotalFrames = 0;
    TotalTime = 0;

    int cnt = 0;
    int cnt1 = 0;

    int SkipFrame = 0;

    unsigned char* planes_[3];
    unsigned char** planes=planes_;

    int stride_[3];
    int* stride=stride_;

    int delay = 0;

    int rc, cc;

//=========

    DosTmrQueryFreq(&TmrFrq);
    DosTmrQueryTime(&Qres);
    StartDec = StartShow = Q2LL(Qres);
    Timer1 = 0;

    // Play video
    while (!Shutdown)
    {
        DosTmrQueryTime(&Qres);
        EndDec = Q2LL(Qres);

        Timer1 += (EndDec - StartDec)*sh_video->fps+(TmrFrq*c_total);

        if (c_total > 0.010)
            SkipFrame = 1;


        StartDec = EndDec;

        numcadr = Timer1/TmrFrq;

        if (numcadr > 0)
        {
            Timer1 %= TmrFrq;

            Memory = (unsigned char *)dW->BeginPaint (&bpl, DIVE_NEXTBUFFER);

            // ᫨ 㧠  
            if (Memory)
            {
                if (RewindFlg != 0)
                {
                    DosRequestMutexSem(rewind_mtx, (ULONG)SEM_INDEFINITE_WAIT);

                    switch(RewindFlg)
                    {
                        case REWIND_FORWARD_15S:
                          demux_seek(demuxer,15,0);
                        break;

                        case REWIND_BACKWARD_15S:
                          demux_seek(demuxer,-15,0);
                        break;

                        case REWIND_FORWARD_60S:
                          demux_seek(demuxer,60,0);
                        break;

                        case REWIND_BACKWARD_60S:
                          demux_seek(demuxer,-60,0);
                        break;

                        case REWIND_FORWARD_600S:
                          demux_seek(demuxer,600,0);
                        break;

                        case REWIND_BACKWARD_600S:
                          demux_seek(demuxer,-600,0);
                        break;
                    }

                    DosReleaseMutexSem(rewind_mtx);

                    RewindFlg = 0;
                }

                in_size=ds_get_packet(d_video,&start);

                if(in_size < 0)
                {
                    end_video = 1;
                    break; 
                }
   
                sh_video->bih->biSizeImage = in_size;

                decode_video(Memory, sh_video, start, in_size, SkipFrame);

                // 稫 pᮢ
                dW->EndPaint ();

                if (SkipFrame == 0) {

                    // p稬 p
                    dW->Switch (DIVE_NEXTBUFFER);
                    //  砭 p
                    dW->WaitSwitch ();
                }
                else
                    SkipFrame = 0;
            }

            DosSleep(1);
        }
        else
        {
            DosSleep(1);
        }

        if (end_video == 1)
            break;
    }

    return;
}

int InitPlayer(char *MovieName)
{
    stream=NULL;
    demuxer=NULL;
    d_audio=NULL;
    d_video=NULL;
    sh_audio=NULL;
    sh_video=NULL;

    stream = open_stream(MovieName, 0, &file_format);
    if (!stream) exit(1);

//============ Open & Sync stream and detect file format ===============
    if(!has_audio) audio_id=-2; // do NOT read audio packets...

    current_module="demux_open";

    demuxer=demux_open(stream,file_format,audio_id,video_id,dvdsub_id);
    if(!demuxer) exit(1);

    d_audio=demuxer->audio;
    d_video=demuxer->video;
    d_dvdsub=demuxer->sub;

// DUMP STREAMS:
    if(stream_dump_type){
      FILE *f;
      demux_stream_t *ds=NULL;
      current_module="dump";
      // select stream to dump
      switch(stream_dump_type){
      case 1: ds=d_audio;break;
      case 2: ds=d_video;break;
      case 3: ds=d_dvdsub;break;
      }
      if(!ds){        
//          mp_msg(MSGT_CPLAYER,MSGL_FATAL,MSGTR_DumpSelectedSteramMissing);
//          exit_player(MSGTR_Exit_error);
          exit(1);
      }
      // disable other streams:
      if(d_audio && d_audio!=ds) {ds_free_packs(d_audio); d_audio->id=-2; }
      if(d_video && d_video!=ds) {ds_free_packs(d_video); d_video->id=-2; }
      if(d_dvdsub && d_dvdsub!=ds) {ds_free_packs(d_dvdsub); d_dvdsub->id=-2; }
      // let's dump it!
      f=fopen(stream_dump_name?stream_dump_name:"stream.dump","wb");
      if(!f){
//        mp_msg(MSGT_CPLAYER,MSGL_FATAL,MSGTR_CantOpenDumpfile);
//        exit_player(MSGTR_Exit_error);
          exit(1);
      }
      while(!ds->eof){
        unsigned char* start;
        int in_size=ds_get_packet(ds,&start);
        if( (demuxer->file_format==DEMUXER_TYPE_AVI || demuxer->file_format==DEMUXER_TYPE_ASF || demuxer->file_format==DEMUXER_TYPE_MOV)
            && stream_dump_type==2) fwrite(&in_size,1,4,f);
        if(in_size>0) fwrite(start,in_size,1,f);
      }
      fclose(f);
//      mp_msg(MSGT_CPLAYER,MSGL_INFO,MSGTR_CoreDumped);
//      exit_player(MSGTR_Exit_eof);
      exit(1);
    }

    sh_audio=(sh_audio_t *)d_audio->sh;
    sh_video=(sh_video_t *)d_video->sh;

    current_module="video_read_properties";

    if(sh_video){

      if(!video_read_properties(sh_video)) exit(1);

      printf("Video: filefmt:%d fourcc:0x%X size:%dx%d fps:%5.2f ftime:=%6.4f\n",
       demuxer->file_format,sh_video->format, sh_video->disp_w,sh_video->disp_h,
       sh_video->fps,sh_video->frametime
      );

      if(!sh_video->fps && !force_fps){
//        mp_msg(MSGT_CPLAYER,MSGL_FATAL,MSGTR_FPSnotspecified);
        exit(1);
      }

    }

    if(!sh_video){
//        mp_msg(MSGT_CPLAYER,MSGL_FATAL,MSGTR_NoVideoStream);
        exit(1);
    }

//================== Init AUDIO (codec) ==========================

    current_module="init_audio_codec";

    if(sh_audio){
      // Go through the codec.conf and find the best codec...
      sh_audio->codec=NULL;
      if(audio_family!=-1) printf("Trying to force audio codec driver family %d ...\n",audio_family);
      while(1){
        sh_audio->codec=find_audio_codec(sh_audio->format,NULL,sh_audio->codec);
        if(!sh_audio->codec){
          if(audio_family!=-1) {
            sh_audio->codec=NULL; /* re-search */
            printf("Can't find audio codec\n");
            audio_family=-1;
            continue;      
          }
          printf("Can't find codec for audio format 0x%X !\n",sh_audio->format);
//          printf(MSGT_CPLAYER,MSGL_HINT, MSGTR_TryUpgradeCodecsConfOrRTFM,get_path("codecs.conf"));
          sh_audio=NULL;
          d_audio->sh=NULL;
          break;
        }
        if(audio_codec && strcmp(sh_audio->codec->name,audio_codec)) continue;
        else if(audio_family!=-1 && sh_audio->codec->driver!=audio_family) continue;
        printf("%s audio codec: [%s] drv:%d (%s)\n",audio_codec?"Forcing":"Detected",sh_audio->codec->name,sh_audio->codec->driver,sh_audio->codec->info);
        break;
      }
    }

    if(sh_audio){
      printf("Initializing audio codec...\n");
      if(!init_audio(sh_audio)){
        printf("Couldn't initialize audio codec! -> nosound\n");
        sh_audio=NULL;
        d_audio->sh=NULL;
      } else {
        printf("Audio: sample rate=%d channels=%d bps=%d sfmt=0x%X ratio: %d->%d\n",
            sh_audio->samplerate,sh_audio->channels,sh_audio->samplesize,
            sh_audio->sample_format,sh_audio->i_bps,sh_audio->o_bps);
      }
    }

//================== Init VIDEO (codec & libvo) ==========================

    current_module="init_video_codec";

    // Go through the codec.conf and find the best codec...
    sh_video->codec=NULL;
    if(video_family!=-1) printf("Trying to force video codec driver family %d ...\n",video_family);
    while(1){
      sh_video->codec=find_video_codec(sh_video->format,
        sh_video->bih?((unsigned int*) &sh_video->bih->biCompression):NULL,sh_video->codec);
      if(!sh_video->codec){
        if(video_family!=-1) {
          sh_video->codec=NULL; /* re-search */
          printf("Can't find video codec for forced driver family, fallback to other drivers.\n");
          video_family=-1;
          continue;      
        }
        printf("Can't find codec for video format 0x%X !\n",sh_video->format);
//        printf(MSGT_CPLAYER,MSGL_HINT, MSGTR_TryUpgradeCodecsConfOrRTFM,get_path("codecs.conf"));
        exit(1);
      }
      // is next line needed anymore? - atmos ::
//      if(!allow_dshow && sh_video->codec->driver==VFM_DSHOW) continue; // skip DShow
      else if(video_codec && strcmp(sh_video->codec->name,video_codec)) continue;
      else if(video_family!=-1 && sh_video->codec->driver!=video_family) continue;
      break;
    }

    printf("%s video codec: [%s] drv:%d (%s)\n",video_codec?"Forcing":"Detected",sh_video->codec->name,sh_video->codec->driver,sh_video->codec->info);

//    for(i=0;i<CODECS_MAX_OUTFMT;i++){
//        int ret;
//        out_fmt=sh_video->codec->outfmt[i];
//        if(out_fmt==0xFFFFFFFF) continue;
//        ret=video_out->query_format(out_fmt);
//        mp_msg(MSGT_CPLAYER,MSGL_DBG2,"vo_debug: query(%s) returned 0x%X\n",vo_format_name(out_fmt),ret);
//        if(ret) break;
//    }
//    if(i>=CODECS_MAX_OUTFMT){
//        mp_msg(MSGT_CPLAYER,MSGL_FATAL,MSGTR_VOincompCodec);
//        goto goto_next_file; // exit_player(MSGTR_Exit_error);
//    }
//    sh_video->outfmtidx=i;

//    if(flip==-1){
//        // autodetect flipping
//        flip=0;
//        if(sh_video->codec->outflags[i]&CODECS_FLAG_FLIP)
//          if(!(sh_video->codec->outflags[i]&CODECS_FLAG_NOFLIP))
//             flip=1;
//    }

    flip = 0;

//    mp_msg(MSGT_CPLAYER,MSGL_DBG2,"vo_debug1: out_fmt=%s\n",vo_format_name(out_fmt));

    if(!init_video(sh_video)){
         printf("FATAL: Couldn't initialize video codec :(\n");
         exit(1);
    }

//    if(auto_quality>0){
//        // Auto quality option enabled
//        output_quality=get_video_quality_max(sh_video);
//        if(auto_quality>output_quality) auto_quality=output_quality;
//        else output_quality=auto_quality;
//        mp_msg(MSGT_CPLAYER,MSGL_V,"AutoQ: setting quality to %d\n",output_quality);
//        set_video_quality(sh_video,output_quality);
//    }


//================== MAIN: ==========================
{

    float time_frame=0; // Timer
    int eof=0;
    int force_redraw=0;
    int grab_frames=0;
    char osd_text_buffer[64];
    int drop_frame=0;
    int drop_frame_cnt=0;
    float AV_delay=0; // average of A-V timestamp differences
    double cvideo_base_vtime;
    double cvideo_base_vframe;
    double vdecode_time;

//================ SETUP AUDIO ==========================
    current_module="setup_audio";

    if(sh_audio){
  
//      const ao_info_t *info=audio_out->info;
//      printf("AO: [%s] %iHz %s %s\n",
//          info->short_name,
//          force_srate?force_srate:sh_audio->samplerate,
//          sh_audio->channels>1?"Stereo":"Mono",
//          audio_out_format_name(sh_audio->sample_format)
//       );
//       printf("AO: Description: %s\nAO: Author: %s\n",
//          info->name,
//          info->author	
//       );
//       if(strlen(info->comment) > 0)
//          printf("AO: Comment: %s\n", info->comment);
//       if(!audio_out->init(force_srate?force_srate:sh_audio->samplerate,
//          sh_audio->channels,sh_audio->sample_format,0)){
//        printf("couldn't open/init audio device -> NOSOUND\n");
//        sh_audio=NULL;
//        d_audio->sh=NULL;
//      } else {
//        inited_flags|=INITED_AO;
//      }

//      printf("Audio buffer size: %d bytes, delay: %5.3fs\n",audio_buffer_size,audio_buffer_delay);
    }

    sh_video->timer=0;
    if(sh_audio) sh_audio->timer=-audio_delay;

    if(!sh_audio){
      printf("Audio: no sound!!!\n");
      printf("Freeing %d unused audio chunks\n",d_audio->packs);
      ds_free_packs(d_audio); // free buffered chunks
      d_audio->id=-2;         // do not read audio chunks
//      if(audio_out) exit(1); //uninit_player(INITED_AO); // close device
    }

    current_module=NULL;

    if(demuxer->file_format!=DEMUXER_TYPE_AVI) pts_from_bps=0; // it must be 0 for mpeg/asf!
    if(force_fps){
      sh_video->fps=force_fps;
      sh_video->frametime=1.0f/sh_video->fps;
      printf("FPS forced to be %5.3f  (ftime: %5.3f)\n",sh_video->fps,sh_video->frametime);
    }
}
    return 0;
}


int main(int argc, char *argv[])
{
    PTIB  tib;
    PPIB  pib;
    int   WindowX, WindowY, WindowWidth, WindowHeight;
    HWND  WinHandle;
    PMrq  rq;

    ULONG i, rc;
    TID   PlayThread, AudThread;

    unlink("wvision.log");

    if (argc <= 1) {

        printf("Usage: WarpVision [options] movie_name.avi\n");
        printf(" options: -44100 - Resample audio 48kHz to 44kHz\n");
        printf(" options: -24000 - Resample audio 48kHz to 24kHz\n");

        exit(1);
    }

    printf("Command line:");

    for(i=0;i<argc;i++) {

        if (strcmp(argv[i], "-44100") == 0)
            AudioResampleFlag = 1;

        if (strcmp(argv[i], "-24000") == 0)
            AudioResampleFlag = 2;

        printf(" '%s'",argv[i]);
    }

    printf("\n");

    rc = DosCreateMutexSem(NULL, &demux_mtx, 0, FALSE);
    rc = DosCreateMutexSem(NULL, &pause_mtx, 0, FALSE);
    rc = DosCreateMutexSem(NULL, &rewind_mtx, 0, FALSE);

    DosGetInfoBlocks (&tib, &pib);
    pib->pib_ultype = 3;

    gdMH = NULLHANDLE;

    rc = InitPlayer(argv[argc-1]);

    if (rc != 0)
        return 1;

    switch(sh_video->bih->biBitCount)
    {
        case 16:
            fccColorFormat = FOURCC_R565;
            ScreenBpp = 16;
        break;

        case 24:
//            fccColorFormat = FOURCC_BGR3;
            fccColorFormat = FOURCC_R565;
            ScreenBpp = 24;
        break;

        case 32:
//            fccColorFormat = FOURCC_BGR4;
            fccColorFormat = FOURCC_R565;
            ScreenBpp = 32;
        break;

        default:
            printf("Can't play this video file with %dbpp.\n", sh_video->bih->biBitCount);
            exit(1);
    }

    // Initialize DIVE
    if (!gdDiveInitialize ())
    {
      printf ("Unable to initialize DIVE\n");
      exit (1);
    }

    WindowX = 10;
    WindowY = 10;
    WindowWidth = sh_video->bih->biWidth;
    WindowHeight = sh_video->bih->biHeight;

    DosSetPriority ( PRTYS_THREAD, PRTYC_TIMECRITICAL, 15, 0 );

    // Create PM window

    sprintf(pszTitleText,
            "WarpVision v0.0.12 (%dx%d, %dbpp)",
            sh_video->bih->biWidth, sh_video->bih->biHeight, sh_video->bih->biBitCount);

    rq.Parm.CreateWindow.Title = pszTitleText;
//    rq.Parm.CreateWindow.Title = NULL;
    if ((rc = PMcall (pmcmdCreateWindow, &rq)) != pmrcOK)
    {
      printf ("Cannot create PM window: no resources bound to executable?\n");
      return false;
    }

    WinHandle = rq.Parm.CreateWindow.Handle;

    FGVideoMode Mode = // selected mode with double buffering
    { WindowWidth, WindowHeight, fccColorFormat, 2, vmfWindowed };

    // Create DIVE contect
    rq.Parm.CreateCtx.Mode = &Mode;
    if ((rc = PMcall (pmcmdCreateDIVEctx, &rq)) != pmrcOK)
    {
      printf ("Cannot create DIVE context\n");
      return false;
    }

    dW = rq.Parm.CreateCtx.dW;

    // Setup event handlers
    dW->SetKeyboardHandler (KeyboardHandlerStub, NULL);
    dW->SetMouseHandler (MouseHandlerStub, NULL);
    dW->SetTerminateHandler (TerminateHandlerStub, NULL);
    dW->SetFocusHandler (FocusHandlerStub, NULL);

    // Bind DIVE context to window
    rq.Parm.BindCtx.dW = dW;
    rq.Parm.BindCtx.Handle = WinHandle;
    rq.Parm.BindCtx.DesktopW = DesktopW;
    rq.Parm.BindCtx.DesktopH = DesktopH;
    if ((rc = PMcall (pmcmdBindDIVEctx, &rq)) != pmrcOK)
    {
      printf ("Cannot bind DIVE context to window!\n");
      return false;
    }

    if ((WindowWidth != -1) && (WindowHeight != -1))
    {
      rq.Parm.Resize.dW = dW;
      rq.Parm.Resize.Width = WindowWidth;
      rq.Parm.Resize.Height = WindowHeight;
      rq.Parm.Resize.Center = true;
      PMcall (pmcmdResizeWindow, &rq);
    }

    if ((WindowX != INT_MIN) || (WindowY != INT_MIN))
    {
      rq.Parm.Locate.dW = dW;
      if (WindowX != INT_MIN)
        rq.Parm.Locate.x = ((DesktopW * WindowX) / 100) & ~1;
      else
        rq.Parm.Locate.x = INT_MIN;
      if (WindowY != INT_MIN)
        rq.Parm.Locate.y = (DesktopH * WindowY) / 100;
      else
        rq.Parm.Locate.y = INT_MIN;
      PMcall (pmcmdLocateWindow, &rq);
    }

    // Show window
    rq.Parm.ShowWin.dW = dW;
    rq.Parm.ShowWin.State = 1;
    if ((rc = PMcall (pmcmdShowWindow, &rq)) != pmrcOK)
      return false;

    if(sh_audio) {
     DosCreateThread(&AudThread,
                    (PFNTHREAD) StartSound,
                    (ULONG)&dartCallback, 0L, 8192L);
    }

    DosCreateThread(&PlayThread,
                   (PFNTHREAD) PlayVideo,
                   0, 0L, 16384L);

    /* Set the proiroty of the blitting thread */
//    DosSetPriority (PRTYS_THREAD, PRTYC_REGULAR, PRTYD_MAXIMUM, PlayThread);
//    DosSetPriority (PRTYS_THREAD, PRTYC_REGULAR, PRTYD_MAXIMUM, AudThread);

    DosWaitThread(&PlayThread, DCWW_WAIT);

    // Destroy DIVE context
    rq.Parm.DestroyCtx.dW = dW;
    PMcall (pmcmdDestroyDIVEctx, &rq);

    // Destroy PM window
    rq.Parm.DestroyWindow.Handle = WinHandle;
    PMcall (pmcmdDestroyWindow, &rq);

    // Deallocate DIVE resources
    gdDiveDeinitialize ();

//    DosBeep(2200, 10);

    rc = DosCloseMutexSem(demux_mtx);
    rc = DosCloseMutexSem(pause_mtx);
    rc = DosCloseMutexSem(rewind_mtx);

    return 0;
}
