#define INCL_DOS
#define INCL_OS2MM

#include <os2.h>
#include <os2me.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libDART.h"
#include "devaudio.h"

#include "mp3lib\mp3.h"

#include "avcodec.h"

extern ReSampleContext *aud_resample;
extern int aud_resample_flg;

extern "C" HMTX pause_mtx;
extern float mci_pts;
extern int MCIFormat;
extern int AudioResampleFlag;

VOID APIENTRY StartSound(dartInputCallback dartCallback)
{
  int device_index = 0;
  int sr, rc;

  MP3_bps = (MP3_bps == 2)?BPS_16:BPS_8;

  if (MP3_samplerate == 48000 && AudioResampleFlag > 0)
  {
    if (AudioResampleFlag == 1)
    {
        sr = 44100;
        aud_resample_flg = TRUE;
        printf("Audio resampling %d -> %d\n", MP3_samplerate, 44100);
    }
    else if (AudioResampleFlag == 2)
    {
        sr = 24000;
        aud_resample_flg = TRUE;
        printf("Audio resampling %d -> %d\n", MP3_samplerate, 24000);
    }
  }
  else
  {
    sr = MP3_samplerate;
    aud_resample_flg = FALSE;
  }

  aud_resample = audio_resample_init(MP3_channels, MP3_channels,
                                 sr, 
                                 MP3_samplerate);

  DART dart (device_index,
             MP3_bps,
             sr,
             MCIFormat,
             MP3_channels,
             2);

  if (dart.Error ())
  {
    printf ("DART error: %s\n", dart.GetErrorString ());
    return;
  }

  dart.SetInputCallback (dartCallback);
  dart.Play ();

  if (dart.Error ())
  {
    printf ("DART error: %s\n", dart.GetErrorString ());
    return;
  }

  while (!dart.Stopped)
  {

    rc = DosRequestMutexSem(pause_mtx, (ULONG)200);
    if (rc != NO_ERROR)
    {
        dart.Pause();
        DosRequestMutexSem(pause_mtx, (ULONG)SEM_INDEFINITE_WAIT);
        dart.Resume();
    }

    DosSleep(100);

    DosReleaseMutexSem(pause_mtx);
  }

  return;
}
