#ifndef DEF_H
#define DEF_H

/* Misc. constants. */

#ifdef false
#undef false
#endif
#define false 0

#ifdef true
#undef true
#endif
#define true  1

#include "bih.h"

#ifndef CONST
#define CONST       const
#endif

/* Standard data types. These are the same for emulator and library. */

#ifndef WORD
typedef unsigned short  WORD;
#endif
#ifndef DWORD
typedef unsigned long   DWORD;
#endif

typedef LONG SCODE;

/* HIC struct (same layout as Win95 one) */
typedef struct tagWINE_HIC {
	long		magic;		/* 00: 'Smag' */
	HANDLE	        curthread;	/* 04: */
	long		type;		/* 08: */
	long		handler;	/* 0C: */
	int		hdrv;		/* 10: */
	long		_private;	/* 14:(handled by SendDriverMessage)*/
	int		driverproc;	/* 18:(handled by SendDriverMessage)*/
	long		x1;		/* 1c: name? */
	short		x2;		/* 20: */
	long		x3;		/* 22: */
					/* 26: */
} HIC;

typedef struct _WAVEFORMATEX {
  WORD   wFormatTag;
  WORD   nChannels;
  DWORD  nSamplesPerSec;
  DWORD  nAvgBytesPerSec;
  WORD   nBlockAlign;
  WORD   wBitsPerSample;
  WORD   cbSize;
} WAVEFORMATEX, *PWAVEFORMATEX, *NPWAVEFORMATEX, *LPWAVEFORMATEX;

typedef USHORT          HANDLE16;

#define DECLARE_HANDLE(a) \
	typedef HANDLE16 a##16; \
	typedef a##16 *P##a##16; \
	typedef a##16 *NP##a##16; \
	typedef a##16 *LP##a##16; \
	typedef HANDLE a; \
	typedef a *P##a; \
	typedef a *LP##a

DECLARE_HANDLE(HACMSTREAM);
DECLARE_HANDLE(HACMDRIVER);

typedef	UINT	MMRESULT;

#define WAVE_FORMAT_PCM     1

#define ACMERR_BASE        512
#define ACMERR_NOTPOSSIBLE (ACMERR_BASE + 0)
#define ACMERR_BUSY        (ACMERR_BASE + 1)
#define ACMERR_UNPREPARED  (ACMERR_BASE + 2)
#define ACMERR_CANCELED    (ACMERR_BASE + 3)

#define ACM_STREAMSIZEF_SOURCE      0x00000000L
#define ACM_STREAMSIZEF_DESTINATION 0x00000001L
#define ACM_STREAMSIZEF_QUERYMASK   0x0000000FL

#define WINAPI      __stdcall
typedef DWORD          *LPDWORD;
typedef BYTE           *LPBYTE;

typedef struct _WAVEFILTER {
  DWORD   cbStruct;
  DWORD   dwFilterTag;
  DWORD   fdwFilter;
  DWORD   dwReserved[5];
} WAVEFILTER, *PWAVEFILTER, *NPWAVEFILTER, *LPWAVEFILTER;

typedef struct _ACMSTREAMHEADER
{
  DWORD  cbStruct;
  DWORD  fdwStatus;
  DWORD  dwUser;
  LPBYTE pbSrc;
  DWORD  cbSrcLength;
  DWORD  cbSrcLengthUsed;
  DWORD  dwSrcUser;
  LPBYTE pbDst;
  DWORD  cbDstLength;
  DWORD  cbDstLengthUsed;
  DWORD  dwDstUser;
  DWORD  dwReservedDriver[10];
} ACMSTREAMHEADER, *PACMSTREAMHEADER, *LPACMSTREAMHEADER;

#ifdef __cplusplus
extern "C" {
#endif

MMRESULT WINAPI acmStreamConvert(
  HACMSTREAM has, PACMSTREAMHEADER pash, DWORD fdwConvert
);

MMRESULT WINAPI acmStreamOpen(
  PHACMSTREAM phas, HACMDRIVER had, PWAVEFORMATEX pwfxSrc,
  PWAVEFORMATEX pwfxDst, PWAVEFILTER pwfltr, DWORD dwCallback,
  DWORD dwInstance, DWORD fdwOpen
);

MMRESULT WINAPI acmStreamSize(
  HACMSTREAM has, DWORD cbInput, 
  LPDWORD pdwOutputBytes, DWORD fdwSize
);

MMRESULT WINAPI acmStreamPrepareHeader(
  HACMSTREAM has, PACMSTREAMHEADER pash, DWORD fdwPrepare
);

MMRESULT WINAPI acmStreamUnprepareHeader(
  HACMSTREAM has, PACMSTREAMHEADER pash, DWORD fdwUnprepare
);

#ifdef __cplusplus
}
#endif

#endif
