#define INCL_DOS
#define INCL_OS2MM

#include <os2.h>
#include <os2me.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libavcodec\inttypes.h"

#include <rgb2rgb.h>

char retstr[128];
extern int ScreenBpp;

#define memalign(a,b) malloc(b)

extern int verbose; // defined in mplayer.c
extern int divx_quality;

extern double video_time_usage;
extern double vout_time_usage;

//extern int frameratecode2framerate[16];

//#include "linux/timer.h"
//#include "linux/shmem.h"

#include "stream.h"
#include "demuxer.h"
//#include "parse_es.h"

//#include "wine/mmreg.h"
#include "avifmt.h"
//#include "wine/vfw.h"

#include "codec-cfg.h"
#include "stheader.h"

#include "img_format.h"
#include "video_out.h"

extern sh_video_t *sh_video;


//#ifdef USE_LIBVO2
//#include "libvo2/libvo2.h"
//#else
//#include "libvo/video_out.h"
//#endif

//#include "libmpeg2/mpeg2.h"
//#include "libmpeg2/mpeg2_internal.h"

//extern picture_t *picture;	// exported from libmpeg2/decode.c


//#ifdef USE_DIRECTSHOW
//#include "loader/DirectShow/DS_VideoDec.h"
//#endif

#include "libavcodec/avcodec.h"
    static AVCodec *lavc_codec=NULL;
    static AVCodecContext lavc_context;
    static AVPicture lavc_picture;
    int avcodec_inited=0;

//#ifndef NEW_DECORE
//#include "opendivx/decore.h"
//#else
//#include <decore.h>
//#endif

void AVI_Decode_RLE8(char *image,char *delta,int tdsize,
    unsigned int *map,int imagex,int imagey,unsigned char x11_bytes_pixel);

void uninit_video(sh_video_t *sh_video){
    if(!sh_video->inited) return;
    printf("uninit video: %d  \n",sh_video->codec->driver);

    switch(sh_video->codec->driver){
    case VFM_FFMPEG:
        if (avcodec_close(&lavc_context) < 0)
    	    printf("Cannot close codec.\n");
	break;
    }

    if(sh_video->our_out_buffer){
	free(sh_video->our_out_buffer);
	sh_video->our_out_buffer=NULL;
    }
    sh_video->inited=0;
}

int init_video(sh_video_t *sh_video)
{
unsigned int out_fmt=sh_video->codec->outfmt[sh_video->outfmtidx];

sh_video->our_out_buffer=NULL;

switch(sh_video->codec->driver){
   int bpp;
 case VFM_FFMPEG: {  // FFmpeg's libavcodec
//   printf("FFmpeg's libavcodec video codec\n");
    if(!avcodec_inited){
      avcodec_init();
      avcodec_register_all();
      avcodec_inited=1;
    }
    lavc_codec = (AVCodec *)avcodec_find_decoder_by_name(sh_video->codec->dll);
    if(!lavc_codec){
	printf("Can't find codec '%s' in libavcodec...\n",sh_video->codec->dll);
	return 0;
    }
    memset(&lavc_context, 0, sizeof(lavc_context));
    lavc_context.width=sh_video->disp_w;
    lavc_context.height=sh_video->disp_h;
// dbg
//    printf("libavcodec.size: %d x %d\n",lavc_context.width,lavc_context.height);
    /* open it */
    if (avcodec_open(&lavc_context, lavc_codec) < 0) {
//        mp_msg(MSGT_DECVIDEO,MSGL_ERR, MSGTR_CantOpenCodec);
        return 0;
    }

//   printf("INFO: libavcodec init OK!\n");

   yuv2rgb_init(sh_video->bih->biBitCount, MODE_RGB);

   printf(retstr);

   break;
 }
}
  sh_video->inited=1;
  return 1;
}

unsigned int GetTimer(void)
{
    return 0;
}

#define Q2LL(a) ((ULONG)a.ulHi<<32)|((ULONG)a.ulLo)

FILE *out;

#define MBC 48
#define MBR 36

int decode_video(unsigned char *mem, sh_video_t *sh_video,unsigned char *start,int in_size,int drop_frame)
{
 unsigned int out_fmt=sh_video->codec->outfmt[sh_video->outfmtidx];
 int planar=(out_fmt==IMGFMT_YV12||out_fmt==IMGFMT_IYUV||out_fmt==IMGFMT_I420);
 int blit_frame=0;

 int quant_store[MBR+1][MBC+1];

//static unsigned long long MaxDec = 0, MinDec = 0xFFFFFFFF;

unsigned char* planes_[3];
unsigned char** planes=planes_;
int stride_[3];
int* stride=stride_;

unsigned int t=GetTimer();
unsigned int t2;
int ret;

  //--------------------  Decode a frame: -----------------------
switch(sh_video->codec->driver){
  case VFM_FFMPEG: {        // libavcodec
    int got_picture=0;
    if(drop_frame<2 && in_size>0) {
//        QWORD Qres;
//        unsigned long long StartDec, EndDec, re;

//        DosTmrQueryTime(&Qres);
//        StartDec = Q2LL(Qres);

        ret = avcodec_decode_video(&lavc_context, &lavc_picture,
	     &got_picture, start, in_size);

//        DosTmrQueryTime(&Qres);
//        EndDec = Q2LL(Qres);

//        re = EndDec-StartDec;
//        if (MaxDec < re)  MaxDec = re;
//        if (MinDec > re)  MinDec = re;

//        printf("%Li/%Li/%Li \r", MaxDec, MinDec, re);

if(verbose>1){
     unsigned char *x="???";
     switch(lavc_context.pix_fmt){
     case PIX_FMT_YUV420P: x="YUV420P";break;
     case PIX_FMT_YUV422: x="YUV422";break;
     case PIX_FMT_RGB24: x="RGB24";break;
     case PIX_FMT_BGR24: x="BGR24";break;
#ifdef PIX_FMT_YUV422P
     case PIX_FMT_YUV422P: x="YUV422P";break;
     case PIX_FMT_YUV444P: x="YUV444P";break;
#endif
     }
}
	if(ret<0) printf("Error while decoding frame!\n");
	if(!drop_frame && got_picture){
	  if(planar){
            AVPicture *src_picture, *dst_picture;
            AVPicture picture_tmp0;
            unsigned char *picture_420p = NULL;

////            QWORD Qres;
////            unsigned long long StartDec, EndDec, re;

////            DosTmrQueryTime(&Qres);
////            StartDec = Q2LL(Qres);

//            src_picture = &lavc_picture;

//            dst_picture = &picture_tmp0;
//            avpicture_fill(dst_picture, mem, PIX_FMT_RGB24, sh_video->disp_w, sh_video->disp_h);

	    planes=lavc_picture.data;
	    stride=lavc_picture.linesize;

            if (ScreenBpp == 24 || ScreenBpp == 32)
            {
                unsigned char *tmp_pic;
                int destbytes;

                destbytes = (sh_video->disp_w*sh_video->disp_h)*sh_video->bih->biBitCount/8;
                tmp_pic = (unsigned char *)malloc(destbytes);

                yuv2rgb((unsigned char *)tmp_pic,
                    planes[0],
                    planes[1],
                    planes[2],
                    sh_video->disp_w,
                    sh_video->disp_h,
                    sh_video->disp_w*3,
                    stride[0],
                    stride[1]
                   );

                if (sh_video->bih->biBitCount == 24)
                    rgb24to16(tmp_pic, mem, destbytes);
                else if (sh_video->bih->biBitCount == 32)
                    rgb32to16(tmp_pic, mem, destbytes);

                free(tmp_pic);
            }
            else
                yuv2rgb((unsigned char *)mem,
                    planes[0],
                    planes[1],
                    planes[2],
                    sh_video->disp_w,
                    sh_video->disp_h,
                    sh_video->disp_w*3,
                    stride[0],
                    stride[1]
                   );

////            DosTmrQueryTime(&Qres);
////            EndDec = Q2LL(Qres);

////            re = EndDec-StartDec;
////            if (MaxDec < re)  MaxDec = re;
////            if (MinDec > re)  MinDec = re;

////            printf("%Li/%Li/%Li \r", MaxDec, MinDec, re);

            blit_frame=2;
            return blit_frame;
	  } else {
	    int y;
	    // temporary hack - FIXME
	    if(!sh_video->our_out_buffer)
		sh_video->our_out_buffer = (char*)memalign(64,sh_video->disp_w*sh_video->disp_h*2);
	    for(y=0;y<sh_video->disp_h;y++){
	      unsigned char *s0=lavc_picture.data[0]+lavc_picture.linesize[0]*y;
	      unsigned char *s1=lavc_picture.data[1]+lavc_picture.linesize[1]*y;
	      unsigned char *s2=lavc_picture.data[2]+lavc_picture.linesize[2]*y;
	      unsigned char *d=sh_video->our_out_buffer+y*2*sh_video->disp_w;
	      int x;
	      for(x=0;x<sh_video->disp_w/2;x++){
	          d[4*x+0]=s0[2*x+0];
	          d[4*x+1]=s1[x];
	          d[4*x+2]=s0[2*x+1];
	          d[4*x+3]=s2[x];
	      }
	    }
            blit_frame=3;
	  }

	}
    }
    break;
  }
} // switch
//------------------------ frame decoded. --------------------

#ifdef HAVE_MMX
	// some codecs is broken, and doesn't restore MMX state :(
	// it happens usually with broken/damaged files.
	__asm __volatile ("emms;":::"memory");
#endif

t2=GetTimer();t=t2-t;video_time_usage+=t*0.000001f;

switch(blit_frame){
case 3:
      if(planar){
        stride[0]=sh_video->disp_w;
        stride[1]=stride[2]=sh_video->disp_w/2;
        planes[0]=sh_video->our_out_buffer;
        planes[2]=planes[0]+sh_video->disp_w*sh_video->disp_h;
        planes[1]=planes[2]+sh_video->disp_w*sh_video->disp_h/4;
      } else
        planes[0]=sh_video->our_out_buffer;
case 2:
#ifdef USE_LIBVO2
    if(planar)
        vo2_draw_slice(video_out,planes,stride,sh_video->disp_w,sh_video->disp_h,0,0);
    else
        vo2_draw_frame(video_out,planes[0],sh_video->disp_w,sh_video->disp_w,sh_video->disp_h);
#else
//    if(planar)
//        video_out->draw_slice(planes,stride,sh_video->disp_w,sh_video->disp_h,0,0);
//    else
//        video_out->draw_frame(planes);
#endif
    t2=GetTimer()-t2;vout_time_usage+=t2*0.000001f;
    blit_frame=1;
    break;
}

  return blit_frame;
}


int video_read_properties(sh_video_t *sh_video){
demux_stream_t *d_video=sh_video->ds;

// Determine image properties:
switch(d_video->demuxer->file_format){
 case DEMUXER_TYPE_AVI:
 case DEMUXER_TYPE_ASF: {
  // display info:
    sh_video->format=sh_video->bih->biCompression;
    sh_video->disp_w=sh_video->bih->biWidth;
    sh_video->disp_h=abs(sh_video->bih->biHeight);
  break;
 }
} // switch(file_format)

return 1;
}
