#define INCL_OS2MM

#include <os2.h>
#include <os2me.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
//#include <errno.h>
//#include <ctype.h>
//#include <assert.h>
//#include <string.h>

// for mmioFOURCC:
#include "avifmt.h"

#ifndef mmioFOURCC
#define mmioFOURCC( ch0, ch1, ch2, ch3 )				\
		( (DWORD)(BYTE)(ch0) | ( (DWORD)(BYTE)(ch1) << 8 ) |	\
		( (DWORD)(BYTE)(ch2) << 16 ) | ( (DWORD)(BYTE)(ch3) << 24 ) )
#endif

#include "img_format.h"
#include "codec-cfg.h"

codecs_t* find_video_codec(unsigned int fourcc, unsigned int *fourccmap, codecs_t *start)
{
  static codecs_t *codec;

  unsigned long fcc = fourcc;

  codec=(codecs_t *)malloc(sizeof(codecs_t));

  switch(fcc)
  {
    case mmioFOURCC('D', 'I', 'V', 'X'):
    case mmioFOURCC('d', 'i', 'v', 'x'):
      codec->name = "OpenDivX";
      codec->info = "OpenDivX (MPEG-4 v2)";
      codec->dll = "mpeg4";
      codec->driver = VFM_FFMPEG;
      codec->outfmt[0] = IMGFMT_YV12;
    break;

    case mmioFOURCC('M', 'P', '4', '3'):
    case mmioFOURCC('m', 'p', '4', '3'):
    case mmioFOURCC('D', 'I', 'V', '3'):
    case mmioFOURCC('d', 'i', 'v', '3'):
    case mmioFOURCC('D', 'I', 'V', '4'):
    case mmioFOURCC('d', 'i', 'v', '4'):
    case mmioFOURCC('M', 'P', '4', '1'):
    case mmioFOURCC('m', 'p', '4', '1'):
      codec->name = "DivX";
      codec->info = "DivX ;-) (MS MPEG-4 v3)";
      codec->dll = "msmpeg4";
      codec->driver = VFM_FFMPEG;
      codec->outfmt[0] = IMGFMT_YV12;
    break;

    default: {
      free(codec);
      codec = NULL;
    }
  }

  return codec;
}

codecs_t* find_audio_codec(unsigned int fourcc, unsigned int *fourccmap, codecs_t *start)
{
  static codecs_t *codec;

  codec=(codecs_t *)malloc(sizeof(codecs_t));

  switch(fourcc)
  {
    case 0x2000:
      codec->name = "AC3";
      codec->info = "AC3";
      codec->dll = "libac3";
      codec->driver = AFM_AC3;
    break;

    case 0x50:
    case 0x55:
      codec->name = "MPEG";
      codec->info = "MPEG layer-2, layer-3";
      codec->dll = "mp3lib";
      codec->driver = AFM_MPEG;
    break;

    default: {
      free(codec);
      codec = NULL;
    }
  }

  return codec;
}

