/* ========================================================================
        File: rt.h
        Desc: Skin Resource Type definitions
    Revision: 2
    Modified: 2001-05-22 by Henrik Djurner.
======================================================================== */

#ifndef _RT_H
  #define _RT_H

   #define V_SkinEngineVersion       0x0110 // Current version of Skin Engine

   #define Quadrant_UpperRight       1
   #define Quadrant_UpperLeft        2
   #define Quadrant_LowerLeft        3
   #define Quadrant_LowerRight       4

   // Constants for ResourceType member in Resource records...
   //
   #define T_Skin                    0x0001 // RT_Skin
   #define T_Look                    0x0002 // RT_Look
   #define T_Mode                    0x0003 // RT_Mode
   #define T_CtrlGeneric             0x0004 // RT_CtrlGeneric
   #define T_CtrlBitmap              0x0005 // RT_CtrlBitmap
   #define T_CtrlPushButton          0x0006 // RT_CtrlPushButton
   #define T_Ctrl2StateButton        0x0007 // RT_Ctrl2StateButton
   #define T_CtrlSimpleSlider        0x0008 // RT_CtrlSimpleSlider
   #define T_CtrlSlider              0x0009 // RT_CtrlSlider
   #define T_2StateIndicator         0x000A // RT_2StateIndicator
   #define T_3StateIndicator         0x000B // RT_3StateIndicator
   #define T_Counter                 0x000C // RT_Counter
   #define T_DigitFont               0x000D // RT_DigiFont
   #define T_Scroll                  0x000E // RT_Scroll
   #define T_LookSwitch              0x000F // RT_LookSwitch
   #define T_StateIndicator          0x0010 // RT_StateIndicator
   #define T_AnimatedBitmap          0x0011 // RT_AnimatedBitmap
   #define T_ExternalBitmap          0x0012 // RT_ExternalBitmap
   #define T_MultipleBitmaps         0x0013 // RT_MultipleBitmaps
   #define T_SystemFont              0x0014 // RT_SystemFont
   #define T_BitmapFont              0x0015 // RT_BitmapFont
   #define T_MetaControl             0x0016 // RT_MetaControl

   // Constants for 'logical' control hooks...
   //
   #define LC_2SB_Play               0x0100 // A two state 'play' button
   #define LC_2SB_Stop               0x0101 // A two state 'stop' button
   #define LC_2SB_Pause              0x0102 // A two state 'pause' button
   #define LC_2SB_Loop               0x0103 // A two state 'loop' button
   #define LC_2SB_Random             0x0104 // A two state 'random' button
   #define LC_2SB_Rewind             0x0105 // A two state 'rewind' button
   #define LC_2SB_Forward            0x0106 // A two state 'fast forward' button
   #define LC_2SB_LookSwitch         0x0107 // A two state 'look switch' button
   #define LC_PB_Play                0x0200 // A 'play' pushbutton
   #define LC_PB_Stop                0x0201 // A 'stop' pushbutton
   #define LC_PB_Pause               0x0202 // A 'pause' pushbutton
   #define LC_PB_Loop                0x0203 // A 'loop' pushbutton
   #define LC_PB_Random              0x0204 // A 'random' pushbutton
   #define LC_PB_Forward             0x0205 // A 'forward' pushbutton
   #define LC_PB_Rewind              0x0206 // A 'rewind' pushbutton
   #define LC_PB_Previous            0x0207 // A 'previous' pushbutton
   #define LC_PB_Next                0x0208 // A 'next' pushbutton
   #define LC_PB_Close               0x0209 // A 'close' pushbutton
   #define LC_PB_OpenFile            0x020A // A 'open file' pushbutton
   #define LC_PB_OpenPlaylist        0x020B // A 'open playlist' pushbutton
   #define LC_PB_Minimize            0x020C // A 'minimize' pushbutton
   #define LC_PB_LookSwitch          0x020D // A 'look switch' pushbutton
   #define LC_PB_LoadMedia           0x020E // A 'load media' pushbutton
   #define LC_CNT_PlaylistProgress   0x0300 // A 'currently playing song/songs in playlist' counter
   #define LC_CNT_AudioBitrate       0x0301 // A 'audio stream bitrate' counter
   #define LC_CNT_AudioFrequency     0x0302 // A 'stream output' counter
   #define LC_2SI_Stereo             0x0400 // A stereo indicator
   #define LC_3SI_MonoStereo         0x0500 // A 3-state version of the mono/stereo indicator
   #define LC_SI_StereoMode          0x0550 // A StereoMode indicator
   #define LC_SL_Volume              0x0600 // A volume slider
   #define LC_SL_Seek                0x0601 // A seek slider
   #define LC_SL_Balance             0x0602 // A balance slider
   #define LC_SCROLL_StreamInfo      0x0700 // A scroll control

   #define LC_2SBI_AlwaysOnTop       0x0800 // AlwaysOnTop push/two-state button/indicator

   #define LC_NULL                   0x0000

   // The 'root' of skin definition resources...
   //
   #define ID_StartOfSkin            0x2000
   #define ID_StartOfSkinWinAMP      0xF242

   struct RT_Skin {
      USHORT ResourceType;
      USHORT EngineVersion;
      USHORT ID_SkinName;
      USHORT ID_SkinComment;
      USHORT ID_Looks[1];
   };

   struct RT_Look {
      USHORT ResourceType;
      USHORT ID_NormalMode;
      USHORT ID_DarkMode;
   };

   struct RT_Mode {
      USHORT ResourceType;
      USHORT Quadrant;

      union {
         struct {
            USHORT Red;
            USHORT Green;
            USHORT Blue;
         } Colour;

         struct {
            USHORT x;
            USHORT y;
            USHORT Reserved;
         } Coordinate;
      } Transparent;

      // 0 = Disabled 
      // 1 = Enabled, RGB value specified (requires PM in 24bpp mode or higher)
      // 2 = Enabled, X/Y coordinate specified
      USHORT TransparentMode; 

      USHORT ID_BmpBackground;
      USHORT NumControls;
      USHORT ID_Controls[1];
   };
   // Note: When a resource of type RT_Mode has been loaded, the memory
   //       following directly after this record will be occupied by an
   //       ARRAY [0..NumControls-1] of uShort.

   struct RT_CtrlGeneric {
      USHORT ResourceType;
      USHORT ConnectsTo;
      USHORT ControlType;
   };

   struct RT_CtrlBitmap {
      USHORT ResourceType;
      USHORT X;
      USHORT Y;
      USHORT ID_Bmp;
   };

   struct RT_CtrlPushButton {
      USHORT ResourceType;
      USHORT X;
      USHORT Y;
      USHORT ID_BmpShape;
      USHORT ID_BmpUp;
      USHORT ID_BmpDown;
      USHORT ID_BmpMouseOver;
   };

   struct RT_Ctrl2StateButton {
      USHORT ResourceType;
      USHORT X;
      USHORT Y;
      USHORT ID_BmpShape;
      USHORT ID_BmpEnabledUp;
      USHORT ID_BmpEnabledDown;
      USHORT ID_BmpDisabledUp;
      USHORT ID_BmpDisabledDown;
      USHORT ID_BmpEnabledMouseOver;
      USHORT ID_BmpDisabledMouseOver;
   };

   struct RT_CtrlSimpleSlider {
      USHORT ResourceType;
      USHORT X;
      USHORT Y;
      USHORT Vertical;  // 0 == Horizontal, 1 == Vertical
      USHORT ID_BmpShape;
      USHORT ID_BmpMin;
      USHORT ID_BmpMax;
   };

   struct RT_CtrlSlider {
      USHORT ResourceType;
      USHORT BGX;
      USHORT BGY;
      USHORT HandleX;
      USHORT HandleY;
      USHORT HandleMaxX;        // Ignored when vertical
      USHORT HandleMaxY;        // Ignored when horizontal
      USHORT Vertical;          // 0 == Horizontal, 1 == Vertical
      USHORT ID_BmpShape;
      USHORT ID_BmpBackground;
      USHORT ID_BmpHandleUp;
      USHORT ID_BmpHandleDown;
   };

   struct RT_2StateIndicator {
      USHORT ResourceType;
      USHORT X;
      USHORT Y;
      USHORT ID_BmpEnabled;
      USHORT ID_BmpDisabled;
   };

   struct RT_3StateIndicator {
      USHORT ResourceType;
      USHORT X;
      USHORT Y;
      USHORT ID_BmpEnabled1;
      USHORT ID_BmpEnabled2;
      USHORT ID_BmpDisabled;
   };

   struct RT_Counter {
      USHORT ResourceType;
      USHORT X;
      USHORT Y;
      USHORT X2;
      USHORT Y2;
      USHORT ID_DigitFont;
      USHORT NumDigits;
      struct {
         USHORT X;
         USHORT Y;
         USHORT ID_BmpOn;
         USHORT ID_BmpOff;
      } Digits[1];
   };

   struct RT_DigitFont {
      USHORT ResourceType;
      USHORT ID_Bmp_Digits[11];   // Disabled followed by 0 to 9
   };

   struct RT_Scroll {
      USHORT ResourceType;
      USHORT X;
      USHORT Y;
      USHORT X2;
      USHORT Y2;
      USHORT Mode;
      USHORT StartDelay;
      USHORT TimerID;
      USHORT TickInterval;
      USHORT PixelPerTick;
      USHORT Space;
      USHORT Color_FG_Red;
      USHORT Color_FG_Green;
      USHORT Color_FG_Blue;
      USHORT Color_BG_Red;
      USHORT Color_BG_Green;
      USHORT Color_BG_Blue;
      USHORT ID_Font;
   };

   struct RT_LookSwitch {
      USHORT ResourceType;
      USHORT ID_NewLookString;
      USHORT ControlTypeButton;  // TwoState or PushButton.
   };

   struct RT_StateIndicator {
      USHORT ResourceType;
      USHORT X;
      USHORT Y;
      USHORT ID_BmpDisabled;
      USHORT ID_BmpStates[1];
   };

   struct RT_AnimatedBitmap {
      USHORT ResourceType;
      USHORT TimerID;
      struct {
         USHORT ID_Bmp;
         USHORT msActiveTime;
      } Bitmaps[1];
   };

   struct RT_ExternalBitmap {
      USHORT ResourceType;
      USHORT X;
      USHORT Y;
      USHORT X2;
      USHORT Y2;
      USHORT ID_BmpFilename;
   };

   struct RT_MultipleBitmaps {
      USHORT ResourceType;
      struct {
         USHORT ID_Bmp;
      } Bitmaps[1];
   };

   struct RT_SystemFont {
      USHORT ResourceType;
      USHORT FontX;
      USHORT FontY;
      char FontName[1];
   };

   struct RT_BitmapFont {
      USHORT ResourceType;
      USHORT SpacingX;
      USHORT SpacingY;
      USHORT ID_BmpDefault;
      USHORT DefaultAscii;   // When some character is unavailable, use this one.
      struct {
         USHORT FromAscii;
         USHORT ToAscii;
         USHORT FirstCharX;
         USHORT FirstCharY;
         USHORT CharSizeX;
         USHORT CharSizeY;
         USHORT SpaceToNextCharX;
         USHORT SpaceToNextCharY;
         USHORT ID_Bmp;
      } Characters[1];
   };

   struct RT_MetaControl {
      USHORT ResourceType;
      USHORT X;
      USHORT Y;
      USHORT X2;
      USHORT Y2;
      USHORT fCycleWithButton1;
      USHORT fContextMenu;
      USHORT ID_Controls[1];
   };

#endif
