/* ========================================================================
   Skin definition header file by Leif Simmons & Henrik Djurner
   Revision 2, 2001-05-23
   (c) 2001, Software Developers Guild
======================================================================== */

#ifndef SKIN_RC_H
  #define SKIN_RC_H

  // Resource type definitions
  //
  #define RT_Skin                       0x0001
  #define RT_Look                       0x0002
  #define RT_Mode                       0x0003
  #define RT_CtrlGeneric                0x0004
  #define RT_CtrlBitmap                 0x0005
  #define RT_CtrlPushButton             0x0006
  #define RT_Ctrl2StateButton           0x0007
  #define RT_CtrlSimpleSlider           0x0008
  #define RT_CtrlSlider                 0x0009
  #define RT_2StateIndicator            0x000A
  #define RT_3StateIndicator            0x000B
  #define RT_Counter                    0x000C
  #define RT_DigitFont                  0x000D
  #define RT_Scroll                     0x000E
  #define RT_LookSwitch                 0x000F
  #define RT_StateIndicator             0x0010
  #define RT_AnimatedBitmap             0x0011
  #define RT_ExternalBitmap             0x0012
  #define RT_MultipleBitmaps            0x0013
  #define RT_SystemFont                 0x0014
  #define RT_BitmapFont                 0x0015
  #define RT_MetaControl                0x0016

  // Logical control definitions for 2-state buttons
  //
  #define LC_2SB_Play                   0x0100
  #define LC_2SB_Stop                   0x0101
  #define LC_2SB_Pause                  0x0102
  #define LC_2SB_Loop                   0x0103
  #define LC_2SB_Random                 0x0104
  #define LC_2SB_Rewind                 0x0105
  #define LC_2SB_Forward                0x0106
  #define LC_2SB_LookSwitch             0x0107

  // Logical control definitions for push buttons
  //
  #define LC_PB_Play                    0x0200
  #define LC_PB_Stop                    0x0201
  #define LC_PB_Pause                   0x0202
  #define LC_PB_Loop                    0x0203
  #define LC_PB_Random                  0x0204
  #define LC_PB_Forward                 0x0205
  #define LC_PB_Rewind                  0x0206
  #define LC_PB_Previous                0x0207
  #define LC_PB_Next                    0x0208
  #define LC_PB_Close                   0x0209
  #define LC_PB_OpenFile                0x020A
  #define LC_PB_OpenPlaylist            0x020B
  #define LC_PB_Minimize                0x020C
  #define LC_PB_LookSwitch              0x020D
  #define LC_PB_LoadMedia               0x020E

  // Logical control definitions for counters
  //
  #define LC_CNT_PlaylistProgress       0x0300
  #define LC_CNT_AudioBitrate           0x0301
  #define LC_CNT_AudioFrequency         0x0302

  // Logical control definitions for 2-state indicators
  //
  #define LC_2SI_Stereo                 0x0400

  // Logical control definitions for 3-state indicators
  //
  #define LC_3SI_MonoStereo             0x0500

  // Logical control definitions for state indicators
  //
  #define LC_SI_StereoMode              0x0550

  // Logical control definitions for sliders
  //
  #define LC_SL_Volume                  0x0600
  #define LC_SL_Seek                    0x0601
  #define LC_SL_Balance                 0x0602

  // Logical control definitions for scrolls
  //
  #define LC_SCROLL_StreamInfo          0x0700

  // Logical control definitions for other stuff
  // 
  #define LC_2SBI_AlwaysOnTop           0x0800
  #define LC_NULL                       0x0

  // A skin always has a specific id within a resource file
  //
  #define ID_StartOfSkin                0x2000

#endif
