/* Qu-Player/2 REXX Edition v0.99c (c) Anton Malykh, 1999-2000. */

parse arg cmdline

if cmdline='' then do
    call Help
    return
end

if Init() then do
    say
    say "Error: Can't initialize Qu2Rexx.Dll."
    return
end

signal on halt name Quit

testmode=0
call Analyze

call DrawScreen
call RxQuPlay

sec100=0
quitflag=0
do until quitflag
    code=RxQuEvent('p1', 'p2')
    select
        when code=QU_EVENT_SONG then do
            call SysCurPos 2, 0
            call RxQuEventGetInfo 'info'
            
            call charout, SetNormalColor

            longname=QueryLongName(info.filename)
            if longname='' then
                longname=substr(info.filename, lastpos('\', info.filename)+1)
            say ClearLine'Filename: 'SetHighlightColor||longname

            call charout, SetNormalColor
            call charout, ClearLine'Filesize: 'SetHighlightColor||info.common.size
            call charout, SetNormalColor' byte(s)'

            call SysCurPos 1, SysCols-14
            call charout, SetNormalColor||format(info.song, 4)' of 'info.songs
            call SysCurPos 5, 0
            call charout, SetNormalColor'Current time: ['SetHighlightColor
            call charout, '00:00'SetNormalColor'], total time: ['
            min=info.common.secs%60
            sec=info.common.secs-min*60
            call charout, SetHighlightColor||right(min, 2, '0')':'right(sec, 2, '0')
            call charout, SetNormalColor']'
            oldsec=0;

            call SysCurPos 8, 0
            call charout, ClearLine'Playing as '
            call charout, SetHighlightColor||info.audio.rate
            call charout, SetNormalColor' Hz, '
            call charout, SetHighlightColor||info.audio.bits
            call charout, SetNormalColor' bits, '
            call charout, SetHighlightColor
            if info.audio.channels=1 then
                say 'mono'
            else
                say 'stereo'
            
            call charout, SetNormalColor'Playing device: '
            say SetHighlightColor||info.audio.device

            call SysCurPos SysRows-8, 0
            say ClearLine
            say ClearLine
            say ClearLine

            call SysCurPos 7, 0
            call charout, SetNormalColor'Type: 'SetHighlightColor||info.add.type
            select
                when info.add.infoid=1 then
                    if \RxQuEventGetTypeInfo(info.add.infoid, 'info1') then
                    do
                        call charout, SetNormalColor', '
                        call charout, SetHighlightColor||info1.rate
                        call charout, SetNormalColor' Hz, '
                        call charout, SetHighlightColor||info1.bits
                        call charout, SetNormalColor' bits, '
                        call charout, SetHighlightColor
                        if info1.channels=1 then
                            say 'mono'
                        else   
                            say 'stereo'
                    end
                when info.add.infoid=2 then
                    if \RxQuEventGetTypeInfo(info.add.infoid, 'info2') then
                    do
                        call charout, SetNormalColor', '
                        if info2.type\='' then
                            call charout, info2.type' '
                        call charout, SetHighlightColor||info2.rate
                        call charout, SetNormalColor' Hz, '
                        call charout, SetHighlightColor||info2.bits
                        call charout, SetNormalColor' bits, '
                        call charout, SetHighlightColor
                        if info2.channels=1 then
                            say 'mono'
                        else   
                            say 'stereo'
                    end
                when info.add.infoid=3 then
                    if \RxQuEventGetTypeInfo(info.add.infoid, 'info3') then
                    do
                        call charout, SetNormalColor', MPEG '
                        call charout, SetHighlightColor||info3.mpeg
                        call charout, SetNormalColor' layer '
                        call charout, SetHighlightColor||info3.layer
                        call charout, SetNormalColor', '
                        call charout, SetHighlightColor
                        if info3.bitrate\=0 then
                            call charout, info3.bitrate
                        else
                            if info.common.secs\=0 then
                            do
                                bitrate=info.common.size/info.common.secs*8/1000
                                bitrate=format(bitrate,,0)
                                call charout, 'VBR ('bitrate')'
                            end
                            else
                                call charout, '0'
                        call charout, SetNormalColor' kbit/s, '
                        call charout, SetHighlightColor||info3.rate
                        call charout, SetNormalColor' Hz '
                        call charout, SetHighlightColor||info3.mode
                        len=length(info3.artist)+length(info3.title)
                        len=len+length(info3.album)+length(info3.year)
                        len=len+length(info3.genre)+length(info3.comment)
                        if len\=0 then
                        do
                            call SysCurPos SysRows-8, 0
                            call charout, SetNormalColor'Artist '
                            if info3.artist='' then
                                str='none'
                            else
                                str=info3.artist
                            call charout, SetHighlightColor||left(str, 30)
                            call charout, SetNormalColor'Title   '
                            if info3.title='' then
                                str='none'
                            else
                                str=info3.title
                            say SetHighlightColor||left(str, 30)

                            call charout, SetNormalColor'Album  '
                            if info3.album='' then
                                str='none'
                            else
                                str=info3.album
                            call charout, SetHighlightColor||left(str, 30)
                            call charout, SetNormalColor'Year    '
                            if info3.year='' then
                                str='none'
                            else
                                str=info3.year
                            say SetHighlightColor||left(str, 30)

                            call charout, SetNormalColor'Genre  '
                            if info3.genre='' then
                                str='none'
                            else
                                str=info3.genre
                            call charout, SetHighlightColor||left(str, 30)
                            call charout, SetNormalColor'Comment '
                            if info3.comment='' then
                                str='none'
                            else
                                str=info3.comment
                            say SetHighlightColor||left(str, 30)
                        end
                    end
                otherwise nop
            end
            call SysCurPos 12, 0
            call charout, SetNormalColor
            if info.add.userinfo\='' then
            do
                len=SysCols-14;
                call charout, 'User comment: 'SetHighlightColor
                call charout, left(info.add.userinfo, len)
                if length(info.add.userinfo)>len then
                do
                    call SysCurPos 12, SysCols-1
                    call charout, '>'
                end
            end
            else
                call charout, ClearLine
        end
        when code=QU_EVENT_FRAME then
        do
            if oldsec\=p2 then do
                call SysCurPos 5, 15
                min=p2%60
                sec=p2-min*60
                call charout, SetHighlightColor||right(min, 2, '0')':'right(sec, 2, '0')
                oldsec=p2
            end
        end
        when code=QU_EVENT_DONE then
            quitflag=1
        when code=QU_EVENT_PAUSE then
            call pause
        otherwise nop
    end
    do while CHARS()
        key=c2d(SysGetKey('NOECHO'))
        select
            when (key=27) | (key=8) then
            do
                quitflag=1
                leave
            end
            when (key=224) | (key=0) then
            do
                key=c2d(SysGetKey('NOECHO'))
                if key=73 then call RxQuPrev
                if key=81 then call RxQuNext
            end
            when key=32 | key=c2d('p') then
                call RxQuSetValue QU_VALUE_PAUSE, 1
            when key=c2d('+') then
            do
                if RxQuQueryValue(QU_VALUE_VOLUME)<=90 then
                    call RxQuSetValue QU_VALUE_VOLUME, RxQuQueryValue(QU_VALUE_VOLUME)+10
            end
            when key=c2d('-') then
            do
                if RxQuQueryValue(QU_VALUE_VOLUME)>=10 then
                    call RxQuSetValue QU_VALUE_VOLUME, RxQuQueryValue(QU_VALUE_VOLUME)-10
            end
            otherwise nop
        end
    end
end

call SysCls

Quit:
    call RxQuTerm
    call RxQuDropFuncs
    exit

Init:
    QU_VALUE_PAUSE      = 1
    QU_VALUE_VOLUME     = 2
    QU_VALUE_LOOP       = 3
    QU_VALUE_SHUFFLE    = 4
    QU_VALUE_EQUALIZER  = 5
    QU_VALUE_MEMORY     = 6
    
    QU_EVENT_SONG       = 1
    QU_EVENT_FRAME      = 2
    QU_EVENT_DONE       = 3
    QU_EVENT_JUMP       = 4
    QU_EVENT_PAUSE      = 5
    
    QU_STATUS_OK	     = 0
    QU_STATUS_FILE_NOT_FOUND = 1
    QU_STATUS_INVALID_FORMAT = 2
    QU_STATUS_AUDIO_ERROR    = 3

    SetNormalColor='1b'x'[1;36;40m'
    SetHighlightColor='1b'x'[1;37;40m'
    SetStatusLineColor='1b'x'[0;30;46m'
    ClearLine='1b'x'[K'

    call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
    call SysLoadFuncs
    
    call RxFuncAdd 'RxQuLoadFuncs', 'QU2REXX', 'RxQuLoadFuncs'
    call RxQuLoadFuncs
return RxQuInit()

Analyze:
    do until cmdline=''
        cmdline = strip(cmdline)
        select
            when abbrev(cmdline, '-') then
            do
                parse upper var cmdline 2 option 3 cmdline
                select
                    when option='L' then call RxQuSetValue QU_VALUE_LOOP, 1
                    when option='Z' then call RxQuSetValue QU_VALUE_SHUFFLE, 1
                    when option='R' then call RxQuSetValue QU_VALUE_MEMORY, 1
                    when option='T' then testmode=1
                    otherwise do
                        say 'Unknown option: 'option
                        call Quit
                    end
                end
            end
            when abbrev(cmdline, '@') then
            do
                if abbrev(space(cmdline) ,'@"') then
                    parse var cmdline 3 argv '"' cmdline
                else
                    parse var cmdline 2 argv cmdline
                call RxQuLoadPlaylist argv, 'file'
                do i=1 to file.0
                    call RxQuAdd file.i
                end
            end
            otherwise
            do
                if abbrev(space(cmdline), '"') then
                    parse var cmdline 2 argv '"' cmdline
                else
                    parse var cmdline argv cmdline
                call SysFileTree argv, 'file', 'FO'
                do i=1 to file.0
                    call RxQuAdd file.i
                end
            end
        end
    end
return

Help:
    say 'Qu-Player/2 REXX Edition v0.99c (c) Anton Malykh, 1999-2000.'
    say 'Thanks to Andrew Cherepivsky.'
    say
    say 'Usage: qu2rexx [option(s)] [file(s)] [@filelist(s)]'
    say 'Supported options:'
    say '  -l    loop play                   -z    shuffle play'
    say '  -t    test mode                   -r    load into memory'
    say
    say 'To configuration please use Qu-Player CFG/2 program.'
return

DrawScreen:
    call SysCls
    call SysCurState 'OFF'
    say SetNormalColor'Qu-Player/2 REXX Edition v0.99c by Anton Malykh.'
    parse value SysTextScreenSize() with SysRows SysCols
    call SysCurPos SysRows-1, 0
    call charout, SetStatusLineColor||ClearLine
    call charout, '  Esc: Quit | PgUp/PgDown: Prev/Next song | P, <SPACE>: Pause | +/-: Volume'
return

Pause:
    if RxQuQueryValue(QU_VALUE_PAUSE) then
    do
    /* Pause */
        call SysCurPos 10, (SysCols-6)/2
        call charout, SetHighlightColor'Pause '
        do forever
            key=c2d(SysGetKey('NOECHO'))
            select
                when key=27 then
                do
                    quitflag=1
                    leave
                end
                when (key=224) | (key=0) then
                do
                    if key=1073 then do
                        call RxQuPrev
                        leave
                    end
                    if key=1081 then do
                        call RxQuNext
                        leave
                    end
                end
                when key=32 | key=c2d('p') then
                do
                    call RxQuSetValue QU_VALUE_PAUSE, 0
                    leave
                end
                otherwise nop
            end
        end
    end
    else
    do
    /* Resume */
        call SysCurPos 10, (SysCols-6)/2
        call charout, SetHighlightColor'      '
    end
return

QueryLongName: procedure
    parse arg filename
    EAT_ASCII='fdff'x  /* A type of '.LONGNAME' EA is ASCII */
    if SysGetEA(filename, '.longname', 'longname')\=0 then
        return ''
    parse var longname type 3 len 5 longname
    if type=EAT_ASCII then
    do
        len=c2d(reverse(len))
        return left(longname, len)
    end
return ''
