PROGRAM sample_player;
  {$X+}

USES os2def,os2base,cd2,crt,use32,vputils;
//{$DYNAMIC VPRTL.LIB}
//{$DYNAMIC UTILS.LIB}

CONST

  play		      : Boolean = False;
  { play track		}
  watch 	      : Boolean = False;
  { watch cd		}
  stop		      : Boolean = False;
  { stop drive		}
  resume	      : Boolean = False;
  { resume playing	}
  tracks	      : Boolean = False;
  { view tracks 	}
  OneTrack	     : Boolean = False;
  { play only one track }
  eject 	      : Boolean = False;
  { eject disk		}
  autoplay	      : Boolean = False;
  Continue	      : Boolean = False;
  { do not stop when program cd is placed into drive }
  WrongTrack	      : pchar=('Wrong Track');

VAR
  PlayFrom,
  PlayTo	      : Byte;
  result	      : Integer;
//DriveLetter	      : String[3];
  temporary	      : String[10];
  BeginEnd	      : CdStruct;
  TrackSize	      : TrackStartStop;
//begin and end of a track }
  HeadLocation	      : CurrentPosition;
  PlayStatus	      : ChannelQStatus;
  CurrentTrack	      : byte;
  UPC		      : UPCCode;

  counter:byte;

  // needed for watch param


  PROCEDURE CheckCommandLine;

  BEGIN
    temporary := ParamStr(1);

    IF temporary = 't' THEN
      //show tracks
      BEGIN
	tracks := True;
	Exit;
      END;

    IF temporary = 'p' THEN
      // play all tracks from
      BEGIN
	play := True;
	IF ParamCount < 2 THEN PlayFrom := FirstTrack
	ELSE
	  BEGIN
	    Val(ParamStr(2), PlayFrom, result);
	    // first track to play
	    IF result <> 0 THEN
	      BEGIN
		WriteLn(WrongTrack);
		Halt;
	      END;
	  END;

	IF ParamCount < 3 THEN PlayTo := LastTrack
	 ELSE
	  BEGIN
	    Val(ParamStr(3), PlayTo, result);
	    IF result <> 0 THEN
	      BEGIN
		WriteLn(Wrongtrack);
		Halt;
	      END;
	  END;
	Exit;
      END;

    IF (temporary = 'a') OR (temporary = 'A') THEN
      // auto play audio discs
      BEGIN
	autoplay := True;
	continue:=true;
	IF temporary = 'a' THEN Continue := False;
      END;


    IF temporary = 'P' THEN
      // play one track
      BEGIN
	play := True;
	Val(ParamStr(2), PlayFrom, result);
	IF result <> 0 THEN
	  BEGIN
	    WriteLn(WrongTrack);
	    Halt;
	  END;
	OneTrack := True;
	Exit;
      END;

    IF temporary = 's' THEN
      // stop playing
      BEGIN
	stop := True;
	Exit;
      END;

    IF temporary = 'w' THEN
      // watch
      BEGIN
	watch := True;
	Exit;
      END;

    IF temporary = 'r' THEN
      // resume playing
      BEGIN
	resume := True;
	Exit;
      END;

    IF temporary = 'e' THEN
      // eject
      BEGIN
	eject := True;
	Exit;
      END;

  END;

BEGIN
  WriteLn;
  WriteLn('Simple CD player 1.10');
  WriteLn;

  IF ParamStr(1) = '' THEN
    BEGIN
      // show help if no params are entered
      WriteLn('By Gerard Gerritsen ');
      WriteLn('based on the unit CD2');
      WriteLn;
      WriteLn('   s -> Stop playing ');
      WriteLn('   t -> Show all tracks ');
      WriteLn('   p -> Play a track until the end of the cd');
      WriteLn('   P -> Play only ONE track                 ');
      WriteLn('   w -> Watch drive playing ');
      WriteLn('   e -> Eject disk ');
      WriteLn('   r -> Resume playing ');
      WriteLn('   a -> Auto play ');
      WriteLn('   A -> Same as Auto Play, but will not stop when a ''normal''');
      WriteLn('        CD is inserted');
      WriteLn;
      Halt;
    END;

  CheckCommandLine;

  IF autoplay THEN
    BEGIN
      // now change priority to low priority
      DosSetPriority(2, 					      // a single thread of the process
		     1, 					      // idle time priority
		     10,					      // delta priority offset
		     0);					      // process number, our own

     Repeat
     Dossleep(2000);
     until InitCdrom(TrackPointer);


	BEGIN
	  REPEAT
	    IF ReInitCdRom(TrackPointer) THEN
	      BEGIN
		IF FirstTrack <> 0 THEN 	      // stop autoplaying when 'normal' cd is inserted
		  BEGIN
		    TrackPointer^[FirstTrack].stop := TrackPointer^[LastTrack].stop;
		    PlayTrack(TrackPointer^[FirstTrack]);
		    REPEAT
		      DosSleep(5500);
		    UNTIL NOT DiscInDrive;

		    CloseCdrom;
		  END;
	      END;
	    DosSleep(1500);

	  UNTIL (FirstTrack = 0) AND Continue;

	  WriteLn('Closing down');
	  CloseCdrom;
	  Halt;
	END;
end;

  IF InitCdrom(TrackPointer)
  THEN
    BEGIN
      CheckCommandLine;

      IF stop THEN StopPlaying;
      IF resume THEN ResumePlaying;
      IF eject THEN OpenTray;

      IF watch THEN
	BEGIN
	  clrscr;
	  HideCursor;
	  WriteLn('Press any key to stop watching');
	  WriteLn;
	  DosSetPriority(2,1,0,0);
	   if GetUPCCode(Upc) then		// not all drives support UPC ?
	     begin
		Write('UPC code is ');
	       for counter:=0 to 7 do Write(Lo(UPC.UPC[counter]),Hi(UPC.UPC[counter]));
	      Writeln;
	     end;
	 ClrSCr;
	  REPEAT
	    GotoXy(1,5);
	    HeadLocation:=GetCurrentLocation;
	    WriteLn('Current position is ', HeadLocation.current.minutes:2, ':',
		    HeadLocation.current.seconds:2, '.',
		    HeadLocation.current.frames:2);
	    CurrentTrack:=GetCurrentTrack;
	    Writeln('Current track : ',CurrentTrack,'   ');

	    DosSleep(1000);
	    //sleep for one second
	  UNTIL keypressed;
	  ShowCursor;
	 end;

      IF tracks THEN		// show number of tracks
	BEGIN
	  WriteLn('   There are ', LastTrack-FirstTrack+1, ' tracks');
	  WriteLn('   Beginning from track ', FirstTrack,
		  ' to track ', LastTrack);
	  Halt;
	END;

      IF play THEN
  //
  //	 Not needed since DosOpen took care of avoiding data cd's
  //
  //	  IF FirstTrack = 0 THEN
  //	    BEGIN
  //	      WriteLn('There is no audio disc in the drive');
  //	      Halt;
  //	    END
  //	  ELSE
	  BEGIN
	    IF PlayFrom < FirstTrack THEN PlayFrom := FirstTrack;
	    Write('Playing track ', PlayFrom);

	    IF OneTrack THEN PlayTo := PlayFrom ELSE
	      BEGIN
		IF PlayTo > LastTrack THEN PlayTo := LastTrack;
		TrackPointer^[PlayFrom].stop := TrackPointer^[PlayTo].stop;
		WriteLn(' to ', PlayTo);
	      END;

	    WriteLn;

	    // if not play until the end of the CD
	    IF NOT PlayTrack(TrackPointer^[PlayFrom])
	    THEN
	      WriteLn('The drive is probably playing a cd right now');
	  END;
      CloseCdrom;
    END
  ELSE WriteLn('I need an AUDIO cd in the drive in order to work, I''m sorry ');

END.
