UNIT CD2;

{
 A cdaudio unit for Virtual Pascal Version 1.0
 which makes use of the OS2 API.

 Please note, that "I" am not an "experienced" programmer and these
 routines could prove to be absolutely useless in the real world.

 I assert no promises or guarantees in relation to these routines.
 Nor do I claim any "rights" to their use. If however you make
 improvements to them, please drop me a line at one of the address below
 so I can update my routines.

 These routines are not complete, but should be enough to get a simple player
 working. ( i.e. functions should return APIRET instead of booleans )

 By Gerard Gerritsen,
 2:283/203.18 @fidonet.org
 1000521@et.fnt.hvu.nl

 written on 01-05-1996 but released 01-13-1996, due to circumstances
 ( new processor, unexpected but welcome night work etc. ( a local building had
   burned down a little bit, and they needed people to clean up the mess.... )
   And the most important reason, school :^(
 )

 version 1.02	-> removed 'debug' parts
		   improved play function

  version 1.1	-> easier interface,
  version 1.11	-> lowered memory requirements
  version 1.2	-> improved speed

 Thanks and greetings to:
 David Muir	  -> for posting his serial I/O routines with dosdevioctl...
		     and his disclaimer...
 Kiril Lebedev	  -> For sending the source of CrazyCdPm
 Eelco Dolstra	  -> For finding about 20 bugs...
 Irina Mikhailets -> for the nice postcard you sent me
 Ineka Sawyer	  -> ..................................................
 Ernst Steenbrink -> For some hints for the sample program

}

{&DELPHI+}

INTERFACE

USES OS2DEF, os2base;

  (* CONST *)

CONST
  // addresing mode
  MSF		      = 1;
  LOGICAL	      = 0;

  // device status
  Door_open	      = 1;   // door is open

  // b.t.w. checking if the door is open after obtaining a file handle,
  // will not work very well, since the door must be closed for dosopen to
  // work

  Door_locked	      = 2;   // door is locked
  Cooked_and_raw      = 4;   // device supports cooked & raw
  Read_and_write      = 8;   // device can read & write
  Audio_and_video     = 16;  // can play audio and video
  ISO_interleaving    = 32;  // supports ISO interleaving
  Prefetch_supported  = 128; // supports prefetch }
  Audio_manipulation  = 256; // support audio channel manipulation
  Logical_and_MSF_address = 512; // supports logical and MSF addresses
  Form_1_and_form_2   = 1024;  // support form 1 and form 2 sectors
  Disc_not_present    = 2048;  // Disc present...
  Playing_audio       = 4096;  // Drive is playing...

  (* TYPE  *)

TYPE

  CDSIG 	      = ARRAY[1..4] OF Char;

  VolumeControl       = RECORD
			  InpSelectChannel0,
			  VolumeChannel0,
			  InpSelectChannel1,
			  VolumeChannel1,
			  InpSelectChannel2,
			  VolumeChannel2,
			  InpSelectChannel3,
			  VolumeChannel3      : Byte;
			END;

  TrackPosition       = RECORD
			  frames,
			  seconds,
			  minutes	      : Byte;
			END;

  TrackStartStop      = RECORD
			  start,
			  stop		      : TrackPosition;
			END;

  CdStruct	      = RECORD
			  FirstTrack,
			  LastTrack	      : Byte
			END;

  CompleteCd	      = ARRAY[1..100] OF TrackStartStop;
  { Red Book does not say anything about more tracks... }

  completeCdPointer   = ^CompleteCd;

  CurrentPosition     = RECORD	 // MSF format
			  current	      : TrackPosition;
			  Dummy 	      : Byte;
			END;

  DeviceStatusParam   = RECORD
			  status	      : Ulong;
			END;

  UPCArray	      = ARRAY[0..7] OF Byte;

  UPCCode	      = RECORD
			  ADR		      : Byte;
			  UPC		      : UPCArray;
			  Reserved	      : Byte;
			  Frame 	      : Byte;
			END;

  ChannelQStatus      = RECORD
			  ADR		      : Byte;
			  Track 	      : Byte;
			  Index 	      : Byte;
			  Running	      : TrackPosition;
			  NullByte	      : Byte;
			  DiskTime	      : TrackPosition;
			END;

CONST
  DriveLetter	      : ARRAY[0..2] OF Char = ('I', ':', #0);

  (* VARIABLES *)

VAR
  DeviceHandle	      : hfile;
  TrackPointer	      : completeCdPointer;
  FirstTrack,
  LastTrack	      : Byte;
  Initialized	      : Boolean;

  (* INTERFACE FUNCTIONS *)

FUNCTION OpenCdrom(DriveLabel : PChar) : Boolean;
  // simply opens device driver

FUNCTION CloseCdrom : Boolean;
  // Closes cdrom. Returns true upon succes

FUNCTION DeviceStatus(VAR param : DeviceStatusParam)  : Boolean;
  // returns information about player and CD. Returns true upon succes

FUNCTION DiscInDrive : Boolean;
  // returns true if there is a CD in the drive

FUNCTION GetCurrentLocation:CurrentPosition;
  // Returns current position in MSF or LOGICAL block format
  // can be used regardless whether the drive is already playing
  // Returns true upon success

FUNCTION OpenTray   : Boolean;
  // Ejects disk i.e. duck for cover :^)

FUNCTION CloseTray  : Boolean;
  // Closes cdrom tray if open. Returns true upon success

FUNCTION StopPlaying : Boolean;
  // Stops playing. Returns true upon succes

FUNCTION ResumePlaying : Boolean;
  // Resumes playing. Returns true upon succes

FUNCTION QueryCdrom:CdStruct;
  // Returns first and last track. Returns true upon succes

FUNCTION QueryTrack(Track : Byte; VAR TrackPos : TrackStartStop) : Boolean;
  // Returns begin and endposition of a given track. Returns true upon success

FUNCTION PlayTrack(TrackPos : TrackStartStop) : Boolean;
  // Plays cd from start_of_track to end_of_track. Returns true upon succes
  // start_of_track&end_of_track are in MSF format
  // see record current_position for a description of the MSF format

FUNCTION InitCdrom(VAR TrackPointer : completeCdPointer) : Boolean;
  // Initializes cdrom
FUNCTION ReInitCdrom(VAR TrackPointer : completeCdPointer) : Boolean;
  // reinits drive }

Function GetCurrentTrack:Byte;
  // gets current track number
  // improved....

FUNCTION DiscPlaying : Boolean;
  // Tells if disc is playing right now

FUNCTION GetUpcCode(VAR UPC : UPCCode) : Boolean;
  // Gets Universal Product Code from CD     (see structure for more goodies)
  // Nobody seems to add then :^(, or my CDROM driver does not read them....
  // CdAudio also cannot read them, maybe IBM knows more about it ?

FUNCTION GetPlayStatus(VAR ChannelStatus : ChannelQStatus) : Boolean;
  // Gets running time on track/cd, track and index

FUNCTION SetCdVolume(VAR Volume : VolumeControl) : Boolean;
  // Set them...

FUNCTION GetCdVolume(VAR Volume : VolumeControl) : Boolean;
  // Get VolumeSettings from Player

FUNCTION CdVolumeUpLeft(Add : Byte) : Byte;
  // Increase volume with Add, and returns volume level
FUNCTION CdVolumeDownLeft(Sub : Byte) : Byte;
  // Decreases volume with Sub and returns volume level
FUNCTION CdVolumeUpRight(Add : Byte) : Byte;
  // Increase volume with Add, and returns volume level
FUNCTION CdVolumeDownRight(Sub : Byte) : Byte;
  // Decreases volume with Sub and returns volume level
function LengthOfCd:Ulong;
  // Gets length of CD
FUNCTION FindValidCdrom:boolean;
  // Tracks down cdrom drives in the system
PROCEDURE Seconds2MSF(second : Ulong; VAR Temporary : TrackPosition);
FUNCTION MSF2Seconds(VAR Time : TrackPosition) : Ulong;

IMPLEMENTATION

TYPE

  ReturnTracksParam   = RECORD
			  FirstLast	      : CdStruct;
			  EndLastTrack	      : TrackPosition;
			  Dummy 	      : Byte;
			END;

  LabelDrive	      = String[2];

  ReturnTrackCommand  = RECORD
			  Signature	      : CDSIG;
			  Track 	      : Byte;
			END;

  PlayTrackCommand    = RECORD
			  Signature	      : CDSIG;
			  AddressMode	      : Byte;
			  start 	      : TrackPosition;
			  DummyByte	      : Byte;
			  EndTrack	      : TrackPosition;
			  Dummy 	      : Byte;
			END;

  GetCurrentLocationCommand = RECORD
				   Signature	       : CDSIG;
				   AddressMode	       : Byte;
				 END;

  StandardCommand     = RECORD
			  Signature	      : CDSIG;
			END;

  ReturnTrackParam    = RECORD
			  BeginOfTrack	      : TrackPosition;
			  DummyByte	      : Byte;
			  track_ctl	      : Byte;
			END;

  StandardParam       = RECORD
			  Dummy 	      : Byte;
			END;


  (*	  Here are the functions and procedures 	  *)

  (*			  Variables	  *)

CONST
    Command:StandardCommand=(Signature:('C','D','0','1'));
    CommandSize:ulong=SizeOf(Command);

VAR
  CdStructure	      : ReturnTracksParam;
  // for internal reference

  FUNCTION StopPlaying : Boolean;
  BEGIN
    Result:=Not boolean(DosDevIoCtl(DeviceHandle, $81, $51, @command, SizeOf(CommandSize),
			@CommandSize, nil, 0, nil));
 end;

  FUNCTION CanPlayAudio : Boolean;

  VAR
    status		: DeviceStatusParam;

  BEGIN
    IF (DeviceStatus(status)) AND ((status.status AND Audio_and_video) = Audio_and_video)
	 THEN Result := True ELSE Result := False;
  END;

  FUNCTION DiscInDrive : Boolean;
  VAR
    status		: DeviceStatusParam;
  BEGIN
    IF DeviceStatus(status) and ((status.status AND Disc_not_present) = 0)
      THEN Result := True ELSE Result := False;
  END;

  FUNCTION DiscPlaying : Boolean;
  VAR
    status		: DeviceStatusParam;

  BEGIN
  if DeviceStatus(status) and ((status.status AND Playing_audio)= 0)
     THEN Result := False ELSE Result := True;
  END;

  FUNCTION DeviceStatus(VAR param : DeviceStatusParam) : Boolean;
  CONST ParamSize:ulong=SizeOf(DeviceSTatusParam);
  BEGIN
    Result:=not boolean(DosDevIoCtl(DeviceHandle, $80, $60, @command, SizeOf(command),
		   @CommandSize, @param, SizeOf(param), @ParamSize));
  END;

  FUNCTION IsCdrom    : Boolean;

  CONST
    Param:StandardCommand=(Signature:('C','D','0','1'));
    ParamSize:Ulong=SizeOf(Command);

  BEGIN
    Result:=(DosDevIoCtl(DeviceHandle, $80, $61, @command, SizeOf(command),
		   @CommandSize, @param, SizeOf(param), @ParamSize)=0)
    and (param.signature = command.signature );

  END;

  FUNCTION FindValidCdrom : Boolean;

  VAR
    counter		: Integer;
    DeviceLabel 	: String[3];

  BEGIN
    DeviceLabel[2] := ':';  // we need that
    DeviceLabel[3] := #0;
    FOR counter := Ord('C') TO Ord('Z') DO
      BEGIN
	DeviceLabel[1] := Char(counter);
	IF OpenCdrom(@DeviceLabel[1]) and IsCdrom THEN
	    BEGIN
	      Result := True;
	      DriveLetter[0] := Char(Counter);
	      Exit;
	    END
	   else
       CloseCdrom;	// to keep enough file handles free
       Result := False;
  END;
 end;

  FUNCTION GetCurrentLocation:CurrentPosition;
  CONST
    Command:GetCurrentLocationCommand=(Signature:('C','D','0','1');AddressMode:Msf);
    CommandSize:ulong=SizeOf(Command);
    ParamSize:ulong=SizeOf(CurrentPosition);
  BEGIN
    DosDevIoCtl(DeviceHandle, $80, $70, @command, SizeOf(command),
		   @CommandSize, @Result, SizeOf(Result), @ParamSize);
  end;

  { close tray }
  FUNCTION CloseTray  : Boolean;
  BEGIN
    Result:=Not Boolean(DosDevIoCtl(DeviceHandle, $80, $45, @command, SizeOf(command),
		   @CommandSize, nil, 0, nil));
  END;

  { ejects disk }
  FUNCTION OpenTray   : Boolean;
  BEGIN
    Result:=Not Boolean(DosDevIoCtl(DeviceHandle, $80, $44, @command, SizeOf(command),
		   @CommandSize, nil, 0, nil));
  END;

  { resume playing when playing had been stopped by StopPlaying }
  FUNCTION ResumePlaying : Boolean;
  BEGIN
    Result:=Not Boolean(DosDevIoCtl(DeviceHandle, $81, $52, @command, SizeOf(command),
		   @CommandSize, nil, 0, nil));
  END;

  { close cdrom drive }
  FUNCTION CloseCdrom : Boolean;
  BEGIN
    Initialized:=false;
    Result:=Not Boolean(dosclose(DeviceHandle));
  END;

  { opens cdrom drive and returns file handle to cdrom }

  FUNCTION OpenCdrom(DriveLabel : PChar) : Boolean;
  VAR
    action		: Ulong;
    { action taken by dosopen }

  BEGIN ;
    //	  DriveLabel[2] := #0;

    DosError(ferr_DisableHardErr);					// disables OS/2 popup errorbox
    Result:=Not boolean(dosopen(
	       DriveLabel,	    // FileName
	       DeviceHandle,	    // FileHandle
	       action,		    // Action taken by DosOpen
	       0,		    // FileSize :^)
	       file_normal,	    // Atributes
	       file_open OR open_action_open_if_exists OR open_action_fail_if_new,
	       Open_Access_readwrite OR Open_share_Denynone OR open_flags_dasd,
	       NIL));		     // No Ea's

// Open_Access_ReadWrite    -> only audio cd's
// If not, then Digital CD's will also be opened

//    THEN Result := True ELSE Result := False;
    DosError(ferr_EnableHardErr);						      // enables popups
  END;


  PROCEDURE ScanAllTracks;
  VAR
    counter		: Byte;
    cd			: CdStruct;

  begin
    cd:=QueryCdrom;
    LastTrack := cd.LastTrack;
    FirstTrack := cd.FirstTrack;
    FOR counter := FirstTrack TO LastTrack DO
      QueryTrack(counter, TrackPointer^[counter]);
    Exit;
   end;


  // initialize cdrom, checks if audio capable and closes tray
  // Somehow breaks Close Code for certain cdrom drives. Why ?
  // Beter is to uses FindValidCdrom and close the drive, and then isue a ReInitCdrom
  FUNCTION InitCdrom(VAR TrackPointer : completeCdPointer) : Boolean;

  BEGIN
    IF FindValidCdrom and CanPlayAudio then
      BEGIN
       ScanAllTracks;
       Result:=true;
       Initialized:=true;
       Exit;
      END;
    Result := False;
    CloseCdrom;
  END;

  // opens drive directly without searching for first valid drive
  FUNCTION ReInitCdrom(VAR TrackPointer : completeCdPointer) : Boolean;

  VAR
    counter		: Byte;
    cd			: CdStruct;

  BEGIN
    IF OpenCdrom(DriveLetter) THEN						 // open selected drive
      BEGIN
       Result:=true;
       Initialized:=true;
       ScanAllTracks;
       exit;
      END;
    Result:= False;
    CloseCdrom;

  END;

  // will return first and last track
  FUNCTION QueryCdrom: CdStruct;
  CONST
    ParamSize  : Ulong=SizeOf(ReturnTracksParam);

  VAR
    param		: ReturnTracksParam;

  BEGIN
    IF DosDevIoCtl(DeviceHandle, $81, $61, @command, SizeOf(command), @CommandSize,
		   @param, SizeOf(param), @ParamSize)=0
    THEN
      BEGIN
	CdStructure := param;
	//  make a reserve copy..
	Result := param.FirstLast;
      END
  END;

  // request begin and end location of track
  FUNCTION QueryTrack(Track : Byte; VAR TrackPos : TrackStartStop) : Boolean;
  CONST
  CommandSize:Ulong=SizeOf(ReturnTrackCommand);
  ParamSize:Ulong=SizeOf(ReturnTrackParam);
  Command:ReturnTrackCommand=(Signature:('C','D','0','1');Track:1);

  VAR
    param		: ReturnTrackParam;

  BEGIN
    BEGIN
      command.Track := Track;		     // what track to check ?

      Result:= not Boolean(DosDevIoCtl(DeviceHandle, $81, $62, @command, SizeOf(command),
		     @CommandSize, @param, SizeOf(param), @ParamSize));

      if not Result then exit;

      TrackPos.start := param.BeginOfTrack;
      IF command.Track >= CdStructure.FirstLast.LastTrack
	      THEN TrackPos.stop := CdStructure.EndLastTrack
	  ELSE
	   BEGIN
	   Inc(command.Track);
	   Result:=Not Boolean(DosDevIoCtl(DeviceHandle, $81, $62, @command, SizeOf(command),
			 @CommandSize, @param, SizeOf(param), @ParamSize));
	  TrackPos.stop := param.BeginOfTrack;
	END;
    END;
  END;

  // play cd from start to stop location
  FUNCTION PlayTrack(TrackPos : TrackStartStop) : Boolean;
  CONST
  Command:PlayTrackCommand=(Signature:('C','D','0','1');AddressMode:MSF;Start:(frames:0;seconds:0;minutes:0);
			    DummyByte:0;EndTrack:(frames:0;seconds:0;minutes:0);Dummy:0);
  CommandSize:Ulong=SizeOf(Command);
  VAR
    Retry		: Byte;
    Resul		: APIRET;

  BEGIN
    IF Initialized THEN
      BEGIN
	Retry := 0;
	command.start := TrackPos.start;
	command.EndTrack := TrackPos.stop;

	StopPlaying;

	REPEAT
	  Resul := DosDevIoCtl(DeviceHandle, $81, $50, @command, SizeOf(command),
				@CommandSize, nil, 0, nil);
	  Inc(Retry);

	UNTIL (Resul = 0) OR (Retry = 6);
	Result:=Not(Boolean(Resul));
      END;
  END;

  // Gets current track number
  function GetCurrentTrack:Byte;
  VAR Channel	      : ChannelQStatus;
  BEGIN
	GetPlayStatus(Channel);
	Result:= ((Channel.Track AND $f0) SHR 4)*10+(Channel.Track AND $f);
	// BCD encoded track number
  END;

  function LengthOfCd: Ulong;
  CONST
    ParamSize:Ulong=SizeOf(Ulong);

  BEGIN
    DosDevIoCtl(DeviceHandle, $80, $87, @command, SizeOf(command),
		@CommandSize, @Result, SizeOf(Result), @ParamSize);
  END;

  FUNCTION GetPlayStatus(VAR ChannelStatus : ChannelQStatus) : Boolean;

  CONST
    ParamSize:Ulong=SizeOf(ChannelQStatus);

  BEGIN
    Result:=Not boolean((DosDevIoCtl(DeviceHandle, $81, $63, @command, SizeOf(command),
		   @CommandSize, @ChannelStatus, SizeOf(ChannelStatus), @ParamSize)));
  END;

  FUNCTION GetUpcCode(VAR UPC : UPCCode) : Boolean;

  CONST
    ParamSize :Ulong=SizeOf(UPCCode);

  BEGIN
    Result:=not boolean(DosDevIoCtl(DeviceHandle, $80, $79, @command, SizeOf(command),
		   @CommandSize, @UPC, SizeOf(UPC), @ParamSize));
  END;

  FUNCTION GetCdVolume(VAR Volume : VolumeControl) : Boolean;

  CONST
    ParamSize:Ulong=SizeOf(VolumeControl);

  BEGIN
    Result:=not boolean(DosDevIoCtl(DeviceHandle, $81, $60, @command, SizeOf(command),
		   @CommandSize, @Volume, SizeOf(Volume), @ParamSize));
  END;

  FUNCTION CdVolumeUpLeft(Add : Byte) : Byte;
  VAR Volume	      : VolumeControl;

  BEGIN
    WITH Volume DO
      BEGIN
	GetCdVolume(Volume);
	IF VolumeChannel0 < 255-Add THEN inc(VolumeChannel0,Add) // VolumeChannel0 := VolumeChannel0+Add
	ELSE VolumeChannel0 := 255;
	SetCdVolume(Volume);
	Result:= VolumeChannel0;
      END;
  END;

  FUNCTION CdVolumeUpRight(Add : Byte) : Byte;
  VAR Volume	      : VolumeControl;

  BEGIN
    WITH Volume DO
      BEGIN
	GetCdVolume(Volume);
	IF VolumeChannel1 < 255-Add THEN Inc(VolumeChannel1,add) //VolumeChannel1 := VolumeChannel1+Add
	ELSE VolumeChannel1 := 255;
	SetCdVolume(Volume);
	Result := VolumeChannel1;
      END;
  END;

  FUNCTION CdVolumeDownLeft(Sub : Byte) : Byte;
  VAR Volume	      : VolumeControl;

  BEGIN
    WITH Volume DO
      BEGIN
	GetCdVolume(Volume);
	IF VolumeChannel0 > Sub THEN dec(VolumeChannel0,sub) //VolumeChannel0 := VolumeChannel0-Sub
	ELSE VolumeChannel0 := 0;
	SetCdVolume(Volume);
	Result := VolumeChannel0;
      END;
  END;

  FUNCTION CdVolumeDownRight(Sub : Byte) : Byte;
  VAR Volume	      : VolumeControl;

  BEGIN
    WITH Volume DO
      BEGIN
	GetCdVolume(Volume);
	IF VolumeChannel1 > Sub THEN Dec(VolumeChannel1,sub) // VolumeChannel1 := VolumeChannel1-Sub
	ELSE VolumeChannel1 := 0;
	SetCdVolume(Volume);
	Result := VolumeChannel1;
      END;
  END;

  FUNCTION SetCdVolume(VAR Volume : VolumeControl) : Boolean;

  CONST
    ParamSize:Ulong=SizeOf(VolumeControl);
  BEGIN
    Result:=Not Boolean(DosDevIoCtl(DeviceHandle, $81, $40, @command, SizeOf(command),
		   @CommandSize, @Volume, SizeOf(Volume), @ParamSize));
  END;

  { end of unit }
  { thank you for reading this.... <G> }

  PROCEDURE Seconds2MSF(second : Ulong; VAR Temporary : TrackPosition);
    // Conveert seconden om naar een track positie
  BEGIN
   With Temporary do
    begin
    if second=0 then exit;
    {$R-}
    minutes := second DIV 60;
    seconds := second MOD 60;
    frames  := 0;
   end;
  END;

  FUNCTION MSF2Seconds(VAR Time : TrackPosition) : Ulong;
   // Converteert minuten en seconden naar enkel seconden
  BEGIN
    WITH Time DO
      BEGIN
	IF seconds > 59 THEN seconds := 59;
	Result := seconds+minutes*60;
      END;
  END;

Initialization
  GetMem(TrackPointer, 100*SizeOf(CompleteCd)); 	{ max 99 tracks }
  Initialized:=false;
END.




