/* 

Pipe Mixer Base - A base module for pipe mixer demon by Lesha Bogdanow
Copyright (C) 1999-2000  Lesha Bogdanow

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#define USE_OS2_TOOLKIT_HEADERS
#define INCL_DOSPROCESS			   /* For init function */
#define INCL_BASE
#define INCL_ERRORS
#define INCL_DOSMODULEMGR
#define INCL_DOSSEMAPHORES
#define INCL_DOSFILEMGR
#define INCL_DOSQUEUES
#define INCL_DOSPROCESS
#define INCL_DOSMEMMGR
#define INCL_DOSDATETIME
#define INCL_DOSNMPIPES

#include <stddef.h>
#include <stdio.h>
#include <os2.h>
#include <stdlib.h>
#include "PipeMixPvt.h"

char pszPipeName[CCHMAXPATH+1]="\\PIPE\\MIXER";
unsigned long ApiLevel=1;
int InfoBufSize=0;
char *InfoBuf=NULL;
int Debug=FALSE;

int main(int argc, char *argv[]) {
   HPIPE hPipe;
   char Buff[PIPE_BUF_MAX+1];
   ULONG cbActual;
   ULONG ulRC;
   int cmd,p1,p2,p3,tokens;
   char **args;
   int i,j;
   char *tp;

   printf("\n%s\n",szLogo);
   args=malloc(sizeof(char *)*(argc+1));
   for (i=0,j=0;i<argc;i++) {
     if (!stricmp(argv[i],"-pn"))  {
        i++;
        if (i==argc) return FALSE;		// Syntax error
        strncpy(pszPipeName,argv[i],CCHMAXPATH);
        }
     else if (!stricmp(argv[i],"-v")) Debug=TRUE;
     else args[j++]=argv[i];
     }

   if (!MixerInit(j,args)) {
      fprintf(stderr,"ERROR: Unable to initialize mixer.\n");
      exit(1);
      }   

   if(DosCreateNPipe((char *)pszPipeName,&hPipe,NP_ACCESS_DUPLEX,
                     NP_WAIT|NP_TYPE_BYTE|NP_READMODE_BYTE|1,PIPE_BUF_MAX,
                     PIPE_BUF_MAX,0)) {
      fprintf(stderr,"ERROR: Unable to create pipe.\n");
      exit(1);
      }
   while(1) {
      if (Debug) printf("Waiting on pipe %s for command.\n",pszPipeName);
      if(DosConnectNPipe(hPipe)) {
         fprintf(stderr,"ERROR: Unable to connect pipe.\n");
         DosClose(hPipe);
         exit(1);
         }
      if (DosRead(hPipe,Buff,PIPE_BUF_MAX,&cbActual)) {
         fprintf(stderr,"ERROR: Failed to read from pipe.\n");
         DosClose(hPipe);
         exit(1);
         }
      Buff[cbActual]=0;
      tp=Buff;
      while ((*tp>=0x20)||(*tp==9)) {
         if (*tp==9) *tp=0x20;
         tp++;
         }
      *tp=0;
      if (Debug) printf("Got: \"%s\",",Buff);
      tokens=sscanf(Buff,"%x %d %d %x",&cmd,&p1,&p2,&p3);
      if (tokens) {
         if (cmd>0xF) _itoa(cmd,Buff,16);
         else {
            Buff[0]='0';
            _itoa(cmd,Buff+1,16);
            }
         strcat(Buff," ");
         if (cmd==0x80) _itoa(ApiLevel,Buff+strlen(Buff),10);	// API level
         else if (cmd==0x83) {					// Message buffer
            strncat(Buff,szLogo,PIPE_BUF_MAX);
            if (InfoBuf) {
               strncat(Buff,"\n",PIPE_BUF_MAX);
               strncat(Buff,InfoBuf,PIPE_BUF_MAX);
               }
            }
         else {
            if (tokens<2) p1=100;			// Default values
            if (tokens<3) p2=p1;
            if (tokens<4) p3=0;
            ProcessCmd(Buff,tokens,cmd,p1,p2,p3);
            }
         if (Debug) printf(" Responding: \"%s\"\n",Buff);
         ulRC=DosWrite(hPipe,Buff,strlen(Buff),&cbActual);
         if (ulRC||(cbActual!=strlen(Buff)))
            fprintf(stderr,"ERROR: Failed to write to pipe. %d\n",ulRC);
         }
      else if (Debug) printf("Ignoring empty command.\n");
      DosResetBuffer(hPipe);
      if(DosDisConnectNPipe(hPipe)) {
         fprintf(stderr,"ERROR: Unable to disconnect pipe.\n");
         DosClose(hPipe);
         exit(1);
         }
      }   
   }
