#include "PipeMix.h"

#define DEF_INFO_BUF_SIZE 128

/******************* VARIABLES *******************/

/* API Level. Defined in the base part and defaults to 1. Can be changed by
   hardware specific part. */
extern unsigned long ApiLevel;

/* Size and pointer to info buffer returned on command 83. Defined
   in the base part and default to 0 and NULL. Can be changed by
   hardware specific part. */
extern int InfoBufSize;
extern char *InfoBuf;

/* Debug mode if TRUE. Defined in the base part. Should not be changed by
   hardware specific part */
extern int Debug;

/* Logo text to be displayed on startup and to be returned on command 83.
   Must be defined in hardware specific part  */
extern const char szLogo[];


/************ FUNCTIONS (defined in hardware specific part) *************/


/* Initialize mixer. Return TRUE if Ok. argc and argv are command line
   parameters passed to main() without parameters handled by the base part
*/
int MixerInit(int argc, char *argv[]);

// Deinitialize mixer
void MixerClose();

/* Process a command. Buff is an output buffer, the function number and
   a trailing space are already there. tokens - number of command tokens
   cmd - command, p1, p2, p3 - parameters. If some of them are not specified
   then default values (p1=100, p2=p1, p3=0) are supplied.
*/
int ProcessCmd(char *Buff, int tokens, int cmd, int p1, int p2, int p3);
