;;;
;;;  Letter to sound rules for US English
;;;
;;;  Converted back from the convert British English version
;;;  Converted from C to Festival LTS format 
;;;  (awb@cstr.ed.ac.uk) September 10th 1996
;;;
;;;  This version was extracted from the ausay program 
;;;  text to speech program for net audio (nas) by
;;;  Steve Hocking <sysseh@devetir.qld.gov.au> but a
;;;  readme points at John A. Wasser who had some play
;;;  in the following code (whose address is given as
;;;  WASSER%VIKING.DEC@decwrl.ARPA and dated 4/15/85)
;;;  I reckon he is now wasser@ranger.enet.dec.com
;;;
;;;	English to Phoneme rules.
;;;	Derived from: 
;;;	     AUTOMATIC TRANSLATION OF ENGLISH TEXT TO PHONETICS 
;;;           BY MEANS OF LETTER-TO-SOUND RULES 
;;; 
;;;			NRL Report 7948 
;;; 
;;;		      January 21st, 1976
;;; 	    Naval Research Laboratory, Washington, D.C.
;;; 
;;;	Published by the National Technical Information Service as 
;;; document "AD/A021 929". 
;;;
;;;  Navy Research Laboratory Letter to Sound rules in Festival format
;;;  They've been converted a little to produce mrpa phoneset for 
;;;  British English, then converted back to US English
;;;

(lts.ruleset
 nrl_us
;;;  Sets
(
 (V a e i o u)
 (C b c d f g h j k l m n p q r s t v w x y z)
 (Cv b d v g j l m n r w z)   ;; voiced consonants
 (VF e i y )                  ;; a front vowel
 (TSRDLZNJ t s r d l z n j )
 (TCS t c s)
 (SCGZXJ s c g z x j)
 (RSD r s d)
 (SD s d)
 (OT o t)
 (SY s y)
)
;; The rule set
(
 ;; A rules
 (   [ a ]   # = ax )               ;; {Anything, "A", Nothing, "AX"},
 (   [ a h ] # = ah )
 ( # [ a r ] o = ax r )	           ;; {Nothing, "AR", "O", "AXr"},
 (   [ a r ] e d # = eh r ) 
 (   [ a r ] V = eh r )             ;; {Anything, "AR", "#", "EHr"},
 ( C [ a s ] V = ey s )            ;; {"^", "AS", "#", "EYs"},
 (   [ a ]   w a = ax )             ;; {Anything, "A", "WA", "AX"},
 (   [ a w ]     = ao )            ;; {Anything, "AW", Anything, "AO"},
 ( # C * [ a n y ] = eh n iy )        ;; {" :", "ANY", Anything, "EHnIY"},
 (   [ a ] C VF V + = ey )         ;; {Anything, "A", "^+#", "EY"},
 ( V + C * [ a l l y ] = ax l iy ) ;; {"#:", "ALLY", Anything, "AXlIY"},
 ( # [ a l ] V + = ax l )          ;; {Nothing, "AL", "#", "AXl"},
 (  [ a g a i n ] = ax g eh n )    ;; {Anything, "AGAIN", Anything, "AXgEHn"},
 ( V + C * [ a g ] e = ih jh )      ;; {"#:", "AG", "E", "IHj"},
 ( [ a ] C VF C * V + =  ae )       ;; {Anything, "A", "^+:#", "AE"},
 ( h [ a ] C VF = ae )
 ( # C * [ a ] C VF = ey )         ;; {" :", "A", "^+ ", "EY"},
 (  [ a ] C e # = ey )             ;; {Anything, "A", "^%", "EY"},
 (  [ a ] C e RSD # = ey )         ;; {Anything, "A", "^%", "EY"},
 (  [ a ] C e r SY # = ey )         ;; {Anything, "A", "^%", "EY"},
 (  [ a ] C e l y # = ey )         ;; {Anything, "A", "^%", "EY"},
 (  [ a ] C i n g # = ey )         ;; {Anything, "A", "^%", "EY"},
 ( # [ a r r ] = ax r )             ;; {Nothing, "ARR", Anything, "AXr"},
 (   [ a r r ] = ae r )             ;; {Anything, "ARR", Anything, "AEr"},
 ( # C * [ a r ] = aa r )            ;; {" :", "AR", Nothing, "AAr"},
 ( [ a r ] # = er r )              ;; {Anything, "AR", Nothing, "ER"},
 ( [ a r ] C  = er r)               ;; {Anything, "AR", Nothing, "ER"},
 ( [ a r ] V = aa r )              ;; {Anything, "AR", Anything, "AAr"},
 ( [ a i r ] = eh r)                ;; {Anything, "AIR", Anything, "EHr"},
 ( [ a i ] = ey )                  ;; {Anything, "AI", Anything, "EY"},
 ( [ a y ] = ey )                  ;; {Anything, "AY", Anything, "EY"},
 ( [ a u ] = ao )                  ;; {Anything, "AU", Anything, "AO"},
 ( V + C * [ a l ] # = ax l )      ;; {"#:", "AL", Nothing, "AXl"},
 ( V + C * [ a l s ] # = ax l z )  ;; {"#:", "ALS", Nothing, "AXlz"},
 ( [ a l k ] = ao k )              ;; {Anything, "ALK", Anything, "AOk"},
 ( [ a l ] C = ao l )              ;; {Anything, "AL", "^", "AOl"},
 ( # C * [ a b l e ] = ey b ax l ) ;; {" :", "ABLE", Anything, "EYbAXl"},
 ( [ a b l e ] = ax b ax l )       ;; {Anything, "ABLE", Anything, "AXbAXl"},
 ( [ a n g ] VE = ey n jh )        ;; {Anything, "ANG", "+", "EYnj"},
 ( [ a ] = ae )                     ;; {Anything, "A", Anything, "AE"},

;; B rules
 ( # [ b e ] C V + = b ih )       ;; {Nothing, "BE", "^#", "bIH"},
 ( [ b e i n g ] = b iy ih ng )   ;; {Anything, "BEING", Anything, "bIYIHNG"},
 ( # [ b u s ] V + = b ih z )     ;; {Nothing, "BUS", "#", "bIHz"},
 ( [ b u i l ] = b ih l )         ;; {Anything, "BUIL", Anything, "bIHl"},
 ( [ b ] = b )                    ;; {Anything, "B", Anything, "b"},

;; C rules
 ( # [ c h  ] C = k )              ;; {Nothing, "CH", "^", "k"},
 ( # [ c h ] a r a = k )
 ( C e [ c h ] = k )               ;; {"^E", "CH", Anything, "k"},
 ( i a r [ c h ] = k )          
 ( C [ c h ] # = ch )
 ( [ c h ] # = k )
 ( a r [ c h ] i n g  = ch )          
 ( a r [ c h ] e RSD = ch )          
 ( a r [ c h ] V = k )          
 ( a r [ c h ] y # = k )          
 ( [ c h ] = ch )                  ;; {Anything, "CH", Anything, "CH"},
 ( s [ c i ] V + = s ay )            ;; {" S", "CI", "#", "sAY"},
 ( [ c i ] a = sh )                ;; {Anything, "CI", "A", "SH"},
 ( [ c i ] o = sh )                ;; {Anything, "CI", "O", "SH"},
 ( [ c i ] e n = sh )              ;; {Anything, "CI", "EN", "SH"},
 ( [ c ] VF = s )                  ;; {Anything, "C", "+", "s"},
 ( [ c k ] = k )                   ;; {Anything, "CK", Anything, "k"},
 ( [ c o m ] e # = k ah m )        ;; {Anything, "COM", "%", "kAHm"},
 ( [ c o m ] e RSD # = k ah m )    ;; {Anything, "COM", "%", "kAHm"},
 ( [ c o m ] e l y # = k ah m )    ;; {Anything, "COM", "%", "kAHm"},
 ( [ c o m ] i n g # = k ah m )    ;; {Anything, "COM", "%", "kAHm"},
 ( [ c ] = k )                     ;; {Anything, "C", Anything, "k"},

;; D rules
 ( V + C * [ d e d ] # = d ih d)    ;; {"#:", "DED", Nothing, "dIHd"},
 ( Cv e [ d ] # = d )              ;; {".E", "D", Nothing, "d"},
 ( V + C * e [ d ] # = t )         ;; {"#^:E", "D", Nothing, "t"},
 ( # [ d e ] C V + = d ih )         ;; {Nothing, "DE", "^#", "dIH"},
 ( # [ d o e s ] = d ah z )        ;; {Nothing, "DOES", Anything, "dAHz"},
 ( # [ d o i n g ] = d uw ih ng )  ;; {Nothing, "DOING", Anything, "dUWIHNG"},
 ( # [ d o w ] = d aw )            ;; {Nothing, "DOW", Anything, "dAW"},
 ( [ d u ] a = jh uw )             ;; {Anything, "DU", "A", "jUW"},
 ( [ d ] = d )                     ;; {Anything, "D", Anything, "d"},

;; E rules
 ( V + C * [ e ] # = )             ;; {"#:", "E", Nothing, Silent},
;; ( \' C + [ e ] # = )              ;; {"'^:", "E", Nothing, Silent},
 ( # C * [ e ] # = iy )            ;; {" :", "E", Nothing, "IY"},
 ( V + [ e d ] # = d )             ;; {"#", "ED", Nothing, "d"},
 ( V + C * [ e ] d # = )           ;; {"#:", "E", "D ", Silent},
 ( [ e v ] e r = eh v )             ;; {Anything, "EV", "ER", "EHv"},
 ( [ e r ] e d = er r)  
 ( [ e r ] V + = eh r )             ;; {Anything, "ER", "#", "EHr"},
 ( [ e r ] = er r)                 ;; {Anything, "ER", Anything, "ER"},
 ( [ e ] C e # = iy )              ;; {Anything, "E", "^%", "IY"},
 ( [ e ] C e RSD # = iy )          ;; {Anything, "E", "^%", "IY"},
 ( [ e ] C e l y # = iy )          ;; {Anything, "E", "^%", "IY"},
 ( [ e ] C i n g # = iy )          ;; {Anything, "E", "^%", "IY"},
 ( [ e r i ] V + = iy r iy )       ;; {Anything, "ERI", "#", "IYrIY"},
 ( [ e r i ] = eh r ih )             ;; {Anything, "ERI", Anything, "EHrIH"},
 ( V + C * [ e r ] V + = er r)      ;; {"#:", "ER", "#", "ER"},
 ( # [ e v e n ] = iy v eh n )      ;; {Nothing, "EVEN", Anything, "IYvEHn"},
 ( V + C * [ e  w ] # = uw )       
 ( V + C * [ e ] w = )             ;; {"#:", "E", "W", Silent},
 ( TSRDLZNJ [ e w ] = uw )         ;; {"T", "EW", Anything, "UW"},
 ( TCS h [ e w ] = uw )            ;; {"TH", "EW", Anything, "UW"},
 ( [ e w ] = y uw )                ;; {Anything, "EW", Anything, "YUw"},
 ( [ e ] o = iy )                  ;; {Anything, "E", "O", "IY"},
 ( V + C * SCGZXJ [ e s ] # = ih z )  ;; {"#:S", "ES", Nothing, "IHz"},
 ( V + C * c h [ e s ] # = ih z )   ;; {"#:CH", "ES", Nothing, "IHz"},
 ( V + C * s h [ e s ] # = ih z )   ;; {"#:SH", "ES", Nothing, "IHz"},
 ( V + C * [ e ] s # = )           ;; {"#:", "E", "S ", Silent},
 ( V + C * [ e l y ] # = l iy )    ;; {"#:", "ELY", Nothing, "lIY"},
 ( V + C * [ e m e n t ] = m eh n t ) ;; {"#:", "EMENT", Anything, "mEHnt"},
 ( [ e f u l ] = f uh l )           ;; {Anything, "EFUL", Anything, "fUHl"},
 ( [ e e ] = iy )                  ;; {Anything, "EE", Anything, "IY"},
 ( [ e a r n ] = er r n )            ;; {Anything, "EARN", Anything, "ERn"},
 ( # [ e a r ] C = er r)            ;; {Nothing, "EAR", "^", "ER"},
 ( [ e a d ] = eh d )               ;; {Anything, "EAD", Anything, "EHd"},
 ( V + C * [ e a ] # = iy ax )        ;; {"#:", "EA", Nothing, "IYAX"},
 ( [ e a ] s u = eh )               ;; {Anything, "EA", "SU", "EH"},
 ( [ e a r ] C = er r)              ;; 
 ( [ e a r ] = ih r)                ;; 
 ( C [ e a u ] # = ou )
 ( C [ e a u x ] # = ou )
 ( [ e a ] = iy )                  ;; {Anything, "EA", Anything, "IY"},
 ( [ e i g h ] = ey )              ;; {Anything, "EIGH", Anything, "EY"},
 ( [ e i ] = ey )                  ;; {Anything, "EI", Anything, "IY"},
 ( [ e y e ] = ay )                ;; {Nothing, "EYE", Anything, "AY"},
 ( [ e y ] = iy )                  ;; {Anything, "EY", Anything, "IY"},
 ( [ e u ] = y uw )                ;; {Anything, "EU", Anything, "YUw"},
 ( [ e ] = eh )                     ;; {Anything, "E", Anything, "EH"},

;; F rules
 ( [ f u l ] = f uh l )             ;; {Anything, "FUL", Anything, "fUHl"},
 ( [ f ] = f )                     ;; {Anything, "F", Anything, "f"},

;; G rules 
 ( [ g i v ] = g ih v )             ;; {Anything, "GIV", Anything, "gIHv"},
 ( # [ g ] i C = g )               ;; {Nothing, "G", "I^", "g"},
 ( [ g e ] t = g eh )               ;; {Anything, "GE", "T", "gEH"},
 ( s u [ g g e s ] = g jh eh s )      ;; {"SU", "GGES", Anything, "gjEHs"},
 (  [ g g ] = g )                  ;; {Anything, "GG", Anything, "g"},
 ( # b V + [ g ] = g )             ;; {" B#", "G", Anything, "g"},
 ( [ g ] VF = jh )                 ;; {Anything, "G", "+", "j"},
 ( [ g r e a t ] = g r ey t )      ;; {Anything, "GREAT", Anything, "grEYt"},
 ( V + [ g h ] = )                 ;; {"#", "GH", Anything, Silent},
 ( [ g ] = g )                     ;; {Anything, "G", Anything, "g"},

;; H rules
 ( # [ h a v ] = hh ae v )           ;; {Nothing, "HAV", Anything, "hAEv"},
 ( # [ h e r e ] = hh iy r)        ;; {Nothing, "HERE", Anything, "hIYr"},
 ( # [ h o u r ] = aw er r)          ;; {Nothing, "HOUR", Anything, "AWER"},
 ( [ h o w ] = hh aw )              ;; {Anything, "HOW", Anything, "hAW"},
 ( [ h ] V + = hh )                 ;; {Anything, "H", "#", "h"},
 ( [ h ] = )                       ;; {Anything, "H", Anything, Silent},

;; I rules 
 ( # [ i n ] = ih n )               ;; {Nothing, "IN", Anything, "IHn"},
 ( [ i n ] d = ay n )              ;; {Anything, "IN", "D", "AYn"},
 ( [ i e r ] = iy  er r)             ;; {Anything, "IER", Anything, "IYER"},
 ( V + C * r [ i e d ] = iy d )    ;; {"#:R", "IED", Anything, "IYd"},
 ( [ i e d ] = ay d )              ;; {Anything, "IED", Nothing, "AYd"},
 ( [ i e n ] = iy eh n )           ;; {Anything, "IEN", Anything, "IYEHn"},
 ( [ i e ] t = ay e )              ;; {Anything, "IE", "T", "AYEH"},
 ( # C * [ i ] e # = ay )          ;; {" :", "I", "%", "AY"},
 ( # C * [ i ] e RSD # = ay )      ;; {" :", "I", "%", "AY"},
 ( # C * [ i ] e l y # = ay )      ;; {" :", "I", "%", "AY"},
 ( # C * [ i ] i n g # = ay )      ;; {" :", "I", "%", "AY"},
 ( [ i ] e # = iy )                ;; {Anything, "I", "%", "IY"},
 ( [ i ] e RSD # = iy )            ;; {Anything, "I", "%", "IY"},
 ( [ i ] e l y # = iy )            ;; {Anything, "I", "%", "IY"},
 ( [ i ] i n g # = iy )            ;; {Anything, "I", "%", "IY"},
 ( [ i e ] = iy )                  ;; {Anything, "IE", Anything, "IY"},
 ( [ i r ] e s = ay r )           ;; {Anything, "IR", "#", "AYr"},
 ( [ i r ] e d = ay r )           ;; {Anything, "IR", "#", "AYr"},
 ( [ i r ] V + = ay r )            ;; {Anything, "IR", "#", "AYr"},
 ( [ i ] C e # = ay )              ;;
 ( [ i ] C e RSD # = ay )          ;;
 ( [ i ] C e l y # = ay )          ;;
 ( [ i ] C i n g # = ay )          ;;
 ( [ i ] C V + C + = ih )           ;; {Anything, "I", "^+:#", "IH"},
 ( [ i z ] e # = ay z )            ;; {Anything, "IZ", "%", "AYz"},
 ( [ i z ] e RSD # = ay z )        ;; {Anything, "IZ", "%", "AYz"},
 ( [ i z ] e l y # = ay z )        ;; {Anything, "IZ", "%", "AYz"},
 ( [ i z ] i n g # = ay z )        ;; {Anything, "IZ", "%", "AYz"},
 ( [ i s ] e # = ay z )            ;; {Anything, "IS", "%", "AYz"},
 ( [ i s ] e RSD # = ay z )        ;; {Anything, "IS", "%", "AYz"},
 ( [ i s ] e l y # = ay z )        ;; {Anything, "IS", "%", "AYz"},
 ( [ i s ] i n g # = ay z )        ;; {Anything, "IS", "%", "AYz"},
 ( [ i ] d e # = ay )              ;; {Anything, "I", "D%", "AY"},
 ( [ i ] d e RSD # = ay )          ;; {Anything, "I", "D%", "AY"},
 ( [ i ] d e l y # = ay )          ;; {Anything, "I", "D%", "AY"},
 ( [ i ] d i n g # = ay )          ;; {Anything, "I", "D%", "AY"},
 ( VF C [ i ] VF = ih )             ;; {"+^", "I", "^+", "IH"},
 ( [ i ] t e # = ay )              ;; {Anything, "I", "T%", "AY"}, 
 ( [ i ] t e RSD # = ay )          ;; {Anything, "I", "T%", "AY"}, 
 ( [ i ] t e l y # = ay )          ;; {Anything, "I", "T%", "AY"}, 
 ( [ i ] t i n g # = ay )          ;; {Anything, "I", "T%", "AY"}, 
 ( V + C + [ i ] C VF = ih )        ;; {"#^:", "I", "^+", "IH"},
 ( [ i ] C VF = ay )               ;; {Anything, "I", "^+", "AY"},
 ( [ i r ] = er r)                  ;; {Anything, "IR", Anything, "ER"},
 ( [ i g h ] = ay )                ;; {Anything, "IGH", Anything, "AY"},
 ( [ i l d ] = ay l d )            ;; {Anything, "ILD", Anything, "AYld"},
 ( [ i g n ] # = ay n )            ;; {Anything, "IGN", Nothing, "AYn"},
 ( [ i g n ] C = ay n )            ;; {Anything, "IGN", "^", "AYn"},
 ( [ i g n ] e # = ay n )          ;; {Anything, "IGN", "%", "AYn"},
 ( [ i g n ] e RSD # = ay n )      ;; {Anything, "IGN", "%", "AYn"},
 ( [ i g n ] e l y # = ay n )      ;; {Anything, "IGN", "%", "AYn"},
 ( [ i g n ] i n g # = ay n )      ;; {Anything, "IGN", "%", "AYn"},
 ( [ i q u e ] = iy k )            ;; {Anything, "IQUE", Anything, "IYk"},
 ( [ i c r ] = ay k r )
 ( [ i ] = ih )                     ;; {Anything, "I", Anything, "IH"},

;; J rules
 ( [ j ] = jh )                    ;; {Anything, "J", Anything, "j"},
 
;; K rules
 ( [ k ] n = )                     ;; {Nothing, "K", "N", Silent},
 ( [ k ] = k )                     ;; {Anything, "K", Anything, "k"},

;; L rules 
 ( [ l o ] c V + = l ow )          ;; {Anything, "LO", "C#", "lOW"},
 ( l [ l ] = )                     ;; {"L", "L", Anything, Silent},
 ( V + C + [ l ] e # = ax l )       ;; {"#^:", "L", "%", "AXl"},
 ( V + C + [ l ] e RSD # = ax l )   ;; {"#^:", "L", "%", "AXl"},
 ( V + C + [ l ] e l y # = ax l )   ;; {"#^:", "L", "%", "AXl"},
 ( V + C + [ l ] i n g # = ax l )   ;; {"#^:", "L", "%", "AXl"},
 ( [ l e a d ] = l iy d )          ;; {Anything, "LEAD", Anything, "lIYd"},
 ( [ l ] = l )                     ;; {Anything, "L", Anything, "l"},

;; M rules 
 ( [ m o v ] = m uw v )            ;; {Anything, "MOV", Anything, "mUWv"},
 ( [ m ] = m )                     ;; {Anything, "M", Anything, "m"},

;; N rules 
 ( e [ n g ] VF = n jh )           ;; {"E", "NG", "+", "nj"},
 ( [ n g ] r = ng g )              ;; {Anything, "NG", "R", "NGg"},
 ( [ n g ] V + = ng g )            ;; {Anything, "NG", "#", "NGg"},
 ( [ n g l ] e # = ng g ax l )      ;; {Anything, "NGL", "%", "NGgAXl"},
 ( [ n g l ] e RSD # = ng g ax l )  ;; {Anything, "NGL", "%", "NGgAXl"},
 ( [ n g l ] e l y # = ng g ax l )  ;; {Anything, "NGL", "%", "NGgAXl"},
 ( [ n g l ] i n g # = ng g ax l )  ;; {Anything, "NGL", "%", "NGgAXl"},
 ( [ n g ] = ng )                  ;; {Anything, "NG", Anything, "NG"},
 ( [ n k ] = ng k )                ;; {Anything, "NK", Anything, "NGk"},
 ( [ n ] = n )                     ;; {Anything, "N", Anything, "n"},

;; O rules
 ( [ o f ] # = ax v )               ;; {Anything, "OF", Nothing, "AXv"},
 ( [ o r o u g h ] = er r ow )     ;; {Anything, "OROUGH", Anything, "EROW"},
 ( V + C * [ o r ] # = er r)        ;; {"#:", "OR", Nothing, "ER"},
 ( V + C * [ o r s ] # = er r z )    ;; {"#:", "ORS", Nothing, "ERz"},
 ( [ o r ] = ao r)                  ;; {Anything, "OR", Anything, "AOr"},
 ( # [ o n e ] = w ah n )          ;; {Nothing, "ONE", Anything, "wAHn"},
 ( [ o w ] = ow )                  ;; {Anything, "OW", Anything, "OW"},
 ( # [ o v e r ] = ow v er r)        ;; {Nothing, "OVER", Anything, "OWvER"},
 ( # [ o v ] = ah v )              ;; {Anything, "OV", Anything, "AHv"},
 ( [ o ] C e # = ow )              ;; {Anything, "O", "^%", "OW"},
 ( [ o ] C e RSD # = ow )          ;; {Anything, "O", "^%", "OW"},
 ( [ o ] C e l y # = ow )          ;; {Anything, "O", "^%", "OW"},
 ( [ o ] C i n g # = ow )          ;; {Anything, "O", "^%", "OW"},
 ( [ o ] C e n  = ow )             ;; {Anything, "O", "^EN", "OW"},
 ( [ o ] C i V + = ow )            ;; {Anything, "O", "^I#", "OW"},
 ( [ o l ] d = ow l )              ;; {Anything, "OL", "D", "OWl"},
 ( [ o u g h t ] = ao t )          ;; {Anything, "OUGHT", Anything, "AOt"},
 ( [ o u g h ] = ah f )            ;; {Anything, "OUGH", Anything, "AHf"},
 ( # [ o u ] = aw )                ;; {Nothing, "OU", Anything, "AW"},
 ( h [ o u ] s V + = aw )          ;; {"H", "OU", "S#", "AW"},
 ( [ o u s ] = ax s )               ;; {Anything, "OUS", Anything, "AXs"},
 ( [ o u r ] = ao r )               ;;  {Anything, "OUR", Anything, "AOr"},
 ( [ o u l d ] = uh d )             ;; {Anything, "OULD", Anything, "UHd"},
 ( C [ o u ] C l = ah )            ;; {"^", "OU", "^L", "AH"},
 ( [ o u p ] = uw )                ;; {Anything, "OUP", Anything, "UWp"},
 ( [ o u ] = aw )                  ;; {Anything, "OU", Anything, "AW"},
 ( [ o y ] = oy )                  ;; {Anything, "OY", Anything, "OY"},
 ( [ o i n g ] = ow ih ng )         ;; {Anything, "OING", Anything, "OWIHNG"},
 ( [ o i ] = oy )                  ;; {Anything, "OI", Anything, "OY"},
 ( [ o o r ] = ao r)                ;; {Anything, "OOR", Anything, "AOr"},
 ( [ o o k ] = uh k )               ;; {Anything, "OOK", Anything, "UHk"},
 ( [ o o d ] = uh d )               ;; {Anything, "OOD", Anything, "UHd"},
 ( [ o o ] = uw )                  ;; {Anything, "OO", Anything, "UW"},
 ( [ o ] e = ow )                  ;; {Anything, "O", "E", "OW"},
 ( [ o ] # = ow )                  ;; {Anything, "O", Nothing, "OW"},
 ( [ o a ] = ow )                  ;; {Anything, "OA", Anything, "OW"},
 ( # [ o n l y ] = ow n l iy )     ;; {Nothing, "ONLY", Anything, "OWnlIY"},
 ( # [ o n c e ] = w ah n s )      ;; {Nothing, "ONCE", Anything, "wAHns"},
;; ( [ o n \' t ] = ow n t )       ;; {Anything, "ON'T", Anything, "OWnt"},
 ( c [ o ] n = aa )                ;; {"C", "O", "N", "AA"},
 ( [ o ] n g = ao )                ;; {Anything, "O", "NG", "AO"},
 ( C + [ o ] n = ah )              ;; {"^:", "O", "N", "AH"},
 ( i [ o n ] = ax n )              ;; {"I", "ON", Anything, "AXn"},
 ( V + C * [ o n ] # = ax n )      ;; {"#:", "ON", Nothing, "AXn"},
 ( V + C [ o n ] = ax n )          ;; {"#^", "ON", Anything, "AXn"},
 ( [ o ] s t # = ow )              ;; {Anything, "O", "ST ", "OW"},
 ( [ o f ] C = ao f )              ;; {Anything, "OF", "^", "AOf"},
 ( [ o t h e r ] = ah dh er r)       ;; {Anything, "OTHER", Anything, "AHDHER"},
 ( [ o s s ] # = ao s )            ;; {Anything, "OSS", Nothing, "AOs"},
 ( V + C * [ o m ] = ah m )        ;; {"#^:", "OM", Anything, "AHm"},
 ( [ o ] = aa )                    ;; {Anything, "O", Anything, "AA"},

;; P rules
 ( [ p h ] = f )                   ;; {Anything, "PH", Anything, "f"},
 ( [ p e o p ] = p iy p )          ;; {Anything, "PEOP", Anything, "pIYp"},
 ( [ p o w ] = p aw )              ;; {Anything, "POW", Anything, "pAW"},
 ( [ p u t ] = p uh t )            ;; {Anything, "PUT", Nothing, "pUHt"},
 ( [ p ] = p )                     ;; {Anything, "P", Anything, "p"},

;; Q rules
 ( [ q u a r ] = k w ao r)          ;; {Anything, "QUAR", Anything, "kwAOr"},
 ( C [ q u e ] # = k )                 ;; {Anything, "QU", Anything, "kw"},
 ( V [ q u e ] # = k )                 ;; {Anything, "QU", Anything, "kw"},
 ( [ q u ] = k w )                 ;; {Anything, "QU", Anything, "kw"},
 ( [ q ] = k )                     ;; {Anything, "Q", Anything, "k"},

;; R rules 
 ( # [ r e ] C V + = r iy )        ;; {Nothing, "RE", "^#", "rIY"},
 ( t [ r e ] # = er r)               ;; centre
 ( # [ r h ] = r )
 ( [ r ] = r )                     ;; {Anything, "R", Anything, "r"},

;; S rules
 ( [ s h ] = sh )                  ;; {Anything, "SH", Anything, "SH"},
 ( V + [ s i o n ] = zh ax n )      ;; {"#", "SION", Anything, "ZHAXn"},
 ( [ s o m e ] = s ah m )          ;; {Anything, "SOME", Anything, "sAHm"},
 ( V + [ s u r ] V + = zh er r)     ;; {"#", "SUR", "#", "ZHER"},
 ( [ s u r ] V + = sh er r)         ;; {Anything, "SUR", "#", "SHER"},
 ( V + [ s u ] V + = zh uw )       ;; {"#", "SU", "#", "ZHUW"},
 ( V + [ s s u ] V + = sh uw )     ;; {"#", "SSU", "#", "SHUW"},
 ( V + [ s e d ] # = z d )         ;; {"#", "SED", Nothing, "zd"},
 ( V + [ s ] V + = z )             ;; {"#", "S", "#", "z"},
 ( [ s a i d ] = s eh d )           ;; {Anything, "SAID", Anything, "sEHd"},
 ( C [ s i o n ] = sh ax n )        ;; {"^", "SION", Anything, "SHAXn"},
 ( [ s ] s = )                     ;; {Anything, "S", "S", Silent},
 ( Cv [ s ] # = z )                ;; {".", "S", Nothing, "z"},
 ( V + C * Cv e [ s ] # = z )      ;; {"#:.E", "S", Nothing, "z"},
 ( V + C + V V + [ s ] # = z )     ;; {"#^:##", "S", Nothing, "z"},
 ( V + C + V + [ s ] # = s )       ;; {"#^:#", "S", Nothing, "s"},
 ( u [ s ] # = s )                 ;; {"U", "S", Nothing, "s"},
 ( # C + V + [ s ] # = z )           ;; {" :#", "S", Nothing, "z"},
 ( [ s c h ] = s k )               ;; {Nothing, "SCH", Anything, "sk"},
 ( [ s ] c VF = )                  ;; {Anything, "S", "C+", Silent},
 ( V + [ s m ] = z m )             ;; {"#", "SM", Anything, "zm"},
 ( V + [ s n ] = z ax n )           ;; {"#", "SN", "'", "zAXn"},
 ( [ s ] = s )                     ;; {Anything, "S", Anything, "s"},

;; T rules 
 ( [ t o ] # = t uw )              ;; {Anything, "TO", Nothing, "tUW"},
 ( # [ t h e y ] = dh ey )         ;; {Nothing, "THEY", Anything, "DHEY"},
 ( # [ t h e r e ] = dh eh )       ;; {Nothing, "THERE", Anything, "DHEHr"},
 ( [ t h e r ] = dh er r)           ;; {Anything, "THER", Anything, "DHER"},
 ( [ t h e i r ] = dh eh r)        ;; {Anything, "THEIR", Anything, "DHEHr"},
 ( [ t h e s e ] # = dh iy z )     ;; {Anything, "THESE", Nothing, "DHIYz"},
 ( [ t h e n ] = dh eh n )         ;; {Nothing, "THEN", Anything, "DHEHn"},
 ( [ t h r o u g h ] = th r uw )   ;; {Anything, "THROUGH", Anything, "THrUW"},
 ( [ t h o s e ] = dh ow z )       ;; {Anything, "THOSE", Anything, "DHOWz"},
 ( [ t h o u g h ] = dh ow )       ;; {Anything, "THOUGH", Nothing, "DHOW"},
 ( [ t h u s ] = dh ah s )         ;; {Nothing, "THUS", Anything, "DHAHs"},
 ( [ t h ] = th )                  ;; {Anything, "TH", Anything, "TH"},
 ( V + C * [ t e d ] # = t ih d )  ;; {"#:", "TED", Nothing, "tIHd"},
 ( s [ t i ] V + n = ch )          ;; {"S", "TI", "#N", "CH"},
 ( [ t i ] o = sh )                ;; {Anything, "TI", "O", "SH"},
 ( [ t i ] a = sh )                ;; {Anything, "TI", "A", "SH"},
 ( [ t i e n ] = sh ax n )          ;; {Anything, "TIEN", Anything, "SHAXn"},
 ( [ t u r ] V + = ch er r)         ;; {Anything, "TUR", "#", "CHER"},
 ( [ t u ] a = ch uw )             ;; {Anything, "TU", "A", "CHUW"},
 ( # [ t w o ] = t uw )            ;; {Nothing, "TWO", Anything, "tUW"},
 ( [ t ] = t )                     ;; {Anything, "T", Anything, "t"},

;; U rules 
 ( # [ u n ] i = y uw n )          ;;{Nothing, "UN", "I", "yUWn"},
 ( # [ u n ] = ah n )              ;; {Nothing, "UN", Anything, "AHn"},
 ( # [ u p o n ] = ax p ao n )      ;; {Nothing, "UPON", Anything, "AXpAOn"},
 ( TSRDLZNJ [ u r ] V + = uh r )    ;; {"T", "UR", "#", "UHr"},
 ( TCS h [ u r ] V + = uh r )       ;; {"TH", "UR", "#", "UHr"},
;;  ( [ u r ] e SD = y uh r)
 ( [ u r ] V + = y uh r )           ;; {Anything, "UR", "#", "yUHr"},
 ( [ u r ] = er r)                  ;; {Anything, "UR", Anything, "ER"},
 ( [ u ] C # = ah )                ;; {Anything, "U", "^ ", "AH"},
 ( [ u ] C C = ah )                ;; {Anything, "U^^", Anything, "AH"},
 ( [ u y ] = ay )                  ;; {Anything, "UY", Anything, "AY"},
 ( # g [ u ] V + = )               ;; {" G", "U", "#", Silent},
 ( g [ u ] e # = )                 ;; {"G", "U", "%", Silent},
 ( g [ u ] e RSD # = )             ;; {"G", "U", "%", Silent},
 ( g [ u ] e l y # = )             ;; {"G", "U", "%", Silent},
 ( g [ u ] i n g # = )             ;; {"G", "U", "%", Silent},
 ( g [ u ] V + = w )               ;; {"G", "U", "#", "w"},
 ( V + n [ u ] = y uw )            ;; {"#N", "U", Anything, "YUw"},
 ( TSRDLZNJ [ u ] = uh )            ;; {"T", "U", Anything, "UH"},
 ( TCS h [ u ] = uh )               ;; {"TH", "U", Anything, "UH"},
 ( [ u ] = uh )                     ;; {Anything, "U", Anything, "UH"},

;; V rules
 ( [ v i e w ] = v y uw )        ;; {Anything, "VIEW", Anything, "vYUw"},
 ( [ v ] = v )                     ;; {Anything, "V", Anything, "v"},

;; W rules 
 ( # [ w e r e ] = w er r )          ;; {Nothing, "WERE", Anything, "wER"},
 ( [ w a ] s = w aa )               ;; {Anything, "WA", "S", "wAA"},
 ( [ w a ] t = w aa )               ;; {Anything, "WA", "T", "wAA"},
 ( [ w e r e ] = w eh r )            ;; {Anything, "WERE", Anything, "WHEHr"},
 ( [ w h e r e ] = w eh r)          
 ( [ w h a t ] = w aa t )           ;; {Anything, "WHAT", Anything, "WHAAt"},
 ( [ w h o l ] = h ow l )          ;; {Anything, "WHOL", Anything, "hOWl"},
 ( [ w h o ] = hh uw )              ;; {Anything, "WHO", Anything, "hUW"},
 ( [ w h ] = w )                   ;; {Anything, "WH", Anything, "WH"},
 ( [ w a r e ] = w eh r)
 ( [ w a r ] = w ao r)              ;; {Anything, "WAR", Anything, "wAOr"},
 ( [ w o r ] C = w er r)            ;; {Anything, "WOR", "^", "wER"},
 ( [ w r ] = r )                   ;; {Anything, "WR", Anything, "r"},
 ( [ w ] = w )                     ;; {Anything, "W", Anything, "w"},

;; X rules
 ( [ x ] = k s )                   ;; {Anything, "X", Anything, "ks"},

;; Y rules 
 ( [ y o u n g ] = y ah ng )       ;; {Anything, "YOUNG", Anything, "yAHNG"},
 ( # [ y o u ] = y uw )            ;; {Nothing, "YOU", Anything, "yUW"},
 ( # [ y e s ] = y eh s )           ;; {Nothing, "YES", Anything, "yEHs"},
 ( # [ y ] C = iy )                
 ( # [ y ] = y )                   ;; {Nothing, "Y", Anything, "y"},
 ( V + C + [ y ] # = iy )          ;; {"#^:", "Y", Nothing, "IY"},
 ( V + C + [ y ] i = iy )          ;; {"#^:", "Y", "I", "IY"},
 ( # C + [ y ] # = ay )              ;; {" :", "Y", Nothing, "AY"},
 ( # C + [ y ] V + = ay )            ;; {" :", "Y", "#", "AY"},
 ( # C + [ y ] C VF V + = ih )        ;; {" :", "Y", "^+:#", "IH"},
 ( # C + [ y ] C V + = ay )          ;; {" :", "Y", "^#", "AY"},
 ( # C + [ y ] C V + = ay )          ;; {" :", "Y", "^#", "AY"},
 ( [ y ] = ih )                     ;; {Anything, "Y", Anything, "IH"},

;; Z rules 
 ( [ z ] = z )                     ;; {Anything, "Z", Anything, "z"},
))

(provide 'lts_nrl_us)
