/********************************************************************/
/*                                                                  */
/* COPY2CD: Version 1.4                                             */
/* Author: Michel SUCH. Email: msuch@free.fr                        */
/*                                                                  */
/* Purpose: Copy the content of a directory                         */
/* and subdirectories to CD                                         */
/* You can also copy a single file.                                 */
/*                                                                  */
/* This program requires several components to be installed         */
/*                                                                  */
/* 1: CDRECORD/2 at minimal level 1.8a19                            */
/*                                                                  */
/* 2: EMXRT libraries 0.9d with fixpack 1.                          */
/*                                                                  */
/* 3: SPE.ZIP package from HOBBES                                   */
/* if you plan to use direct copy option                            */
/*                                                                  */
/* All components may be obtained on HOBBES: http://hobbes.nmsu.edu */
/*                                                                  */
/* Note: All components except EMXRT must be installed in the same  */
/* directory.                                                       */
/*                                                                  */
/********************************************************************/

   parse arg parms
   say "COPY2CD Version 1.4, 1999-10-16"
   say "Author: Michel SUCH, Email: msuch@free.fr"
   say ""
   call getparms
   if base = '' then call help
   basefile = translate(base, '/', '\')
   call init_prog
   if direct = 1 then call direct_copy
   else do
      "@"cdromreader "-a -f -l -L -R -v -o" tempraw basefile
      if rc <> 0 then do
         say "Error reading files rc="rc
         call exit_proc rc
      end
      call write_cd
   end
   if ncopies = 1 then
      say "CD recorded successfuly."
   else
      say "CDs recorded successfuly."
   call exit_proc rc
exit


getparms:

   ncopies = ''
   quiet = ''
   base = ''
   dummy = ''
   direct = 0
   do i = 1 to words(parms)
      parm = word(parms, i)
      keyword = translate(parm)
      select
         when keyword = '-Q' then do
            if quiet = '' then quiet = 1
            else call badparm "duplicate parameter"
         end
         when keyword = '-DIRECT' then do
            if direct = 0 then direct = 1
            else call badparm "duplicate parameter"
         end
         when substr(keyword, 1, 4) = '-NC:' then do
            if ncopies = '' then do
               ncopies = substr(keyword, 5)
               if datatype(ncopies) <> 'NUM' then
                  call badparm "Invalid number of copies"
            end
            else call badparm "duplicate parameter"
         end
         when keyword = '-DUMMY' | keyword = '-TEST' then do
            if dummy = '' then dummy = '-dummy'
            else call badparm "Duplicate parameter"
         end
         when keyword = '-H' then call help
         otherwise do
            if base = '' then base = parm
            else call badparm "Invalid parameter"
         end
      end
   end
   if ncopies = '' then ncopies = 1
   if quiet = '' then quiet = 0
return /* getparms */


badparm:

   parse arg msg
   say parm":" msg
   say "Type: COPY2CD -h for help"
   call exit_proc 60
   exit /* badparm */


help:

   say "Syntax: COPY2CD basefile [options]"
   say "   where basefile is the full path to the file or directory to copy"
   say "   Options:"
   say "   -nc:x - Number of copies (default 1)"
   say "   -direct - Direct copy to CD, do not use temporary file"
   say "   -dummy/-test - do everything with laser turned off"
   say "   -q - run in quiet mode: do not ask to insert the disks"
   say "   -h - Display this help screen"
   exit /* help */


init_prog:


/*------------------- Init Rexxutil-----------------------------------*/
   If RXFUNCQUERY('SysLoadFuncs') Then Do
      Call rxfuncadd 'SysLoadFuncs', 'REXXUTIL', 'SYSLOADFUNCS'
      Call sysloadfuncs
   End

   parse source . . progname .
   mydir = filespec('d', progname) || filespec('p', progname)
   cdromreader = mydir || 'MKISOFS.EXE'
   writer = mydir || 'CDRECORD.EXE'
   spe = mydir || "spe.exe t28"
   call readcfg
   if savedir = '' then savedir = mydir || "SAVEDISK"
   org = directory()
   dir = directory(savedir)
   if translate(dir) <> translate(savedir) then do
      ret = sysmkdir(savedir)
      if ret <> 0 then do
         say "Cannot create directory" savedir
         call exit_proc 40
      end
      dir = directory(savedir)
   end
   tempraw = 'temp.raw'
   cdtype = '-data'
   call check_emx
   if outdev = '' then call get_cdr
   call cleanup
return /* init_prog */


readcfg:

   savedir = ''
   indrive = ''
   outdev = ''
   maxspeed = ''
   config = mydir'cdcopy.cfg'
   i = 0
   do while lines(config) > 0
      i = i + 1
      line = translate(linein(config))
      parse var line cmd';'comment
      cmd = strip(cmd)
      if cmd = '' then iterate
      parse var cmd keyword'='value
      value = strip(value)
      if value = '' then call badcfg
      keyword = strip(keyword)
      select
         when keyword = 'CD-R' then do
            if outdev = '' then outdev = value
            else call badcfg "Duplicate CD-R ID"
         end
         when keyword = 'SPEED' then do
            if maxspeed = '' then maxspeed = value
            else call badcfg "Duplicate speed definition"
            if wordpos(maxspeed, '1 2 4 6 8') = 0 then
               call badparm "Speed value can be 1, 2, 4, 6 or 8"
         end
         when keyword = 'CD-ROM' then do
            if indrive = '' then indrive = value
            else call badcfg "Duplicate CD-ROM unit letter"
         end
         when keyword = 'DIRECTORY' then do
            if savedir = '' then savedir = value
            else call badcfg "duplicate save directory definition"
         end
         otherwise call badcfg
      end
   end
   call stream config, 'c', 'close'
   if maxspeed = '' & direct = 1 then do
      Say "You cannot use the -direct option"
      say "if the CDR speed is not defined in file CDCOPY.CFG"
      call exit_proc 100
   end
   if maxspeed = '' then maxspeed = 8
return /* readcfg */


badcfg:

   parse arg msg
   say "Error in file" config "line" i
   if msg <> '' then say msg
   call exit_proc 50
exit /* badcfg */


check_emx:

   /* Check if EMXRT is installed */
   "@call emxrev >"tempfile "2>nul"
   if rc <> 0 then do
      say "The EMXRT libraries are not installed on your system"
      say "or are not at the right level."
         call require_emx
      end

   /* check if levels are good */
   emxref = "EMX EMXIO EMXLIBC EMXLIBCM EMXLIBCS EMXWRAP"
   emxfound = ''
   do while lines(tempfile) <> 0
      emx = translate(linein(tempfile))
      dll = word(emx, 1)
      level = word(emx, words(emx))
      select
         when dll = 'EMX' then do
            if level < 60 then call require_emx
            emxfound = emxfound' 'dll
         end
         when dll = 'EMXIO' then do
            if level < 60 then call require_emx
            emxfound = emxfound' 'dll
         end
         when dll = 'EMXLIBC' then do
            if level < 60 then call require_emx
            emxfound = emxfound' 'dll
         end
         when dll = 'EMXLIBCM' then do
            if level < 61 then call require_emx
            emxfound = emxfound' 'dll
         end
         when dll = 'EMXLIBCS' then do
            if level < 61 then call require_emx
            emxfound = emxfound' 'dll
         end
         when dll = 'EMXWRAP' then do
            if level < 60 then call require_emx
            emxfound = emxfound' 'dll
         end
         otherwise nop
      end
   end
   do i = 1 to words(emxref)
      emxlib = word(emxref, i)
      if wordpos(emxlib, emxfound) = 0 then do
         say "EMXRT problem: Library" emxlib "not found."
         call require_emx
      end
   end
   call stream tempfile, 'c', 'close'
   call sysfiledelete tempfile
   "@SET EMXOPT=-h120"
return /* check_emx */


require_emx:

   call stream tempfile, 'c', 'close'
   say "This program requires EMXRT Version 09D"
   say "With fixpack 1"
   say "You can get EMXRT 09D and EMXFIX01 packages"
   say "on the WEB from HOBBES: http://hobbes.nmsu.edu"
   call exit_proc
return /* require_emx */


cleanup:

   call sysfiledelete tempraw
   call sysfiledelete tempfile
return /* cleanup */


exit_proc:

   parse arg rcode
   call cleanup
   dir = directory(org)
   if rcode <> 0 then call beep 440, 200
exit rcode /* exit_proc */


write_cd:

   do n = 1 to ncopies
      if quiet = 0 | n > 1 then do
         call ok_cancel n
      end

      /* try to determine the max speed for the writer */
      do forever
         "@"writer" dev="outdev" speed="maxspeed dummy "-v -eject -pad" cdtype tempraw
         if rc = 0 then leave
         if maxspeed = 1 then leave
         if maxspeed > 2 then maxspeed = maxspeed - 2
         else maxspeed = 1
      end
      if rc <> 0 then do
         say "Error writing CD rc="rc
         call exit_proc rc
      end
   end
return /* write_cd */


direct_copy:

   do n = 1 to ncopies
      if quiet = 0 | n > 1 then do
         call ok_cancel n
      end

      "@"spe cdromreader "-a -f -l -L -R -v" basefile "|" writer  "dev="outdev "speed="maxspeed dummy "-v -eject -pad" cdtype "-"
      if rc <> 0 then do
         say "Error writing CD rc="rc
         say "CD could be corrupted!"
         call exit_proc rc
      end
   end
return /* write_cd */


get_cdr:

   /* Find out the device for CD-r if any */
   /* Also find out the letter for CD-ROM */
   "@"writer" -scanbus >"tempfile "2>nul"
   if rc <> 0 then do
      say "Error: cannot detect the SCSI id of your CD-R unit."
      call exit_proc rc
   end
   scsibus = ''
   outdev = ''
   cdr = ''
   do while lines(tempfile) <> 0
      line = translate(linein(tempfile))
      select
         when pos('CD-R ', line) > 0 then do
            if cdr = '' then cdr = strip(word( line, 2), 't', ')')
         end
         when substr(line, 1, 7) = 'SCSIBUS' then do
            if cdr = '' then do
               scsibus= substr(line, 8)
               scsibus = strip(scsibus, 't', ':')
               scsibus = strip(scsibus, 'l', ' ')
            end
         end
         otherwise nop
      end
   end
   call stream tempfile, 'c', 'close'
   call sysfiledelete tempfile
   if cdr <> '' then outdev = cdr','scsibus
   else do
      say "No CD-R unit found"
      call exit_proc 10
   end
return /* get_cdr */


ok_cancel:

   call beep 220, 100
   say "Insert a blank CD in the CD-R unit for copy" n
   say "press enter to cuntinue,"
   say "any other key to cancel."
   if c2d(sysgetkey('noecho')) <> 13 then do
      say "Program aborted by user"
      call exit_proc 1
   end
return /* ok_cancel */
