/* 

This program supports reading of digital audio from CDs under OS/2. 
All reading is done with standard system calls, it works with WARP4 and
should work with older versions (Not tested!), too. 

You can use this program or parts of it in any non-commercial way you 
like, as long as remember to put my name in the credits ... 

Carsten Thorenz, 1997.

*/


#define INCL_DOS
#define INCL_DOSDEVIOCTL
#define INCL_DEVICE
#define INCL_DOSERRORS
#define INCL_KBD
#define INCL_VIO

#include <os2.h>   
#include <stdlib.h>
#include <stdio.h> 
#include <malloc.h>
#include <string.h>

#define RAW_MODE 1
#define COOKED_MODE 0
#define READ_MODE RAW_MODE
#if READ_MODE == COOKED_MODE
  #define FRAME_SIZE 2048
#else
  #define FRAME_SIZE 2352
#endif

#pragma pack(1)
struct ReadLong {
     ULONG       ID_code;
     UCHAR       address_mode;
     USHORT      transfer_count;
     ULONG       start_sector;
     UCHAR       reserved;
     UCHAR       interleave_size;
     UCHAR       interleave_skip_factor;
 };
#pragma pack()

void info()
{
  struct {
     int  door_open       : 1;
     int  door_unlocked   : 1;
     int  read_raw        : 1;
     int  read_write      : 1;
     int  audio_video     : 1;
     int  interleave      : 1;
     int                  : 1;
     int  prefetch        : 1;
     int  audio_channel   : 1;
     int  msf             : 1;
     int                  : 1;
     int  disk_absent     : 1;
     int  playing_audio   : 1;
     int                  : 18;
  }dataquery;

  struct ReadLong rl;
  static char buf1[2352];
  static char buf2[2352];
  char drive[2];

  ULONG rc,Action,ulDinout,ulPinout;
  ULONG datasize,uldata,i,j,inull,idiff;
  HFILE handle; 
  
  datasize=sizeof(dataquery);

  printf("Please enter your CD-drive letter (with colon): \n");
  scanf("%s",&drive);
  
  rc=DosOpen(drive,&handle,&Action,0L,0L,FILE_OPEN,OPEN_FLAGS_FAIL_ON_ERROR | OPEN_SHARE_DENYREADWRITE |OPEN_FLAGS_DASD| OPEN_FLAGS_WRITE_THROUGH | OPEN_FLAGS_FAIL_ON_ERROR| OPEN_FLAGS_NOINHERIT,0L);

  printf("\n");
  if (rc) {
    printf("Couldn't open a handle for your Drive!\n");
    exit(1);
  }

  rc = DosDevIOCtl(handle, 0x80, 0x60, "CD01", 4, NULL,
                   &dataquery, datasize, &datasize );
  
  printf("\n");
  if (rc) {
    printf("Couldn't do any inquiries. Givin' up.");
    exit(1);
  }
  
  if (dataquery.door_open != 0)
    printf("Door is open\n");
  else
    printf("Door is closed\n");
  
  if (dataquery.door_unlocked == 0)
    printf("Door is locked\n");
  else
    printf("Door is unlocked\n");
  
  if (dataquery.read_raw != 0)
    printf("Supports READ2048 and READ2352\n");
  
  if (dataquery.read_write != 0)
    printf("Supports read and write\n");
  
  if (dataquery.audio_video != 0)
    printf("Drive can play audio and video\n");
  
  if (dataquery.interleave != 0)
    printf("ISO-9660 interleaving and skip supported\n");
  
  if (dataquery.prefetch != 0)
    printf("Dataprefetching supported\n");
  
  if (dataquery.msf != 0)
    printf("SUPPORTS MINUTE-SECOND-FRAME ADDRESSING\n");
  
  if (dataquery.disk_absent != 0)
    printf("Disc is not present\n");
  else
    printf("Disc is present\n");
  
  if (dataquery.playing_audio != 0)
    printf("Drive is playing audio\n");
  else
    printf("Drive is not playing audio\n");
  
  /* Wenn 'ne CD da ist, versuche die Groesse zu bestimmen. */
  if (dataquery.disk_absent == 0) { 
    datasize=sizeof(uldata);
    rc = DosDevIOCtl(handle, 0x80, 0x78,
                     "CD01", 4, NULL, &uldata, datasize,
                     &datasize);
      
    if (rc)  printf("Couldn't determin CD size. RC=\n\n",rc);
    if (!rc) printf("Size of CD: %d Sectors\n\n",uldata);
  }   
  
/* If CDDA reading is possible, try test for jitter */
  
  if (dataquery.read_raw != 0) {
  
    ulPinout = sizeof(rl);
    ulDinout = sizeof(buf1);
   
    rl.ID_code                  = 0x31304443L;    // "CD01"
    rl.address_mode             = 0;
    rl.transfer_count           = 1;
    rl.start_sector             = (uldata/2);
    rl.reserved                 = 0;
    rl.interleave_size          = 0;
    rl.interleave_skip_factor   = 0;
  
/* Read the same block twice. Repeat it ten times and compare the results */
  
    inull=0;
    idiff=0;   
      
    printf("Your drive supports reading of digital audio. Now we'll\n");
    printf("test it for jitter problems. This might take a minute ...\n");
   
    for (j=0;j<10;j++) {
      /* Read block  ...*/
      rc = DosDevIOCtl(handle,
                     0x80,
                     0x72,
                     &rl, sizeof(rl), &ulPinout,     /* parms */
                     buf1, sizeof(buf1), &ulDinout); /* data  */
      if (rc) printf("DosDevIOCtl 0x80 0x72 failed. RC=%d\n",rc);
  
      /*...and again the same block */
      rc = DosDevIOCtl(handle,
                     0x80,
                     0x72,
                     &rl, sizeof(rl), &ulPinout,     /* parms */
                     buf2, sizeof(buf1), &ulDinout); /* data  */
      if (rc) printf("DosDevIOCtl 0x80 0x72 failed. RC=%d\n",rc);
  
      /* ... test for differences ... */
  
      for (i=0;i<2352;i++) {
        if (buf1[i]==0) inull++;
        if (buf1[i]!=buf2[i]) idiff++;
        buf1[i]=0;
        buf2[i]=0;
      }     
    }
  
    if (idiff==0) { 
      printf("******************************************\n");
      printf("Excellent! There was absolutely no jitter!\n");
      printf("******************************************\n\n");
    }
    if ((idiff>0)&&(idiff<2500)) {
      printf("***********************************************\n");
      printf("Okay, there was a little jitter. Probably you\n");
      printf("will have luck with this programm if you keep \n");
      printf("the system load low during reading from CD!\n");
      printf("***********************************************\n\n");
    }
    if ((idiff>2500)&&(idiff<15000)) {
      printf("***********************************************\n");
      printf("Hmmm, there was some jitter. Perhaps you will\n");
      printf("have luck with this programm if you keep the\n");
      printf("system load low during reading from CD!\n");
      printf("***********************************************\n\n");
    }
    if (idiff>15000) {
      printf("*********************************************\n");
      printf("Pheeew! There was a lot of jitter. You won't\n");
      printf("have luck with this programm. Wait for the\n");
      printf("next version with dejittering! (...if it ever\n");
      printf("reaches the light of day...)\n");
      printf("*********************************************\n\n");
    } 
  }
       
      rc=DosClose(handle);
      if (rc) printf("DosClose failed! rc=%d\n",rc);
     
      exit(0);
  }
  


/* Start of main program */
  
int main(int argc, char *argv[], char *envp)
{
  ULONG rc,i,j,idiff;
  ULONG parmsize,datasize,uldata;
  ULONG drivemap,currentdisk,mask,Action;
  HFILE handle;
  FILE *fd;
  ULONG len,longdata,longparm;
  ULONG ulPinout, ulDinout;
  USHORT blocks,dejitter;

  UCHAR drive[2];
  ULONG first_sektor,number_of_sektors,size;
  UCHAR *buf;

  struct RIFF {
	UCHAR rID[4];
	ULONG rLen;
  } riff;

  struct FORMAT {
	UCHAR fID[4];
	ULONG fLen;
	USHORT wTag;
	USHORT wChannel;
	ULONG nSample;
	ULONG nByte;
	USHORT align;
	USHORT sample;
  };
  struct DATA {
	UCHAR dID[4];
	ULONG dLen;
  };
  struct WAVE {
	UCHAR wID[4];
	struct FORMAT fmt;
	struct DATA data;
  } wave;

  struct ReadLong rl;

/* Give some info about what's going on ...*/

    printf("CDREAD2, an OS/2 reader for audio CDs\n\n");
    printf("Written by Carsten Thorenz 1997. \n");
    printf("Version 0.1b, so don't expect anything! \n");
    printf("This program is freeware. You might use it as long as you like.\n");
    printf("You're not allowed to sell this program or \nto put it on a media which is to be sold!\n");
    printf("The Author shall not be liable for any damages \narising out of using this program.\n");
    printf("Use this program on your own risk!\n\n\n");

    printf("Do you want some info about your drive? The program will stop afterwards. [y/n]\n");
    if (getchar()=='y') info();

    printf("Please enter your CD-drive letter (with colon): \n");
    scanf("%s",&drive);
    printf("Please enter first sector which shell be read: \n");
    scanf("%ld",&first_sektor);
    printf("Please enter number of sektors to be read (will be \n");
    printf("rounded to a multiple of 25): \n");
    scanf("%ld",&number_of_sektors);
 
    rc=DosOpen(drive,&handle,&Action,0L,0L,FILE_OPEN,OPEN_FLAGS_FAIL_ON_ERROR | OPEN_SHARE_DENYREADWRITE |OPEN_FLAGS_DASD| OPEN_FLAGS_WRITE_THROUGH | OPEN_FLAGS_FAIL_ON_ERROR| OPEN_FLAGS_NOINHERIT,0L);

    printf("\n");
    if (rc) {
     printf("Couldn't open a handle for your Drive!\n");
     exit(1);
    }
     
    printf("I hope that the CD has really %ld sektors.\nI'm not going to test it ...\n",number_of_sektors+first_sektor);

/*  The number of blocks to be read at a time. */ 
    blocks=25;

/*  THIS MUST NOT BE A NUMBER BIGGER THAN 27 !!!
    Otherwise your system will lock hard. If you know why this happens,
    please send me a mail: thorenz@hydromech.uni-hannover.de
    I'd really like to know what's going on .... */


    buf=malloc(2352*blocks);
    if (!buf) printf("Buffer memory could not be malloced!");

    ulPinout = sizeof(rl);
    ulDinout = 2352*blocks;

 
    rl.ID_code                  = 0x31304443L;    // "CD01"
    rl.address_mode             = 0;
    rl.transfer_count           = blocks;
    rl.start_sector             = 1;
    rl.reserved                 = 0;
    rl.interleave_size          = 0;
    rl.interleave_skip_factor   = 0;

    /* Prepare the header for the WAV file */
    strcpy(riff.rID, "RIFF");
    riff.rLen = FRAME_SIZE * number_of_sektors + sizeof(struct WAVE);
    strcpy(wave.wID, "WAVE");
    strcpy(wave.fmt.fID, "fmt ");
    wave.fmt.fLen = sizeof(struct FORMAT) - 8;
    wave.fmt.wTag = 1;
    wave.fmt.wChannel = 2;
    wave.fmt.nSample = 44100L;
    wave.fmt.nByte = 44100L * 4;
    wave.fmt.align = 4;
    wave.fmt.sample = 16;
    strcpy(wave.data.dID, "data");
    wave.data.dLen = FRAME_SIZE * number_of_sektors;

    fd = fopen("output.wav","w+b");
    if (fd == NULL) {
      printf("Can not open output file\n");
      exit(1);
    }

    fwrite( &riff, sizeof(struct RIFF),1,fd);
    fwrite( &wave, sizeof(struct WAVE),1,fd);

    for (i=0;i<(number_of_sektors/blocks);i++) {

       rl.start_sector=first_sektor+i*blocks;  
       printf("Reading sektors %d to %d.\n",rl.start_sector,rl.start_sector+blocks-1);

       rc = DosDevIOCtl(handle,
                     0x80,
                     0x72,
                     &rl, sizeof(rl), &ulPinout,     /* parameters */
                     buf, ulDinout,   &ulDinout);    /* data       */
       fwrite( buf, 2352*blocks,1,fd);
       if (rc) printf("Reading failed!\n");

    }

  fclose(fd);

  return rc;
}
