#include <LUCIER.H>
#include "\PROJECT\MMIO\CDDA\MMIOPROC.H"

#define  MAX_TRACKS  256

void main(int argc, char **argv)   {
EXTENDMMIOINFO    ExMMInfo;
PEXTENDMMIOINFO   pExMMInfo=NULL;
PMMAUDIOHEADER    pmmAudioHdrDest,pmmAudioHdrSrc;
ULONG             ulReadSize,ulReadSize2,ulBufs,i,lRC,ulHeadPos;
MMIOINFO          mmInfo;
BOOL              fWait,fWaveEffect,fRandomSelect,fForeSelect,fShow,fForEver;
PCHAR             ptr;
CHAR              ch,szEffectFourcc[5];
UCHAR             ucTracks[100],ucTrackPos,ucTrackAll,ucCtrl;
FOURCC            fourcc;

   pExMMInfo=&ExMMInfo;

   printf("CDDA standard audio player - (%s - Llcdioct.lib)\n",ESC_TEXT_DOS_LUCIER);
   puts(ESC_YUURIRU_COPYRIGHT);
   puts("");

   /* ************************************************************** */
   /* Argv                                                           */
   /* ************************************************************** */
   memset(ucTracks,0,sizeof(UCHAR)*100L);
   ucTracks[0]=1;
   strcpy(szEffectFourcc,"WMBL");   /* WAVE EFFECT FOURCC (DEF=MARBLE HALL) */
   pExMMInfo->usTrack=2;
   fRandomSelect=FALSE;
   fForeSelect=TRUE;
   fWaveEffect=TRUE;
   ucTrackAll=0;
   ucTrackPos=0;
   fShow=TRUE;
   fForEver=FALSE;

   EscQueryDriveCdrom(pExMMInfo->pDrive,NULL);
   for(i=1;i<argc;i++)  {                                     
      ptr=argv[i];
      ch=*ptr;
      if(ch>='A'&&ch<='z') {  /* DRIVER LETTER OR FOURCC  */
         if(strlen(ptr)==4)   {  /* MAY BE FOURCC OF THE WAVE EFFECT */
            strcpy(szEffectFourcc,ptr);
         }  else  {  /* MAY BE DRIVE LETTER */
            pExMMInfo->pDrive[0]=ch;
         }
      }  else  
      if(ch>='0'&&ch<='9') {  /* TRACK */
         fForeSelect=FALSE;
         fRandomSelect=FALSE;
         ucTracks[ucTrackAll]=atol(ptr);
         ucTrackAll++;
      }  else  {
         strupr(ptr);
         if(EscStrEq(ptr,"/?") || EscStrEq(ptr,"/H") || EscStrEq(ptr,"/HELP"))   {
            puts("Usage:");
            puts("[drive letter] [track number...] [switches...]");
            puts("\nSwitches:");
            puts("/RAND  Random track select.");
            puts("/FE    For ever loop.");
            puts("/NE    Not use wave effect service.");
            puts("/Q     Quiet mode.");
            puts("\nExample:");
            puts("Q: 4 - CD-ROM Drive is Q: and play track at 4.");
            puts("4 2 8 - Play track 4, 2 and last 8.");
            puts("/RAND /FE - Random play Fore ever.");

            puts("\nMore Information:");
            printf("%s\n",ESC_VENDOR_NAME);
            printf("url: %s\n",ESC_YUURIRU_URL);
            printf("e-mail: %s\n",ESC_YUURIRU_MAILTO);
            exit(2);
         }
         if(EscStrEq(ptr,"/NE"))   {
            fWaveEffect=FALSE;
         }
         if(EscStrEq(ptr,"/FE")||EscStrEq(ptr,"/FOREVER"))   {
            fForEver=TRUE;
         }
         if(EscStrEq(ptr,"/RD")||EscStrEq(ptr,"/R")||EscStrEq(ptr,"/RND")||EscStrEq(ptr,"/RAND")||EscStrEq(ptr,"/RANDOM"))   {
            fForeSelect=FALSE;
            fRandomSelect=TRUE;
         }
         if(EscStrEq(ptr,"/Q"))   {
            fShow=FALSE;
         }
      }
   }  /* end of for */

   /* CREATE WAVE INTERFACE TO PLAY */
   /* ************************************************************** */
   /* SETUP - CDDA Digital Transmit                                  */
   /* ************************************************************** */
   if(fShow) printf("Try to connect the CD-ROM device at %s.\n",pExMMInfo->pDrive);
   // lRC = EscQueryDriveInfomation(pExMMInfo->pDrive[0]-'A',NULL, &ucDeviceType, NULL);
   //      printf("Drive %s Device Type [%ld] RET=%ld\n",pExMMInfo->pDrive,ucDeviceType,lRC);
   // if(lRC)  { getch(); return; }
   lRC = EscResetDriveCdrom(pExMMInfo->pDrive);
   if(lRC)  {
      printf("> We regret to inform you that...\n");
      printf("> We could not find the good CD-ROM device.\n");
      exit(ERROR_INVALID_DRIVE);
   }
   if(fShow) printf("Get the track information of the compact disc.\n");
   EscQueryDiskTrackCdaudio(pExMMInfo->pDrive,&pExMMInfo->usStart,&pExMMInfo->usEnd,&pExMMInfo->ulEndPos);
   if(fShow) printf("There are some tracks from %d to %d.\n",pExMMInfo->usStart,pExMMInfo->usEnd);

   /* ************************************************************** */
   /* PARAM SETUP                                                    */
   /* ************************************************************** */
   if(fForEver)  {
      if(fShow) printf("For ever loop play.\n");
   }
   if(fRandomSelect) {  /* RANDOM TRACK SELECT */
      if(fShow) printf("Random play.\n");
      DosQuerySysInfo(QSV_TIME_LOW,QSV_TIME_LOW,(PVOID)&lRC,sizeof(ULONG));
      srand(lRC/1000L);
   }

   if(fForeSelect)   {
      for(i=0;i<=pExMMInfo->usEnd-pExMMInfo->usStart;i++)   {
         ucTracks[i]=pExMMInfo->usStart+i;
      }
   }
   if(fShow) printf("Initialize Mission is completed.\n\n");

   while(ucTracks[ucTrackPos] || fForEver)   {
      if(ucTrackPos>=MAX_TRACKS) ucTrackPos=0;
      pExMMInfo->usTrack=ucTracks[ucTrackPos];
      if(fForEver)  {
         if(!ucTracks[ucTrackPos])   {
            ucTrackPos=0;
            pExMMInfo->usTrack=ucTracks[ucTrackPos];
         }
      }
      ucTrackPos++;

      if(fRandomSelect) {  /* RANDOM TRACK SELECT */
         RNDMLOOP:
         lRC = pExMMInfo->usStart+rand()%(pExMMInfo->usEnd-pExMMInfo->usStart+1);
         DosSleep(32);
         if( pExMMInfo->usEnd - pExMMInfo->usStart > 1)  {
            if(lRC == pExMMInfo->usTrack)    goto RNDMLOOP;
         }
         pExMMInfo->usTrack=(UCHAR)lRC;
      }

      EscQueryTrackAddress(pExMMInfo->pDrive,pExMMInfo->usTrack,&pExMMInfo->ulTrackStartAddress,&ucCtrl);
      if(fShow) printf("Play the track at %d.\n",pExMMInfo->usTrack);

      /* CALC AUDIO ADDRESS */
      if(fShow) printf("Get the address information of this track.\n");
      if(pExMMInfo->usTrack==pExMMInfo->usEnd)   pExMMInfo->ulTrackEndAddress=pExMMInfo->ulEndPos;
      else  EscQueryTrackAddress(pExMMInfo->pDrive,pExMMInfo->usTrack+1,&pExMMInfo->ulTrackEndAddress,NULL);

      pExMMInfo->ulTrackStartAddress=EscConvertMsfToLba(pExMMInfo->ulTrackStartAddress);
      pExMMInfo->ulTrackEndAddress=EscConvertMsfToLba(pExMMInfo->ulTrackEndAddress);
      pExMMInfo->ulAddress=pExMMInfo->ulTrackStartAddress;
      if(fShow) printf("Logical block address: from %ld to %ld ",pExMMInfo->ulTrackStartAddress,pExMMInfo->ulTrackEndAddress);

      /* CALC AUDIO ADDRESS */
      if(fShow) printf("then seek to the address, %ld.\n\n",pExMMInfo->ulAddress);
      lRC=EscSeekCdrom(pExMMInfo->pDrive, EscConvertLbaToMsf(pExMMInfo->ulTrackStartAddress) );
      if(lRC)  {
         printf("> We regret to inform you that...\n");
         printf("> Seek error.\n");
         break;
      }

      printf("\n%c[1A%c[s",0x1B,0x1B); /* ESCAPE-SS */
      printf("TRACK %d TOTAL TIME %c[s--:--\n%c[u",pExMMInfo->usTrack, 0x1B,0x1B); /* ESCAPE-SS */


      ulBufs=20;   /* TRANSMIT FRAMES - BUFFERS=20 */
      fWait=FALSE;

      if(ucCtrl&(1<<6)) {
         puts("Error: This Track is DATA Track\n");
      }  else  {
         lRC=EscPlayCdaudioTrack(pExMMInfo->pDrive, pExMMInfo->usTrack);
         while(1) {
            if(!EscQueryCdromHeadPos(pExMMInfo->pDrive, &ulHeadPos))   {
               ulHeadPos=EscConvertMsfToLba(ulHeadPos);
               if(ulHeadPos>=pExMMInfo->ulTrackEndAddress)   {
                  EscStopCdaudio( pExMMInfo->pDrive);
                     break;
               }
            }
            lRC=(ulHeadPos-pExMMInfo->ulTrackStartAddress)/75*1000;
            printf("%c[s",0x1B); /* SAVE CURSOR POSITION */
            printf("%02ld:%02ld\n", (lRC/1000)/60, (lRC/1000)%60 ); /* SHOW THE PLAY TIME */
            printf("%c[u",0x1B); /* RESTORE CURSOR POSITION */
            DosSleep(500);
         }
      }
   }

   EndExit:
   if(fShow) puts("\nTransmit order is completed.");

   i=0L; lRC=1L;
   DosSleep(2000);

   if(fShow) printf("Thank you for using this software.");
   if(fShow) puts("Done.");

exit(NO_ERROR); }

