/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) GBConstraintsConverter.java 1.14 - last change made 07/18/96
 */

package sunsoft.jws.visual.rt.type;

import sunsoft.jws.visual.rt.base.Shadow;
import sunsoft.jws.visual.rt.awt.GBConstraints;
import java.util.Hashtable;

/**
 * Converts instances of GBConstraints to strings and back again.
 *
 * @version 1.14, 07/18/96
 */
public class GBConstraintsConverter extends Converter {

  private static final GBConstraints constraintsDefault = new GBConstraints();

  private String constantToString(int c) {
    if (c == GBConstraints.RELATIVE)
	return("relative");
    else if (c == GBConstraints.REMAINDER)
	return("remainder");
    else if (c == GBConstraints.NONE)
	return("none");
    else if (c == GBConstraints.BOTH)
	return("both");
    else if (c == GBConstraints.HORIZONTAL)
	return("horizontal");
    else if (c == GBConstraints.VERTICAL)
	return("vertical");
    else if (c == GBConstraints.CENTER)
	return("center");
    else if (c == GBConstraints.NORTH)
	return("north");
    else if (c == GBConstraints.NORTHEAST)
	return("northeast");
    else if (c == GBConstraints.EAST)
	return("east");
    else if (c == GBConstraints.SOUTHEAST)
	return("southeast");
    else if (c == GBConstraints.SOUTH)
	return("south");
    else if (c == GBConstraints.SOUTHWEST)
	return("southwest");
    else if (c == GBConstraints.WEST)
	return("west");
    else if (c == GBConstraints.NORTHWEST)
	return("northwest");
    else
        throw new Error("unknown constant " + c);
  }

  private int stringToConstant(String s) {
    if (s.equals("relative"))
	return GBConstraints.RELATIVE;
    else if (s.equals("remainder"))
	return GBConstraints.REMAINDER;
    else if (s.equals("none"))
	return GBConstraints.NONE;
    else if (s.equals("both"))
	return GBConstraints.BOTH;
    else if (s.equals("horizontal"))
	return GBConstraints.HORIZONTAL;
    else if (s.equals("vertical"))
	return GBConstraints.VERTICAL;
    else if (s.equals("center"))
	return GBConstraints.CENTER;
    else if (s.equals("north"))
	return GBConstraints.NORTH;
    else if (s.equals("northeast"))
	return GBConstraints.NORTHEAST;
    else if (s.equals("east"))
	return GBConstraints.EAST;
    else if (s.equals("southeast"))
	return GBConstraints.SOUTHEAST;
    else if (s.equals("south"))
	return GBConstraints.SOUTH;
    else if (s.equals("southwest"))
	return GBConstraints.SOUTHWEST;
    else if (s.equals("west"))
	return GBConstraints.WEST;
    else if (s.equals("northwest"))
	return GBConstraints.NORTHWEST;
    else
      throw new Error("unknown constant " + s);
  }

  /**
   * Converts an instance of GBConstraints to a string representation.
   */
  public String convertToString(Object obj) {
    if (obj != null) {
      GBConstraints c = (GBConstraints) obj;
      String retval = "";

      if (c.gridx != constraintsDefault.gridx) {
	retval = retval + "x=" + c.gridx + ";";
      }
      if (c.gridy != constraintsDefault.gridy) {
	retval = retval + "y=" + c.gridy + ";";
      }
      if (c.gridwidth != constraintsDefault.gridwidth) {
	retval = retval + "width=" + c.gridwidth + ";";
      }
      if (c.gridheight != constraintsDefault.gridheight) {
	retval = retval + "height=" + c.gridheight + ";";
      }
      if (c.weightx != constraintsDefault.weightx) {
	retval = retval + "weightx=" + c.weightx + ";";
      }
      if (c.weighty != constraintsDefault.weighty) {
	retval = retval + "weighty=" + c.weighty + ";";
      }
      if (c.fill != constraintsDefault.fill) {
	retval = retval + "fill=" + constantToString(c.fill) + ";";
      }
      if (c.ipadx != constraintsDefault.ipadx) {
	retval = retval + "ipadx=" + c.ipadx + ";";
      }
      if (c.ipady != constraintsDefault.ipady) {
	retval = retval + "ipady=" + c.ipady + ";";
      }
      if (c.shrinkx != constraintsDefault.shrinkx) {
	retval = retval + "shrinkx=" + c.shrinkx + ";";
      }
      if (c.shrinky != constraintsDefault.shrinky) {
	retval = retval + "shrinky=" + c.shrinky + ";";
      }

      if (retval.length() > 0 && retval.charAt(retval.length() - 1) == ';')
	return(retval.substring(0, retval.length() - 1));
      else
	return(retval);
    }
    else {
      return(null);
    }
  }

  /**
   * Returns a code for creating a GBConstraints instance like the one given.
   *
   * @param obj an instance of GBConstraints
   */
  public String convertToCode(Object obj) {
    return("new GBConstraints(\"" + convertToString(obj) + "\")");
  }

  private int getIntegerFromTable(Hashtable table, String key) {
    String value = (String) table.get(key);
    if (value != null)
      return(Integer.valueOf(value).intValue());
    else
      return(0);
  }

  private boolean getBooleanFromTable(Hashtable table, String key) {
    String value = (String) table.get(key);
    if (value != null)
      return(Boolean.valueOf(value).booleanValue());
    else
      return(false);
  }

  private double getDoubleFromTable(Hashtable table, String key) {
    String value = (String) table.get(key);
    if (value != null)
      return(Double.valueOf(value).doubleValue());
    else
      return(0.0);
  }

  private int getConstantFromTable(Hashtable table, String key) {
    String value = (String) table.get(key);
    if (value != null)
      return(stringToConstant(value));
    else
      return(0);
  }

  /**
   * Converts a string into a new instance of GBConstraints.
   *
   * @exception Error when there is a problem with the string
   */
  public Object convertFromString(String s) {
    if (s != null && s.length() > 0) {
      SubFieldTokenizer sft = new SubFieldTokenizer(s);
      Hashtable table = sft.getHashtable();
      GBConstraints retval = new GBConstraints();

      if (table.containsKey("x")) {
	retval.gridx = getIntegerFromTable(table, "x");
      }
      if (table.containsKey("y")) {
	retval.gridy = getIntegerFromTable(table, "y");
      }
      if (table.containsKey("width")) {
	retval.gridwidth = getIntegerFromTable(table, "width");
      }
      if (table.containsKey("height")) {
	retval.gridheight = getIntegerFromTable(table, "height");
      }
      if (table.containsKey("weightx")) {
	retval.weightx = getDoubleFromTable(table, "weightx");
      }
      if (table.containsKey("weighty")) {
	retval.weighty = getDoubleFromTable(table, "weighty");
      }
      if (table.containsKey("fill")) {
	retval.fill = getConstantFromTable(table, "fill");
      }
      if (table.containsKey("ipadx")) {
	retval.ipadx = getIntegerFromTable(table, "ipadx");
      }
      if (table.containsKey("ipady")) {
	retval.ipady = getIntegerFromTable(table, "ipady");
      }
      if (table.containsKey("shrinkx")) {
	retval.shrinkx = getBooleanFromTable(table, "shrinkx");
      }
      if (table.containsKey("shrinky")) {
	retval.shrinky = getBooleanFromTable(table, "shrinky");
      }

      return(retval);
    }
    else {
      return(null);
    }
  }
}
