/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) @(#) DimensionConverter.java 1.6 - last change made 07/18/96
 */

package sunsoft.jws.visual.rt.type;

import java.awt.Dimension;
import java.util.Hashtable;
import java.util.Enumeration;

/**
 * Converts Dimension objects to strings and back again.  The format
 * of the string representation is "width=#;height=#", where # can be
 * any non-negative number.
 *
 * @see Dimension
 * @version 1.6, 07/18/96
 */
public class DimensionConverter extends Converter {
  public String convertToString(Object obj) {
    if (obj == null)
      return "";

    Dimension d = (Dimension)obj;
    return ("width=" + d.width + ";height=" + d.height);
  }

  public Object convertFromString(String s) {
    if (s == null || s.length() == 0)
      return null;

    SubFieldTokenizer sft = new SubFieldTokenizer(s);
    Hashtable table = sft.getHashtable();
    Dimension d = new Dimension();

    Enumeration e = table.keys();
    while (e.hasMoreElements()) {
      String key = (String)e.nextElement();
      if (!key.equals("width") && !key.equals("height")) {
	throw new ParseException("Illegal dimension value: " + key);
      }
    }

    if (table.containsKey("width"))
      d.width = getIntegerFromTable(table, "width");
    if (table.containsKey("height"))
      d.height = getIntegerFromTable(table, "height");

    return d;
  }

  private int getIntegerFromTable(Hashtable table, String key) {
    String value = (String) table.get(key);
    if (value != null) {
      try {
	return Integer.valueOf(value).intValue();
      }
      catch (NumberFormatException ex) {
	throw new ParseException("Badly formatted dimension value: " + value);
      }
    }
    else {
      return(0);
    }
  }

  public String convertToCode(Object obj) {
    if (obj == null) {
      return "new java.awt.Dimension()";
    }
    else {
      Dimension d = (Dimension)obj;
      return("new java.awt.Dimension(" + d.width + ", " + d.height + ")");
    }
  }
}
