/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) ColorConverter.java 1.10 - last change made 07/31/96
 */

package sunsoft.jws.visual.rt.type;

import java.awt.Color;

/**
 * Converts Color objects to strings and back again.
 *
 * @see Color
 * @version 	1.10, 07/31/96
 */
public class ColorConverter extends Converter {
  /**
   * Returns the string for a given color value.  Looks in the
   * ColorStore fisrt, for a good name for the color, or if it can't
   * find one, returns rgb hexadecimal format (e.g. #ef6caf).
   *
   * @param obj instance of Color
   * @see ColorStore
   */
  public String convertToString(Object obj) {
    Color c = (Color)obj;
    if (c == null)
      return "";

    // check the color store for a name
    String colorName = ColorStore.getDefaultColorStore().getColorName(c);
    if (colorName != null)
      return colorName;

    // create a string contain the hexidecimal rgb value
    int rgb = c.getRGB();
    rgb = rgb & 0xffffff;	// RGB is 3 bytes
    StringBuffer sb = new StringBuffer(Integer.toString(rgb, 16));
    while (sb.length() < 6) {
      sb.insert(0, '0');
    }
    return("#" + sb.toString());
  }

  /**
   * Figures out the color the given string represents.
   *
   * @exception ParseException when the color can't be figured
   */
  public Object convertFromString(String s) {
    if (s == null || s.length() == 0)
      return null;

    Color color = ColorStore.getDefaultColorStore().getColor(s);
    if (color != null)
      return color;

    if (!s.startsWith("#")) {
      throw new ParseException("Illegal color value: " + s);
    }

    Integer colorValue;
    try {
      colorValue = Integer.valueOf(s.substring(1), 16);
    }
    catch (NumberFormatException ex) {
      throw new ParseException("Badly formatted color value: " + s);
    }

    int i = colorValue.intValue();
    color = new Color((i >> 16) & 0xFF,
		      (i >> 8) & 0xFF,
		      (i >> 0) & 0xFF);

    return color;
  }
}
