/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) NVGroup.java 1.8 - last change made 07/02/96
 */

package sunsoft.jws.visual.rt.base;

public abstract class NVGroup extends Group {

  public NVGroup() {
    attributes.add("visible", "java.lang.Boolean", Boolean.TRUE,
		   HIDDEN | TRANSIENT);
    attributes.add("initialized", "java.lang.Boolean", Boolean.TRUE, 0);
  }

  public Object get(String key) {
    if (key.equals("initialized"))
      key = "visible";

    return super.get(key);
  }

  public void set(String key, Object value) {
    if (key.equals("initialized"))
      key = "visible";

    super.set(key, value);
  }

  protected Root initRoot() {
    return null;
  }

  public void setParentBody() {
  }

  public void unsetParentBody() {
  }

  protected void removeForwardedAttributes() {
  }
}
