/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) Global.java 1.42 - last change made 07/30/96
 */

package sunsoft.jws.visual.rt.base;

import java.util.StringTokenizer;

/**
 * Globals for runtime area.
 *
 * @version 	1.42, 07/30/96
 */
public class Global {
  private static final double version = 1.0;
  private static final String vendor = "SunSoft, Inc.";

  /**
   * Returns the version number of this runtime package.
   */
  public static double getVersion() { return(version); }

  /**
   * Returns the vendor of this runtime package.
   */
  public static String getVendor() { return(vendor); }

  /**
   * A convenient instance of the Util class, easy access to the utility
   * functions there.
   */
  public static Util util = new Util();

  // Which OS are we running?  If we know we can work-around some AWT bugs.
  private static boolean isWindows;
  private static boolean isWindows95;
  private static boolean isWindowsNT;
  private static boolean isSolaris;
  private static boolean isUnix;
  private static boolean isIrix;
  private static boolean isMotif;

  // What version of java are we using?
  private static double javaVersion;

  // What do we use for new lines (when printing, generating, etc.)
  private static String newline;

  static {
    String osname = System.getProperty("os.name");
    isWindows = osname.startsWith("Windows");
    isWindows95 = osname.startsWith("Windows 95");
    isWindowsNT = osname.startsWith("Windows NT");
    isSolaris = osname.startsWith("Solaris");
    isUnix = !osname.startsWith("Windows");
    isIrix = osname.startsWith("Irix");
    isMotif = isUnix;

    // work-around for the fact that newline character
    // sequences are different on Unix and Windows
    newline = (isWindows ? "\r\n" : "\n");

    initJavaVersion();
  }

  private static void initJavaVersion() {
    String jv;
    int i, len;

    javaVersion = 0.0;
    jv = System.getProperty("java.version");

    // Strip everything off starting at the first non-numeric character.
    // The JWS java version will soon look like this: "1.0.1ss:<date-time>"
    len = jv.length();
    for (i=0; i<len; i++) {
      char c = jv.charAt(i);
      if (!Character.isDigit(c) && c != '.')
	break;
    }
    jv = jv.substring(0, i);

    // JWS screws up the "java.version" property.  This will
    // be fixed soon.
    if (jv.equals("")) {
      javaVersion = 1.01;
      return;
    }

    // Count up the number of dot characters.  This is necessary because
    // the JDK java version looks like this: "1.0.2"
    int dotcount = 0;
    len = jv.length();
    for (i=0; i<len; i++) {
      if (jv.charAt(i) == '.')
	dotcount++;
    }

    // The netscape java version looks like this: "1.021"
    if (dotcount <= 1) {
      try {
	javaVersion = Double.valueOf(jv).doubleValue();
	return;
      }
      catch (NumberFormatException ex) {
      }
    }

    // The JDK java version looks like this: "1.0.2"
    double mult = 1;
    StringTokenizer st = new StringTokenizer(jv, ".");
    while (st.hasMoreTokens()) {
      javaVersion += Integer.parseInt(st.nextToken()) * mult;
      mult *= 0.1;
    }
  }

  /**
   * Returns true if running on Windows 95 or NT.
   */
  public static boolean isWindows() { return isWindows; }

  /**
   * Returns true if running on Windows 95.
   */
  public static boolean isWindows95() { return isWindows95; }

  /**
   * Returns true if running on Windows NT.
   */
  public static boolean isWindowsNT() { return isWindowsNT; }

  /**
   * Returns true if running on Solaris.
   */
  public static boolean isSolaris() { return isSolaris; }

  /**
   * Returns true if running on Unix.
   */
  public static boolean isUnix() { return isUnix; }

  /**
   * Returns true if running on SGI Irix.
   */
  public static boolean isIrix() { return isIrix; }

  /**
   * Returns true if using Motif.
   */
  public static boolean isMotif() { return isMotif; }

  /**
   * Returns a string that can be used as a newline.  This string includes
   * a carriage return if we are running on Windows.
   */
  public static String newline() { return newline; }

  /**
   * Appends a newline to buf.  This also appends a carriage return
   * if we are running on Windows.
   */
  public static void newline(StringBuffer buf) { buf.append(newline); }

  /**
   * Returns the version of Java we are using.
   */
  public static double javaVersion() {
    return javaVersion;
  }
}
