/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) VJCanvas.java 1.2 - last change made 06/03/96
 */

package sunsoft.jws.visual.rt.awt;

import java.awt.*;

public class VJCanvas extends Canvas {

  public static final int PAINT_EVENT = 2567;
  public static final int UPDATE_EVENT = 2568;

  /**
   * This Canvas doesn't keep growing like the regular Canvas does.
   **/

  int minWidth = 100, minHeight = 100;

  public void setMinWidth(int minWidth) {
    this.minWidth = minWidth;
  }
  
  public void setMinHeight(int minHeight) {
    this.minHeight = minHeight;
  }

  public int getMinWidth() {
    return minWidth;
  }
  
  public int getMinHeight() {
    return minHeight;
  }

  public Dimension minimumSize() {
    return new Dimension(minWidth, minHeight);
  }

  public Dimension preferredSize() {
    return minimumSize();
  }

  public void update(Graphics g) {
    postEvent(new Event(this, UPDATE_EVENT, g));
    paint(g);
  }

  public void paint(Graphics g) {
    super.paint(g);
    postEvent(new Event(this, PAINT_EVENT, g));
  }
}
