/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) CardPanel.java 1.3 - last change made 07/30/96
 */

package sunsoft.jws.visual.rt.awt;

import java.awt.*;
import java.util.*;

public class CardPanel extends VJPanel {
  public static final int FETCHCARD = 68496;
  public static final int CURRENTCARD = 68497;

  protected Vector tabs;
  private Label cardLabel;
  private CardLayout cardLayout;
  private String currentCard;
  private Hashtable cards;

  public CardPanel() {
    cardLayout = new CardLayout();
    setLayout(cardLayout);

    tabs = new Vector();
    cards = new Hashtable();

    cardLabel = newCardLabel();
    add(cardLabel);
  }

  protected Label newCardLabel() {
    return new Label("Card Panel");
  }

  public Component add(String name, Component comp) {
    boolean isFront =
      (currentCard != null && cards.get(currentCard) == comp);

    super.add(name, comp);

    if (isFront) {
      comp.show();
      currentCard = name;
    }

    return comp;
  }

  public void addTab(String name) {
    tabs.addElement(name);
  }

  public void addTab(String name, int index) {
    tabs.insertElementAt(name, index);
  }

  public String getTab(int index) {
    int size = tabs.size();
    if (index >= 0 && index < size)
      return (String)tabs.elementAt(index);
    else
      return null;
  }

  public int getTabIndex(String name) {
    return tabs.indexOf(name);
  }

  public void removeTab(String name) {
    tabs.removeElement(name);
    removeCard(name);
  }

  public void renameTab(String oldName, String newName) {
    int index = tabs.indexOf(oldName);
    if (index != -1) {
      tabs.removeElementAt(index);
      tabs.insertElementAt(newName, index);
      renameCard(oldName, newName);
    }
  }

  public void removeAllTabs() {
    tabs.removeAllElements();
    removeAllCards();
  }

  public Enumeration tabs() {
    return tabs.elements();
  }

  public Component addCard(String name, Component card) {
    if (cardLabel.getParent() == this)
      remove(cardLabel);

    if (!tabs.contains(name)) {
      throw new Error("\r\n" +
		      "    There is no tab for \"" + name + "\".\r\n" +
		      "    You must call addTab before addCard.");
    }

    cards.put(name, card);

    // The first card that is added will be shown by the cardLayout,
    // and thusly it must become the currentCard.
    if (currentCard == null) {
      currentCard = name;
      postEvent(new Event(this, CURRENTCARD, name));
    }

    return add(name, card);
  }

  public Component getCard(String name) {
    return (Component)cards.get(name);
  }

  public String getCardName(Component comp) {
    Enumeration e = cards.keys();
    while (e.hasMoreElements()) {
      String key = (String)e.nextElement();
      if (cards.get(key) == comp)
	return key;
    }

    return null;
  }

  // Call renameTab to rename the card
  private void renameCard(String oldName, String newName) {
    Component comp = (Component)cards.get(oldName);

    if (comp != null) {
      cards.remove(oldName);
      cards.put(newName, comp);

      remove(comp);
      add(newName, comp);

      if (oldName.equals(currentCard)) {
	currentCard = newName;
	comp.show();
      }
    }
  }

  // Call removeTab to remove the card
  private void removeCard(String name) {
    if (name.equals(currentCard))
      currentCard = null;

    Component comp = (Component)cards.get(name);
    if (comp != null) {
      cards.remove(name);
      remove(comp);
    }

    if (cardLabel.getParent() != this && countComponents() == 0)
      add(cardLabel);
  }

  // Call removeAllTabs to remove all the cards
  private void removeAllCards() {
    cards.clear();

    if (cardLabel.getParent() != this)
      add(cardLabel);
  }

  public String getCurrentCard() {
    return currentCard;
  }

  public void show(String name) {
    if (cards.get(name) == null) {
      postEvent(new Event(this, FETCHCARD, name));
    }

    if (cards.get(name) != null) {
      currentCard = name;
      cardLayout.show(this, name);
      postEvent(new Event(this, CURRENTCARD, name));
    }
  }

  public void first() {
    if (tabs.size() > 0)
      show((String)tabs.elementAt(0));
  }

  public void next() {
    int index = frontIndex();
    if (tabs.size() > (index+1))
      show((String)tabs.elementAt(index+1));
  }

  void previous() {
    int index = frontIndex();
    if (tabs.size() > 0 && (index-1) >= 0)
      show((String)tabs.elementAt(index-1));
  }

  public void last() {
    int index = tabs.size()-1;
    if (index >= 0)
      show((String)tabs.elementAt(index));
  }

  private int frontIndex() {
    if (currentCard == null)
      return -1;
    else
      return tabs.indexOf(currentCard);
  }
}
