/*
 *  Smart Cache, http proxy cache server
 *  Copyright (C) 1998-2001 Radim Kolar
 *
 *    Smart Cache is Open Source Software; you may redistribute it
 *  and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2, or (at your option) any later version.
 *
 *    This program distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *    A copy of the GNU General Public License is available as
 *  /usr/doc/copyright/GPL in the Debian GNU/Linux distribution or on
 *  the World Wide Web at http://www.gnu.org/copyleft/gpl.html. You
 *  can also obtain it by writing to the Free Software Foundation,
 *  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

import java.io.*;
import java.util.*;
import java.util.zip.*;
import java.text.*;
import java.net.*;


/* chyby : pri POST posle HTTP1.0 hlavicku HTTP0.9 klientu */

public final class request{

/* maximal time difference for checking validity of expire<now */
public static final long MAXDIFFTIME=8*60*60*1000L;

public static final byte GIF[]={
(byte)0x47,(byte)0x49,(byte)0x46,(byte)0x38,(byte)0x39,(byte)0x61,(byte)0x01,(byte)0x00,
(byte)0x01,(byte)0x00,(byte)0x80,(byte)0x00,(byte)0x00,(byte)0xff,(byte)0xff,(byte)0xff,
(byte)0x00,(byte)0x00,(byte)0x00,(byte)0x21,(byte)0xf9,(byte)0x04,(byte)0x01,(byte)0x00,
(byte)0x00,(byte)0x00,(byte)0x00,(byte)0x2c,(byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00,
(byte)0x01,(byte)0x00,(byte)0x01,(byte)0x00,(byte)0x00,(byte)0x02,(byte)0x02,(byte)0x44,
(byte)0x01,(byte)0x00,(byte)0x3B
};

/* quick abort config */
public static int qa_minlen, qa_maxlen;
public static String wafer;
public static float qa_percent;
public static long qa_maxtime;
public static boolean append_via;
public static char pnocache;
public static int read_timeout;
public static boolean cache_protected;
public static char referer_hack;
public static String default_forward_for;
public static boolean remove_pragma_no_cache;
public static DateFormat formatter= new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
public static String fake_user_agent, fake_referer;

/* agent.log */
public static String alogpatterns[];
public static DataOutputStream alogfilez[];
public static String alogfilenames[];

/* referer.log */
public static String rlogpatterns[];
public static DataOutputStream rlogfilez[];
public static String rlogfilenames[];

public static boolean full_referer_log;

/* object private data */
private String URL;
private int method;
private DataInputStream in; /* klient input */
private DataOutputStream out; /* klient output */
private boolean http10;

private boolean cacheable;

private long ims; /* if modified since */
private long exp; /* expires */

private boolean hasCookie;
private int ctsize;
private String ctype;
private String location;
private String encoding;
private boolean reload;
private Vector headers;
private boolean host;
private int httprc;
private String protocol; /* ftp, gopher, ... */

private int proxyport;
private InetAddress proxyhost;

request(int met,String url,Vector head,DataInputStream in,DataOutputStream out) throws MalformedURLException
{
 hasCookie=false;
 ims=httprc=0;
 ctsize=-1;
 reload=false;
 cacheable=true;
 this.method=met;
 protocol=null;
 ctype=null;

 // if(met<httpreq.REQUEST_MIN || met>httpreq.REQUEST_MAX) throw new NullPointerException("Bad Method");
 URL=url;
 if(head==null) { http10=false; headers=new Vector();}
  else
   { http10=true;
     headers=head;}
 this.in=in;
 this.out=out;

 host=false; /* host hlavicka */
 /* projdeme hlavicky, zajima nas Pragma: no-cache
  a if-modified-since
 */
 int i,j;
 String s,s1,s2,hosth;
 hosth=null;
 char rhcache=referer_hack;
 if(rhcache==0 && rlogpatterns!=null) rhcache=99;  /* log or fake */
 int cachedsize=headers.size();
 for(i=0;i<cachedsize;i++)
 {
    s=(String)headers.elementAt(i);
    j=s.indexOf(':',0);
    if(j==-1) continue;
    s1=s.substring(0,j).toLowerCase();
    s2=s.substring(j+1).trim();
//  System.out.println("Header = "+s1);
    if(s1.equals("pragma"))
           {
	   reload=true;
           if (remove_pragma_no_cache) { headers.removeElementAt(i--);cachedsize--;}
           continue;
           }
    if(s1.equals("host")) { host=true; hosth=s2;continue;}
    if(s1.equals("content-length"))
             try
              {
                 ctsize=Integer.valueOf(s2).intValue();
              }
              catch (Exception ignore) {}
              finally { continue;}
    if(s1.equals("accept-encoding"))
    {
     if(s2.indexOf("gzip")>-1) encoding="gzip";
     continue;
    }
    if(s1.equals("if-modified-since")) {
                                        /* cut of file size */
                                        j=s2.indexOf(';',0);
                                        if(j>-1) s2=s2.substring(0,j);
					try
					{
                                        ims=new Date(s2).getTime();
					}
					catch (IllegalArgumentException baddate)
					 {}
                                        headers.removeElementAt(i--);
                                        cachedsize--;
                                        continue;
                                     // System.out.println("IMS="+ims);
                                      }
    /* kill possible Keep-Alive */
    if(s1.equals("connection")) {
                                        headers.removeElementAt(i--);
                                        cachedsize--;
                                        continue;
                                      }

    if(s1.equals("proxy-connection")) {
                                        headers.removeElementAt(i--);
                                        cachedsize--;
                                        continue;
                                      }
    if(hasCookie==false && s1.equals("cookie"))
                                      {
                                       hasCookie=true;
                                       continue;
                                      }
    if(s1.equals("authorization")) {
                                        cacheable=cache_protected; // was false;
                                        continue;
                                      }


    if(s1.equals("user-agent")) {
                                  /* agent.log enabled? */
                                  if(alogpatterns!=null)
                                  {
                                    int j1=alogpatterns.length;
                                    for(int ii=0;ii<j1;ii++)
                                    {
                                       String fragment;
                                       fragment=mgr.simpleWildMatch(alogpatterns[ii], url);
                                       if(fragment==null) continue;
                                       DataOutputStream output;
                                       output=alogfilez[ii];
                                       if(output==null && alogfilenames[ii]!=null)
                                          /* OPEN LOGFILE */
                                          if(!httpreq.open_logfile(alogfilenames,alogfilez,ii)) break;
                                           else
                                            output=alogfilez[ii];
                                       try
                                       {
                                        synchronized (output)
                                        {
                                         output.writeBytes(s2);
                                         output.writeByte('\n');
                                        }
                                       }
                                       catch (IOException zz1)
                                        {
                                         alogfilenames[ii]=null;
                                        }
                                       break;

                                    } /* log for */
                                  } /* alog enabled? */
				  /* Change User-Agent: */

                                        if(fake_user_agent!=null)
					  {
                                            s=fake_user_agent;
                                            headers.setElementAt(s,i);
					  }
                                         else
					   if(append_via)
					        {
					           s+=" via "+scache.VERSION;
                                                   headers.setElementAt(s,i);
						}
                                        continue;
                                      }
    if(rhcache>0 && s1.equals("referer")) {

                                  /* referer.log enabled? */
                                  if(rlogpatterns!=null)
                                  {
                                    int j1=rlogpatterns.length;
                                    for(int ii=0;ii<j1;ii++)
                                    {
                                       String fragment;
                                       fragment=mgr.simpleWildMatch(rlogpatterns[ii], url);
                                       if(fragment==null) continue;
                                       if(full_referer_log==false)
                                        { /* mini referer - log */
                                         int z=url.indexOf("://");
                                         if(z==-1) break;
                                         int z2=url.indexOf('/',z+3);
                                         if(z2!=-1)
                                           if (s2.regionMatches(0,url,0,z2)) break;
                                             else ;
                                          else
                                           if(s2.regionMatches(0,url,0,url.length())) break;

                                        }
                                       DataOutputStream output;
                                       output=rlogfilez[ii];
                                       if(output==null && rlogfilenames[ii]!=null)
                                          /* OPEN LOGFILE */
                                          if(!httpreq.open_logfile(rlogfilenames,rlogfilez,ii)) break;
                                           else
                                            output=rlogfilez[ii];
                                       try
                                       {
                                        synchronized(output)
                                        {
                                         output.writeBytes(s2+" -> "+url);
                                         output.writeByte('\n');
                                        }
                                       }
                                       catch (IOException zz1)
                                        {
                                         rlogfilenames[ii]=null;
                                        }
                                       break;

                                    } /* log for */
                                  } /* referer log enabled? */
                                  if (rhcache==99)
					    {
					     rhcache=0;continue;
					    }
				    else
				  if(fake_referer!=null)
                                           s=fake_referer;
		                    else
                                  if(rhcache==1)  /* kill referer header */
                                       { headers.removeElementAt(i--);cachedsize--;rhcache=0;continue;}
                                    else
                                       s="Referer: "+url;

                                   headers.setElementAt(s,i);
                                   rhcache=0; /* turn it off! */
                                   continue;
                                      }

 }
 /* pokud jsme http 0.9 tak pridame accept hlavicku */
 if(!http10) headers.addElement("Accept: */*");
 /* pro jistotu */
 // headers.addElement("Connection: close");

/* - F O R W A R D E R - */

 if(url.charAt(0)=='/')
  {
   /* fire-up forwarder! */
   protocol="http";
   if(hosth!=null) URL="http://"+hosth+url;
           else
                   URL="http://"+default_forward_for+url;
   return;
  }

 if(met!=httpreq.REQUEST_CONNECT)
  {
   /* extract protocol */
   int pos=url.indexOf("://",0);
   if(pos==-1) throw new MalformedURLException();
   protocol=url.substring(0,pos);

   /* check for losername/password */
 try
 {
  int zav=url.indexOf('@',pos+3);
  if(zav>0)
   {
    /*   @   / - ok     */
    /*   /  @ - ignore  */
    /*   @    - ok      */
    int slash=url.indexOf('/',pos+3);
    if( slash>zav || slash==-1 )
    {
     String auth="Authorization: Basic "+HTUU.encode_string(url.substring(pos+3,zav));
     headers.addElement(auth);
     URL=protocol+"://"+url.substring(zav+1); // remove auth string from URL
     // System.err.println("new URL="+URL);
    }
   }
 }
 catch (Exception e)
   { throw new MalformedURLException();} // So no need to check index out of bounds

  } else {protocol=null;cacheable=false;}

}

final public void rewriteURL(String newURL)
{
 this.URL=newURL;
 char rhcache=referer_hack;
 if(!host && rhcache<2) return; // scan and kill old host header
 String s,s1;
  int cachedsize=headers.size();

  for(int i=0;i<cachedsize;i++)
 {
    int j;
    s=(String)headers.elementAt(i);
    j=s.indexOf(':',0);
    if(j==-1) continue;
    s1=s.substring(0,j).toLowerCase();
    // s2=s.substring(j+1).trim();
    if(s1.equals("host")) {
                            headers.removeElementAt(i--);
                            cachedsize--;
                            continue;
                           }
    if(rhcache>0 && s1.equals("referer")) {
                                            s="Referer: "+newURL;
                                            headers.setElementAt(s,i);

                                            rhcache=0; /* turn it off! */
                                            continue;
                                      }

 }
 host=false;
}

final public void removeCookies()
{
 if(hasCookie==false) return;
 // scan and kill c00kie header
  String s,s1;
  int cachedsize=headers.size();

  for(int i=0;i<cachedsize;i++)
 {
    int j;
    s=(String)headers.elementAt(i);
    j=s.indexOf(':',0);
    if(j==-1) continue;
    s1=s.substring(0,j).toLowerCase();
    // s2=s.substring(j+1).trim();
    if(s1.equals("cookie")) {
                            if(wafer==null)
                              {
                                headers.removeElementAt(i--);
                                cachedsize--;
                              }
                              else
                              {headers.setElementAt(wafer,i);}
                            continue;
                           }

 }
}


final public void addHost(String hostname,String port)
{
 if(host) return; /* uz ji mame - nemenime */
 if(port==null)  headers.addElement("Host: "+hostname);
  else
   headers.addElement("Host: "+hostname+":"+port);

 host=true;
}

final public int getMethod()
{
 return method;
}

final public boolean requestReload()
{
 return reload;
}
final public String getURL()
{
 return URL;
}

/* nastavi cil - proxy nebo cilovy server, to je jedno */
final public void setTarget(InetAddress proxyhost, int proxyport)
{
 this.proxyhost=proxyhost;
 this.proxyport=proxyport;
}

final public Socket connectToHost() throws IOException
{
 Socket s;
 if(proxyhost==null) throw new java.net.UnknownHostException();
 s=new Socket(proxyhost,proxyport);
 try
 {
   s.setSoTimeout(read_timeout);
 }
 catch (java.net.SocketException ignore) {}
 return s;
}

final public void handle_connect() throws IOException
{
 Socket toserver=null;
 try
  {
   toserver=connectToHost();
  }
  catch (IOException e)
   {
    send_error(500,"Connect to server failed. CONNECT request canceled.");
    return;
   }
  DataInputStream sin=new DataInputStream (new BufferedInputStream(toserver.getInputStream()));
  DataOutputStream sou=new DataOutputStream(new BufferedOutputStream(toserver.getOutputStream()));
  out.writeBytes("HTTP/1.0 200 Connection established\r\nProxy-agent: ");
  out.writeBytes(scache.VERSION);
  out.writeBytes("\r\n\r\n");
  out.flush();

  /* buffer */
  byte b[]=new byte[512];
  int rb;

  Thread worker=new Thread(new InOut(sin,out,Thread.currentThread()));
  worker.start();

  mainloop:while(true)
  {
     if(Thread.interrupted()) break;
     rb=in.read(b,0,512);
     if(rb==-1) break mainloop;
     sou.write(b,0,rb);
     sou.flush();
  }
  worker.interrupt();
  toserver.close();
  close();
  return;
}

final public void handle_options() throws IOException
{
  int maxforwards=get_and_update_maxforwards();
  if(maxforwards==0)
    {
      /* reply to OPTIONS Message */
      Vector oldheaders=(Vector)headers.clone();
      make_headers(200,null,null,null,0,0,0);
      headers.addElement("Allow: GET, HEAD, OPTIONS, TRACE");
      send_headers();
      out.close();
    }
    else
      direct_request(false);
}
final public void handle_trace() throws IOException
{
  int maxforwards=get_and_update_maxforwards();
  if(maxforwards==0)
    {
      /* reply to trace Message */
      Vector oldheaders=(Vector)headers.clone();
      make_headers(200,"message/http",null,null,0,0,0);
      send_headers();
      StringBuffer sb=new StringBuffer(1024);
      sb.append(httpreq.methodToString(method));
      sb.append(" ");
      sb.append(URL);
      if(http10==true)
      {
      sb.append(" HTTP/1.0\r\n");
      int szc=oldheaders.size();
      for(int i=0;i<szc;i++)
      {
        sb.append((String)oldheaders.elementAt(i));
	sb.append("\r\n");
      }
      } else sb.append("\r\n");
      out.writeBytes(sb.toString());
      out.close();
    }
    else
      direct_request(false);
}

final private int get_and_update_maxforwards()
{
  int maxforwards=-1;
 String s,s1;
  int cachedsize=headers.size();
  for(int i=0;i<cachedsize;i++)
  {
    int j;
    s=(String)headers.elementAt(i);
    j=s.indexOf(':',0);
    if(j==-1) continue;
    s1=s.substring(0,j).toLowerCase();
    if(s1.equals("max-forwards")) {
                            try
			    {
                              String s2=s.substring(j+1).trim();
                              maxforwards=Integer.valueOf(s2).intValue();
			    }
			    catch (NumberFormatException nfe) {continue;}
                            if(maxforwards>0) headers.setElementAt("Max-Forwards: "+(maxforwards-1),i);
                            return maxforwards;
                           }
 }
 return -1; // NONE
}

final public void direct_request(boolean datafromclient) throws IOException
{
  DataInputStream sin=null;
  DataOutputStream sou=null;
  Socket toserver=null;
 try{
  toserver=connectToHost();
  sin=new DataInputStream (new BufferedInputStream(toserver.getInputStream()));
  sou=new DataOutputStream(new BufferedOutputStream(toserver.getOutputStream()));
 send_request(sou);
 }
 catch (IOException e)
  { send_error(500,"Connect to server failed. "+
    (method==httpreq.REQUEST_POST? "POST":
     (method==httpreq.REQUEST_DELETE? "DELETE":
      (method==httpreq.REQUEST_PUT? "PUT":
       (method==httpreq.REQUEST_OPTIONS? "OPTIONS":
        (method==httpreq.REQUEST_TRACE? "TRACE": "UNKNOWN")
       )
      )
     )
    )+" request canceled.");return; }
 try{

 /* pokud nemame ctsize, tak cteme az na konec */
 /* precteme data z klienta a odesleme je na server */
 if(datafromclient) {
	 while(ctsize!=0)
	 {
	//  System.out.println(ctsize);
	  byte b[]=new byte[512];
	  int rb;
	  if(ctsize<0) rb=in.read(b);
		 else
		  rb=in.read(b,0,Math.min(ctsize,512));
	  if(rb==-1) break; /* konec dat! */
	  ctsize-=rb;
	  sou.write(b,0,rb);
	 }
	 sou.writeByte(0); // Zbynek Pospichal lamer detector
			   // Some versions of Netscape does this for fixing badly
			   // written CGI scripts
	 sou.flush();
 }
 /* otocime to, cteme data ze serveru a posilame je klientu */
 while(true)
 {
  byte b[]=new byte[512];
  int rb;
  rb=sin.read(b);
  if(rb==-1) break; /* konec dat! */
  out.write(b,0,rb);
 }

 sou.close();
 sin.close();
 toserver.close();
 /* zavrit klienta */
 out.close();
 in.close();
 }
 catch (IOException e1) { toserver.close();}
}

		
final public void send_request(DataOutputStream sout) throws IOException
{
 String met=null;
 met=httpreq.methodToString(method);
 sout.writeBytes(met+" "+URL+" HTTP/1.0\r\n");

 int hscache=headers.size();
 for(int i=0;i<hscache;i++)
   { sout.writeBytes((String)headers.elementAt(i));
     sout.writeBytes("\r\n");
   }
 sout.writeBytes("\r\n");
 sout.flush();
}

final public void close() throws IOException
{
 out.flush();
 // in.close();
}

/* reads headers from server and parses it */
final public void read_headers(DataInputStream in) throws IOException
{
 headers=new Vector();
 ims=exp=0; /* pro last modified */
 ctsize=-1;
 encoding=null;
 // ctype="application/octet-stream";
 ctype="text/html"; // like Mozilla does
 reload=false; /* pouzivano pro pragma: no-cache */
 String line;
 line=in.readLine(); /* HTTP/1.0 XX OK */
 if(line==null)
                  try{
                        in.close();
                     }
                  catch(IOException e) {}
                  finally
                  { throw new EOFException("Cannot read http return code");}

 /* precteme si tedy kod */
 StringTokenizer st;
 st=new StringTokenizer(line);
 /* tady to spadne pri remote HTTP 0.9 serveru */
 try
 {
   st.nextToken(); /* http/1.0 - nezajimave */
   httprc=Integer.valueOf(st.nextToken()).intValue();
 }
 catch (Exception http09)
 { /* 502 - Bad gateway */
  send_error(502,"Remote servers talking with old HTTP 0.9 protocol are not supported.");return;
 }

 int pnci=-1;
 int expi=-1;
 /* cteme hlavicky */
  while(true)
    {
      int j;
      String s1,s2;
      line=in.readLine();
      if(line==null) break;
      if(line.length()==0) break;
      headers.addElement(line);
    j=line.indexOf(':',0);
    if(j==-1) continue;
    s1=line.substring(0,j).toLowerCase();
    s2=line.substring(j+1).trim();
    if(s1.equals("pragma")) { reload=true;pnci=headers.size()-1;continue;}
    if(s1.equals("content-length"))
             try
              {
                 ctsize=Integer.valueOf(s2).intValue();
              }
              catch (Exception ignore) {}
              finally { continue;}

    if(s1.equals("content-type")) { ctype=s2; continue;}
    if(s1.equals("content-encoding")) { encoding=s2; continue;}
    if(s1.equals("location")) { location=s2; continue;}

    if(s1.equals("last-modified")) {
                                        try{
                                        ims=new Date(s2).getTime();
                                        }
                                        catch (IllegalArgumentException e)
                                         { ims=0;}
                                        continue;
                                      }

    if(s1.equals("expires")) {          try{
                                        exp=new Date(s2).getTime();
                                        }
                                        catch (IllegalArgumentException e)
                                         { exp=System.currentTimeMillis()+MAXDIFFTIME;}
					finally
					{
					  expi=headers.size()-1;
					  continue;
					}
                                      }

 } /* hlavicky */
 if(method!=httpreq.REQUEST_GET) cacheable=false; /* CACHE ONLY GET REQUESTS */
 if(exp!=0)
     {
      /* try to get now from Date: header */
      long now=0;
      for(int i=headers.size()-1;i>=0;i--)
      {
       String h,s1,s2;
       int j;
       h=(String)headers.elementAt(i);
       j=line.indexOf(':',0);
       if(j==-1) continue;
       s1=line.substring(0,j).toLowerCase();
       if(s1.equals("date")) {
                                        try{
                                        s2=line.substring(j+1).trim();
                                        now=new Date(s2).getTime();
                                        }
                                        catch (IllegalArgumentException e)
                                         { now=0;}
                                        break;
                                      }
      } /* Date: header hunting */
      if(now==0) now=System.currentTimeMillis();
      if(exp<=now)
      {  /* Expire date NOW or in the past is the same as Pragma: no-cache */

          exp=0; // kill expire info
	  reload=true;
          headers.removeElementAt(expi); /* KILL EXPIRE!!!*/
          if(pnci>expi) pnci--;
	   else
             if(pnci==-1) /* if removed Expire, generate PNC */
	                  { headers.addElement("Pragma: no-cache");
	                    pnci=headers.size()-1;
			  }
      } /* exp<=now, killed */
      else
       { /* fix expire to out local time */
         exp=System.currentTimeMillis()+(exp-now);
       }
     }
 if(cacheable==false) { return;}
 /* set Expire to MaxAge, prevents from early redirect refresh */
 if( (httprc==301 || httprc==300) && exp==0) exp=System.currentTimeMillis()+mgr.max_age;
 if(!reload) {
               if(cacheobject.generate_lastmod==2 && ims==0 )
                {
                 headers.addElement("Last-Modified: "+printDate(new Date()));
                }
               return;
             }

 /* CHECK:
      if we are removing PNC, could we also kill GOOD expire header in future?

      NO: PNC and Good Expire should never happen
      */
 switch(pnocache)
 {
  case 1:
        reload=false;
        if(pnci>=0) headers.removeElementAt(pnci);
	break;
  case 2:
        if(ctype.startsWith("image"))
	{
		reload=false;
                if(pnci>=0) headers.removeElementAt(pnci);
	}
	break;
  case 3:
         if(!ctype.startsWith("text"))
	 {
		 reload=false;
                 if(pnci>=0) headers.removeElementAt(pnci);
	 }
	 break;
  case 4:
  	 if(location==null)
		 {
		 reload=false;
                 if(pnci>=0) headers.removeElementAt(pnci);
		 }
         break;
 }
 /* set uncacheable */
 if(reload==true) cacheable=false;
}

final public void transfer_object(InputStream sin, OutputStream file,cachedir dir) throws IOException
{
 int read=0;
 int i;
 long whenaborted;
 boolean clientdead;
 boolean filedead;
 byte b[]=new byte[4096];
 clientdead=filedead=false;
 whenaborted=0;
 while(true)
 {
  /* precist */
  try{
  i=sin.read(b);
  }
  catch (IOException e) { if(file!=null) file.close();
                          ctsize=read;
                          throw e;
                        }
  if(i==-1) break; /* end of Data stream? */

  read+=i;
  if(file!=null) { dir.dirty=true;
                   try {
                        file.write(b,0,i);
		       }
		   catch(IOException writerr)
		   {
		    try
		     {
		      file.close();
		     }
		    catch (IOException ignore) {}
		    finally { file=null;filedead=true;}
		   }
		   }

  /* zapisovat do klienta opatrne! */
  try{
  if(!clientdead) out.write(b,0,i);
   else
    if(qa_minlen<0 && System.currentTimeMillis()-whenaborted>qa_maxtime)
                            { ctsize=read;
			      sin.close();
                            // System.out.println("Transfer of "+this.URL+" terminated. (aborted transfer time exceed)");
                            throw new IOException("Aborted transfer time timed out");}
  }
  catch(IOException e) { if(file==null) /* not caching */
                                { ctsize=read;sin.close();throw e; }
                         if(CheckQuickAbort(read)) { ctsize=read;file.close();sin.close();throw e;}
                         // System.out.println("client-close!");
                         clientdead=true;
                         whenaborted=System.currentTimeMillis();
                         }
 }
 sin.close();

 try{
 out.flush();
 } catch (IOException ignore) {}

 if(file!=null) { file.flush();file.close();}

 if(ctsize>0 && read<ctsize) {
                                ctsize=read;
                                throw new IOException("Object too small");
			     }
 if(filedead) throw new IOException("Write error (disk full?)");			
 // waz !=ctsize
 ctsize=read;
}

/* add if-mod-since header */
final public void add_ims()
{
 add_ims(ims);
}

final public void add_ims(long when)
{
 if(when==0) return;
 headers.insertElementAt("If-Modified-Since: "+printDate(new Date(when)),0);
}

final public void add_header(String header)
{
 if(header==null) return;
 headers.addElement(header);
}

final public int getRc()
{
 return httprc;
}

/* odesle obdrzene hlavicky od serveru klientu */
/* nereportuje io chyby */
final public void send_headers()
{
 if(!http10) return;
 try{
 out.writeBytes("HTTP/1.0 "+httprc+" OK\r\n");
 int headerscache=headers.size();
 for(int i=0;i<headerscache;i++)
   { out.writeBytes((String)headers.elementAt(i));
     out.writeBytes("\r\n");
   }
 out.writeBytes("\r\n");
 out.flush();
 }
 catch (IOException e)
   {
    try{
    out.close();
    }
    catch (IOException e1) {}
   }
}

final public void make_headers(int rc,String ctype,String enc,String loc,int sz,long lm,long exp)
{
 httprc=rc;
 headers=new Vector();
 Date d=new Date();
 if(ctype!=null) headers.addElement("Content-Type: "+ctype);
 if(enc!=null) headers.addElement("Content-Encoding: "+enc);
 if(sz>0) headers.addElement("Content-Length: "+sz);
 if(lm!=0) headers.addElement("Last-Modified: "+printDate(new Date(lm)));

 /*
   SETUP: Uncoment following line if you want to SC don't send Expired:
     headers from the past.
   if(exp>d.getTime()) headers.addElement("Expires: "+printDate(new Date(exp)));
 */
 if(exp>0) headers.addElement("Expires: "+printDate(new Date(exp)));
 if(loc!=null) headers.addElement("Location: "+loc);
 /* prevent TCP/IP FIN2 state !! */
 headers.addElement("Connection: close");
 headers.addElement("Proxy-Connection: close");
 /* less important , may be ignored in old Netscapes */
 headers.addElement("Date: "+printDate(d));
 headers.addElement("Server: "+scache.VERSION);
}

final public void setRequestTo(String URL)
{
 this.URL=URL;
}

final public long getIms()
{
 return ims;
}

final public long getExpires()
{
 return exp;
}


final public void clearIms()
{
 ims=0;
}

final public String getCtype()
{
 return ctype;
}

final public int getCsize()
{
 return ctsize;
}

final public String getLocation()
{
 return location;
}

final public String getEncoding()
{
 return encoding;
}

final public void send_error(int errorrc,String msg) throws IOException
{
 httpreq.server_error(http10,errorrc,msg, out);
}


/* return true if the request should be aborted */

final private boolean
CheckQuickAbort(int readb)
{
    if (!cacheable)
          {
	    // System.out.println("Non cacheable data?? - Abort");
            return true;
	  }

    if (qa_minlen < 0)
	{
	 /* disabled */
	 // System.out.println("QUICK_ABORT DISABLED - continuing");
	 return false;
	}

    if(ctsize!=-1) /* Content-size is known */
    {
    if (readb > ctsize)
        {
	/* bad content length */
	// System.out.println("ABORTING more data than expected in header");
	return true;
	}

    if ((ctsize - readb) < qa_minlen)
        {
	/* only little more left */
	// System.out.println("Continue, more than minlen bytes left.");
	return false;
	}
    if ((ctsize - readb) > qa_maxlen)
       {
	/* too much left to go */
	// System.out.println("Abort, more than maxlen bytes left.");
	return true;
       }
    if ( (float)readb / ctsize > qa_percent)
        {
	/* past point of no return */
	// System.out.println("Percentage ratio is good, continue");
	return false;
	} else
	{
        // System.out.println("Percentage ratio is bad, abort");
	return true;
	}
    }
    // System.out.println("Unknown data size?, abort");
    return true; /* STOP DOWNLOADING! */

    /*
    return false;  no dobra povolime to, ale vypadne to na timeout nebo
    na pocet dat */
}

final public static String printDate(Date d)
{

 try
  {
   return formatter.format(d);
  }
 catch (Exception z)
  {
   z.printStackTrace();
   System.out.println("[JAVA_INTERNAL_ERROR] SimpleDateFormat.format(d) failed\nDate format=EEE, dd MMM yyyy HH:mm:ss 'GMT' BadDate(formated)="+d+" time(long)="+d.getTime()+" THIS IS A JAVA BUG.\nREPORT TO      http://java.sun.com/cgi-bin/bugreport.cgi");
  }
  return null;
}

final public boolean canCache()
{
 return cacheable;
}

final public void nocache()
{
 cacheable=false;
}

final public void sendString(String arg) throws IOException
{
 out.writeBytes(arg);
}

final public void sendBytes(byte b[]) throws IOException
{
 out.write(b);
}

public final String getProtocol()
{
 return protocol;
}

}
