/*
 *  Smart Cache, http proxy cache server
 *  Copyright (C) 1998-2001 Radim Kolar
 *
 *    Smart Cache is Open Source Software; you may redistribute it
 *  and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2, or (at your option) any later version.
 *
 *    This program distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *    A copy of the GNU General Public License is available as
 *  /usr/doc/copyright/GPL in the Debian GNU/Linux distribution or on
 *  the World Wide Web at http://www.gnu.org/copyleft/gpl.html. You
 *  can also obtain it by writing to the Free Software Foundation,
 *  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

import java.io.*;
import java.util.*;
import java.util.zip.*;
import java.net.*;

public final class garbage
{
public static final String GCVERSION="0.13";

public static final int EXPORT_LRU=1;
public static final int EXPORT_DATE=2;
public static final int EXPORT_FILEDATE=3;
public static final int EXPORT_ALL=4;

public static boolean realdirsize;

private int cachesize;
private int dirsize;
private int oursize;
private int lowmark,highmark;
private int maxsize,refage;
private int blocksize;

private cacheobject gcarray[];
private float gcvalues[];

private int gcused;
private float gclow;

private long now;

private int lopsize,lopsizeinc;
private String lopact1,lopact2;

private int sopsize;
private String sopact;
private String exppenal, notchpenal,ebc;
private String neg; /* negative cached */
private regexp urlmask[];
private String urlact[];

String root;

garbage(String root)
{
 this.root=root;
 /* init to defaults */
 cachesize=100*1024*1024; /* 100MB Cache */
 maxsize=15*1024*1024;
 lowmark=90;
 highmark=95;
 refage=365;
 blocksize=4096;
 dirsize=blocksize*2;
 lopsize=1024*1024*10;
 gcused=0;
 gclow=0;
 gcarray=new cacheobject[1400];
 gcvalues=new float[1400];
 exppenal="*100";
 ebc="*4";
 neg="*10";
 /* */
 read_config(scache.GCFGFILE);
 urlmask=fixup_urls(urlmask);
 /* reverze it! */
 urlmask=mgr.reverseRegexpArray(urlmask);
 urlact=mgr.reverseStringArray(urlact);
 now=System.currentTimeMillis();
 System.out.println(new Date()+" Garbage collector version "+GCVERSION+" initialized.");
}

private final void read_config(String cfgfile)
{
 try{
 String line,token;
 StringTokenizer st;
 int lineno=0;
 if(! new File(cfgfile).isAbsolute()) cfgfile=scache.cfgdir+File.separator+cfgfile;

 DataInputStream dis=new DataInputStream(new BufferedInputStream(new FileInputStream(cfgfile)));
 while ( (line = dis.readLine()) != null)
 {
          lineno++;
          if(line.startsWith("#")) continue;
	  st=new StringTokenizer(line);
          if(st.hasMoreTokens()==false) continue;
          token=st.nextToken();
          try
          {

          if(token.equalsIgnoreCase("cache_size")) {cachesize=Integer.valueOf(st.nextToken()).intValue()*1024*1024;
          					    continue;
                                                    }

          if(token.equalsIgnoreCase("average_directory_size")) {dirsize=Integer.valueOf(st.nextToken()).intValue();
          					    continue;
                                                    }

          if(token.equalsIgnoreCase("cache_low_mark")) {lowmark=Integer.valueOf(st.nextToken()).intValue();
          					    continue;
                                                    }

          if(token.equalsIgnoreCase("cache_high_mark")) {highmark=Integer.valueOf(st.nextToken()).intValue();
          					    continue;
                                                    }
          if(token.equalsIgnoreCase("block_size")) {blocksize=Integer.valueOf(st.nextToken()).intValue();
          					    continue;
                                                    }

          if(token.equalsIgnoreCase("gcarraysize")) {gcarray=new cacheobject[Integer.valueOf(st.nextToken()).intValue()];
                                                     gcvalues=new float[gcarray.length];
          					    continue;
                                                    }

          if(token.equalsIgnoreCase("maximum_object_size")) {
                                                    maxsize=Integer.valueOf(st.nextToken()).intValue()*1024;
                                                    if(maxsize<=0) maxsize=Integer.MAX_VALUE;
          					    continue;
                                                    }
          if(token.equalsIgnoreCase("reference_age")) {
                                                    refage=Integer.valueOf(st.nextToken()).intValue();

                                                    if(refage<=0) refage=Integer.MAX_VALUE;
          					    continue;
                                                    }

          if(token.equalsIgnoreCase("large_object_penalty")) {
                                                    lopsize=Integer.valueOf(st.nextToken()).intValue();
                                                    lopact1=st.nextToken();
                                                    lopsizeinc=Integer.valueOf(st.nextToken()).intValue();
                                                    lopact2=st.nextToken();
          					    continue;
                                                    }
          if(token.equalsIgnoreCase("small_object_penalty")) {
                                                    sopsize=Integer.valueOf(st.nextToken()).intValue();
                                                    sopact=st.nextToken();
          					    continue;
                                                    }

          if(token.equalsIgnoreCase("expired_penalty")) {
                                                    exppenal=st.nextToken();
          					    continue;
                                                    }

          if(token.equalsIgnoreCase("expired_but_checkable_penalty")) {
                                                    ebc=st.nextToken();
          					    continue;
                                                    }

          if(token.equalsIgnoreCase("not_checkable_penalty")) {
                                                    notchpenal=st.nextToken();
          					    continue;
                                                    }

          if(token.equalsIgnoreCase("negative_cached_penalty")) {
                                                    neg=st.nextToken();
          					    continue;
                                                    }
          if(token.equals("case_sensitive_matching")) {
          				                   char c=(char)Integer.valueOf(st.nextToken()).intValue();
                                                           if(c==1) mgr.case_sensitive=true; else mgr.case_sensitive=false;
                                                           continue;
                                                      }

          if(token.equalsIgnoreCase("urlmask")) {
          					 token=st.nextToken();
                                                 if(mgr.isInRegexpArray(token,urlmask)) continue;
                                                 urlmask=mgr.addRegexpToArray(token,urlmask);
                                                 urlact=mgr.addStringToArray(st.nextToken(),urlact);
          					 continue;
                                                 }
          }
          catch (NoSuchElementException z)
           {
          System.out.println("[GC_CONFIG_ERROR] Missing argument(s) in "+cfgfile+":"+lineno);
          continue;
           }

          catch (NumberFormatException z)
           {
          System.out.println("[GC_CONFIG_ERROR] Invalid number in "+cfgfile+":"+lineno);
          continue;
           }

          System.out.println("[GC_CONFIG_ERROR] Unknown keyword "+token+" in "+cfgfile+":"+lineno);
 }/* while */
 dis.close();
 if(dirsize< 2*blocksize) dirsize=2*blocksize;
 if(dirsize<4096) dirsize=4096;
 }
 catch(IOException e) {}

}

private final regexp[] fixup_urls(regexp what[])
{
 if(what==null) return null;
 for(int i=0;i<what.length;i++)
  {
  regexp r;
  r=new regexp( encodechars(what[i].toString()),false);
  what[i]=r;
  }
  return what;
}

public final void rebalance()
{
 if(cachedir.readonly==true)
 {
	 System.out.println(new Date()+" Cache directory is in READ-ONLY mode, operation Aborted.");
	 return;
 }
 rebalance0(root);
}

public final void dirimport(String improot)
{
 import0(improot,improot);
}

public final void export(String to,int type,long difftime)
{
 export_one_dir(root,to,type,difftime);
}

public final void cacheimport(String improot)
{
 importcache0(improot);
}

public final void cleanup()
{
 if(cachedir.readonly==true)
 {
	 System.out.println(new Date()+" Cache directory is in READ-ONLY mode, operation Aborted.");
	 return;
 }
 kill_unref_dir(root,true);
}

public final void converto020()
{
 convert020dir(root);
}

public final void converto030()
{
 convert030dir(root);
}

private final void dump_gcarray()
{
 System.out.println("\n"+new Date()+" Dumping garbage collection memory array:\nComputed LRU value in days\t\tURL\n");
 for(int i=gcused;i>=0;i--)
  {
   if(gcarray[i]==null) continue;
   System.out.println(gcvalues[i]+"  "+gcarray[i].getDirectory().getLocalDir()+gcarray[i].getName());
  }
 System.out.println("\n"+new Date()+"   ... End of dump.");
}

private final void convert020dir(String dirname)
{
  File root=new File(dirname);

  String dirfilez[];
  Vector filez=new Vector();

  if(!root.isDirectory()) return;

//  if(!new File(dirname,cachedir.DIRINFO).exists()) return;
  try{

  DataInputStream dis=new DataInputStream( new BufferedInputStream(new FileInputStream(root+File.separator+cachedir.DIRINFO)));

  DataOutputStream dos=new DataOutputStream( new BufferedOutputStream(new FileOutputStream(root+File.separator+cachedir.DIRINFO+"new")));

  int howmany=dis.readInt();
  dos.writeInt(howmany);

  for(int i=0;i<howmany;i++)
  {
  String s;
  /* name */
  s=dis.readUTF();
  dos.writeUTF(s);
  /* ctype */
  s=dis.readUTF();
  dos.writeUTF(s);
  /* localname */
  s=dis.readUTF();
  dos.writeUTF(s);
  /* location */
  s=dis.readUTF();
  dos.writeUTF(s);
  int x;
  /* size */
  x=dis.readInt();
  dos.writeInt(x);
  /* httprc */
  x=dis.readInt();
  dos.writeInt(x);
  long l;
  /* expires */
  l=dis.readLong();
  dos.writeLong(l);
  /* date */
  l=dis.readLong();
  dos.writeLong(l);
  /* lastmod */
  l=dis.readLong();
  dos.writeLong(l);
  /* LRU */
  dos.writeLong(System.currentTimeMillis());

  }
 dis.close();
 dos.close();
 new File(dirname,cachedir.DIRINFO).delete();
 if(!new File(dirname,cachedir.DIRINFO+"new").renameTo(new File(dirname,cachedir.DIRINFO)))
   System.out.println("Rename failed in dir "+dirname);
 }
  catch (FileNotFoundException e1) {}
  catch (Exception e) {System.out.println(e);}

  dirfilez=root.list();
  /* rekurzivne do adresaru */
  for(int i=0;i<dirfilez.length;i++)
   {
     if(!new File(root,dirfilez[i]).isDirectory()) continue;
     convert020dir(dirname+File.separator+(String)dirfilez[i]);
   }
}

private final void import0(String improot,String dirname)
{
 File myroot=new File(dirname);
 if(!myroot.isDirectory()) return;

 if(dirname.length()>improot.length())
 {
   String urlpart;
   String hp;
   urlpart=dirname.substring(improot.length()+1);
   // roseknuti na host cast adresare a URL cast
   if(urlpart.indexOf(File.separator)==-1)
   {
     hp=urlpart;
     urlpart="";
   }
   else
   {
     hp=urlpart.substring(0,urlpart.indexOf(File.separator));
     urlpart=urlpart.substring(hp.length());
   }
   // extract hostname from filename
   String hn;
   hn=hp.toLowerCase();
   if(hn.indexOf('_')>-1)
      hn=hn.substring(0,hn.indexOf('_'));
   if(hn.indexOf('^')>-1)
      hn=hn.substring(0,hn.indexOf('^'));

   if(hn.indexOf('.')==-1)
    {
      System.out.println(new Date()+" [IMPORT] ignoring host without dot in name: "+hn);
      return;
     }
      // spocitat crc32 hash
      StringBuffer result;
      result=new StringBuffer(80);
      result.append(root);
      int ii;

      /* 1. spocitat hash z host stringu */
      java.util.zip.CRC32 crc=new CRC32();
      crc.update(hn.getBytes());
      /* mame hash - rozdelime ho na adresar */
      long unit=((long)1<<32)/(mgr.swap_level1_dirs*mgr.swap_level2_dirs);
      ii=(int)(crc.getValue()/unit);
      /* zacneme budovat cestu */
      result.append(File.separator+(ii/mgr.swap_level2_dirs)+File.separator+(ii-mgr.swap_level1_dirs*(ii/mgr.swap_level2_dirs))+File.separator+hp+urlpart+File.separator);

   cachedir imp,my;
   /* create .cacheinfo in to-be-imported directory */
   imp=repair.repairDir(dirname,false);
   my=new cachedir(result.toString());
   // System.out.println("hp="+hp+"("+hn+") urlpart="+urlpart+" mydir="+result);
   my.merge(imp);
   my.save();
 }

 // into subdirz
 String filez[];
 filez=myroot.list();
 if(filez==null) return;
 for(int i=filez.length-1;i>=0;i--)
  if(new File(dirname+File.separator+filez[i]).isDirectory()) import0(improot,dirname+File.separator+filez[i]);

}

private final void rebalance0(String dirname)
{
 File myroot=new File(dirname);
 boolean goodlevel=false;

 if(!myroot.isDirectory()) return;

 /* zjistit, zda jsme jiz na spravne urovni t.j. */
 /* root=d:\store
    my           \x\y */

 if(dirname.length()-this.root.length()>3)
 {
  // je uz to mozne.... ?
  String nd=dirname.substring(this.root.length()+1);
  int i=nd.indexOf(File.separatorChar,0);
  if(i!=-1) {
     // System.out.println("[debug] Good level="+dirname);
     goodlevel=true;
            }
 }
  /* rekurzivne do adresaru */
  String dirfilez[]=myroot.list();
  for(int i=0;i<dirfilez.length;i++)
   {
     if(!new File(myroot,dirfilez[i]).isDirectory()) continue;
     if(goodlevel==true)
     {
      // extract hostname from filename
      String hn;
      hn=dirfilez[i];
      if(hn.indexOf('_')>-1)
        hn=hn.substring(0,hn.indexOf('_'));
	
      if(hn.indexOf('^')>-1)
        hn=hn.substring(0,hn.indexOf('^'));
      hn=hn.toLowerCase();
      // System.out.println("fn="+dirname+File.separator+dirfilez[i]+" hn="+hn);

      // spocitat crc32 hash
      StringBuffer result=new StringBuffer(90);
      result.append(root);

      /* 1. spocitat hash z host stringu */
      java.util.zip.CRC32 crc=new CRC32();
      crc.update(hn.getBytes());
      /* mame hash - rozdelime ho na adresar */
      int ii;
      ii=(int)(crc.getValue()/(0x100000000L/(mgr.swap_level1_dirs*mgr.swap_level2_dirs)));
      result.append(File.separator+(ii/mgr.swap_level2_dirs)+File.separator+(ii % mgr.swap_level2_dirs)+File.separator+dirfilez[i]);
      // System.out.println("crc="+crc.getValue()+" units="+ii+" np="+result);
      if(!result.toString().equals(dirname+File.separator+dirfilez[i]))
       {
          File f1,f2;
	  f1=new File(myroot,dirfilez[i]); // old
	  f2=new File(result.toString());
          new File(f2.getParent()).mkdirs();
	  if(!f1.renameTo(f2))
	    System.out.println("Rename "+f1+" to "+f2+" failed.");

       }

     } else /* goodleve==false */
         rebalance0(dirname+File.separator+(String)dirfilez[i]);
   }
   myroot.delete();
}

private final void convert030dir(String dirname)
{
  File root=new File(dirname);

  String dirfilez[];
  Vector filez=new Vector();
  boolean goodlevel=false;
  if(!root.isDirectory()) return;

  /* zjistit,  zda jsme na spravnem levelu t.j. d:\store\x\y\zzzzz.yy */
  if(dirname.length()-this.root.length()>5)
  {
  String nd=dirname.substring(this.root.length()+1);
  int i=nd.indexOf(File.separatorChar,0);
  if(i!=-1) {
  nd=nd.substring(i+1);
  i=i=nd.indexOf(File.separatorChar,0);
  if(i!=-1) goodlevel=true;
  }
  // System.out.println(dirname+" = "+nd);

  }

  /* rekurzivne do adresaru */
  dirfilez=root.list();
  for(int i=0;i<dirfilez.length;i++)
   {
     if(!new File(root,dirfilez[i]).isDirectory()) continue;
     if(goodlevel==true && dirfilez[i].startsWith("-"))
     {
      new File(root,dirfilez[i]).renameTo(new
       File(root,"~"+dirfilez[i].substring(1))  );
     }
     if(goodlevel==false) convert030dir(dirname+File.separator+(String)dirfilez[i]);
   }
}


/* ************************************* */
/* ALERT: Synchronize by hand with mgr!! */
/* ************************************* */

private final String encodechars(String urldir)
{
 /* odstranit http:// if any */
  // System.out.println("Encode in="+urldir);
  /* get protocol if any */
  int i=urldir.indexOf("://",0);
  if(i!=-1)
   {
    String proto=urldir.substring(0,i);
    urldir=urldir.substring(i+3); //cut of protocol
    if(!proto.equalsIgnoreCase("http"))
     {
      /* ftp://ftp.debian.org/* -> ftp.debian.org^ftp/* */
      /* ftp://ftp.lamer* -> ftp.lamer*^ftp             */

      i=urldir.indexOf('/',0);
      if(i==-1)  urldir+='^'+proto+'*';
        else
      urldir=urldir.substring(0,i)+'^'+proto+urldir.substring(i);
     }
   }
  // if(urldir.startsWith("http://")) urldir=urldir.substring(7);

  /* nahrazujeme nepratelske znaky */
  urldir=urldir.replace(':','_');
  // urldir=urldir.replace('*','@');
  // urldir=urldir.replace('?','#');
  // urldir=urldir.replace('~','-');
  if(cacheobject.end_dot==false)
  {
    urldir=urldir.replace('>','}');
    urldir=urldir.replace('<','{');
    urldir=urldir.replace('|','!');
  }
  if(File.separatorChar!='/') urldir=urldir.replace('/',File.separatorChar);
  // System.out.println("encode debug="+urldir);
  return urldir;
}

public final void garbage_collection()
{
 int bot=(int)( (float)cachesize*(float)lowmark/100f);
 int high=(int)( (float)cachesize*(float)highmark/100f);
 if(cachedir.readonly==true)
 {
	 System.out.println(new Date()+" Cache directory is in READ-ONLY mode, GC Aborted.\n"+new Date()+"\tYou can try use -fakegc instead");
	 return;
 }

 System.out.println(new Date()+" Cache size watermarks: Low="+bot+" ("+lowmark+"%) High="+high+" ("+highmark+"%)");
 // boolean cleaning=false;
 oursize=high+1;
 while(oursize>high)
 {
 oursize=0;
 gcarray=new cacheobject[gcarray.length];
 gcvalues=new float[gcvalues.length];
 System.out.println(new Date()+" Scanning cache directory. This may take some time...");
 scan_cache(root);
 System.out.println(new Date()+" Scan end. Cachesize="+oursize+
 " B\n"+new Date()+" GC array time marks: Low ="+gclow+" high="+
 (gcused>=gcvalues.length ? new Float(gcvalues[gcvalues.length])
 : new Float(gcvalues[gcused])));
 // dump_gcarray();
 delete_files();
 // if(cleaning==false && oursize<high) break; else cleaning=true;
 }
}

public final void fake_garbage_collection()
{
 refage=maxsize=Integer.MAX_VALUE;
 int bot=(int)( (float)cachesize*(float)lowmark/100f);
 int high=(int)( (float)cachesize*(float)highmark/100f);
 System.out.println(new Date()+" Cache size watermarks: Low="+bot+" ("+lowmark+"%) High="+high+" ("+highmark+"%)");
 // boolean cleaning=false;
 oursize=0;
 gcarray=new cacheobject[gcarray.length];
 gcvalues=new float[gcvalues.length];
 System.out.println(new Date()+" Scanning cache directory. This may take some time...");
 scan_cache(root);
 System.out.println(new Date()+" Scan end. Cachesize="+oursize+
 " B\n"+new Date()+" GC array time marks: Low ="+gclow+" high="+
 (gcused>=gcvalues.length ? new Float(gcvalues[gcvalues.length])
 : new Float(gcvalues[gcused])));
 dump_gcarray();
 fake_delete_files();
 // if(cleaning==false && oursize<high) break; else cleaning=true;
}

private final void delete_files()
{
 int bot=(int)( (float)cachesize*(float)lowmark/100f);
 int high=(int)( (float)cachesize*(float)highmark/100f);
 if(oursize<bot)
  {
   System.out.println(new Date()+" Cache size is OK - No further cleaning needed");
   return;
  }

 System.out.println(new Date()+" Cleaning files....");
 for(int i=gcused;i>=0;i--)
 {
  if(gcarray[i]==null) continue;
  /* smazat soubor */
  /* TODO: vytisknout nazev souboru! */
  System.out.println("Deleted: "+gcarray[i].getDirectory().getLocalDir()+File.separator+gcarray[i].getLocalName());
  gcarray[i].delete();
  int size;
  size=gcarray[i].getSize();
  oursize-= (size/blocksize)*blocksize;
  if(size % blocksize !=0 ) oursize-=blocksize;

  if(gcarray[i].getDirectory().countObjects()==0)
   {
    /* TODO half dir! */
    oursize-=dirsize;
    gcarray[i].getDirectory().cleandir();
   }
   if(oursize<bot) break;
 }
 /* SAVE Directories */
 System.out.println(new Date()+" Updating directory information...");
 for(int i=gcused;i>=0;i--)
 {
  if(gcarray[i]==null) continue;
  gcarray[i].getDirectory().save();

 }
 System.out.println(new Date()+" Done. Cachesize is now "+oursize+" bytes.");
 if(oursize>high) System.out.println(new Date()+" WARNING: Another rescan cache needed to finish GC.\nIf this happens frequently increase gcarraysize in gc.cnf.\ngcarraysize is now set to "+gcarray.length+", good practice is add 20% to it.");
}

private final void fake_delete_files()
{
 int bot=(int)( (float)cachesize*(float)lowmark/100f);
 int high=(int)( (float)cachesize*(float)highmark/100f);
 if(oursize<bot)
  {
   System.out.println(new Date()+" [FAKE] Cache size is OK - No further cleaning needed");
   return;
  }

 System.out.println(new Date()+" [FAKE] Not Cleaning files....");
 for(int i=gcused;i>=0;i--)
 {
  if(gcarray[i]==null) continue;
  /* smazat soubor */
  System.out.println("[FAKE] Delete "+gcarray[i].getDirectory()+gcarray[i].getName());
  int size;
  size=gcarray[i].getSize();
  oursize-= (size/blocksize)*blocksize;
  if(size % blocksize !=0 ) oursize-=blocksize;

  if(oursize<bot) break;
 }

 System.out.println(new Date()+" [FAKE] Done. Cachesize is now "+oursize+" bytes.");
 if(oursize>high) System.out.println(new Date()+" [FAKE] WARNING: Another rescan cache needed to finish GC.");
}

/* proscanuje rekurzivne cache a naplni gcarray */
private final void scan_cache(String dirname)
{
 oursize+=dirsize;
 cachedir cd;
 /* nacist adresar */
 cd=kill_unref_dir(dirname,false);
 /* nacpat do gc pole */
 if(cd!=null)
  {
   /* prevest localname na URL */
   /* ze d:\store\XX\YY\name */
   /* udelat name */
   String urlpart;
   urlpart=cd.getLocalDir().substring(root.length()+1);
   /* preskocit 2x file-separator */
   int i;
   i=urlpart.indexOf(File.separatorChar,0);
   if(i!=-1) {
      urlpart=urlpart.substring(i+1);
      i=urlpart.indexOf(File.separatorChar,0);
      if(i!=-1) urlpart=urlpart.substring(i+1);
                else
             { System.out.println(new Date()+" Scanning "+dirname); urlpart="";}
      } else { urlpart="";}

   // System.out.println(cd.getLocalDir()+"="+urlpart);

   Enumeration en;
   en=cd.getObjects();
   while(en.hasMoreElements())
   {
   cacheobject obj;
   obj=(cacheobject)en.nextElement();
   /* spocitat vahu objektu */
   float w;
   w=(now-obj.getLRU())/86400000.0000f;
   /* large obj penalty */
   int size;
   size=obj.getSize();
   if(size>maxsize)
                    {
		      System.out.println("Deleted too large object: "+dirname+File.separator+obj.getLocalName()+" size="+w+"B");
		    obj.delete();continue; }
   oursize+= (size/blocksize)*blocksize;
   if(size % blocksize !=0 ) oursize+=blocksize;

   if(size>lopsize) { size-=lopsize;w=applyMod(w,lopact1);
                      while(size>lopsizeinc)
                       {
                        size-=lopsizeinc;
                        w=applyMod(w,lopact2);
                       }
                    } /* LOP HACK */
  else
   if(size<=sopsize) w=applyMod(w,sopact);

  if(obj.getRC()>=400) w=applyMod(w,neg);
  long xsize;
  xsize=obj.getExp();
  boolean chk;
  chk=obj.isCheckable();
  if(xsize>0 && xsize<now)
   if(chk) w=applyMod(w,ebc); else
           w=applyMod(w,exppenal);
   else
    if (chk==false) w=applyMod(w,notchpenal);

  // System.out.println(dirname+obj.getName()+" w="+w);

  /* URL masky */
  if(urlmask!=null)
  {
  for(size=urlmask.length-1;size>=0;size--)
   if(urlmask[size].matches(urlpart+obj.getName())) { w=applyMod(w,urlact[size]);break;}
  }
  /* refage delete */
  if(w>=refage) {
                size=obj.getSize();
                oursize-= (size/blocksize)*blocksize;
                if(size % blocksize !=0 ) oursize-=blocksize;
		System.out.println("Deleted too old object: "+dirname+File.separator+obj.getLocalName()+" age="+w+", max="+refage);
                obj.delete();
		continue; }

  /* pridat do gc pole */
  if(w<gclow) continue;
  /* najit misto pro vlozeni pomoci puleni intervalu */
  int l,h;
  l=0;
  h=gcused;
  while (l!=h)
  {
    int z;
    z=(l+h)/2;
    if(w<gcvalues[z]) {h=z;continue;}
    if(w>gcvalues[z]) {l=z+1;continue;}
    l=z;break;
  }
  /* pridat za pozici l */
  if(w<gcvalues[l]) l--;

  /* pridat doprava */
     if(gcused<gcvalues.length-1)
      {
       /* jeste mame misto - posunuje se doprava*/
       // System.out.println("right l="+l+" gcused="+gcused);
       System.arraycopy(gcvalues,l+1,gcvalues,l+2,gcvalues.length-l-2);
       System.arraycopy(gcarray,l+1,gcarray,l+2,gcarray.length-l-2);
       gcvalues[l+1]=w;
       gcarray[l+1]=obj;
       gcused++;
      }
     else
      {
       /* misto neni - jedeme do leva */
       // System.out.println("left l="+l+" gcused="+gcused);
       if(l>0)
       {
        System.arraycopy(gcvalues,1,gcvalues,0,l);
        System.arraycopy(gcarray,1,gcarray,0,l);
       }
       gcvalues[l]=w;
       gcarray[l]=obj;
       gclow=gcvalues[0];
      }

  } /* elements */
  /* TODO - half empty directory! */
  if(cd.countObjects()==0) { cd.cleandir();oursize-=dirsize;} else
  cd.save();
  } /* cd not null */

  /* dive into subdirz */
  /* potrebuje mnoho pameti!!! */
  File root=new File(dirname);

  String filez[];
  filez=root.list();
  if(filez==null) { oursize-=dirsize;return;}
  for(int i=filez.length-1;i>=0;i--)
   if(new File(dirname+File.separator+filez[i]).isDirectory()) scan_cache(dirname+File.separator+filez[i]);
}

private final float applyMod(float f,String mod)
{
 if(mod==null) return f;
 float m;
 try
 {
  m=Float.valueOf(mod.substring(1)).floatValue();
 }
 catch ( NumberFormatException z)
  {
   System.out.println("[GC_CONFIG_ERROR] Invalid number in LRU modifier '"+mod+"'");
   throw z;
  }
 switch(mod.charAt(0))
 {
  case '+':f+=m;break;
  case '-':f-=m;break;
  case '*':f*=m;break;
  case '/':f/=m;break;
  case '=':if(f>=m) f=refage;
           break;
  default:
   System.out.println("[GC_CONFIG_ERROR] Invalid action in LRU modifier '"+mod+"'");
   throw new IllegalArgumentException("Unknown action "+mod.charAt(0));
 }
 return f;
}

private final cachedir kill_unref_dir(String dirname, boolean recurse)
{
  File root=new File(dirname);

  String dirfilez[];
  String local[];
  Vector filez=new Vector();

  if(!root.isDirectory()) return null;
  dirfilez=root.list();
  if(dirfilez==null) dirfilez=new String[0];
  cachedir cd=new cachedir(dirname+File.separator);
  cd.checkDir();
  local=cd.listLocalNames();
  cd.save();
  /* konverze dirfilez na vector */
  for(int i=dirfilez.length-1;i>=0;i--)
   filez.addElement(dirfilez[i]);
  dirfilez=null;

  /* smazat localnames z filez, abychom je nesmazali */
  for(int i=local.length-1;i>=0;i--)
   filez.removeElement(local[i]);

  /* abychom si nesmazali cacheinfo !! */
  /* pokud jsme empty dir, tak ho smazeme */

  if(cd.countObjects()>0 ) filez.removeElement(cachedir.DIRINFO);
  if(recurse==true) cd=null;

  local=null;
  long now=System.currentTimeMillis();
  /* projedeme filez a smazeme nalezene soubory */
  for(int i=filez.size()-1;i>=0;i--)
   {
    File df=null;
    try{
    df=new File(dirname+File.separator+(String)filez.elementAt(i));
    }
    catch (ArrayIndexOutOfBoundsException z) {continue;}
    if(!df.isDirectory())
      {
       // .tmp age check
       if(now-df.lastModified()>1000*6*60)
        {
         System.out.println("Deleting orphan file: "+df);
         df.delete();
	}
       filez.removeElementAt(i);
       i++;continue;
      }
   }
  if(!recurse) { root.delete();return cd;}
  filez.trimToSize();

  /* rekurzivne do adresaru */
  for(int i=filez.size()-1;i>=0;i--)
   {
     kill_unref_dir(dirname+File.separator+(String)filez.elementAt(i),true);
   }
  root.delete();
  return cd;
}

private final void importcache0(String dirname)
{
 File myroot=new File(dirname);
 if(!myroot.isDirectory()) return;

  /* rekurzivne do adresaru */
  String dirfilez[]=myroot.list();
  for(int i=0;i<dirfilez.length;i++)
   {
     if(!new File(myroot,dirfilez[i]).isDirectory()) continue;
     try {
          Integer.valueOf(dirfilez[i]);
	 }
     catch (Exception exx) { continue;}
	 String subdirz[];
	 subdirz=new File(dirname,dirfilez[i]).list();
	 for(int j=0;j<subdirz.length;j++)
	 {
          if(!new File(myroot+File.separator+dirfilez[i],subdirz[j]).isDirectory()) continue;
          try {
              Integer.valueOf(subdirz[j]);
	      }
          catch (Exception exx) { continue;}
          import0(dirname+File.separator+dirfilez[i]+File.separator+subdirz[j],
	          dirname+File.separator+dirfilez[i]+File.separator+subdirz[j]);
	  }
   }
} /* import cache 0 */

/* export */
private final void  export_one_dir(String dirname, String to, int type, long difftime)
{
  File root=new File(dirname);

  if(!root.isDirectory()) return;
  cachedir cd=new cachedir(dirname+File.separator);
  boolean export=false;
  if(type!=EXPORT_ALL)
  {
    long now=System.currentTimeMillis();
    Enumeration en=cd.getObjects();
    while(en.hasMoreElements())
    {
     cacheobject obj;
     obj=(cacheobject)en.nextElement();
     if(type==EXPORT_LRU)
        if (now-obj.getLRU()<=difftime) { export=true;break;}
	else continue;
     if(now-obj.getDate()<=difftime) { export=true;break;}
    }
 } else export=true;

 if(export)
  {
   String en;
   en=dirname.substring(this.root.length());
   // System.out.println("Exporting: "+dirname+" >> "+en);
   en=en.substring(en.indexOf(File.separator)+1);
   // System.out.println(">>: "+en);
   en=en.substring(en.indexOf(File.separator)+1);
   // System.out.println(">>:: "+en);
   cachedir ncd;
   ncd=new cachedir(to+File.separator+en+File.separator);
   cd.export_to(ncd,type,difftime);
   ncd.save();
   ncd.cleandir();
  }

 // into subdirz
 String filez[];
 filez=root.list();
 if(filez==null) return;
 for(int i=filez.length-1;i>=0;i--)
  if(new File(dirname+File.separator+filez[i]).isDirectory()) export_one_dir(dirname+File.separator+filez[i],to,type,difftime);
}

public final static long timestring(String s)
{
 long multi=60*1000L; // minutes
 long value=0;
 if(s==null) return 0;
 if(s.length()>1)
  {
   char c=s.charAt(s.length()-1);
   switch(c)
   {
    case 'd':
    case 'D':
    	      multi=24*60*60*1000L;
	      break;
    case 'W':
    case 'w':
    	      multi=7*24*60*60*1000L;
	      break;
    case 'm':
              multi=60*1000L; // minutes
              break;
    case 'M':
    	      multi=30*24*60*60*1000L;
	      break;
    case 'y':
    case 'Y':
    	      multi=365*24*60*60*1000L;
	      break;
    case 'h':
    case 'H':
              multi=60*60*1000L;
              break;
   }
   if(c>'9') s=s.substring(0,s.length()-1);
 }
 value=Integer.valueOf(s).intValue();
 return multi*value;
}
} /* class */
