
/*************************************************************************
 *
 * LogonDialog.java
 *
 *  Copyright 1998 Ardent Software, Inc. - All Rights Reserved
 * This is unpublished proprietary source code of Ardent Software, Inc.
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 *************************************************************************
 *
 * Maintenance Log - Insert most recent change descriptions at top
 *
 * Date.... Descrition......................................
 * 11/24/98 Remove extra comments
 * 11/12/98 Initial Creation for SCT1
 *************************************************************************/

import java.awt.*;
import java.awt.event.*;

/**
 * <code>LogonDialog</code> is a class constructed to gather the necessary
 * information from the user to open a connection to UniVerse.
 *
 * @version	Version 1.0
 * @author	Ardent
 * @since	  1.0
 */

public class LogonDialog extends Dialog
{
	// graphical elements for this dialog
	private Label lUserName, lPassword, lServer, lAccountPath, lProxyServer, lAccessToken;
	private TextField tUserName, tPassword, tServer, tAccount, tProxyServer, tAccessToken;
	private Button bOK, bCancel;
	private Color labelColor = new Color(139,0,0); // Dark Red
	private CatalogDemo parentApplet; // reference to our parent

	LogonDialog(Frame f, CatalogDemo catalogDemo) {
		this(f, catalogDemo, "UniVerse Logon");
	}
	LogonDialog(Frame f,CatalogDemo catalogDemo,String title) {
		super(f,title,true);
		parentApplet = catalogDemo;

		GridBagLayout gbl = new GridBagLayout();
		setLayout(gbl);
		GridBagConstraints gbc1 = new GridBagConstraints();
		GridBagConstraints gbc2 = new GridBagConstraints();
		gbc1.weighty = 1.0;
		gbc2.weighty = 1.0;
		gbc1.anchor = GridBagConstraints.EAST;
		gbc2.anchor = GridBagConstraints.WEST;
		gbc2.gridwidth = GridBagConstraints.REMAINDER;

	  tUserName = new TextField(parentApplet.userName,20);
		tUserName.setForeground(parentApplet.textColor);
  	tPassword = new TextField(parentApplet.password,20);
		tPassword.setForeground(parentApplet.textColor);
    tPassword.setEchoChar('*');
  	tServer = new TextField(parentApplet.server,20);
		tServer.setForeground(parentApplet.textColor);
  	tAccount = new TextField(parentApplet.accountPath,20);
		tAccount.setForeground(parentApplet.textColor);
  	tProxyServer = new TextField(parentApplet.proxyServer,20);
		tProxyServer.setForeground(parentApplet.textColor);
  	tAccessToken = new TextField(parentApplet.accessToken,20);
		tAccessToken.setForeground(parentApplet.textColor);

		bOK = new Button("OK");
		bOK.setForeground(parentApplet.textColor);
		bOK.setBackground(parentApplet.buttonColor);
		bCancel = new Button("Cancel");
		bCancel.setForeground(parentApplet.textColor);
		bCancel.setBackground(parentApplet.buttonColor);

		add(gbl,gbc1,lUserName=new Label("UserName:"));
		lUserName.setForeground(labelColor);
		add(gbl,gbc2,tUserName);
		add(gbl,gbc1,lPassword=new Label("Password:"));
		lPassword.setForeground(labelColor);
		add(gbl,gbc2,tPassword);
		add(gbl,gbc1,lServer=new Label("Server:"));
		lServer.setForeground(labelColor);
		add(gbl,gbc2,tServer);
		add(gbl,gbc1,lAccountPath=new Label("Account Path:"));
		lAccountPath.setForeground(labelColor);
		add(gbl,gbc2,tAccount);
		add(gbl,gbc1,lProxyServer=new Label("Proxy Server:"));
		lProxyServer.setForeground(labelColor);
		add(gbl,gbc2,tProxyServer);
		add(gbl,gbc1,lAccessToken=new Label("Access Token:"));
		lAccessToken.setForeground(labelColor);
		add(gbl,gbc2,tAccessToken);
		add(gbl,gbc1,bOK);
		add(gbl,gbc2,bCancel);

		bOK.addActionListener(new ActionListener()
			{
                                String r = "new String";
				public void actionPerformed(ActionEvent event)
				{
					// pass the entered parameters to the parent applet
					parentApplet.userName = tUserName.getText();
					parentApplet.password = tPassword.getText();
					parentApplet.server = tServer.getText();
					parentApplet.accountPath = tAccount.getText();
					parentApplet.proxyServer = tProxyServer.getText();
					parentApplet.accessToken = tAccessToken.getText();
					parentApplet.cancelConnect = false;
					setVisible(false);
					dispose();
				}
			}
		);
		bCancel.addActionListener(new ActionListener()
			{
				public void actionPerformed(ActionEvent event)
				{
					// cancel connect operation
					parentApplet.cancelConnect = true;
					setVisible(false);
					dispose();
				}
			}
		);
		addWindowListener(new WindowAdapter()
			{
				public void windowClosing(WindowEvent event)
				{
					setVisible(false);
					dispose();
				}
			}
		);

 		Point scrnLoc = parentApplet.myFrame.getLocationOnScreen();
		setLocation(scrnLoc.x + 150, scrnLoc.y + 100);

		setSize(300,280);
		setVisible(true);
		/* for some reason requestFocus and transferFocus are not working */
		bOK.requestFocus();
		bOK.transferFocus();
	}

	// Macro for adding components
	void add(GridBagLayout gb,GridBagConstraints c,Component o)
	{
		gb.setConstraints(o,c);
		add(o);
	}
}