import java.io.*;
import asjava.uniobjects.*;
import asjava.uniclientlibs.UniTokens;
import asjava.uniclientlibs.*;
import java.util.Vector;
import java.util.Enumeration;
import java.lang.reflect.Field;
/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author
 * @version 1.0
 */

public class loadFiles {
  public static String userid, password, server, accountpath;
  private UniSession session;
  String tmp = new String("\t");
  private final char TAB = tmp.toCharArray()[0];
  String tmp1 = new String("\n");
  private final char CR  = tmp1.toCharArray()[0];
  String tmp2 = new String(UniTokens.AT_VM);
  private final char FM = tmp2.toCharArray()[0];


  public loadFiles(String[] args) {

    if( args == null || args.length < 4){
        System.out.println("Usage: java loadFiles UserId Password Server AccountPath");
    }else{
        userid      = args[0];
        password    = args[1];
        server      = args[2];
        accountpath = args[3];
        connect();
        createFile();
        loadData();
    }
  }


  public void loadData(){
    try{
        UniFile file = session.openFile("MUSIC_CAT");
        UniDataSet uset = new UniDataSet();

        FileReader fr = new FileReader("music_catalog.u");
        char[] b = new char[1];
        int inc = 0;
        StringBuffer sb = new StringBuffer();
        UniDynArray str = new UniDynArray();
        String id = new String();
        while( fr.read(b) > -1) {
            if( inc == 0 && b[0] ==  TAB  ){
//                System.out.println(inc + ": " + sb.toString());
                id = sb.toString();
                inc++;
                sb = new StringBuffer();
            }else if( inc > 0 && inc < 7 && b[0] == CR ){
//                System.out.println(inc + ": " + sb.toString());
                str.insert(inc, sb.toString());
                inc++;
                sb = new StringBuffer();
            }else if(inc == 7 && b[0] == CR ){
//                System.out.println(inc + ": " + sb.toString());
                str.insert(inc, sb.toString());
                inc = 0;
                file.write(id, str);
                sb = new StringBuffer();
                str = new UniDynArray();
            }else{
                if( b[0] != TAB ){
                     sb.append(b[0]);
                }
            }

        }

    }catch(UniFileException f){
      f.printStackTrace();
    }catch(FileNotFoundException f){
      f.printStackTrace();
    }catch(IOException f){
      f.printStackTrace();
    }catch(UniSessionException f){
      f.printStackTrace();
    }

  }

  public void createFile(){
    try{
      String cmd = "CREATE.FILE MUSIC_CAT 1";
      UniCommand ucmd = session.command();
      ucmd.setCommand(cmd);
      ucmd.exec();
      System.out.println(ucmd.response());

      Vector dict = new Vector();
      dict.addElement(new String[]{"STYLE","D","1","","","","S",""});
      dict.addElement(new String[]{"ARTIST","D","2","","","","S",""});
      dict.addElement(new String[]{"TITLE","D","3","","","","S",""});
      dict.addElement(new String[]{"FORMAT","D","4","","","","MV",""});
      dict.addElement(new String[]{"PRICE","D","5","","","","MV",""});
      dict.addElement(new String[]{"DESCRIPTION","D","6","","","","S",""});
      dict.addElement(new String[]{"IMAGE_LOCATION","D","7","","","","S",""});
      setDictionary("MUSIC_CAT", dict);


    }catch(UniSessionException s){
        s.printStackTrace();
    }catch(UniCommandException s){
        s.printStackTrace();
    }

  }
  public void connect(){
      try
      {
              session = new UniSession();
              session.setUserName(userid);
              session.setPassword(password);
              session.setHostName(server);
              session.setAccountPath(accountpath);
              session.connect();
      }
      catch (UniSessionException e)
      {
          e.printStackTrace();
      }
  }

  public void finalize(){
    try{
      session.disconnect();
    }catch(UniSessionException e){
        e.printStackTrace();
    }
  }
  public static void main(String[] args) {
    if( args == null || args.length < 4){
        System.out.println("Usage: java loadFiles UserId Password Server AccountPath");
    }else{
        loadFiles loadFiles1 = new loadFiles(args);
    }

  }

  public void setDictionary(String fileName, Vector vDict)
  {
          Vector vField = new Vector();
          try {
                  UniDictionary udict = session.openDict( fileName ) ;
                  // for each Attribute...
                  for(Enumeration enum = vDict.elements(); enum.hasMoreElements(); )
                  {
                          String[] dict = (String[])enum.nextElement();
                          if( dict != null )
                          {
                                  udict.setRecordID(dict[0]);
                                  udict.setType(dict[1]);
                                  udict.setLoc(dict[2]);
                                  if(dict[3].length() > 0 ){ udict.setConv(dict[3]);}
                                  if(dict[4].length() > 0 ){ udict.setName(dict[4]);}
                                  if(dict[5].length() > 0 ){ udict.setFormat(dict[5]);}
                                  if(dict[6].length() > 0 ){ udict.setSM (dict[6]);}
                                  if(dict[7].length() > 0 ){ udict.setAssoc(dict[7]);}
                          }
                  }
                  udict.close() ;
          } catch ( UniSessionException ue ){
                ue.printStackTrace();
          } catch ( UniFileException fe ) {
                fe.printStackTrace();
          }
  }

}