/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11;

public class PKCS11TokenInfo {
    private String utcTime;
    private int firmwareVersion;
    private int hardwareVersion;
    private int freePrivateMemory;
    private int totalPrivateMemory;
    private int freePublicMemory;
    private int totalPublicMemory;
    private int minPinLen;
    private int maxPinLen;
    private int rwSessionCount;
    private int maxRwSessionCount;
    private int sessionCount;
    private int maxSessionCount;
    private int flags;
    private String serialNumber;
    private String model;
    private String manufacturer;
    private String label;
    static final String[] flagNames;
    static final int[] flagList;
    public static final int EFFECTIVELY_INFINITE = 0;
    public static final int UNAVAILABLE_INFORMATION = -1;
    public static final int SO_PIN_TO_BE_CHANGED = 0x800000;
    public static final int SO_PIN_LOCKED = 0x400000;
    public static final int SO_PIN_FINAL_TRY = 0x200000;
    public static final int SO_PIN_COUNT_LOW = 0x100000;
    public static final int USER_PIN_TO_BE_CHANGED = 524288;
    public static final int USER_PIN_LOCKED = 262144;
    public static final int USER_PIN_FINAL_TRY = 131072;
    public static final int USER_PIN_COUNT_LOW = 65536;
    public static final int SECONDARY_AUTHENTICATION = 2048;
    public static final int TOKEN_INITIALIZED = 1024;
    public static final int DUAL_CRYPTO_OPERATIONS = 512;
    public static final int PROTECTED_AUTHENTICATION_PATH = 256;
    public static final int SUPPORTS_PARALLEL = 128;
    public static final int CLOCK_ON_TOKEN = 64;
    public static final int RESTORE_KEY_NOT_NEEDED = 32;
    public static final int EXCLUSIVE_EXISTS = 16;
    public static final int USER_PIN_INITIALIZED = 8;
    public static final int LOGIN_REQUIRED = 4;
    public static final int WRITE_PROTECTED = 2;
    public static final int RNG = 1;

    public String utcTime() {
        return this.utcTime;
    }

    String unavailable(int n2) {
        return n2 == -1 ? "UNAVAILABLE_INFORMATION" : Integer.toString(n2);
    }

    public int totalPublicMemory() {
        return this.totalPublicMemory;
    }

    public int totalPrivateMemory() {
        return this.totalPrivateMemory;
    }

    public String toString() {
        return "PKCS11TokenInfo:\n    Label:             " + this.label + "\n    Manufacturer:      " + this.manufacturer + "\n    Model:             " + this.model + "\n    Serial:            " + this.serialNumber + "\n    Flags:             " + this.flagsToString(" | ") + "\n    Max sessions:      " + this.infinite(this.maxSessionCount) + "\n    Sessions:          " + this.unavailable(this.sessionCount) + "\n    Max RW sessions:   " + this.infinite(this.maxRwSessionCount) + "\n    RW sessions:       " + this.unavailable(this.rwSessionCount) + "\n    Max PIN len:       " + this.maxPinLen + "\n    Min PIN len:       " + this.minPinLen + "\n    Total public mem:  " + this.unavailable(this.totalPublicMemory) + "\n    Free public mem:   " + this.unavailable(this.freePublicMemory) + "\n    Total private mem: " + this.unavailable(this.totalPrivateMemory) + "\n    Free private mem:  " + this.unavailable(this.freePrivateMemory) + "\n    Hardware version:  " + PKCS11.versionString(this.hardwareVersion) + "\n    Firmware version:  " + PKCS11.versionString(this.firmwareVersion) + (this.utcTime != null ? "\n    UTC time:          " + this.utcTime : "");
    }

    public int sessionCount() {
        return this.sessionCount;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public int rwSessionCount() {
        return this.rwSessionCount;
    }

    public String model() {
        return this.model;
    }

    public int minPinLen() {
        return this.minPinLen;
    }

    public int maxSessionCount() {
        return this.maxSessionCount;
    }

    public int maxRwSessionCount() {
        return this.maxRwSessionCount;
    }

    public int maxPinLen() {
        return this.maxPinLen;
    }

    public String manufacturer() {
        return this.manufacturer;
    }

    public String label() {
        return this.label;
    }

    String infinite(int n2) {
        return n2 == 0 ? "EFFECTIVELY_INFINITE" : this.unavailable(n2);
    }

    public int hardwareVersion() {
        return this.hardwareVersion;
    }

    public int freePublicMemory() {
        return this.freePublicMemory;
    }

    public int freePrivateMemory() {
        return this.freePrivateMemory;
    }

    public String flagsToString(String string) {
        return PKCS11.flagsToString(this.flags, flagList, flagNames, string);
    }

    public int flags() {
        return this.flags;
    }

    public int firmwareVersion() {
        return this.firmwareVersion;
    }

    public PKCS11TokenInfo(String string, String string2, String string3, String string4, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, String string5) {
        this.label = string;
        this.manufacturer = string2;
        this.model = string3;
        this.serialNumber = string4;
        this.flags = n2;
        this.maxSessionCount = n3;
        this.sessionCount = n4;
        this.maxRwSessionCount = n5;
        this.rwSessionCount = n6;
        this.maxPinLen = n7;
        this.minPinLen = n8;
        this.totalPublicMemory = n9;
        this.freePublicMemory = n10;
        this.totalPrivateMemory = n11;
        this.freePrivateMemory = n12;
        this.hardwareVersion = n13;
        this.firmwareVersion = n14;
        this.utcTime = string5;
    }

    static {
        flagList = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000};
        flagNames = new String[]{"RNG", "WRITE_PROTECTED", "LOGIN_REQUIRED", "USER_PIN_INITIALIZED", "EXCLUSIVE_EXISTS", "RESTORE_KEY_NOT_NEEDED", "CLOCK_ON_TOKEN", "SUPPORTS_PARALLEL", "PROTECTED_AUTHENTICATION_PATH", "DUAL_CRYPTO_OPERATIONS", "TOKEN_INITIALIZED", "SECONDARY_AUTHENTICATION", "USER_PIN_COUNT_LOW", "USER_PIN_FINAL_TRY", "USER_PIN_LOCKED", "USER_PIN_TO_BE_CHANGED", "SO_PIN_COUNT_LOW", "SO_PIN_FINAL_TRY", "SO_PIN_LOCKED", "SO_PIN_TO_BE_CHANGED"};
    }
}

